"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
const language_core_1 = require("@vue/language-core");
const vscode_uri_1 = require("vscode-uri");
function create() {
    return {
        name: 'vue-compiler-dom-errors',
        capabilities: {
            diagnosticProvider: {
                interFileDependencies: false,
                workspaceDiagnostics: false,
            },
        },
        create(context) {
            return {
                provideDiagnostics(document) {
                    if (!isSupportedDocument(document)) {
                        return;
                    }
                    const uri = vscode_uri_1.URI.parse(document.uri);
                    const decoded = context.decodeEmbeddedDocumentUri(uri);
                    const sourceScript = decoded && context.language.scripts.get(decoded[0]);
                    const virtualCode = decoded && sourceScript?.generated?.embeddedCodes.get(decoded[1]);
                    if (!virtualCode) {
                        return;
                    }
                    const root = sourceScript?.generated?.root;
                    if (!(root instanceof language_core_1.VueVirtualCode)) {
                        return;
                    }
                    const templateErrors = [];
                    const { template } = root.sfc;
                    if (template) {
                        for (const error of template.errors) {
                            onCompilerError(error, 1);
                        }
                        for (const warning of template.warnings) {
                            onCompilerError(warning, 2);
                        }
                        function onCompilerError(error, severity) {
                            const templateHtmlRange = {
                                start: error.loc?.start.offset ?? 0,
                                end: error.loc?.end.offset ?? 0,
                            };
                            let errorMessage = error.message;
                            templateErrors.push({
                                range: {
                                    start: document.positionAt(templateHtmlRange.start),
                                    end: document.positionAt(templateHtmlRange.end),
                                },
                                severity,
                                code: error.code,
                                source: 'vue',
                                message: errorMessage,
                            });
                        }
                    }
                    return templateErrors;
                },
            };
        },
    };
    function isSupportedDocument(document) {
        return document.languageId === 'jade' || document.languageId === 'html';
    }
}
//# sourceMappingURL=vue-compiler-dom-errors.js.map