/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.api.actions.Editable;
import org.netbeans.swing.laf.flatlaf.FlatLafOptionsPanelController;
import org.netbeans.swing.laf.flatlaf.FlatLafPrefs;
import org.openide.LifecycleManager;
import org.openide.awt.ColorComboBox;
import org.openide.awt.Mnemonics;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class FlatLafOptionsPanel
extends JPanel {
    private static final Color DEFAULT = new Color(0, true);
    private static final Color currentAccentColor = FlatLafPrefs.getAccentColor();
    private static final RequestProcessor RP = new RequestProcessor(FlatLafOptionsPanel.class);
    private final FlatLafOptionsPanelController controller;
    private static Notification restartNotification;
    private ColorComboBox accentColorField;
    private JLabel accentColorLabel;
    private JPanel advPanel;
    private JCheckBox alwaysShowMnemonicsCheckBox;
    private JButton customPropertiesButton;
    private JLabel customPropertiesLabel;
    private JCheckBox menuBarEmbeddedCheckBox;
    private JLabel needsRestartLabel;
    private JCheckBox underlineMenuSelectionCheckBox;
    private JCheckBox unifiedTitleBarCheckBox;
    private JCheckBox useWindowDecorationsCheckBox;

    public FlatLafOptionsPanel(FlatLafOptionsPanelController flatLafOptionsPanelController) {
        this.controller = flatLafOptionsPanelController;
        this.initComponents();
        this.initAccentColor();
        this.updateEnabled();
    }

    private void initAccentColor() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Color> arrayList2 = new ArrayList<Color>();
        arrayList.add("default");
        arrayList2.add(DEFAULT);
        String string = UIManager.getString("nb.accentColors.predefined");
        if (string == null) {
            String[] stringArray = new Properties();
            try {
                stringArray.load(this.getClass().getClassLoader().getResourceAsStream("org/netbeans/swing/laf/flatlaf/FlatLaf.properties"));
                string = stringArray.getProperty("nb.accentColors.predefined");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (string != null) {
            for (String string2 : string.split(";")) {
                Color color;
                int n = string2.indexOf(58);
                if (n < 1) continue;
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1).trim();
                if (string3.isEmpty() || string4.isEmpty() || (color = FlatLafPrefs.parseColor(string4)) == null) continue;
                arrayList.add(string3);
                arrayList2.add(color);
            }
        }
        this.accentColorField.setModel(arrayList2.toArray(new Color[0]), arrayList.toArray(new String[0]));
    }

    private void updateEnabled() {
        boolean bl = FlatLaf.supportsNativeWindowDecorations();
        this.useWindowDecorationsCheckBox.setEnabled(bl);
        this.unifiedTitleBarCheckBox.setEnabled(bl && this.useWindowDecorationsCheckBox.isSelected());
        this.menuBarEmbeddedCheckBox.setEnabled(bl && this.useWindowDecorationsCheckBox.isSelected());
        this.underlineMenuSelectionCheckBox.setEnabled(!SystemInfo.isMacOS);
    }

    private void initComponents() {
        this.accentColorLabel = new JLabel();
        this.accentColorField = new ColorComboBox();
        this.needsRestartLabel = new JLabel();
        this.useWindowDecorationsCheckBox = new JCheckBox();
        this.menuBarEmbeddedCheckBox = new JCheckBox();
        this.unifiedTitleBarCheckBox = new JCheckBox();
        this.underlineMenuSelectionCheckBox = new JCheckBox();
        this.alwaysShowMnemonicsCheckBox = new JCheckBox();
        this.advPanel = new JPanel();
        this.customPropertiesLabel = new JLabel();
        this.customPropertiesButton = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Mnemonics.setLocalizedText((JLabel)this.accentColorLabel, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.accentColorLabel.text"));
        this.accentColorField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlatLafOptionsPanel.this.accentColorFieldActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.needsRestartLabel, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.needsRestartLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.useWindowDecorationsCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.useWindowDecorationsCheckBox.text"));
        this.useWindowDecorationsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlatLafOptionsPanel.this.useWindowDecorationsCheckBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.menuBarEmbeddedCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.menuBarEmbeddedCheckBox.text"));
        this.menuBarEmbeddedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlatLafOptionsPanel.this.menuBarEmbeddedCheckBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.unifiedTitleBarCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.unifiedTitleBarCheckBox.text"));
        this.unifiedTitleBarCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlatLafOptionsPanel.this.unifiedTitleBarCheckBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.underlineMenuSelectionCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.underlineMenuSelectionCheckBox.text"));
        this.underlineMenuSelectionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlatLafOptionsPanel.this.underlineMenuSelectionCheckBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.alwaysShowMnemonicsCheckBox, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.alwaysShowMnemonicsCheckBox.text"));
        this.alwaysShowMnemonicsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlatLafOptionsPanel.this.alwaysShowMnemonicsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.advPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.Advanced.title")));
        Mnemonics.setLocalizedText((JLabel)this.customPropertiesLabel, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.customPropertiesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.customPropertiesButton, (String)NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.customPropertiesButton.text"));
        this.customPropertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlatLafOptionsPanel.this.customPropertiesButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.advPanel);
        this.advPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customPropertiesLabel, -1, 368, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.customPropertiesButton).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.customPropertiesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.customPropertiesButton).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.advPanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useWindowDecorationsCheckBox).addComponent(this.unifiedTitleBarCheckBox).addComponent(this.menuBarEmbeddedCheckBox).addComponent(this.underlineMenuSelectionCheckBox).addComponent(this.alwaysShowMnemonicsCheckBox).addGroup(groupLayout2.createSequentialGroup().addGap(0, 0, 0).addComponent(this.accentColorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.accentColorField, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.needsRestartLabel))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.accentColorField, -2, -1, -2).addComponent(this.needsRestartLabel).addComponent(this.accentColorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useWindowDecorationsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unifiedTitleBarCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.menuBarEmbeddedCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.underlineMenuSelectionCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.alwaysShowMnemonicsCheckBox).addGap(18, 18, 18).addComponent(this.advPanel, -2, -1, -2).addContainerGap(69, Short.MAX_VALUE)));
    }

    private void useWindowDecorationsCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.updateEnabled();
        this.fireChanged();
    }

    private void unifiedTitleBarCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.fireChanged();
    }

    private void menuBarEmbeddedCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.fireChanged();
    }

    private void underlineMenuSelectionCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.fireChanged();
    }

    private void alwaysShowMnemonicsCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.fireChanged();
    }

    private void customPropertiesButtonActionPerformed(ActionEvent actionEvent) {
        RP.execute(() -> {
            try {
                Object object;
                Object object2;
                FileObject fileObject = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)"LookAndFeel");
                FileObject fileObject2 = fileObject.getFileObject("FlatLaf.properties");
                if (fileObject2 == null) {
                    fileObject2 = fileObject.createData("FlatLaf.properties");
                    object2 = new BufferedWriter(new OutputStreamWriter(fileObject2.getOutputStream()));
                    object = null;
                    try {
                        ((Writer)object2).append(NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.customProperties.content"));
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object2 != null) {
                            if (object != null) {
                                try {
                                    ((BufferedWriter)object2).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                ((BufferedWriter)object2).close();
                            }
                        }
                    }
                }
                object2 = DataObject.find((FileObject)fileObject2);
                object = (Editable)object2.getLookup().lookup(Editable.class);
                object.edit();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        });
    }

    private void accentColorFieldActionPerformed(ActionEvent actionEvent) {
        this.fireChanged();
    }

    private void fireChanged() {
        boolean bl = false;
        if (!Objects.equals(this.accentColorField.getSelectedColor(), this.getPrefsAccentColorOrDefault()) || this.useWindowDecorationsCheckBox.isSelected() != FlatLafPrefs.isUseWindowDecorations() || this.unifiedTitleBarCheckBox.isSelected() != FlatLafPrefs.isUnifiedTitleBar() || this.menuBarEmbeddedCheckBox.isSelected() != FlatLafPrefs.isMenuBarEmbedded() || this.underlineMenuSelectionCheckBox.isSelected() != FlatLafPrefs.isUnderlineMenuSelection() || this.alwaysShowMnemonicsCheckBox.isSelected() != FlatLafPrefs.isAlwaysShowMnemonics()) {
            bl = true;
        }
        this.controller.changed(bl);
    }

    protected void load() {
        this.accentColorField.setSelectedColor(this.getPrefsAccentColorOrDefault());
        this.useWindowDecorationsCheckBox.setSelected(FlatLafPrefs.isUseWindowDecorations());
        this.unifiedTitleBarCheckBox.setSelected(FlatLafPrefs.isUnifiedTitleBar());
        this.menuBarEmbeddedCheckBox.setSelected(FlatLafPrefs.isMenuBarEmbedded());
        this.underlineMenuSelectionCheckBox.setSelected(FlatLafPrefs.isUnderlineMenuSelection());
        this.alwaysShowMnemonicsCheckBox.setSelected(FlatLafPrefs.isAlwaysShowMnemonics());
        this.updateEnabled();
    }

    protected boolean store() {
        Color color = this.accentColorField.getSelectedColor();
        FlatLafPrefs.setAccentColor(color != DEFAULT ? color : null);
        FlatLafPrefs.setUseWindowDecorations(this.useWindowDecorationsCheckBox.isSelected());
        FlatLafPrefs.setUnifiedTitleBar(this.unifiedTitleBarCheckBox.isSelected());
        FlatLafPrefs.setMenuBarEmbedded(this.menuBarEmbeddedCheckBox.isSelected());
        FlatLafPrefs.setUnderlineMenuSelection(this.underlineMenuSelectionCheckBox.isSelected());
        FlatLafPrefs.setAlwaysShowMnemonics(this.alwaysShowMnemonicsCheckBox.isSelected());
        if (!Objects.equals(color, currentAccentColor)) {
            this.askForRestart();
        }
        return false;
    }

    private void askForRestart() {
        if (restartNotification != null) {
            restartNotification.clear();
        }
        restartNotification = NotificationDisplayer.getDefault().notify(NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.restartTitle"), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/core/windows/resources/restart.png", (boolean)true), NbBundle.getMessage(FlatLafOptionsPanel.class, (String)"FlatLafOptionsPanel.restartDetails"), actionEvent -> {
            if (restartNotification != null) {
                restartNotification.clear();
                restartNotification = null;
            }
            LifecycleManager.getDefault().markForRestart();
            LifecycleManager.getDefault().exit();
        }, NotificationDisplayer.Priority.NORMAL, NotificationDisplayer.Category.INFO);
    }

    private Color getPrefsAccentColorOrDefault() {
        Color color = FlatLafPrefs.getAccentColor();
        return color != null ? color : DEFAULT;
    }

    boolean valid() {
        return true;
    }
}

