/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.windows;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Shopkeeper;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.items.Gold;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.MasterThievesArmband;
import com.shatteredpixel.shatteredpixeldungeon.journal.Catalog;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.CurrencyIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndInfoItem;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;

public class WndTradeItem
extends WndInfoItem {
    private static final float GAP = 2.0f;
    private static final int BTN_HEIGHT = 18;
    private WndBag owner;
    private boolean selling = false;

    public WndTradeItem(final Item item, WndBag owner) {
        super(item);
        this.selling = true;
        this.owner = owner;
        float pos = this.height;
        Shopkeeper shop = null;
        for (Char ch : Actor.chars()) {
            if (!(ch instanceof Shopkeeper)) continue;
            shop = (Shopkeeper)ch;
            break;
        }
        final Shopkeeper finalShop = shop;
        if (item.quantity() == 1) {
            RedButton btnSell = new RedButton(Messages.get(this, "sell", item.value())){

                @Override
                protected void onClick() {
                    WndTradeItem.sell(item, finalShop);
                    WndTradeItem.this.hide();
                }
            };
            btnSell.setRect(0.0f, pos + 2.0f, this.width, 18.0f);
            btnSell.icon(new ItemSprite(ItemSpriteSheet.GOLD));
            this.add(btnSell);
            pos = btnSell.bottom();
        } else {
            int priceAll = item.value();
            RedButton btnSell1 = new RedButton(Messages.get(this, "sell_1", priceAll / item.quantity())){

                @Override
                protected void onClick() {
                    WndTradeItem.sellOne(item, finalShop);
                    WndTradeItem.this.hide();
                }
            };
            btnSell1.setRect(0.0f, pos + 2.0f, this.width, 18.0f);
            btnSell1.icon(new ItemSprite(ItemSpriteSheet.GOLD));
            this.add(btnSell1);
            RedButton btnSellAll = new RedButton(Messages.get(this, "sell_all", priceAll)){

                @Override
                protected void onClick() {
                    WndTradeItem.sell(item, finalShop);
                    WndTradeItem.this.hide();
                }
            };
            btnSellAll.setRect(0.0f, btnSell1.bottom() + 1.0f, this.width, 18.0f);
            btnSellAll.icon(new ItemSprite(ItemSpriteSheet.GOLD));
            this.add(btnSellAll);
            pos = btnSellAll.bottom();
        }
        this.resize(this.width, (int)pos);
    }

    public WndTradeItem(final Heap heap) {
        super(heap);
        this.selling = false;
        CurrencyIndicator.showGold = true;
        final Item item = heap.peek();
        float pos = this.height;
        int price = Shopkeeper.sellPrice(item);
        RedButton btnBuy = new RedButton(Messages.get(this, "buy", price)){

            @Override
            protected void onClick() {
                WndTradeItem.this.hide();
                WndTradeItem.this.buy(heap);
            }
        };
        btnBuy.setRect(0.0f, pos + 2.0f, this.width, 18.0f);
        btnBuy.icon(new ItemSprite(ItemSpriteSheet.GOLD));
        btnBuy.enable(price <= Dungeon.gold);
        this.add(btnBuy);
        pos = btnBuy.bottom();
        final MasterThievesArmband.Thievery thievery = Dungeon.hero.buff(MasterThievesArmband.Thievery.class);
        if (thievery != null && !thievery.isCursed() && thievery.chargesToUse(item) > 0) {
            final float chance = thievery.stealChance(item);
            int chargesToUse = thievery.chargesToUse(item);
            RedButton btnSteal = new RedButton(Messages.get(this, "steal", Math.min(100, (int)(chance * 100.0f)), chargesToUse), 6){

                @Override
                protected void onClick() {
                    if (chance >= 1.0f) {
                        thievery.steal(item);
                        Hero hero = Dungeon.hero;
                        Item item2 = heap.pickUp();
                        WndTradeItem.this.hide();
                        if (!item2.doPickUp(hero)) {
                            Dungeon.level.drop((Item)item2, (int)heap.pos).sprite.drop();
                        }
                    } else {
                        GameScene.show(new WndOptions(new ItemSprite(ItemSpriteSheet.ARTIFACT_ARMBAND), Messages.titleCase(Messages.get(MasterThievesArmband.class, "name", new Object[0])), Messages.get(WndTradeItem.class, "steal_warn", new Object[0]), new String[]{Messages.get(WndTradeItem.class, "steal_warn_yes", new Object[0]), Messages.get(WndTradeItem.class, "steal_warn_no", new Object[0])}){

                            @Override
                            protected void onSelect(int index) {
                                super.onSelect(index);
                                if (index == 0) {
                                    if (thievery.steal(item)) {
                                        Hero hero = Dungeon.hero;
                                        Item item = heap.pickUp();
                                        WndTradeItem.this.hide();
                                        if (!item.doPickUp(hero)) {
                                            Dungeon.level.drop((Item)item, (int)heap.pos).sprite.drop();
                                        }
                                    } else {
                                        for (Mob mob : Dungeon.level.mobs) {
                                            if (!(mob instanceof Shopkeeper)) continue;
                                            mob.yell(Messages.get(mob, "thief", new Object[0]));
                                            ((Shopkeeper)mob).flee();
                                            break;
                                        }
                                        WndTradeItem.this.hide();
                                    }
                                }
                            }
                        });
                    }
                }
            };
            btnSteal.setRect(0.0f, pos + 1.0f, this.width, 18.0f);
            btnSteal.icon(new ItemSprite(ItemSpriteSheet.ARTIFACT_ARMBAND));
            this.add(btnSteal);
            pos = btnSteal.bottom();
        }
        this.resize(this.width, (int)pos);
    }

    @Override
    public void hide() {
        super.hide();
        CurrencyIndicator.showGold = false;
        if (this.owner != null) {
            this.owner.hide();
        }
        if (this.selling) {
            Shopkeeper.sell();
        }
    }

    public static void sell(Item item) {
        WndTradeItem.sell(item, null);
    }

    public static void sell(Item item, Shopkeeper shop) {
        Hero hero = Dungeon.hero;
        if (item.isEquipped(hero) && !((EquipableItem)item).doUnequip(hero, false)) {
            return;
        }
        item.detachAll(hero.belongings.backpack);
        hero.spend(-hero.cooldown());
        new Gold(item.value()).doPickUp(hero);
        if (shop != null) {
            shop.buybackItems.add(item);
            while (shop.buybackItems.size() > Shopkeeper.MAX_BUYBACK_HISTORY) {
                shop.buybackItems.remove(0);
            }
        }
    }

    public static void sellOne(Item item) {
        WndTradeItem.sellOne(item, null);
    }

    public static void sellOne(Item item, Shopkeeper shop) {
        if (item.quantity() <= 1) {
            WndTradeItem.sell(item, shop);
        } else {
            Hero hero = Dungeon.hero;
            item = item.detach(hero.belongings.backpack);
            hero.spend(-hero.cooldown());
            new Gold(item.value()).doPickUp(hero);
            if (shop != null) {
                shop.buybackItems.add(item);
                while (shop.buybackItems.size() > Shopkeeper.MAX_BUYBACK_HISTORY) {
                    shop.buybackItems.remove(0);
                }
            }
        }
    }

    private void buy(Heap heap) {
        Item item = heap.pickUp();
        if (item == null) {
            return;
        }
        int price = Shopkeeper.sellPrice(item);
        Dungeon.gold -= price;
        Catalog.countUses(Gold.class, price);
        if (!item.doPickUp(Dungeon.hero)) {
            Dungeon.level.drop((Item)item, (int)heap.pos).sprite.drop();
        }
    }
}

