/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.atmp.ImageBuilder;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Annotated;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Previous;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.DisplayPositioned;
import net.sourceforge.plantuml.abel.DisplayPositionned;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.ColorOrder;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.skin.Pragma;
import net.sourceforge.plantuml.skin.SkinParam;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleLoader;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.warning.Warning;

public abstract class TitledDiagram
extends AbstractPSystem
implements Diagram,
Annotated {
    public static boolean FORCE_SMETANA = false;
    public static boolean FORCE_ELK = false;
    private DisplayPositioned title = DisplayPositioned.none(HorizontalAlignment.CENTER, VerticalAlignment.TOP);
    private DisplayPositioned caption = DisplayPositioned.none(HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    private DisplayPositioned legend = DisplayPositioned.none(HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    private DisplayPositioned header = DisplayPositioned.none(HorizontalAlignment.CENTER, null);
    private DisplayPositioned footer = DisplayPositioned.none(HorizontalAlignment.CENTER, null);
    private DisplayPositioned mainFrame = DisplayPositioned.none(null, null);
    private final UmlDiagramType type;
    private final SkinParam skinParam;
    private boolean useSmetana;
    private boolean useElk;

    public TitledDiagram(UmlSource source, UmlDiagramType type, Previous previous, PreprocessingArtifact preprocessing) {
        super(source, preprocessing);
        this.type = type;
        this.skinParam = SkinParam.create(type, Pragma.createEmpty(), preprocessing.getOption());
        if (previous != null) {
            this.skinParam.copyAllFrom(previous);
        }
    }

    public final StyleBuilder getCurrentStyleBuilder() {
        return this.skinParam.getCurrentStyleBuilder();
    }

    public final UmlDiagramType getUmlDiagramType() {
        return this.type;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public void setParam(String key, String value) {
        this.skinParam.setParam(StringUtils.goLowerCase(key), value);
    }

    public void addSprite(String name, Sprite sprite) {
        this.skinParam.addSprite(name, sprite);
    }

    public CommandExecutionResult loadSkin(String newSkin) throws IOException {
        String filename = newSkin + ".skin";
        InputStream is = StyleLoader.getInputStreamForStyle(filename);
        if (is == null) {
            return CommandExecutionResult.error("Cannot find style " + newSkin);
        }
        is.close();
        this.getSkinParam().setDefaultSkin(filename);
        return CommandExecutionResult.ok();
    }

    public final void setTitle(DisplayPositioned title) {
        if (title.isNull() || title.getDisplay().isWhite()) {
            return;
        }
        this.title = title;
    }

    @Override
    public final DisplayPositionned getTitle() {
        return this.title;
    }

    @Override
    public final Display getTitleDisplay() {
        if (this.title == null) {
            return Display.NULL;
        }
        return this.title.getDisplay();
    }

    public final void setMainFrame(DisplayPositioned mainFrame) {
        this.mainFrame = mainFrame;
    }

    public final void setCaption(DisplayPositioned caption) {
        this.caption = caption;
    }

    @Override
    public final DisplayPositioned getCaption() {
        return this.caption;
    }

    @Override
    public final DisplayPositioned getHeader() {
        return this.header;
    }

    @Override
    public final DisplayPositioned getFooter() {
        return this.footer;
    }

    public void updateFooter(LineLocation location, Display display, HorizontalAlignment horizontalAlignment) {
        this.footer = this.footer.withDisplay(display).withHorizontalAlignment(horizontalAlignment).withLocation(location);
    }

    public void updateHeader(LineLocation location, Display display, HorizontalAlignment horizontalAlignment) {
        this.header = this.header.withDisplay(display).withHorizontalAlignment(horizontalAlignment).withLocation(location);
    }

    @Override
    public final DisplayPositioned getLegend() {
        return this.legend;
    }

    public void setLegend(DisplayPositioned legend) {
        this.legend = legend;
    }

    @Override
    public final DisplayPositioned getMainFrame() {
        return this.mainFrame;
    }

    public void setUseSmetana(boolean useSmetana) {
        this.useSmetana = useSmetana;
    }

    public void setUseElk(boolean useElk) {
        this.useElk = useElk;
    }

    public boolean isUseElk() {
        if (FORCE_ELK) {
            return true;
        }
        return this.useElk;
    }

    public boolean isUseSmetana() {
        if (FORCE_SMETANA) {
            return true;
        }
        return this.useSmetana;
    }

    @Override
    public ClockwiseTopRightBottomLeft getDefaultMargins() {
        return ClockwiseTopRightBottomLeft.same(10.0);
    }

    @Override
    public ImageBuilder createImageBuilder(FileFormatOption fileFormatOption) throws IOException {
        return super.createImageBuilder(fileFormatOption).styled(this);
    }

    public HColor calculateBackColor() {
        Style style = StyleSignatureBasic.of(SName.root, SName.document, this.getUmlDiagramType().getStyleName()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        HColor backgroundColor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        if (backgroundColor == null) {
            backgroundColor = HColors.transparent();
        }
        return backgroundColor;
    }

    @Override
    protected ColorMapper muteColorMapper(ColorMapper init) {
        if (SkinParam.isDark(this.getSkinParam())) {
            return ColorMapper.DARK_MODE;
        }
        String monochrome = this.getSkinParam().getValue("monochrome");
        if ("true".equals(monochrome)) {
            return ColorMapper.MONOCHROME;
        }
        if ("reverse".equals(monochrome)) {
            return ColorMapper.MONOCHROME_REVERSE;
        }
        String reversecolor = this.getSkinParam().getValue("reversecolor");
        if (reversecolor == null) {
            return init;
        }
        if ("dark".equalsIgnoreCase(reversecolor)) {
            return ColorMapper.LIGTHNESS_INVERSE;
        }
        ColorOrder order = ColorOrder.fromString(reversecolor);
        if (order == null) {
            return init;
        }
        return ColorMapper.reverse(order);
    }

    protected abstract TextBlock getTextMainBlock(FileFormatOption var1);

    @Override
    public void exportDiagramGraphic(UGraphic ug, FileFormatOption fileFormatOption) {
        TextBlock textBlock = this.getTextMainBlock(fileFormatOption);
        textBlock.drawU(ug);
    }

    public final Pragma getPragma() {
        return this.skinParam.getPragma();
    }

    @Override
    public void addWarning(Warning warning) {
        this.getPragma().addWarning(warning);
    }

    @Override
    public Collection<Warning> getWarnings() {
        return TitledDiagram.join(this.getPreprocessingArtifact().getWarnings(), this.getPragma().getWarnings());
    }

    private static Collection<Warning> join(Collection<Warning> col1, Collection<Warning> col2) {
        LinkedHashSet<Warning> result = new LinkedHashSet<Warning>();
        result.addAll(col1);
        result.addAll(col2);
        return result;
    }

    public String getFlashData() {
        UmlSource source = this.getSource();
        if (source == null) {
            return "";
        }
        return source.getPlainString("\n");
    }
}

