/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.nio;

import java.nio.channels.SocketChannel;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.nio.NioSocketChannel;
import org.opensearch.transport.TcpChannel;

public class NioTcpChannel
extends NioSocketChannel
implements TcpChannel {
    private final boolean isServer;
    private final String profile;
    private final TcpChannel.ChannelStats stats = new TcpChannel.ChannelStats();

    public NioTcpChannel(boolean isServer, String profile, SocketChannel socketChannel) {
        super(socketChannel);
        this.isServer = isServer;
        this.profile = profile;
    }

    public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
        this.getContext().sendMessage((Object)BytesReference.toByteBuffers((BytesReference)reference), ActionListener.toBiConsumer(listener));
    }

    public boolean isServerChannel() {
        return this.isServer;
    }

    public String getProfile() {
        return this.profile;
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.addCloseListener(ActionListener.toBiConsumer(listener));
    }

    public void addConnectListener(ActionListener<Void> listener) {
        this.addConnectListener(ActionListener.toBiConsumer(listener));
    }

    public TcpChannel.ChannelStats getChannelStats() {
        return this.stats;
    }

    public void close() {
        this.getContext().closeChannel();
    }

    public String toString() {
        return "TcpNioSocketChannel{localAddress=" + String.valueOf(this.getLocalAddress()) + ", remoteAddress=" + String.valueOf(this.getRemoteAddress()) + "}";
    }
}

