/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.support.SecuritySettings;

public class SSLConfig {
    private static final Logger logger = LogManager.getLogger(SSLConfig.class);
    private final boolean sslOnly;
    private volatile boolean dualModeEnabled;

    public SSLConfig(boolean sslOnly, boolean dualModeEnabled) {
        this.sslOnly = sslOnly;
        this.dualModeEnabled = dualModeEnabled;
        logger.info("SSL dual mode is {}", (Object)(this.isDualModeEnabled() ? "enabled" : "disabled"));
    }

    public SSLConfig(Settings settings) {
        this(settings.getAsBoolean("plugins.security.ssl_only", Boolean.valueOf(false)), (Boolean)SecuritySettings.SSL_DUAL_MODE_SETTING.get(settings));
    }

    public void registerClusterSettingsChangeListener(ClusterSettings clusterSettings) {
        clusterSettings.addSettingsUpdateConsumer(SecuritySettings.SSL_DUAL_MODE_SETTING, dualModeEnabledClusterSetting -> {
            logger.info("Detected change in settings, cluster setting for SSL dual mode is {}", (Object)(dualModeEnabledClusterSetting != false ? "enabled" : "disabled"));
            this.setDualModeEnabled((boolean)dualModeEnabledClusterSetting);
        });
    }

    private void setDualModeEnabled(boolean dualModeEnabled) {
        this.dualModeEnabled = dualModeEnabled;
    }

    public boolean isDualModeEnabled() {
        return this.dualModeEnabled;
    }

    public boolean isSslOnlyMode() {
        return this.sslOnly;
    }
}

