/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl;

import io.netty.handler.ssl.SslContext;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.security.ssl.SslConfiguration;
import org.opensearch.security.ssl.config.Certificate;
import org.opensearch.transport.NettyAllocator;

public class SslContextHandler {
    private static final Logger LOGGER = LogManager.getLogger(SslContextHandler.class);
    private SslContext sslContext;
    private final SslConfiguration sslConfiguration;
    private final List<Certificate> loadedCertificates;

    public SslContextHandler(SslConfiguration sslConfiguration) {
        this(sslConfiguration, false);
    }

    public SslContextHandler(SslConfiguration sslConfiguration, boolean client) {
        this.sslContext = client ? sslConfiguration.buildClientSslContext(true) : sslConfiguration.buildServerSslContext(true);
        this.sslConfiguration = sslConfiguration;
        this.loadedCertificates = sslConfiguration.certificates();
    }

    public SSLEngine createSSLEngine() {
        return this.sslContext.newEngine(NettyAllocator.getAllocator());
    }

    public SSLEngine createSSLEngine(String hostname, int port) {
        return this.sslContext.newEngine(NettyAllocator.getAllocator(), hostname, port);
    }

    public SslConfiguration sslConfiguration() {
        return this.sslConfiguration;
    }

    SslContext sslContext() {
        return this.sslContext;
    }

    public Stream<Certificate> authorityCertificates() {
        return this.authorityCertificates(this.loadedCertificates);
    }

    Stream<Certificate> authorityCertificates(List<Certificate> certificates) {
        return certificates.stream().filter(Predicate.not(Certificate::hasKey));
    }

    public Stream<Certificate> keyMaterialCertificates() {
        return this.keyMaterialCertificates(this.loadedCertificates);
    }

    Stream<Certificate> keyMaterialCertificates(List<Certificate> certificates) {
        return certificates.stream().filter(Certificate::hasKey);
    }

    boolean reloadSslContext() throws CertificateException {
        List<Certificate> newCertificates = this.sslConfiguration.certificates();
        boolean hasChanges = false;
        List<Certificate> loadedAuthorityCertificates = this.authorityCertificates().collect(Collectors.toList());
        List<Certificate> loadedKeyMaterialCertificates = this.keyMaterialCertificates().collect(Collectors.toList());
        List<Certificate> newAuthorityCertificates = this.authorityCertificates(newCertificates).collect(Collectors.toList());
        List<Certificate> newKeyMaterialCertificates = this.keyMaterialCertificates(newCertificates).collect(Collectors.toList());
        if (this.notSameCertificates(loadedAuthorityCertificates, newAuthorityCertificates)) {
            LOGGER.debug("Certification authority has changed");
            hasChanges = true;
            this.validateDates(newAuthorityCertificates);
        }
        if (this.notSameCertificates(loadedKeyMaterialCertificates, newKeyMaterialCertificates)) {
            LOGGER.debug("Key material and access certificate has changed");
            hasChanges = true;
            this.validateNewKeyMaterialCertificates(loadedKeyMaterialCertificates, newKeyMaterialCertificates, this.sslConfiguration.sslParameters().shouldValidateNewCertDNs());
        }
        if (hasChanges) {
            this.invalidateSessions();
            this.sslContext = this.sslContext.isClient() ? this.sslConfiguration.buildClientSslContext(false) : this.sslConfiguration.buildServerSslContext(false);
            this.loadedCertificates.clear();
            this.loadedCertificates.addAll(newCertificates);
        }
        return hasChanges;
    }

    private boolean notSameCertificates(List<Certificate> loadedCertificates, List<Certificate> newCertificates) {
        Set newCertSignatureSet;
        Set currentCertSignatureSet = loadedCertificates.stream().map(Certificate::x509Certificate).map(X509Certificate::getSignature).map(s -> new String((byte[])s, StandardCharsets.UTF_8)).collect(Collectors.toSet());
        return !currentCertSignatureSet.equals(newCertSignatureSet = newCertificates.stream().map(Certificate::x509Certificate).map(X509Certificate::getSignature).map(s -> new String((byte[])s, StandardCharsets.UTF_8)).collect(Collectors.toSet()));
    }

    private void validateDates(List<Certificate> newCertificates) throws CertificateException {
        for (Certificate certificate : newCertificates) {
            certificate.x509Certificate().checkValidity();
        }
    }

    private void validateSubjectDns(List<Certificate> loadedCertificates, List<Certificate> newCertificates) throws CertificateException {
        List newSubjectDNs;
        List currentSubjectDNs = loadedCertificates.stream().map(Certificate::subject).sorted().collect(Collectors.toList());
        if (!currentSubjectDNs.equals(newSubjectDNs = newCertificates.stream().map(Certificate::subject).sorted().collect(Collectors.toList()))) {
            throw new CertificateException("New certificates do not have valid Subject DNs. Current Subject DNs " + String.valueOf(currentSubjectDNs) + " new Subject DNs " + String.valueOf(newSubjectDNs));
        }
    }

    private void validateIssuerDns(List<Certificate> loadedCertificates, List<Certificate> newCertificates) throws CertificateException {
        List newIssuerDNs;
        List currentIssuerDNs = loadedCertificates.stream().map(Certificate::issuer).sorted().collect(Collectors.toList());
        if (!currentIssuerDNs.equals(newIssuerDNs = newCertificates.stream().map(Certificate::issuer).sorted().collect(Collectors.toList()))) {
            throw new CertificateException("New certificates do not have valid Issuer DNs. Current Issuer DNs: " + String.valueOf(currentIssuerDNs) + " new Issuer DNs: " + String.valueOf(newIssuerDNs));
        }
    }

    private void validateSans(List<Certificate> loadedCertificates, List<Certificate> newCertificates) throws CertificateException {
        List newSans;
        List currentSans = loadedCertificates.stream().map(Certificate::subjectAlternativeNames).sorted().collect(Collectors.toList());
        if (!currentSans.equals(newSans = newCertificates.stream().map(Certificate::subjectAlternativeNames).sorted().collect(Collectors.toList()))) {
            throw new CertificateException("New certificates do not have valid SANs. Current SANs: " + String.valueOf(currentSans) + " new SANs: " + String.valueOf(newSans));
        }
    }

    private void validateNewKeyMaterialCertificates(List<Certificate> loadedCertificates, List<Certificate> newCertificates, boolean shouldValidateNewCertDNs) throws CertificateException {
        this.validateDates(newCertificates);
        if (shouldValidateNewCertDNs) {
            this.validateSubjectDns(loadedCertificates, newCertificates);
            this.validateIssuerDns(loadedCertificates, newCertificates);
            this.validateSans(loadedCertificates, newCertificates);
        }
    }

    private void invalidateSessions() {
        SSLSessionContext sessionContext = this.sslContext.sessionContext();
        if (sessionContext != null) {
            for (byte[] sessionId : Collections.list(sessionContext.getIds())) {
                SSLSession session = sessionContext.getSession(sessionId);
                if (session == null) continue;
                session.invalidate();
            }
        }
    }
}

