/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.jvmsizing;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.performanceanalyzer.rca.framework.api.Rca;
import org.opensearch.performanceanalyzer.rca.framework.api.Resources;
import org.opensearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotClusterSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericFlowUnit;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;

public class LargeHeapClusterRca
extends Rca<ResourceFlowUnit<HotClusterSummary>> {
    private static final long EVAL_INTERVAL_IN_S = 5L;
    private final Rca<ResourceFlowUnit<HotNodeSummary>> oldGenContendedRca;

    public LargeHeapClusterRca(Rca<ResourceFlowUnit<HotNodeSummary>> oldGenContendedRca) {
        super(5L);
        this.oldGenContendedRca = oldGenContendedRca;
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        throw new UnsupportedOperationException("generateFlowUnitListFromWire is not supported on the node-local RCA: " + args.getNode().name());
    }

    @Override
    public ResourceFlowUnit<HotClusterSummary> operate() {
        List oldGenContendedFlowUnits = this.oldGenContendedRca.getFlowUnits();
        ArrayList<HotNodeSummary> unhealthyNodeSummaries = new ArrayList<HotNodeSummary>();
        long currTime = System.currentTimeMillis();
        for (Object flowUnit : oldGenContendedFlowUnits) {
            if (((GenericFlowUnit)flowUnit).isEmpty() || !((ResourceFlowUnit)flowUnit).getResourceContext().isUnhealthy()) continue;
            unhealthyNodeSummaries.add((HotNodeSummary)((ResourceFlowUnit)flowUnit).getSummary());
        }
        if (unhealthyNodeSummaries.isEmpty()) {
            return new ResourceFlowUnit<HotClusterSummary>(currTime);
        }
        HotClusterSummary summary = new HotClusterSummary(this.getAppContext().getAllClusterInstances().size(), unhealthyNodeSummaries.stream().map(HotNodeSummary::getNodeID).collect(Collectors.toSet()).size());
        for (HotNodeSummary hotNodeSummary : unhealthyNodeSummaries) {
            summary.appendNestedSummary(hotNodeSummary);
        }
        ResourceContext context = new ResourceContext(Resources.State.CONTENDED);
        return new ResourceFlowUnit<HotClusterSummary>(currTime, context, summary);
    }
}

