/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.quantization.sampler;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import lombok.Generated;
import org.opensearch.knn.quantization.sampler.Sampler;

final class ReservoirSampler
implements Sampler {
    private static ReservoirSampler instance;

    public static synchronized ReservoirSampler getInstance() {
        if (instance == null) {
            instance = new ReservoirSampler();
        }
        return instance;
    }

    @Override
    public int[] sample(int totalNumberOfVectors, int sampleSize) {
        if (totalNumberOfVectors <= sampleSize) {
            return IntStream.range(0, totalNumberOfVectors).toArray();
        }
        return this.reservoirSampleIndices(totalNumberOfVectors, sampleSize);
    }

    private int[] reservoirSampleIndices(int numVectors, int sampleSize) {
        int i;
        int[] indices = new int[sampleSize];
        for (i = 0; i < sampleSize; ++i) {
            indices[i] = i;
        }
        for (i = sampleSize; i < numVectors; ++i) {
            int j = ThreadLocalRandom.current().nextInt(i + 1);
            if (j >= sampleSize) continue;
            indices[j] = i;
        }
        Arrays.sort(indices);
        return indices;
    }

    @Generated
    public ReservoirSampler() {
    }
}

