"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexDataAdaptor = void 0;
var _json_data_adaptor = require("./json_data_adaptor");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class IndexDataAdaptor {
  constructor(client, directory) {
    _defineProperty(this, "isConfigLocalized", true);
    _defineProperty(this, "directory", void 0);
    _defineProperty(this, "client", void 0);
    this.directory = directory;
    this.client = client;
  }
  async findIntegrationVersions(dirname) {
    const integrationVersions = await this.client.find({
      type: 'integration-template',
      fields: ['name', 'version'],
      search: dirname ? `"${dirname}"` : undefined,
      searchFields: ['name']
    });
    const adaptor = new _json_data_adaptor.JsonCatalogDataAdaptor(integrationVersions.saved_objects.map(obj => obj.attributes));
    return await adaptor.findIntegrationVersions(dirname);
  }
  async readFile(filename, type) {
    // Duplicates a lot of logic from the Json Adaptor version since we need to parse config
    // for an efficient network query anyways
    if (type !== undefined) {
      return {
        ok: false,
        error: new Error('JSON adaptor does not support subtypes (isConfigLocalized: true)')
      };
    }
    const filenameParts = filename.match(/([\w]+)-(\d+(\.\d+)*)\.json/);
    if (!filenameParts) {
      return {
        ok: false,
        error: new Error(`Invalid Config filename: ${filename}`)
      };
    }
    const integrations = await this.client.find({
      type: 'integration-template',
      search: `"${filenameParts[1]}" + "${filenameParts[2]}"`,
      searchFields: ['name', 'version']
    });
    if (integrations.total === 0) {
      return {
        ok: false,
        error: new Error('Config file not found: ' + filename)
      };
    }
    return {
      ok: true,
      value: integrations.saved_objects[0].attributes
    };
  }
  async readFileRaw(_filename, _type) {
    return {
      ok: false,
      error: new Error('JSON adaptor does not support raw files (isConfigLocalized: true)')
    };
  }
  async findIntegrations(dirname = '.') {
    const dir = dirname !== '.' ? dirname : this.directory;
    const integrations = await this.client.find({
      type: 'integration-template',
      fields: ['name'],
      search: dir ? `"${dir}"` : undefined,
      searchFields: ['name']
    });
    const names = integrations.saved_objects.map(obj => obj.attributes.name);
    return {
      ok: true,
      value: [...new Set(names)]
    };
  }
  async getDirectoryType(dirname) {
    const names = await this.findIntegrations(dirname !== null && dirname !== void 0 ? dirname : '.');
    if (!names.value || names.value.length === 0) {
      return 'unknown';
    }
    if (names.value.length === 1) {
      return 'integration';
    }
    return 'repository';
  }
  join(filename) {
    return new IndexDataAdaptor(this.client, filename);
  }
}
exports.IndexDataAdaptor = IndexDataAdaptor;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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