/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.opensearch.common.CheckedFunction;
import org.opensearch.search.aggregations.AggregationReduceableSearchResult;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.BucketCollector;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.MultiBucketCollector;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.query.ReduceableSearchResult;

public abstract class AggregationCollectorManager
implements CollectorManager<Collector, ReduceableSearchResult> {
    protected final SearchContext context;
    private final CheckedFunction<SearchContext, List<Aggregator>, IOException> aggProvider;
    private final String collectorReason;

    AggregationCollectorManager(SearchContext context, CheckedFunction<SearchContext, List<Aggregator>, IOException> aggProvider, String collectorReason) {
        this.context = context;
        this.aggProvider = aggProvider;
        this.collectorReason = collectorReason;
    }

    public Collector newCollector() throws IOException {
        Collector collector = AggregationCollectorManager.createCollector((List)this.aggProvider.apply((Object)this.context));
        assert (collector != BucketCollector.NO_OP_COLLECTOR);
        return collector;
    }

    public String getCollectorReason() {
        return this.collectorReason;
    }

    public abstract String getCollectorName();

    public ReduceableSearchResult reduce(Collection<Collector> collectors) throws IOException {
        List<InternalAggregation> internals = this.context.bucketCollectorProcessor().toInternalAggregations(collectors);
        assert (internals.stream().noneMatch(Objects::isNull));
        this.context.aggregations().resetBucketMultiConsumer();
        InternalAggregations internalAggregations = new InternalAggregations(internals, this.context.request().source().aggregations()::buildPipelineTree);
        return this.buildAggregationResult(internalAggregations);
    }

    protected AggregationReduceableSearchResult buildAggregationResult(InternalAggregations internalAggregations) {
        return new AggregationReduceableSearchResult(internalAggregations);
    }

    static Collector createCollector(List<Aggregator> collectors) throws IOException {
        BucketCollector collector = MultiBucketCollector.wrap(collectors);
        collector.preCollection();
        return collector;
    }
}

