# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Python bindings for libnvme"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _nvme
else:
    import _nvme

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



def hostnqn_from_file():
    r"""hostnqn_from_file() -> PyObject *"""
    return _nvme.hostnqn_from_file()

def hostid_from_file():
    r"""hostid_from_file() -> PyObject *"""
    return _nvme.hostid_from_file()
class host_iter(object):
    r"""Proxy of C host_iter struct."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    root = property(_nvme.host_iter_root_get, _nvme.host_iter_root_set, doc=r"""root : p.struct nvme_root""")
    pos = property(_nvme.host_iter_pos_get, _nvme.host_iter_pos_set, doc=r"""pos : p.struct nvme_host""")

    def __iter__(self):
        r"""__iter__(host_iter self) -> host_iter"""
        return _nvme.host_iter___iter__(self)

    def __next__(self):
        r"""__next__(host_iter self) -> host"""
        return _nvme.host_iter___next__(self)

    def __init__(self):
        r"""__init__(host_iter self) -> host_iter"""
        _nvme.host_iter_swiginit(self, _nvme.new_host_iter())
    __swig_destroy__ = _nvme.delete_host_iter

# Register host_iter in _nvme:
_nvme.host_iter_swigregister(host_iter)
class subsystem_iter(object):
    r"""Proxy of C subsystem_iter struct."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    host = property(_nvme.subsystem_iter_host_get, _nvme.subsystem_iter_host_set, doc=r"""host : p.struct nvme_host""")
    pos = property(_nvme.subsystem_iter_pos_get, _nvme.subsystem_iter_pos_set, doc=r"""pos : p.struct nvme_subsystem""")

    def __iter__(self):
        r"""__iter__(subsystem_iter self) -> subsystem_iter"""
        return _nvme.subsystem_iter___iter__(self)

    def __next__(self):
        r"""__next__(subsystem_iter self) -> subsystem"""
        return _nvme.subsystem_iter___next__(self)

    def __init__(self):
        r"""__init__(subsystem_iter self) -> subsystem_iter"""
        _nvme.subsystem_iter_swiginit(self, _nvme.new_subsystem_iter())
    __swig_destroy__ = _nvme.delete_subsystem_iter

# Register subsystem_iter in _nvme:
_nvme.subsystem_iter_swigregister(subsystem_iter)
class ctrl_iter(object):
    r"""Proxy of C ctrl_iter struct."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    subsystem = property(_nvme.ctrl_iter_subsystem_get, _nvme.ctrl_iter_subsystem_set, doc=r"""subsystem : p.struct nvme_subsystem""")
    pos = property(_nvme.ctrl_iter_pos_get, _nvme.ctrl_iter_pos_set, doc=r"""pos : p.struct nvme_ctrl""")

    def __iter__(self):
        r"""__iter__(ctrl_iter self) -> ctrl_iter"""
        return _nvme.ctrl_iter___iter__(self)

    def __next__(self):
        r"""__next__(ctrl_iter self) -> ctrl"""
        return _nvme.ctrl_iter___next__(self)

    def __init__(self):
        r"""__init__(ctrl_iter self) -> ctrl_iter"""
        _nvme.ctrl_iter_swiginit(self, _nvme.new_ctrl_iter())
    __swig_destroy__ = _nvme.delete_ctrl_iter

# Register ctrl_iter in _nvme:
_nvme.ctrl_iter_swigregister(ctrl_iter)
class ns_iter(object):
    r"""Proxy of C ns_iter struct."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    subsystem = property(_nvme.ns_iter_subsystem_get, _nvme.ns_iter_subsystem_set, doc=r"""subsystem : p.struct nvme_subsystem""")
    ctrl = property(_nvme.ns_iter_ctrl_get, _nvme.ns_iter_ctrl_set, doc=r"""ctrl : p.struct nvme_ctrl""")
    pos = property(_nvme.ns_iter_pos_get, _nvme.ns_iter_pos_set, doc=r"""pos : p.struct nvme_ns""")

    def __iter__(self):
        r"""__iter__(ns_iter self) -> ns_iter"""
        return _nvme.ns_iter___iter__(self)

    def __next__(self):
        r"""__next__(ns_iter self) -> ns"""
        return _nvme.ns_iter___next__(self)

    def __init__(self):
        r"""__init__(ns_iter self) -> ns_iter"""
        _nvme.ns_iter_swiginit(self, _nvme.new_ns_iter())
    __swig_destroy__ = _nvme.delete_ns_iter

# Register ns_iter in _nvme:
_nvme.ns_iter_swigregister(ns_iter)
class root(object):
    r"""Proxy of C nvme_root struct."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    config_file = property(_nvme.root_config_file_get, doc=r"""config_file : p.char""")
    application = property(_nvme.root_application_get, doc=r"""application : p.char""")

    def __init__(self, config_file=None):
        r"""__init__(root self, char const * config_file=None) -> root"""
        _nvme.root_swiginit(self, _nvme.new_root(config_file))
    __swig_destroy__ = _nvme.delete_root

    def log_level(self, level):
        r"""log_level(root self, char const * level)"""
        return _nvme.root_log_level(self, level)

    def hosts(self):
        r"""hosts(root self) -> host"""
        return _nvme.root_hosts(self)

    def refresh_topology(self):
        r"""refresh_topology(root self)"""
        return _nvme.root_refresh_topology(self)

    def update_config(self):
        r"""update_config(root self)"""
        return _nvme.root_update_config(self)

    def dump_config(self):
        r"""dump_config(root self)"""
        return _nvme.root_dump_config(self)

# Register root in _nvme:
_nvme.root_swigregister(root)
class host(object):
    r"""Proxy of C nvme_host struct."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    hostnqn = property(_nvme.host_hostnqn_get, doc=r"""hostnqn : p.char""")
    hostid = property(_nvme.host_hostid_get, doc=r"""hostid : p.char""")
    hostsymname = property(_nvme.host_hostsymname_get, doc=r"""hostsymname : p.char""")
    dhchap_key = property(_nvme.host_dhchap_key_get, _nvme.host_dhchap_key_set, doc=r"""dhchap_key : p.char""")

    def __init__(self, r, hostnqn=None, hostid=None, hostkey=None, hostsymname=None):
        r"""__init__(host self, root r, char const * hostnqn=None, char const * hostid=None, char const * hostkey=None, char const * hostsymname=None) -> host"""
        _nvme.host_swiginit(self, _nvme.new_host(r, hostnqn, hostid, hostkey, hostsymname))

        self.__parent = r  # Keep a reference to parent to ensure garbage collection happens in the right order


    __swig_destroy__ = _nvme.delete_host

    def set_symname(self, hostsymname):
        r"""
        @brief Set or Clear Host's Symbolic Name

        @param hostsymname: A symbolic name, or None to clear the symbolic name.
        @type hostsymname: str|None

        @return: None
        """
        return _nvme.host_set_symname(self, hostsymname)

    def __str__(self):
        r"""__str__(host self) -> PyObject *"""
        return _nvme.host___str__(self)

    def __iter__(self):
        r"""__iter__(host self) -> host_iter"""
        return _nvme.host___iter__(self)

    def subsystems(self):
        r"""subsystems(host self) -> subsystem"""
        return _nvme.host_subsystems(self)

# Register host in _nvme:
_nvme.host_swigregister(host)
class subsystem(object):
    r"""Proxy of C nvme_subsystem struct."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    subsysnqn = property(_nvme.subsystem_subsysnqn_get, doc=r"""subsysnqn : p.char""")
    model = property(_nvme.subsystem_model_get, doc=r"""model : p.char""")
    serial = property(_nvme.subsystem_serial_get, doc=r"""serial : p.char""")
    firmware = property(_nvme.subsystem_firmware_get, doc=r"""firmware : p.char""")
    application = property(_nvme.subsystem_application_get, doc=r"""application : p.char""")

    def __init__(self, host, subsysnqn, name=None):
        r"""__init__(subsystem self, host host, char const * subsysnqn, char const * name=None) -> subsystem"""
        _nvme.subsystem_swiginit(self, _nvme.new_subsystem(host, subsysnqn, name))

        self.__parent = host  # Keep a reference to parent to ensure garbage collection happens in the right order


    __swig_destroy__ = _nvme.delete_subsystem

    def __str__(self):
        r"""__str__(subsystem self) -> PyObject *"""
        return _nvme.subsystem___str__(self)

    def __iter__(self):
        r"""__iter__(subsystem self) -> subsystem_iter"""
        return _nvme.subsystem___iter__(self)

    def controllers(self):
        r"""controllers(subsystem self) -> ctrl"""
        return _nvme.subsystem_controllers(self)

    def namespaces(self):
        r"""namespaces(subsystem self) -> ns"""
        return _nvme.subsystem_namespaces(self)
    name = property(_nvme.subsystem_name_get, doc=r"""name : p.q(const).char""")
    host = property(_nvme.subsystem_host_get, doc=r"""host : p.struct nvme_host""")

# Register subsystem in _nvme:
_nvme.subsystem_swigregister(subsystem)
class ctrl(object):
    r"""Proxy of C nvme_ctrl struct."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    cntrltype = property(_nvme.ctrl_cntrltype_get, doc=r"""cntrltype : p.q(const).char""")
    dctype = property(_nvme.ctrl_dctype_get, doc=r"""dctype : p.q(const).char""")
    discovered = property(_nvme.ctrl_discovered_get, doc=r"""discovered : q(const).bool""")
    name = property(_nvme.ctrl_name_get, doc=r"""name : p.q(const).char""")
    state = property(_nvme.ctrl_state_get, doc=r"""state : p.q(const).char""")
    sysfs_dir = property(_nvme.ctrl_sysfs_dir_get, doc=r"""sysfs_dir : p.q(const).char""")
    address = property(_nvme.ctrl_address_get, doc=r"""address : p.q(const).char""")
    firmware = property(_nvme.ctrl_firmware_get, doc=r"""firmware : p.q(const).char""")
    model = property(_nvme.ctrl_model_get, doc=r"""model : p.q(const).char""")
    numa_node = property(_nvme.ctrl_numa_node_get, doc=r"""numa_node : p.q(const).char""")
    queue_count = property(_nvme.ctrl_queue_count_get, doc=r"""queue_count : p.q(const).char""")
    serial = property(_nvme.ctrl_serial_get, doc=r"""serial : p.q(const).char""")
    sqsize = property(_nvme.ctrl_sqsize_get, doc=r"""sqsize : p.q(const).char""")
    transport = property(_nvme.ctrl_transport_get, doc=r"""transport : p.q(const).char""")
    subsysnqn = property(_nvme.ctrl_subsysnqn_get, doc=r"""subsysnqn : p.q(const).char""")
    traddr = property(_nvme.ctrl_traddr_get, doc=r"""traddr : p.q(const).char""")
    trsvcid = property(_nvme.ctrl_trsvcid_get, doc=r"""trsvcid : p.q(const).char""")
    cntlid = property(_nvme.ctrl_cntlid_get, doc=r"""cntlid : p.q(const).char""")
    phy_slot = property(_nvme.ctrl_phy_slot_get, doc=r"""phy_slot : p.q(const).char""")
    unique_discovery_ctrl = property(_nvme.ctrl_unique_discovery_ctrl_get, _nvme.ctrl_unique_discovery_ctrl_set, doc=r"""unique_discovery_ctrl : bool""")
    discovery_ctrl = property(_nvme.ctrl_discovery_ctrl_get, _nvme.ctrl_discovery_ctrl_set, doc=r"""discovery_ctrl : bool""")
    persistent = property(_nvme.ctrl_persistent_get, _nvme.ctrl_persistent_set, doc=r"""persistent : bool""")
    keyring = property(_nvme.ctrl_keyring_get, _nvme.ctrl_keyring_set, doc=r"""keyring : p.char""")
    tls_key_identity = property(_nvme.ctrl_tls_key_identity_get, _nvme.ctrl_tls_key_identity_set, doc=r"""tls_key_identity : p.char""")
    tls_key = property(_nvme.ctrl_tls_key_get, _nvme.ctrl_tls_key_set, doc=r"""tls_key : p.char""")
    subsystem = property(_nvme.ctrl_subsystem_get, doc=r"""subsystem : p.struct nvme_subsystem""")
    dhchap_host_key = property(_nvme.ctrl_dhchap_host_key_get, _nvme.ctrl_dhchap_host_key_set, doc=r"""dhchap_host_key : p.char""")
    dhchap_key = property(_nvme.ctrl_dhchap_key_get, _nvme.ctrl_dhchap_key_set, doc=r"""dhchap_key : p.char""")

    def __init__(self, r, subsysnqn, transport, traddr=None, host_traddr=None, host_iface=None, trsvcid=None):
        r"""__init__(ctrl self, root r, char const * subsysnqn, char const * transport, char const * traddr=None, char const * host_traddr=None, char const * host_iface=None, char const * trsvcid=None) -> ctrl"""
        _nvme.ctrl_swiginit(self, _nvme.new_ctrl(r, subsysnqn, transport, traddr, host_traddr, host_iface, trsvcid))
    __swig_destroy__ = _nvme.delete_ctrl

    def discovery_ctrl_set(self, discovery: bool):
        r"""DEPRECATED METHOD: Use property setter instead (e.g. ctrl.discovery_ctrl = True)"""
        import warnings
        warnings.warn("Use property setter instead (e.g. ctrl_obj.discovery_ctrl = True)", DeprecationWarning, stacklevel=2)
        return _nvme.ctrl_discovery_ctrl_set(self, discovery)


    def init(self, h, instance):
        r"""init(ctrl self, host h, int instance) -> bool"""
        val = _nvme.ctrl_init(self, h, instance)

        self.__host = h  # Keep a reference to parent to ensure ctrl obj gets GCed before host

        return val


    def connect(self, h, cfg=None):
        r"""connect(ctrl self, host h, struct nvme_fabrics_config * cfg=None)"""
        val = _nvme.ctrl_connect(self, h, cfg)

        self.__host = h  # Keep a reference to parent to ensure ctrl obj gets GCed before host

        return val


    def connected(self):
        r"""connected(ctrl self) -> bool"""
        return _nvme.ctrl_connected(self)

    def persistent_set(self, persistent: bool):
        r"""DEPRECATED METHOD: Use property setter instead (e.g. ctrl.persistent = True)"""
        import warnings
        warnings.warn("Use property setter instead (e.g. ctrl_obj.persistent = True)", DeprecationWarning, stacklevel=2)
        return _nvme.ctrl_persistent_set(self, persistent)


    def rescan(self):
        r"""rescan(ctrl self)"""
        return _nvme.ctrl_rescan(self)

    def disconnect(self):
        r"""disconnect(ctrl self)"""
        return _nvme.ctrl_disconnect(self)

    def is_registration_supported(self):
        r"""@return: True if controller supports explicit registration. False otherwise."""
        return _nvme.ctrl_is_registration_supported(self)

    def registration_ctlr(self, tas):
        r"""@return None on success or Error string on error."""
        return _nvme.ctrl_registration_ctlr(self, tas)

    def discover(self, lsp=0, max_retries=6):
        r"""discover(ctrl self, int lsp=0, int max_retries=6) -> struct nvmf_discovery_log *"""
        return _nvme.ctrl_discover(self, lsp, max_retries)

    def supported_log_pages(self, *args):
        r"""@return: List of supported log pages"""
        return _nvme.ctrl_supported_log_pages(self, *args)

    def __str__(self):
        r"""__str__(ctrl self) -> PyObject *"""
        return _nvme.ctrl___str__(self)

    def __iter__(self):
        r"""__iter__(ctrl self) -> ctrl_iter"""
        return _nvme.ctrl___iter__(self)

    def namespaces(self):
        r"""namespaces(ctrl self) -> ns"""
        return _nvme.ctrl_namespaces(self)

# Register ctrl in _nvme:
_nvme.ctrl_swigregister(ctrl)
class ns(object):
    r"""Proxy of C nvme_ns struct."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    nsid = property(_nvme.ns_nsid_get, doc=r"""nsid : unsigned int""")
    eui64 = property(_nvme.ns_eui64_get, doc=r"""eui64 : a(8).uint8_t""")
    nguid = property(_nvme.ns_nguid_get, doc=r"""nguid : a(16).uint8_t""")
    uuid = property(_nvme.ns_uuid_get, doc=r"""uuid : a(16).uint8_t""")

    def __init__(self, s, nsid):
        r"""__init__(ns self, subsystem s, unsigned int nsid) -> ns"""
        _nvme.ns_swiginit(self, _nvme.new_ns(s, nsid))

        self.__parent = s  # Keep a reference to parent to ensure garbage collection happens in the right order


    __swig_destroy__ = _nvme.delete_ns

    def __str__(self):
        r"""__str__(ns self) -> PyObject *"""
        return _nvme.ns___str__(self)

    def __iter__(self):
        r"""__iter__(ns self) -> ns_iter"""
        return _nvme.ns___iter__(self)
    name = property(_nvme.ns_name_get, doc=r"""name : p.q(const).char""")

# Register ns in _nvme:
_nvme.ns_swigregister(ns)

def nbft_get(filename):
    r"""
    @return an NBFT table as a dict on success, None otherwise.
    @param filename: file to read
    """
    return _nvme.nbft_get(filename)
NVME_UUID_LEN = _nvme.NVME_UUID_LEN

NVME_UUID_LEN_STRING = _nvme.NVME_UUID_LEN_STRING

NVME_NSID_ALL = _nvme.NVME_NSID_ALL

NVME_NSID_NONE = _nvme.NVME_NSID_NONE

NVME_UUID_NONE = _nvme.NVME_UUID_NONE

NVME_CNTLID_NONE = _nvme.NVME_CNTLID_NONE

NVME_CNSSPECID_NONE = _nvme.NVME_CNSSPECID_NONE

NVME_LOG_LSP_NONE = _nvme.NVME_LOG_LSP_NONE

NVME_LOG_LSI_NONE = _nvme.NVME_LOG_LSI_NONE

NVME_LOG_LPO_NONE = _nvme.NVME_LOG_LPO_NONE

NVME_IDENTIFY_DATA_SIZE = _nvme.NVME_IDENTIFY_DATA_SIZE

NVME_LOG_SUPPORTED_LOG_PAGES_MAX = _nvme.NVME_LOG_SUPPORTED_LOG_PAGES_MAX

NVME_ID_NVMSET_LIST_MAX = _nvme.NVME_ID_NVMSET_LIST_MAX

NVME_ID_UUID_LIST_MAX = _nvme.NVME_ID_UUID_LIST_MAX

NVME_ID_CTRL_LIST_MAX = _nvme.NVME_ID_CTRL_LIST_MAX

NVME_ID_NS_LIST_MAX = _nvme.NVME_ID_NS_LIST_MAX

NVME_ID_SECONDARY_CTRL_MAX = _nvme.NVME_ID_SECONDARY_CTRL_MAX

NVME_ID_DOMAIN_LIST_MAX = _nvme.NVME_ID_DOMAIN_LIST_MAX

NVME_ID_ENDURANCE_GROUP_LIST_MAX = _nvme.NVME_ID_ENDURANCE_GROUP_LIST_MAX

NVME_ID_ND_DESCRIPTOR_MAX = _nvme.NVME_ID_ND_DESCRIPTOR_MAX

NVME_FEAT_LBA_RANGE_MAX = _nvme.NVME_FEAT_LBA_RANGE_MAX

NVME_LOG_ST_MAX_RESULTS = _nvme.NVME_LOG_ST_MAX_RESULTS

NVME_LOG_TELEM_BLOCK_SIZE = _nvme.NVME_LOG_TELEM_BLOCK_SIZE

NVME_LOG_FID_SUPPORTED_EFFECTS_MAX = _nvme.NVME_LOG_FID_SUPPORTED_EFFECTS_MAX

NVME_LOG_MI_CMD_SUPPORTED_EFFECTS_MAX = _nvme.NVME_LOG_MI_CMD_SUPPORTED_EFFECTS_MAX

NVME_LOG_MI_CMD_SUPPORTED_EFFECTS_RESERVED = _nvme.NVME_LOG_MI_CMD_SUPPORTED_EFFECTS_RESERVED

NVME_DSM_MAX_RANGES = _nvme.NVME_DSM_MAX_RANGES

NVME_NQN_LENGTH = _nvme.NVME_NQN_LENGTH

NVMF_TRADDR_SIZE = _nvme.NVMF_TRADDR_SIZE

NVMF_TSAS_SIZE = _nvme.NVMF_TSAS_SIZE

NVME_ZNS_CHANGED_ZONES_MAX = _nvme.NVME_ZNS_CHANGED_ZONES_MAX

NVME_CSI_NVM = _nvme.NVME_CSI_NVM

NVME_CSI_KV = _nvme.NVME_CSI_KV

NVME_CSI_ZNS = _nvme.NVME_CSI_ZNS

NVME_CSI_SLM = _nvme.NVME_CSI_SLM

NVME_CSI_CP = _nvme.NVME_CSI_CP

NVME_REG_CAP = _nvme.NVME_REG_CAP

NVME_REG_VS = _nvme.NVME_REG_VS

NVME_REG_INTMS = _nvme.NVME_REG_INTMS

NVME_REG_INTMC = _nvme.NVME_REG_INTMC

NVME_REG_CC = _nvme.NVME_REG_CC

NVME_REG_CSTS = _nvme.NVME_REG_CSTS

NVME_REG_NSSR = _nvme.NVME_REG_NSSR

NVME_REG_AQA = _nvme.NVME_REG_AQA

NVME_REG_ASQ = _nvme.NVME_REG_ASQ

NVME_REG_ACQ = _nvme.NVME_REG_ACQ

NVME_REG_CMBLOC = _nvme.NVME_REG_CMBLOC

NVME_REG_CMBSZ = _nvme.NVME_REG_CMBSZ

NVME_REG_BPINFO = _nvme.NVME_REG_BPINFO

NVME_REG_BPRSEL = _nvme.NVME_REG_BPRSEL

NVME_REG_BPMBL = _nvme.NVME_REG_BPMBL

NVME_REG_CMBMSC = _nvme.NVME_REG_CMBMSC

NVME_REG_CMBSTS = _nvme.NVME_REG_CMBSTS

NVME_REG_CMBEBS = _nvme.NVME_REG_CMBEBS

NVME_REG_CMBSWTP = _nvme.NVME_REG_CMBSWTP

NVME_REG_NSSD = _nvme.NVME_REG_NSSD

NVME_REG_CRTO = _nvme.NVME_REG_CRTO

NVME_REG_PMRCAP = _nvme.NVME_REG_PMRCAP

NVME_REG_PMRCTL = _nvme.NVME_REG_PMRCTL

NVME_REG_PMRSTS = _nvme.NVME_REG_PMRSTS

NVME_REG_PMREBS = _nvme.NVME_REG_PMREBS

NVME_REG_PMRSWTP = _nvme.NVME_REG_PMRSWTP

NVME_REG_PMRMSCL = _nvme.NVME_REG_PMRMSCL

NVME_REG_PMRMSCU = _nvme.NVME_REG_PMRMSCU

NVME_CAP_MQES_SHIFT = _nvme.NVME_CAP_MQES_SHIFT

NVME_CAP_CQR_SHIFT = _nvme.NVME_CAP_CQR_SHIFT

NVME_CAP_AMS_SHIFT = _nvme.NVME_CAP_AMS_SHIFT

NVME_CAP_TO_SHIFT = _nvme.NVME_CAP_TO_SHIFT

NVME_CAP_DSTRD_SHIFT = _nvme.NVME_CAP_DSTRD_SHIFT

NVME_CAP_NSSRC_SHIFT = _nvme.NVME_CAP_NSSRC_SHIFT

NVME_CAP_CSS_SHIFT = _nvme.NVME_CAP_CSS_SHIFT

NVME_CAP_BPS_SHIFT = _nvme.NVME_CAP_BPS_SHIFT

NVME_CAP_CPS_SHIFT = _nvme.NVME_CAP_CPS_SHIFT

NVME_CAP_MPSMIN_SHIFT = _nvme.NVME_CAP_MPSMIN_SHIFT

NVME_CAP_MPSMAX_SHIFT = _nvme.NVME_CAP_MPSMAX_SHIFT

NVME_CAP_PMRS_SHIFT = _nvme.NVME_CAP_PMRS_SHIFT

NVME_CAP_CMBS_SHIFT = _nvme.NVME_CAP_CMBS_SHIFT

NVME_CAP_NSSS_SHIFT = _nvme.NVME_CAP_NSSS_SHIFT

NVME_CAP_CRMS_SHIFT = _nvme.NVME_CAP_CRMS_SHIFT

NVME_CAP_MQES_MASK = _nvme.NVME_CAP_MQES_MASK

NVME_CAP_CQR_MASK = _nvme.NVME_CAP_CQR_MASK

NVME_CAP_AMS_MASK = _nvme.NVME_CAP_AMS_MASK

NVME_CAP_TO_MASK = _nvme.NVME_CAP_TO_MASK

NVME_CAP_DSTRD_MASK = _nvme.NVME_CAP_DSTRD_MASK

NVME_CAP_NSSRC_MASK = _nvme.NVME_CAP_NSSRC_MASK

NVME_CAP_CSS_MASK = _nvme.NVME_CAP_CSS_MASK

NVME_CAP_BPS_MASK = _nvme.NVME_CAP_BPS_MASK

NVME_CAP_CPS_MASK = _nvme.NVME_CAP_CPS_MASK

NVME_CAP_MPSMIN_MASK = _nvme.NVME_CAP_MPSMIN_MASK

NVME_CAP_MPSMAX_MASK = _nvme.NVME_CAP_MPSMAX_MASK

NVME_CAP_PMRS_MASK = _nvme.NVME_CAP_PMRS_MASK

NVME_CAP_CMBS_MASK = _nvme.NVME_CAP_CMBS_MASK

NVME_CAP_NSSS_MASK = _nvme.NVME_CAP_NSSS_MASK

NVME_CAP_CRMS_MASK = _nvme.NVME_CAP_CRMS_MASK

NVME_CAP_AMS_WRR = _nvme.NVME_CAP_AMS_WRR

NVME_CAP_AMS_VS = _nvme.NVME_CAP_AMS_VS

NVME_CAP_CSS_NVM = _nvme.NVME_CAP_CSS_NVM

NVME_CAP_CSS_CSI = _nvme.NVME_CAP_CSS_CSI

NVME_CAP_CSS_ADMIN = _nvme.NVME_CAP_CSS_ADMIN

NVME_CAP_CPS_NONE = _nvme.NVME_CAP_CPS_NONE

NVME_CAP_CPS_CTRL = _nvme.NVME_CAP_CPS_CTRL

NVME_CAP_CPS_DOMAIN = _nvme.NVME_CAP_CPS_DOMAIN

NVME_CAP_CPS_NVMS = _nvme.NVME_CAP_CPS_NVMS

NVME_CAP_CRWMS = _nvme.NVME_CAP_CRWMS

NVME_CAP_CRIMS = _nvme.NVME_CAP_CRIMS

NVME_VS_TER_SHIFT = _nvme.NVME_VS_TER_SHIFT

NVME_VS_MNR_SHIFT = _nvme.NVME_VS_MNR_SHIFT

NVME_VS_MJR_SHIFT = _nvme.NVME_VS_MJR_SHIFT

NVME_VS_TER_MASK = _nvme.NVME_VS_TER_MASK

NVME_VS_MNR_MASK = _nvme.NVME_VS_MNR_MASK

NVME_VS_MJR_MASK = _nvme.NVME_VS_MJR_MASK

NVME_CC_EN_SHIFT = _nvme.NVME_CC_EN_SHIFT

NVME_CC_CSS_SHIFT = _nvme.NVME_CC_CSS_SHIFT

NVME_CC_MPS_SHIFT = _nvme.NVME_CC_MPS_SHIFT

NVME_CC_AMS_SHIFT = _nvme.NVME_CC_AMS_SHIFT

NVME_CC_SHN_SHIFT = _nvme.NVME_CC_SHN_SHIFT

NVME_CC_IOSQES_SHIFT = _nvme.NVME_CC_IOSQES_SHIFT

NVME_CC_IOCQES_SHIFT = _nvme.NVME_CC_IOCQES_SHIFT

NVME_CC_CRIME_SHIFT = _nvme.NVME_CC_CRIME_SHIFT

NVME_CC_EN_MASK = _nvme.NVME_CC_EN_MASK

NVME_CC_CSS_MASK = _nvme.NVME_CC_CSS_MASK

NVME_CC_MPS_MASK = _nvme.NVME_CC_MPS_MASK

NVME_CC_AMS_MASK = _nvme.NVME_CC_AMS_MASK

NVME_CC_SHN_MASK = _nvme.NVME_CC_SHN_MASK

NVME_CC_CRIME_MASK = _nvme.NVME_CC_CRIME_MASK

NVME_CC_IOSQES_MASK = _nvme.NVME_CC_IOSQES_MASK

NVME_CC_IOCQES_MASK = _nvme.NVME_CC_IOCQES_MASK

NVME_CC_CSS_NVM = _nvme.NVME_CC_CSS_NVM

NVME_CC_CSS_CSI = _nvme.NVME_CC_CSS_CSI

NVME_CC_CSS_ADMIN = _nvme.NVME_CC_CSS_ADMIN

NVME_CC_AMS_RR = _nvme.NVME_CC_AMS_RR

NVME_CC_AMS_WRRU = _nvme.NVME_CC_AMS_WRRU

NVME_CC_AMS_VS = _nvme.NVME_CC_AMS_VS

NVME_CC_SHN_NONE = _nvme.NVME_CC_SHN_NONE

NVME_CC_SHN_NORMAL = _nvme.NVME_CC_SHN_NORMAL

NVME_CC_SHN_ABRUPT = _nvme.NVME_CC_SHN_ABRUPT

NVME_CC_CRWME = _nvme.NVME_CC_CRWME

NVME_CC_CRIME = _nvme.NVME_CC_CRIME

NVME_CSTS_RDY_SHIFT = _nvme.NVME_CSTS_RDY_SHIFT

NVME_CSTS_CFS_SHIFT = _nvme.NVME_CSTS_CFS_SHIFT

NVME_CSTS_SHST_SHIFT = _nvme.NVME_CSTS_SHST_SHIFT

NVME_CSTS_NSSRO_SHIFT = _nvme.NVME_CSTS_NSSRO_SHIFT

NVME_CSTS_PP_SHIFT = _nvme.NVME_CSTS_PP_SHIFT

NVME_CSTS_ST_SHIFT = _nvme.NVME_CSTS_ST_SHIFT

NVME_CSTS_RDY_MASK = _nvme.NVME_CSTS_RDY_MASK

NVME_CSTS_CFS_MASK = _nvme.NVME_CSTS_CFS_MASK

NVME_CSTS_SHST_MASK = _nvme.NVME_CSTS_SHST_MASK

NVME_CSTS_NSSRO_MASK = _nvme.NVME_CSTS_NSSRO_MASK

NVME_CSTS_PP_MASK = _nvme.NVME_CSTS_PP_MASK

NVME_CSTS_ST_MASK = _nvme.NVME_CSTS_ST_MASK

NVME_CSTS_SHST_NORMAL = _nvme.NVME_CSTS_SHST_NORMAL

NVME_CSTS_SHST_OCCUR = _nvme.NVME_CSTS_SHST_OCCUR

NVME_CSTS_SHST_CMPLT = _nvme.NVME_CSTS_SHST_CMPLT

NVME_CSTS_SHN_MASK = _nvme.NVME_CSTS_SHN_MASK

NVME_AQA_ASQS_SHIFT = _nvme.NVME_AQA_ASQS_SHIFT

NVME_AQA_ACQS_SHIFT = _nvme.NVME_AQA_ACQS_SHIFT

NVME_AQA_ASQS_MASK = _nvme.NVME_AQA_ASQS_MASK

NVME_AQA_ACQS_MASK = _nvme.NVME_AQA_ACQS_MASK

NVME_ASQ_ASQB_SHIFT = _nvme.NVME_ASQ_ASQB_SHIFT

NVME_ACQ_ACQB_SHIFT = _nvme.NVME_ACQ_ACQB_SHIFT

NVME_CMBLOC_BIR_SHIFT = _nvme.NVME_CMBLOC_BIR_SHIFT

NVME_CMBLOC_CQMMS_SHIFT = _nvme.NVME_CMBLOC_CQMMS_SHIFT

NVME_CMBLOC_CQPDS_SHIFT = _nvme.NVME_CMBLOC_CQPDS_SHIFT

NVME_CMBLOC_CDPLMS_SHIFT = _nvme.NVME_CMBLOC_CDPLMS_SHIFT

NVME_CMBLOC_CDPCILS_SHIFT = _nvme.NVME_CMBLOC_CDPCILS_SHIFT

NVME_CMBLOC_CDMMMS_SHIFT = _nvme.NVME_CMBLOC_CDMMMS_SHIFT

NVME_CMBLOC_CQDA_SHIFT = _nvme.NVME_CMBLOC_CQDA_SHIFT

NVME_CMBLOC_OFST_SHIFT = _nvme.NVME_CMBLOC_OFST_SHIFT

NVME_CMBLOC_BIR_MASK = _nvme.NVME_CMBLOC_BIR_MASK

NVME_CMBLOC_CQMMS_MASK = _nvme.NVME_CMBLOC_CQMMS_MASK

NVME_CMBLOC_CQPDS_MASK = _nvme.NVME_CMBLOC_CQPDS_MASK

NVME_CMBLOC_CDPLMS_MASK = _nvme.NVME_CMBLOC_CDPLMS_MASK

NVME_CMBLOC_CDPCILS_MASK = _nvme.NVME_CMBLOC_CDPCILS_MASK

NVME_CMBLOC_CDMMMS_MASK = _nvme.NVME_CMBLOC_CDMMMS_MASK

NVME_CMBLOC_CQDA_MASK = _nvme.NVME_CMBLOC_CQDA_MASK

NVME_CMBLOC_OFST_MASK = _nvme.NVME_CMBLOC_OFST_MASK

NVME_CMBSZ_SQS_SHIFT = _nvme.NVME_CMBSZ_SQS_SHIFT

NVME_CMBSZ_CQS_SHIFT = _nvme.NVME_CMBSZ_CQS_SHIFT

NVME_CMBSZ_LISTS_SHIFT = _nvme.NVME_CMBSZ_LISTS_SHIFT

NVME_CMBSZ_RDS_SHIFT = _nvme.NVME_CMBSZ_RDS_SHIFT

NVME_CMBSZ_WDS_SHIFT = _nvme.NVME_CMBSZ_WDS_SHIFT

NVME_CMBSZ_SZU_SHIFT = _nvme.NVME_CMBSZ_SZU_SHIFT

NVME_CMBSZ_SZ_SHIFT = _nvme.NVME_CMBSZ_SZ_SHIFT

NVME_CMBSZ_SQS_MASK = _nvme.NVME_CMBSZ_SQS_MASK

NVME_CMBSZ_CQS_MASK = _nvme.NVME_CMBSZ_CQS_MASK

NVME_CMBSZ_LISTS_MASK = _nvme.NVME_CMBSZ_LISTS_MASK

NVME_CMBSZ_RDS_MASK = _nvme.NVME_CMBSZ_RDS_MASK

NVME_CMBSZ_WDS_MASK = _nvme.NVME_CMBSZ_WDS_MASK

NVME_CMBSZ_SZU_MASK = _nvme.NVME_CMBSZ_SZU_MASK

NVME_CMBSZ_SZ_MASK = _nvme.NVME_CMBSZ_SZ_MASK

NVME_CMBSZ_SZU_4K = _nvme.NVME_CMBSZ_SZU_4K

NVME_CMBSZ_SZU_64K = _nvme.NVME_CMBSZ_SZU_64K

NVME_CMBSZ_SZU_1M = _nvme.NVME_CMBSZ_SZU_1M

NVME_CMBSZ_SZU_16M = _nvme.NVME_CMBSZ_SZU_16M

NVME_CMBSZ_SZU_256M = _nvme.NVME_CMBSZ_SZU_256M

NVME_CMBSZ_SZU_4G = _nvme.NVME_CMBSZ_SZU_4G

NVME_CMBSZ_SZU_64G = _nvme.NVME_CMBSZ_SZU_64G

NVME_BPINFO_BPSZ_SHIFT = _nvme.NVME_BPINFO_BPSZ_SHIFT

NVME_BPINFO_BRS_SHIFT = _nvme.NVME_BPINFO_BRS_SHIFT

NVME_BPINFO_ABPID_SHIFT = _nvme.NVME_BPINFO_ABPID_SHIFT

NVME_BPINFO_BPSZ_MASK = _nvme.NVME_BPINFO_BPSZ_MASK

NVME_BPINFO_BRS_MASK = _nvme.NVME_BPINFO_BRS_MASK

NVME_BPINFO_ABPID_MASK = _nvme.NVME_BPINFO_ABPID_MASK

NVME_BPINFO_BRS_NONE = _nvme.NVME_BPINFO_BRS_NONE

NVME_BPINFO_BRS_READ_IN_PROGRESS = _nvme.NVME_BPINFO_BRS_READ_IN_PROGRESS

NVME_BPINFO_BRS_READ_SUCCESS = _nvme.NVME_BPINFO_BRS_READ_SUCCESS

NVME_BPINFO_BRS_READ_ERROR = _nvme.NVME_BPINFO_BRS_READ_ERROR

NVME_BPRSEL_BPRSZ_SHIFT = _nvme.NVME_BPRSEL_BPRSZ_SHIFT

NVME_BPRSEL_BPROF_SHIFT = _nvme.NVME_BPRSEL_BPROF_SHIFT

NVME_BPRSEL_BPID_SHIFT = _nvme.NVME_BPRSEL_BPID_SHIFT

NVME_BPRSEL_BPRSZ_MASK = _nvme.NVME_BPRSEL_BPRSZ_MASK

NVME_BPRSEL_BPROF_MASK = _nvme.NVME_BPRSEL_BPROF_MASK

NVME_BPRSEL_BPID_MASK = _nvme.NVME_BPRSEL_BPID_MASK

NVME_BPMBL_BMBBA_SHIFT = _nvme.NVME_BPMBL_BMBBA_SHIFT

NVME_CMBMSC_CRE_SHIFT = _nvme.NVME_CMBMSC_CRE_SHIFT

NVME_CMBMSC_CMSE_SHIFT = _nvme.NVME_CMBMSC_CMSE_SHIFT

NVME_CMBMSC_CBA_SHIFT = _nvme.NVME_CMBMSC_CBA_SHIFT

NVME_CMBMSC_CRE_MASK = _nvme.NVME_CMBMSC_CRE_MASK

NVME_CMBMSC_CMSE_MASK = _nvme.NVME_CMBMSC_CMSE_MASK

NVME_CMBSTS_CBAI_SHIFT = _nvme.NVME_CMBSTS_CBAI_SHIFT

NVME_CMBSTS_CBAI_MASK = _nvme.NVME_CMBSTS_CBAI_MASK

NVME_UNIT_B = _nvme.NVME_UNIT_B

NVME_UNIT_1K = _nvme.NVME_UNIT_1K

NVME_UNIT_1M = _nvme.NVME_UNIT_1M

NVME_UNIT_1G = _nvme.NVME_UNIT_1G

NVME_CMBEBS_CMBSZU_SHIFT = _nvme.NVME_CMBEBS_CMBSZU_SHIFT

NVME_CMBEBS_RBB_SHIFT = _nvme.NVME_CMBEBS_RBB_SHIFT

NVME_CMBEBS_CMBWBZ_SHIFT = _nvme.NVME_CMBEBS_CMBWBZ_SHIFT

NVME_CMBEBS_CMBSZU_MASK = _nvme.NVME_CMBEBS_CMBSZU_MASK

NVME_CMBEBS_RBB_MASK = _nvme.NVME_CMBEBS_RBB_MASK

NVME_CMBEBS_CMBWBZ_MASK = _nvme.NVME_CMBEBS_CMBWBZ_MASK

NVME_CMBEBS_CMBSZU_B = _nvme.NVME_CMBEBS_CMBSZU_B

NVME_CMBEBS_CMBSZU_1K = _nvme.NVME_CMBEBS_CMBSZU_1K

NVME_CMBEBS_CMBSZU_1M = _nvme.NVME_CMBEBS_CMBSZU_1M

NVME_CMBEBS_CMBSZU_1G = _nvme.NVME_CMBEBS_CMBSZU_1G

NVME_CMBSWTP_CMBSWTU_SHIFT = _nvme.NVME_CMBSWTP_CMBSWTU_SHIFT

NVME_CMBSWTP_CMBSWTV_SHIFT = _nvme.NVME_CMBSWTP_CMBSWTV_SHIFT

NVME_CMBSWTP_CMBSWTU_MASK = _nvme.NVME_CMBSWTP_CMBSWTU_MASK

NVME_CMBSWTP_CMBSWTV_MASK = _nvme.NVME_CMBSWTP_CMBSWTV_MASK

NVME_CMBSWTP_CMBSWTU_B = _nvme.NVME_CMBSWTP_CMBSWTU_B

NVME_CMBSWTP_CMBSWTU_1K = _nvme.NVME_CMBSWTP_CMBSWTU_1K

NVME_CMBSWTP_CMBSWTU_1M = _nvme.NVME_CMBSWTP_CMBSWTU_1M

NVME_CMBSWTP_CMBSWTU_1G = _nvme.NVME_CMBSWTP_CMBSWTU_1G

NVME_CRTO_CRWMT_SHIFT = _nvme.NVME_CRTO_CRWMT_SHIFT

NVME_CRTO_CRIMT_SHIFT = _nvme.NVME_CRTO_CRIMT_SHIFT

NVME_CRTO_CRWMT_MASK = _nvme.NVME_CRTO_CRWMT_MASK

NVME_CRTO_CRIMT_MASK = _nvme.NVME_CRTO_CRIMT_MASK

NVME_PMRCAP_RDS_SHIFT = _nvme.NVME_PMRCAP_RDS_SHIFT

NVME_PMRCAP_WDS_SHIFT = _nvme.NVME_PMRCAP_WDS_SHIFT

NVME_PMRCAP_BIR_SHIFT = _nvme.NVME_PMRCAP_BIR_SHIFT

NVME_PMRCAP_PMRTU_SHIFT = _nvme.NVME_PMRCAP_PMRTU_SHIFT

NVME_PMRCAP_PMRWBM_SHIFT = _nvme.NVME_PMRCAP_PMRWBM_SHIFT

NVME_PMRCAP_PMRTO_SHIFT = _nvme.NVME_PMRCAP_PMRTO_SHIFT

NVME_PMRCAP_CMSS_SHIFT = _nvme.NVME_PMRCAP_CMSS_SHIFT

NVME_PMRCAP_PMRWMB_SHIFT = _nvme.NVME_PMRCAP_PMRWMB_SHIFT

NVME_PMRCAP_RDS_MASK = _nvme.NVME_PMRCAP_RDS_MASK

NVME_PMRCAP_WDS_MASK = _nvme.NVME_PMRCAP_WDS_MASK

NVME_PMRCAP_BIR_MASK = _nvme.NVME_PMRCAP_BIR_MASK

NVME_PMRCAP_PMRTU_MASK = _nvme.NVME_PMRCAP_PMRTU_MASK

NVME_PMRCAP_PMRWBM_MASK = _nvme.NVME_PMRCAP_PMRWBM_MASK

NVME_PMRCAP_PMRTO_MASK = _nvme.NVME_PMRCAP_PMRTO_MASK

NVME_PMRCAP_CMSS_MASK = _nvme.NVME_PMRCAP_CMSS_MASK

NVME_PMRCAP_PMRWMB_MASK = _nvme.NVME_PMRCAP_PMRWMB_MASK

NVME_PMRCAP_PMRTU_500MS = _nvme.NVME_PMRCAP_PMRTU_500MS

NVME_PMRCAP_PMRTU_60S = _nvme.NVME_PMRCAP_PMRTU_60S

NVME_PMRCTL_EN_SHIFT = _nvme.NVME_PMRCTL_EN_SHIFT

NVME_PMRCTL_EN_MASK = _nvme.NVME_PMRCTL_EN_MASK

NVME_PMRSTS_ERR_SHIFT = _nvme.NVME_PMRSTS_ERR_SHIFT

NVME_PMRSTS_NRDY_SHIFT = _nvme.NVME_PMRSTS_NRDY_SHIFT

NVME_PMRSTS_HSTS_SHIFT = _nvme.NVME_PMRSTS_HSTS_SHIFT

NVME_PMRSTS_CBAI_SHIFT = _nvme.NVME_PMRSTS_CBAI_SHIFT

NVME_PMRSTS_ERR_MASK = _nvme.NVME_PMRSTS_ERR_MASK

NVME_PMRSTS_NRDY_MASK = _nvme.NVME_PMRSTS_NRDY_MASK

NVME_PMRSTS_HSTS_MASK = _nvme.NVME_PMRSTS_HSTS_MASK

NVME_PMRSTS_CBAI_MASK = _nvme.NVME_PMRSTS_CBAI_MASK

NVME_PMREBS_PMRSZU_SHIFT = _nvme.NVME_PMREBS_PMRSZU_SHIFT

NVME_PMREBS_RBB_SHIFT = _nvme.NVME_PMREBS_RBB_SHIFT

NVME_PMREBS_PMRWBZ_SHIFT = _nvme.NVME_PMREBS_PMRWBZ_SHIFT

NVME_PMREBS_PMRSZU_MASK = _nvme.NVME_PMREBS_PMRSZU_MASK

NVME_PMREBS_RBB_MASK = _nvme.NVME_PMREBS_RBB_MASK

NVME_PMREBS_PMRWBZ_MASK = _nvme.NVME_PMREBS_PMRWBZ_MASK

NVME_PMREBS_PMRSZU_B = _nvme.NVME_PMREBS_PMRSZU_B

NVME_PMREBS_PMRSZU_1K = _nvme.NVME_PMREBS_PMRSZU_1K

NVME_PMREBS_PMRSZU_1M = _nvme.NVME_PMREBS_PMRSZU_1M

NVME_PMREBS_PMRSZU_1G = _nvme.NVME_PMREBS_PMRSZU_1G

NVME_PMRSWTP_PMRSWTU_SHIFT = _nvme.NVME_PMRSWTP_PMRSWTU_SHIFT

NVME_PMRSWTP_PMRSWTV_SHIFT = _nvme.NVME_PMRSWTP_PMRSWTV_SHIFT

NVME_PMRSWTP_PMRSWTU_MASK = _nvme.NVME_PMRSWTP_PMRSWTU_MASK

NVME_PMRSWTP_PMRSWTV_MASK = _nvme.NVME_PMRSWTP_PMRSWTV_MASK

NVME_PMRSWTP_PMRSWTU_BPS = _nvme.NVME_PMRSWTP_PMRSWTU_BPS

NVME_PMRSWTP_PMRSWTU_KBPS = _nvme.NVME_PMRSWTP_PMRSWTU_KBPS

NVME_PMRSWTP_PMRSWTU_MBPS = _nvme.NVME_PMRSWTP_PMRSWTU_MBPS

NVME_PMRSWTP_PMRSWTU_GBPS = _nvme.NVME_PMRSWTP_PMRSWTU_GBPS

NVME_PMRMSC_CMSE_SHIFT = _nvme.NVME_PMRMSC_CMSE_SHIFT

NVME_PMRMSC_CBA_SHIFT = _nvme.NVME_PMRMSC_CBA_SHIFT

NVME_PMRMSC_CMSE_MASK = _nvme.NVME_PMRMSC_CMSE_MASK

NVME_FLBAS_LOWER_SHIFT = _nvme.NVME_FLBAS_LOWER_SHIFT

NVME_FLBAS_META_EXT_SHIFT = _nvme.NVME_FLBAS_META_EXT_SHIFT

NVME_FLBAS_HIGHER_SHIFT = _nvme.NVME_FLBAS_HIGHER_SHIFT

NVME_FLBAS_LOWER_MASK = _nvme.NVME_FLBAS_LOWER_MASK

NVME_FLBAS_META_EXT_MASK = _nvme.NVME_FLBAS_META_EXT_MASK

NVME_FLBAS_HIGHER_MASK = _nvme.NVME_FLBAS_HIGHER_MASK

NVME_PSD_FLAGS_MXPS = _nvme.NVME_PSD_FLAGS_MXPS

NVME_PSD_FLAGS_NOPS = _nvme.NVME_PSD_FLAGS_NOPS

NVME_PSD_PS_NOT_REPORTED = _nvme.NVME_PSD_PS_NOT_REPORTED

NVME_PSD_PS_100_MICRO_WATT = _nvme.NVME_PSD_PS_100_MICRO_WATT

NVME_PSD_PS_10_MILLI_WATT = _nvme.NVME_PSD_PS_10_MILLI_WATT

NVME_PSD_WORKLOAD_NP = _nvme.NVME_PSD_WORKLOAD_NP

NVME_PSD_WORKLOAD_1 = _nvme.NVME_PSD_WORKLOAD_1

NVME_PSD_WORKLOAD_2 = _nvme.NVME_PSD_WORKLOAD_2

NVME_CMIC_MULTI_PORT_SHIFT = _nvme.NVME_CMIC_MULTI_PORT_SHIFT

NVME_CMIC_MULTI_CTRL_SHIFT = _nvme.NVME_CMIC_MULTI_CTRL_SHIFT

NVME_CMIC_MULTI_SRIOV_SHIFT = _nvme.NVME_CMIC_MULTI_SRIOV_SHIFT

NVME_CMIC_MULTI_ANA_SHIFT = _nvme.NVME_CMIC_MULTI_ANA_SHIFT

NVME_CMIC_MULTI_RSVD_SHIFT = _nvme.NVME_CMIC_MULTI_RSVD_SHIFT

NVME_CMIC_MULTI_PORT_MASK = _nvme.NVME_CMIC_MULTI_PORT_MASK

NVME_CMIC_MULTI_CTRL_MASK = _nvme.NVME_CMIC_MULTI_CTRL_MASK

NVME_CMIC_MULTI_SRIOV_MASK = _nvme.NVME_CMIC_MULTI_SRIOV_MASK

NVME_CMIC_MULTI_ANA_MASK = _nvme.NVME_CMIC_MULTI_ANA_MASK

NVME_CMIC_MULTI_RSVD_MASK = _nvme.NVME_CMIC_MULTI_RSVD_MASK

NVME_CTRL_CMIC_MULTI_PORT = _nvme.NVME_CTRL_CMIC_MULTI_PORT

NVME_CTRL_CMIC_MULTI_CTRL = _nvme.NVME_CTRL_CMIC_MULTI_CTRL

NVME_CTRL_CMIC_MULTI_SRIOV = _nvme.NVME_CTRL_CMIC_MULTI_SRIOV

NVME_CTRL_CMIC_MULTI_ANA_REPORTING = _nvme.NVME_CTRL_CMIC_MULTI_ANA_REPORTING

NVME_CTRL_OAES_NA_SHIFT = _nvme.NVME_CTRL_OAES_NA_SHIFT

NVME_CTRL_OAES_FA_SHIFT = _nvme.NVME_CTRL_OAES_FA_SHIFT

NVME_CTRL_OAES_ANA_SHIFT = _nvme.NVME_CTRL_OAES_ANA_SHIFT

NVME_CTRL_OAES_PLEA_SHIFT = _nvme.NVME_CTRL_OAES_PLEA_SHIFT

NVME_CTRL_OAES_LBAS_SHIFT = _nvme.NVME_CTRL_OAES_LBAS_SHIFT

NVME_CTRL_OAES_EGE_SHIFT = _nvme.NVME_CTRL_OAES_EGE_SHIFT

NVME_CTRL_OAES_NS_SHIFT = _nvme.NVME_CTRL_OAES_NS_SHIFT

NVME_CTRL_OAES_TTH_SHIFT = _nvme.NVME_CTRL_OAES_TTH_SHIFT

NVME_CTRL_OAES_RGCNS_SHIFT = _nvme.NVME_CTRL_OAES_RGCNS_SHIFT

NVME_CTRL_OAES_ANSAN_SHIFT = _nvme.NVME_CTRL_OAES_ANSAN_SHIFT

NVME_CTRL_OAES_ZD_SHIFT = _nvme.NVME_CTRL_OAES_ZD_SHIFT

NVME_CTRL_OAES_DL_SHIFT = _nvme.NVME_CTRL_OAES_DL_SHIFT

NVME_CTRL_OAES_NA_MASK = _nvme.NVME_CTRL_OAES_NA_MASK

NVME_CTRL_OAES_FA_MASK = _nvme.NVME_CTRL_OAES_FA_MASK

NVME_CTRL_OAES_ANA_MASK = _nvme.NVME_CTRL_OAES_ANA_MASK

NVME_CTRL_OAES_PLEA_MASK = _nvme.NVME_CTRL_OAES_PLEA_MASK

NVME_CTRL_OAES_LBAS_MASK = _nvme.NVME_CTRL_OAES_LBAS_MASK

NVME_CTRL_OAES_EGE_MASK = _nvme.NVME_CTRL_OAES_EGE_MASK

NVME_CTRL_OAES_NS_MASK = _nvme.NVME_CTRL_OAES_NS_MASK

NVME_CTRL_OAES_TTH_MASK = _nvme.NVME_CTRL_OAES_TTH_MASK

NVME_CTRL_OAES_RGCNS_MASK = _nvme.NVME_CTRL_OAES_RGCNS_MASK

NVME_CTRL_OAES_ANSAN_MASK = _nvme.NVME_CTRL_OAES_ANSAN_MASK

NVME_CTRL_OAES_ZD_MASK = _nvme.NVME_CTRL_OAES_ZD_MASK

NVME_CTRL_OAES_DL_MASK = _nvme.NVME_CTRL_OAES_DL_MASK

NVME_CTRL_OAES_NA = _nvme.NVME_CTRL_OAES_NA

NVME_CTRL_OAES_FA = _nvme.NVME_CTRL_OAES_FA

NVME_CTRL_OAES_ANA = _nvme.NVME_CTRL_OAES_ANA

NVME_CTRL_OAES_PLEA = _nvme.NVME_CTRL_OAES_PLEA

NVME_CTRL_OAES_LBAS = _nvme.NVME_CTRL_OAES_LBAS

NVME_CTRL_OAES_EGE = _nvme.NVME_CTRL_OAES_EGE

NVME_CTRL_OAES_NS = _nvme.NVME_CTRL_OAES_NS

NVME_CTRL_OAES_TTH = _nvme.NVME_CTRL_OAES_TTH

NVME_CTRL_OAES_RGCNS = _nvme.NVME_CTRL_OAES_RGCNS

NVME_CTRL_OAES_ANSAN = _nvme.NVME_CTRL_OAES_ANSAN

NVME_CTRL_OAES_ZD = _nvme.NVME_CTRL_OAES_ZD

NVME_CTRL_OAES_DL = _nvme.NVME_CTRL_OAES_DL

NVME_CTRL_CTRATT_128_ID = _nvme.NVME_CTRL_CTRATT_128_ID

NVME_CTRL_CTRATT_NON_OP_PSP = _nvme.NVME_CTRL_CTRATT_NON_OP_PSP

NVME_CTRL_CTRATT_NVM_SETS = _nvme.NVME_CTRL_CTRATT_NVM_SETS

NVME_CTRL_CTRATT_READ_RECV_LVLS = _nvme.NVME_CTRL_CTRATT_READ_RECV_LVLS

NVME_CTRL_CTRATT_ENDURANCE_GROUPS = _nvme.NVME_CTRL_CTRATT_ENDURANCE_GROUPS

NVME_CTRL_CTRATT_PREDICTABLE_LAT = _nvme.NVME_CTRL_CTRATT_PREDICTABLE_LAT

NVME_CTRL_CTRATT_TBKAS = _nvme.NVME_CTRL_CTRATT_TBKAS

NVME_CTRL_CTRATT_NAMESPACE_GRANULARITY = _nvme.NVME_CTRL_CTRATT_NAMESPACE_GRANULARITY

NVME_CTRL_CTRATT_SQ_ASSOCIATIONS = _nvme.NVME_CTRL_CTRATT_SQ_ASSOCIATIONS

NVME_CTRL_CTRATT_UUID_LIST = _nvme.NVME_CTRL_CTRATT_UUID_LIST

NVME_CTRL_CTRATT_MDS = _nvme.NVME_CTRL_CTRATT_MDS

NVME_CTRL_CTRATT_FIXED_CAP = _nvme.NVME_CTRL_CTRATT_FIXED_CAP

NVME_CTRL_CTRATT_VARIABLE_CAP = _nvme.NVME_CTRL_CTRATT_VARIABLE_CAP

NVME_CTRL_CTRATT_DEL_ENDURANCE_GROUPS = _nvme.NVME_CTRL_CTRATT_DEL_ENDURANCE_GROUPS

NVME_CTRL_CTRATT_DEL_NVM_SETS = _nvme.NVME_CTRL_CTRATT_DEL_NVM_SETS

NVME_CTRL_CTRATT_ELBAS = _nvme.NVME_CTRL_CTRATT_ELBAS

NVME_CTRL_CTRATT_MEM = _nvme.NVME_CTRL_CTRATT_MEM

NVME_CTRL_CTRATT_HMBR = _nvme.NVME_CTRL_CTRATT_HMBR

NVME_CTRL_CTRATT_RHII = _nvme.NVME_CTRL_CTRATT_RHII

NVME_CTRL_CTRATT_FDPS = _nvme.NVME_CTRL_CTRATT_FDPS

NVME_CTRL_BACAP_RPMBBPWPS_SHIFT = _nvme.NVME_CTRL_BACAP_RPMBBPWPS_SHIFT

NVME_CTRL_BACAP_SFBPWPS_SHIFT = _nvme.NVME_CTRL_BACAP_SFBPWPS_SHIFT

NVME_CTRL_BACAP_RPMBBPWPS_MASK = _nvme.NVME_CTRL_BACAP_RPMBBPWPS_MASK

NVME_CTRL_BACAP_SFBPWPS_MASK = _nvme.NVME_CTRL_BACAP_SFBPWPS_MASK

NVME_CTRL_BACAP_RPMBBPWPS_NOT_SPECIFIED = _nvme.NVME_CTRL_BACAP_RPMBBPWPS_NOT_SPECIFIED

NVME_CTRL_BACAP_RPMBBPWPS_NOT_SUPPORTED = _nvme.NVME_CTRL_BACAP_RPMBBPWPS_NOT_SUPPORTED

NVME_CTRL_BACAP_RPMBBPWPS_SUPPORTED = _nvme.NVME_CTRL_BACAP_RPMBBPWPS_SUPPORTED

NVME_CTRL_PLSI_PLSEPF_SHIFT = _nvme.NVME_CTRL_PLSI_PLSEPF_SHIFT

NVME_CTRL_PLSI_PLSFQ_SHIFT = _nvme.NVME_CTRL_PLSI_PLSFQ_SHIFT

NVME_CTRL_PLSI_PLSEPF_MASK = _nvme.NVME_CTRL_PLSI_PLSEPF_MASK

NVME_CTRL_PLSI_PLSFQ_MASK = _nvme.NVME_CTRL_PLSI_PLSFQ_MASK

NVME_CTRL_CRCAP_RRSUP_SHIFT = _nvme.NVME_CTRL_CRCAP_RRSUP_SHIFT

NVME_CTRL_CRCAP_RGIDC_SHIFT = _nvme.NVME_CTRL_CRCAP_RGIDC_SHIFT

NVME_CTRL_CRCAP_RRSUP_MASK = _nvme.NVME_CTRL_CRCAP_RRSUP_MASK

NVME_CTRL_CRCAP_RGIDC_MASK = _nvme.NVME_CTRL_CRCAP_RGIDC_MASK

NVME_CTRL_CNTRLTYPE_IO = _nvme.NVME_CTRL_CNTRLTYPE_IO

NVME_CTRL_CNTRLTYPE_DISCOVERY = _nvme.NVME_CTRL_CNTRLTYPE_DISCOVERY

NVME_CTRL_CNTRLTYPE_ADMIN = _nvme.NVME_CTRL_CNTRLTYPE_ADMIN

NVME_CTRL_DCTYPE_NOT_REPORTED = _nvme.NVME_CTRL_DCTYPE_NOT_REPORTED

NVME_CTRL_DCTYPE_DDC = _nvme.NVME_CTRL_DCTYPE_DDC

NVME_CTRL_DCTYPE_CDC = _nvme.NVME_CTRL_DCTYPE_CDC

NVME_CTRL_NVMSR_NVMESD = _nvme.NVME_CTRL_NVMSR_NVMESD

NVME_CTRL_NVMSR_NVMEE = _nvme.NVME_CTRL_NVMSR_NVMEE

NVME_CTRL_VWCI_VWCR = _nvme.NVME_CTRL_VWCI_VWCR

NVME_CTRL_VWCI_VWCRV = _nvme.NVME_CTRL_VWCI_VWCRV

NVME_CTRL_MEC_SMBUSME = _nvme.NVME_CTRL_MEC_SMBUSME

NVME_CTRL_MEC_PCIEME = _nvme.NVME_CTRL_MEC_PCIEME

NVME_CTRL_OACS_SSRS_SHIFT = _nvme.NVME_CTRL_OACS_SSRS_SHIFT

NVME_CTRL_OACS_FNVMS_SHIFT = _nvme.NVME_CTRL_OACS_FNVMS_SHIFT

NVME_CTRL_OACS_FWDS_SHIFT = _nvme.NVME_CTRL_OACS_FWDS_SHIFT

NVME_CTRL_OACS_NMS_SHIFT = _nvme.NVME_CTRL_OACS_NMS_SHIFT

NVME_CTRL_OACS_DSTS_SHIFT = _nvme.NVME_CTRL_OACS_DSTS_SHIFT

NVME_CTRL_OACS_DIRS_SHIFT = _nvme.NVME_CTRL_OACS_DIRS_SHIFT

NVME_CTRL_OACS_NSRS_SHIFT = _nvme.NVME_CTRL_OACS_NSRS_SHIFT

NVME_CTRL_OACS_VMS_SHIFT = _nvme.NVME_CTRL_OACS_VMS_SHIFT

NVME_CTRL_OACS_DBCS_SHIFT = _nvme.NVME_CTRL_OACS_DBCS_SHIFT

NVME_CTRL_OACS_GLSS_SHIFT = _nvme.NVME_CTRL_OACS_GLSS_SHIFT

NVME_CTRL_OACS_CFLS_SHIFT = _nvme.NVME_CTRL_OACS_CFLS_SHIFT

NVME_CTRL_OACS_HMLMS_SHIFT = _nvme.NVME_CTRL_OACS_HMLMS_SHIFT

NVME_CTRL_OACS_SSRS_MASK = _nvme.NVME_CTRL_OACS_SSRS_MASK

NVME_CTRL_OACS_FNVMS_MASK = _nvme.NVME_CTRL_OACS_FNVMS_MASK

NVME_CTRL_OACS_FWDS_MASK = _nvme.NVME_CTRL_OACS_FWDS_MASK

NVME_CTRL_OACS_NMS_MASK = _nvme.NVME_CTRL_OACS_NMS_MASK

NVME_CTRL_OACS_DSTS_MASK = _nvme.NVME_CTRL_OACS_DSTS_MASK

NVME_CTRL_OACS_DIRS_MASK = _nvme.NVME_CTRL_OACS_DIRS_MASK

NVME_CTRL_OACS_NSRS_MASK = _nvme.NVME_CTRL_OACS_NSRS_MASK

NVME_CTRL_OACS_VMS_MASK = _nvme.NVME_CTRL_OACS_VMS_MASK

NVME_CTRL_OACS_DBCS_MASK = _nvme.NVME_CTRL_OACS_DBCS_MASK

NVME_CTRL_OACS_GLSS_MASK = _nvme.NVME_CTRL_OACS_GLSS_MASK

NVME_CTRL_OACS_CFLS_MASK = _nvme.NVME_CTRL_OACS_CFLS_MASK

NVME_CTRL_OACS_HMLMS_MASK = _nvme.NVME_CTRL_OACS_HMLMS_MASK

NVME_CTRL_OACS_SECURITY = _nvme.NVME_CTRL_OACS_SECURITY

NVME_CTRL_OACS_FORMAT = _nvme.NVME_CTRL_OACS_FORMAT

NVME_CTRL_OACS_FW = _nvme.NVME_CTRL_OACS_FW

NVME_CTRL_OACS_NS_MGMT = _nvme.NVME_CTRL_OACS_NS_MGMT

NVME_CTRL_OACS_SELF_TEST = _nvme.NVME_CTRL_OACS_SELF_TEST

NVME_CTRL_OACS_DIRECTIVES = _nvme.NVME_CTRL_OACS_DIRECTIVES

NVME_CTRL_OACS_NVME_MI = _nvme.NVME_CTRL_OACS_NVME_MI

NVME_CTRL_OACS_VIRT_MGMT = _nvme.NVME_CTRL_OACS_VIRT_MGMT

NVME_CTRL_OACS_DBBUF_CFG = _nvme.NVME_CTRL_OACS_DBBUF_CFG

NVME_CTRL_OACS_LBA_STATUS = _nvme.NVME_CTRL_OACS_LBA_STATUS

NVME_CTRL_OACS_CMD_FEAT_LD = _nvme.NVME_CTRL_OACS_CMD_FEAT_LD

NVME_CTRL_OACS_HMLM = _nvme.NVME_CTRL_OACS_HMLM

NVME_CTRL_FRMW_1ST_RO = _nvme.NVME_CTRL_FRMW_1ST_RO

NVME_CTRL_FRMW_NR_SLOTS = _nvme.NVME_CTRL_FRMW_NR_SLOTS

NVME_CTRL_FRMW_FW_ACT_NO_RESET = _nvme.NVME_CTRL_FRMW_FW_ACT_NO_RESET

NVME_CTRL_FRMW_MP_UP_DETECTION = _nvme.NVME_CTRL_FRMW_MP_UP_DETECTION

NVME_CTRL_LPA_SMART_PER_NS = _nvme.NVME_CTRL_LPA_SMART_PER_NS

NVME_CTRL_LPA_CMD_EFFECTS = _nvme.NVME_CTRL_LPA_CMD_EFFECTS

NVME_CTRL_LPA_EXTENDED = _nvme.NVME_CTRL_LPA_EXTENDED

NVME_CTRL_LPA_TELEMETRY = _nvme.NVME_CTRL_LPA_TELEMETRY

NVME_CTRL_LPA_PERSETENT_EVENT = _nvme.NVME_CTRL_LPA_PERSETENT_EVENT

NVME_CTRL_LPA_LI0_LI5_LI12_LI13 = _nvme.NVME_CTRL_LPA_LI0_LI5_LI12_LI13

NVME_CTRL_LPA_DA4_TELEMETRY = _nvme.NVME_CTRL_LPA_DA4_TELEMETRY

NVME_CTRL_AVSCC_AVS = _nvme.NVME_CTRL_AVSCC_AVS

NVME_CTRL_APSTA_APST = _nvme.NVME_CTRL_APSTA_APST

NVME_CTRL_RPMBS_NR_UNITS = _nvme.NVME_CTRL_RPMBS_NR_UNITS

NVME_CTRL_RPMBS_AUTH_METHOD = _nvme.NVME_CTRL_RPMBS_AUTH_METHOD

NVME_CTRL_RPMBS_TOTAL_SIZE = _nvme.NVME_CTRL_RPMBS_TOTAL_SIZE

NVME_CTRL_RPMBS_ACCESS_SIZE = _nvme.NVME_CTRL_RPMBS_ACCESS_SIZE

NVME_CTRL_DSTO_SDSO_SHIFT = _nvme.NVME_CTRL_DSTO_SDSO_SHIFT

NVME_CTRL_DSTO_HIRS_SHIFT = _nvme.NVME_CTRL_DSTO_HIRS_SHIFT

NVME_CTRL_DSTO_SDSO_MASK = _nvme.NVME_CTRL_DSTO_SDSO_MASK

NVME_CTRL_DSTO_HIRS_MASK = _nvme.NVME_CTRL_DSTO_HIRS_MASK

NVME_CTRL_DSTO_ONE_DST = _nvme.NVME_CTRL_DSTO_ONE_DST

NVME_CTRL_DSTO_HIRS = _nvme.NVME_CTRL_DSTO_HIRS

NVME_CTRL_HCTMA_HCTM = _nvme.NVME_CTRL_HCTMA_HCTM

NVME_CTRL_SANICAP_CES = _nvme.NVME_CTRL_SANICAP_CES

NVME_CTRL_SANICAP_BES = _nvme.NVME_CTRL_SANICAP_BES

NVME_CTRL_SANICAP_OWS = _nvme.NVME_CTRL_SANICAP_OWS

NVME_CTRL_SANICAP_NDI = _nvme.NVME_CTRL_SANICAP_NDI

NVME_CTRL_SANICAP_NODMMAS = _nvme.NVME_CTRL_SANICAP_NODMMAS

NVME_CTRL_ANACAP_OPT = _nvme.NVME_CTRL_ANACAP_OPT

NVME_CTRL_ANACAP_NON_OPT = _nvme.NVME_CTRL_ANACAP_NON_OPT

NVME_CTRL_ANACAP_INACCESSIBLE = _nvme.NVME_CTRL_ANACAP_INACCESSIBLE

NVME_CTRL_ANACAP_PERSISTENT_LOSS = _nvme.NVME_CTRL_ANACAP_PERSISTENT_LOSS

NVME_CTRL_ANACAP_CHANGE = _nvme.NVME_CTRL_ANACAP_CHANGE

NVME_CTRL_ANACAP_GRPID_NO_CHG = _nvme.NVME_CTRL_ANACAP_GRPID_NO_CHG

NVME_CTRL_ANACAP_GRPID_MGMT = _nvme.NVME_CTRL_ANACAP_GRPID_MGMT

NVME_CTRL_KPIOC_KPIOS_SHIFT = _nvme.NVME_CTRL_KPIOC_KPIOS_SHIFT

NVME_CTRL_KPIOC_KPIOSC_SHIFT = _nvme.NVME_CTRL_KPIOC_KPIOSC_SHIFT

NVME_CTRL_KPIOC_KPIOS_MASK = _nvme.NVME_CTRL_KPIOC_KPIOS_MASK

NVME_CTRL_KPIOC_KPIOSC_MASK = _nvme.NVME_CTRL_KPIOC_KPIOSC_MASK

NVME_CTRL_SQES_MIN = _nvme.NVME_CTRL_SQES_MIN

NVME_CTRL_SQES_MAX = _nvme.NVME_CTRL_SQES_MAX

NVME_CTRL_CQES_MIN = _nvme.NVME_CTRL_CQES_MIN

NVME_CTRL_CQES_MAX = _nvme.NVME_CTRL_CQES_MAX

NVME_CTRL_ONCS_COMPARE = _nvme.NVME_CTRL_ONCS_COMPARE

NVME_CTRL_ONCS_WRITE_UNCORRECTABLE = _nvme.NVME_CTRL_ONCS_WRITE_UNCORRECTABLE

NVME_CTRL_ONCS_DSM = _nvme.NVME_CTRL_ONCS_DSM

NVME_CTRL_ONCS_WRITE_ZEROES = _nvme.NVME_CTRL_ONCS_WRITE_ZEROES

NVME_CTRL_ONCS_SAVE_FEATURES = _nvme.NVME_CTRL_ONCS_SAVE_FEATURES

NVME_CTRL_ONCS_RESERVATIONS = _nvme.NVME_CTRL_ONCS_RESERVATIONS

NVME_CTRL_ONCS_TIMESTAMP = _nvme.NVME_CTRL_ONCS_TIMESTAMP

NVME_CTRL_ONCS_VERIFY = _nvme.NVME_CTRL_ONCS_VERIFY

NVME_CTRL_ONCS_COPY = _nvme.NVME_CTRL_ONCS_COPY

NVME_CTRL_ONCS_COPY_SINGLE_ATOMICITY = _nvme.NVME_CTRL_ONCS_COPY_SINGLE_ATOMICITY

NVME_CTRL_ONCS_ALL_FAST_COPY = _nvme.NVME_CTRL_ONCS_ALL_FAST_COPY

NVME_CTRL_ONCS_WRITE_ZEROES_DEALLOCATE = _nvme.NVME_CTRL_ONCS_WRITE_ZEROES_DEALLOCATE

NVME_CTRL_ONCS_NAMESPACE_ZEROES = _nvme.NVME_CTRL_ONCS_NAMESPACE_ZEROES

NVME_CTRL_FUSES_COMPARE_AND_WRITE = _nvme.NVME_CTRL_FUSES_COMPARE_AND_WRITE

NVME_CTRL_FNA_FMT_ALL_NS_SHIFT = _nvme.NVME_CTRL_FNA_FMT_ALL_NS_SHIFT

NVME_CTRL_FNA_SEC_ALL_NS_SHIFT = _nvme.NVME_CTRL_FNA_SEC_ALL_NS_SHIFT

NVME_CTRL_FNA_CES_SHIFT = _nvme.NVME_CTRL_FNA_CES_SHIFT

NVME_CTRL_FNA_NSID_ALL_F_SHIFT = _nvme.NVME_CTRL_FNA_NSID_ALL_F_SHIFT

NVME_CTRL_FNA_FMT_ALL_NS_MASK = _nvme.NVME_CTRL_FNA_FMT_ALL_NS_MASK

NVME_CTRL_FNA_SEC_ALL_NS_MASK = _nvme.NVME_CTRL_FNA_SEC_ALL_NS_MASK

NVME_CTRL_FNA_CES_MASK = _nvme.NVME_CTRL_FNA_CES_MASK

NVME_CTRL_FNA_NSID_ALL_F_MASK = _nvme.NVME_CTRL_FNA_NSID_ALL_F_MASK

NVME_CTRL_FNA_FMT_ALL_NAMESPACES = _nvme.NVME_CTRL_FNA_FMT_ALL_NAMESPACES

NVME_CTRL_FNA_SEC_ALL_NAMESPACES = _nvme.NVME_CTRL_FNA_SEC_ALL_NAMESPACES

NVME_CTRL_FNA_CRYPTO_ERASE = _nvme.NVME_CTRL_FNA_CRYPTO_ERASE

NVME_CTRL_FNA_NSID_FFFFFFFF = _nvme.NVME_CTRL_FNA_NSID_FFFFFFFF

NVME_CTRL_VWC_PRESENT = _nvme.NVME_CTRL_VWC_PRESENT

NVME_CTRL_VWC_FLUSH = _nvme.NVME_CTRL_VWC_FLUSH

NVME_CTRL_NVSCC_FMT = _nvme.NVME_CTRL_NVSCC_FMT

NVME_CTRL_NWPC_WRITE_PROTECT = _nvme.NVME_CTRL_NWPC_WRITE_PROTECT

NVME_CTRL_NWPC_WRITE_PROTECT_POWER_CYCLE = _nvme.NVME_CTRL_NWPC_WRITE_PROTECT_POWER_CYCLE

NVME_CTRL_NWPC_WRITE_PROTECT_PERMANENT = _nvme.NVME_CTRL_NWPC_WRITE_PROTECT_PERMANENT

NVME_CTRL_SGLS_SUPPORTED = _nvme.NVME_CTRL_SGLS_SUPPORTED

NVME_CTRL_SGLS_KEYED = _nvme.NVME_CTRL_SGLS_KEYED

NVME_CTRL_SGLS_BIT_BUCKET = _nvme.NVME_CTRL_SGLS_BIT_BUCKET

NVME_CTRL_SGLS_MPTR_BYTE_ALIGNED = _nvme.NVME_CTRL_SGLS_MPTR_BYTE_ALIGNED

NVME_CTRL_SGLS_OVERSIZE = _nvme.NVME_CTRL_SGLS_OVERSIZE

NVME_CTRL_SGLS_MPTR_SGL = _nvme.NVME_CTRL_SGLS_MPTR_SGL

NVME_CTRL_SGLS_OFFSET = _nvme.NVME_CTRL_SGLS_OFFSET

NVME_CTRL_SGLS_TPORT = _nvme.NVME_CTRL_SGLS_TPORT

NVME_CTRL_TRATTR_THMCS_SHIFT = _nvme.NVME_CTRL_TRATTR_THMCS_SHIFT

NVME_CTRL_TRATTR_TUDCS_SHIFT = _nvme.NVME_CTRL_TRATTR_TUDCS_SHIFT

NVME_CTRL_TRATTR_MRTLL_SHIFT = _nvme.NVME_CTRL_TRATTR_MRTLL_SHIFT

NVME_CTRL_TRATTR_THMCS_MASK = _nvme.NVME_CTRL_TRATTR_THMCS_MASK

NVME_CTRL_TRATTR_TUDCS_MASK = _nvme.NVME_CTRL_TRATTR_TUDCS_MASK

NVME_CTRL_TRATTR_MRTLL_MASK = _nvme.NVME_CTRL_TRATTR_MRTLL_MASK

NVME_CTRL_FCATT_DYNAMIC = _nvme.NVME_CTRL_FCATT_DYNAMIC

NVME_CTRL_OFCS_DISCONNECT = _nvme.NVME_CTRL_OFCS_DISCONNECT

NVME_LBAF_RP_BEST = _nvme.NVME_LBAF_RP_BEST

NVME_LBAF_RP_BETTER = _nvme.NVME_LBAF_RP_BETTER

NVME_LBAF_RP_GOOD = _nvme.NVME_LBAF_RP_GOOD

NVME_LBAF_RP_DEGRADED = _nvme.NVME_LBAF_RP_DEGRADED

NVME_LBAF_RP_MASK = _nvme.NVME_LBAF_RP_MASK

NVME_NS_FEAT_THIN = _nvme.NVME_NS_FEAT_THIN

NVME_NS_FEAT_NATOMIC = _nvme.NVME_NS_FEAT_NATOMIC

NVME_NS_FEAT_DULBE = _nvme.NVME_NS_FEAT_DULBE

NVME_NS_FEAT_ID_REUSE = _nvme.NVME_NS_FEAT_ID_REUSE

NVME_NS_FEAT_IO_OPT = _nvme.NVME_NS_FEAT_IO_OPT

NVME_NS_FLBAS_LOWER_MASK = _nvme.NVME_NS_FLBAS_LOWER_MASK

NVME_NS_FLBAS_META_EXT = _nvme.NVME_NS_FLBAS_META_EXT

NVME_NS_FLBAS_HIGHER_MASK = _nvme.NVME_NS_FLBAS_HIGHER_MASK

NVME_NVM_ELBAF_STS_MASK = _nvme.NVME_NVM_ELBAF_STS_MASK

NVME_NVM_ELBAF_PIF_MASK = _nvme.NVME_NVM_ELBAF_PIF_MASK

NVME_NVM_ELBAF_QPIF_MASK = _nvme.NVME_NVM_ELBAF_QPIF_MASK

NVME_NVM_PIF_16B_GUARD = _nvme.NVME_NVM_PIF_16B_GUARD

NVME_NVM_PIF_32B_GUARD = _nvme.NVME_NVM_PIF_32B_GUARD

NVME_NVM_PIF_64B_GUARD = _nvme.NVME_NVM_PIF_64B_GUARD

NVME_NVM_PIF_QTYPE = _nvme.NVME_NVM_PIF_QTYPE

NVME_NS_MC_EXTENDED = _nvme.NVME_NS_MC_EXTENDED

NVME_NS_MC_SEPARATE = _nvme.NVME_NS_MC_SEPARATE

NVME_NS_DPC_PI_TYPE1 = _nvme.NVME_NS_DPC_PI_TYPE1

NVME_NS_DPC_PI_TYPE2 = _nvme.NVME_NS_DPC_PI_TYPE2

NVME_NS_DPC_PI_TYPE3 = _nvme.NVME_NS_DPC_PI_TYPE3

NVME_NS_DPC_PI_FIRST = _nvme.NVME_NS_DPC_PI_FIRST

NVME_NS_DPC_PI_LAST = _nvme.NVME_NS_DPC_PI_LAST

NVME_NS_DPS_PI_NONE = _nvme.NVME_NS_DPS_PI_NONE

NVME_NS_DPS_PI_TYPE1 = _nvme.NVME_NS_DPS_PI_TYPE1

NVME_NS_DPS_PI_TYPE2 = _nvme.NVME_NS_DPS_PI_TYPE2

NVME_NS_DPS_PI_TYPE3 = _nvme.NVME_NS_DPS_PI_TYPE3

NVME_NS_DPS_PI_MASK = _nvme.NVME_NS_DPS_PI_MASK

NVME_NS_DPS_PI_FIRST = _nvme.NVME_NS_DPS_PI_FIRST

NVME_NS_NMIC_SHARED = _nvme.NVME_NS_NMIC_SHARED

NVME_NS_RESCAP_PTPL = _nvme.NVME_NS_RESCAP_PTPL

NVME_NS_RESCAP_WE = _nvme.NVME_NS_RESCAP_WE

NVME_NS_RESCAP_EA = _nvme.NVME_NS_RESCAP_EA

NVME_NS_RESCAP_WERO = _nvme.NVME_NS_RESCAP_WERO

NVME_NS_RESCAP_EARO = _nvme.NVME_NS_RESCAP_EARO

NVME_NS_RESCAP_WEAR = _nvme.NVME_NS_RESCAP_WEAR

NVME_NS_RESCAP_EAAR = _nvme.NVME_NS_RESCAP_EAAR

NVME_NS_RESCAP_IEK_13 = _nvme.NVME_NS_RESCAP_IEK_13

NVME_NS_FPI_REMAINING = _nvme.NVME_NS_FPI_REMAINING

NVME_NS_FPI_SUPPORTED = _nvme.NVME_NS_FPI_SUPPORTED

NVME_NS_DLFEAT_RB = _nvme.NVME_NS_DLFEAT_RB

NVME_NS_DLFEAT_RB_NR = _nvme.NVME_NS_DLFEAT_RB_NR

NVME_NS_DLFEAT_RB_ALL_0S = _nvme.NVME_NS_DLFEAT_RB_ALL_0S

NVME_NS_DLFEAT_RB_ALL_FS = _nvme.NVME_NS_DLFEAT_RB_ALL_FS

NVME_NS_DLFEAT_WRITE_ZEROES = _nvme.NVME_NS_DLFEAT_WRITE_ZEROES

NVME_NS_DLFEAT_CRC_GUARD = _nvme.NVME_NS_DLFEAT_CRC_GUARD

NVME_NS_NSATTR_WRITE_PROTECTED = _nvme.NVME_NS_NSATTR_WRITE_PROTECTED

NVME_NIDT_EUI64 = _nvme.NVME_NIDT_EUI64

NVME_NIDT_NGUID = _nvme.NVME_NIDT_NGUID

NVME_NIDT_UUID = _nvme.NVME_NIDT_UUID

NVME_NIDT_CSI = _nvme.NVME_NIDT_CSI

NVME_NIDT_EUI64_LEN = _nvme.NVME_NIDT_EUI64_LEN

NVME_NIDT_NGUID_LEN = _nvme.NVME_NIDT_NGUID_LEN

NVME_NIDT_UUID_LEN = _nvme.NVME_NIDT_UUID_LEN

NVME_NIDT_CSI_LEN = _nvme.NVME_NIDT_CSI_LEN

NVME_ID_UUID_HDR_ASSOCIATION_MASK = _nvme.NVME_ID_UUID_HDR_ASSOCIATION_MASK

NVME_ID_UUID_ASSOCIATION_NONE = _nvme.NVME_ID_UUID_ASSOCIATION_NONE

NVME_ID_UUID_ASSOCIATION_VENDOR = _nvme.NVME_ID_UUID_ASSOCIATION_VENDOR

NVME_ID_UUID_ASSOCIATION_SUBSYSTEM_VENDOR = _nvme.NVME_ID_UUID_ASSOCIATION_SUBSYSTEM_VENDOR

NVME_ID_CTRL_NVM_LBAMQF_TYPE_0 = _nvme.NVME_ID_CTRL_NVM_LBAMQF_TYPE_0

NVME_ID_CTRL_NVM_LBAMQF_VENDOR_MIN = _nvme.NVME_ID_CTRL_NVM_LBAMQF_VENDOR_MIN

NVME_ID_CTRL_NVM_LBAMQF_VENDOR_MAX = _nvme.NVME_ID_CTRL_NVM_LBAMQF_VENDOR_MAX

NVME_IOCS_IOCSC_NVMCS_SHIFT = _nvme.NVME_IOCS_IOCSC_NVMCS_SHIFT

NVME_IOCS_IOCSC_NVMCS_MASK = _nvme.NVME_IOCS_IOCSC_NVMCS_MASK

NVME_IOCS_IOCSC_KVCS_SHIFT = _nvme.NVME_IOCS_IOCSC_KVCS_SHIFT

NVME_IOCS_IOCSC_KVCS_MASK = _nvme.NVME_IOCS_IOCSC_KVCS_MASK

NVME_IOCS_IOCSC_ZNSCS_SHIFT = _nvme.NVME_IOCS_IOCSC_ZNSCS_SHIFT

NVME_IOCS_IOCSC_ZNSCS_MASK = _nvme.NVME_IOCS_IOCSC_ZNSCS_MASK

NVME_IOCS_IOCSC_SLMCS_SHIFT = _nvme.NVME_IOCS_IOCSC_SLMCS_SHIFT

NVME_IOCS_IOCSC_SLMCS_MASK = _nvme.NVME_IOCS_IOCSC_SLMCS_MASK

NVME_IOCS_IOCSC_CPNCS_SHIFT = _nvme.NVME_IOCS_IOCSC_CPNCS_SHIFT

NVME_IOCS_IOCSC_CPNCS_MASK = _nvme.NVME_IOCS_IOCSC_CPNCS_MASK

NVME_ERR_PEL_BYTE_MASK = _nvme.NVME_ERR_PEL_BYTE_MASK

NVME_ERR_PEL_BIT_MASK = _nvme.NVME_ERR_PEL_BIT_MASK

NVME_ERR_SF_PHASE_TAG_SHIFT = _nvme.NVME_ERR_SF_PHASE_TAG_SHIFT

NVME_ERR_SF_STATUS_FIELD_SHIFT = _nvme.NVME_ERR_SF_STATUS_FIELD_SHIFT

NVME_ERR_SF_PHASE_TAG_MASK = _nvme.NVME_ERR_SF_PHASE_TAG_MASK

NVME_ERR_SF_STATUS_FIELD_MASK = _nvme.NVME_ERR_SF_STATUS_FIELD_MASK

NVME_SMART_CRIT_SPARE = _nvme.NVME_SMART_CRIT_SPARE

NVME_SMART_CRIT_TEMPERATURE = _nvme.NVME_SMART_CRIT_TEMPERATURE

NVME_SMART_CRIT_DEGRADED = _nvme.NVME_SMART_CRIT_DEGRADED

NVME_SMART_CRIT_MEDIA = _nvme.NVME_SMART_CRIT_MEDIA

NVME_SMART_CRIT_VOLATILE_MEMORY = _nvme.NVME_SMART_CRIT_VOLATILE_MEMORY

NVME_SMART_CRIT_PMR_RO = _nvme.NVME_SMART_CRIT_PMR_RO

NVME_SMART_EGCW_SPARE = _nvme.NVME_SMART_EGCW_SPARE

NVME_SMART_EGCW_DEGRADED = _nvme.NVME_SMART_EGCW_DEGRADED

NVME_SMART_EGCW_RO = _nvme.NVME_SMART_EGCW_RO

NVME_CMD_EFFECTS_CSUPP = _nvme.NVME_CMD_EFFECTS_CSUPP

NVME_CMD_EFFECTS_LBCC = _nvme.NVME_CMD_EFFECTS_LBCC

NVME_CMD_EFFECTS_NCC = _nvme.NVME_CMD_EFFECTS_NCC

NVME_CMD_EFFECTS_NIC = _nvme.NVME_CMD_EFFECTS_NIC

NVME_CMD_EFFECTS_CCC = _nvme.NVME_CMD_EFFECTS_CCC

NVME_CMD_EFFECTS_CSER_MASK = _nvme.NVME_CMD_EFFECTS_CSER_MASK

NVME_CMD_EFFECTS_CSE_MASK = _nvme.NVME_CMD_EFFECTS_CSE_MASK

NVME_CMD_EFFECTS_UUID_SEL = _nvme.NVME_CMD_EFFECTS_UUID_SEL

NVME_ST_RESULT_NO_ERR = _nvme.NVME_ST_RESULT_NO_ERR

NVME_ST_RESULT_ABORTED = _nvme.NVME_ST_RESULT_ABORTED

NVME_ST_RESULT_CLR = _nvme.NVME_ST_RESULT_CLR

NVME_ST_RESULT_NS_REMOVED = _nvme.NVME_ST_RESULT_NS_REMOVED

NVME_ST_RESULT_ABORTED_FORMAT = _nvme.NVME_ST_RESULT_ABORTED_FORMAT

NVME_ST_RESULT_FATAL_ERR = _nvme.NVME_ST_RESULT_FATAL_ERR

NVME_ST_RESULT_UNKNOWN_SEG_FAIL = _nvme.NVME_ST_RESULT_UNKNOWN_SEG_FAIL

NVME_ST_RESULT_KNOWN_SEG_FAIL = _nvme.NVME_ST_RESULT_KNOWN_SEG_FAIL

NVME_ST_RESULT_ABORTED_UNKNOWN = _nvme.NVME_ST_RESULT_ABORTED_UNKNOWN

NVME_ST_RESULT_ABORTED_SANITIZE = _nvme.NVME_ST_RESULT_ABORTED_SANITIZE

NVME_ST_RESULT_NOT_USED = _nvme.NVME_ST_RESULT_NOT_USED

NVME_ST_RESULT_MASK = _nvme.NVME_ST_RESULT_MASK

NVME_ST_CODE_RESERVED = _nvme.NVME_ST_CODE_RESERVED

NVME_ST_CODE_SHORT = _nvme.NVME_ST_CODE_SHORT

NVME_ST_CODE_EXTENDED = _nvme.NVME_ST_CODE_EXTENDED

NVME_ST_CODE_HOST_INIT = _nvme.NVME_ST_CODE_HOST_INIT

NVME_ST_CODE_VS = _nvme.NVME_ST_CODE_VS

NVME_ST_CODE_ABORT = _nvme.NVME_ST_CODE_ABORT

NVME_ST_CODE_SHIFT = _nvme.NVME_ST_CODE_SHIFT

NVME_ST_CURR_OP_NOT_RUNNING = _nvme.NVME_ST_CURR_OP_NOT_RUNNING

NVME_ST_CURR_OP_SHORT = _nvme.NVME_ST_CURR_OP_SHORT

NVME_ST_CURR_OP_EXTENDED = _nvme.NVME_ST_CURR_OP_EXTENDED

NVME_ST_CURR_OP_VS = _nvme.NVME_ST_CURR_OP_VS

NVME_ST_CURR_OP_RESERVED = _nvme.NVME_ST_CURR_OP_RESERVED

NVME_ST_CURR_OP_MASK = _nvme.NVME_ST_CURR_OP_MASK

NVME_ST_CURR_OP_CMPL_MASK = _nvme.NVME_ST_CURR_OP_CMPL_MASK

NVME_ST_VALID_DIAG_INFO_NSID = _nvme.NVME_ST_VALID_DIAG_INFO_NSID

NVME_ST_VALID_DIAG_INFO_FLBA = _nvme.NVME_ST_VALID_DIAG_INFO_FLBA

NVME_ST_VALID_DIAG_INFO_SCT = _nvme.NVME_ST_VALID_DIAG_INFO_SCT

NVME_ST_VALID_DIAG_INFO_SC = _nvme.NVME_ST_VALID_DIAG_INFO_SC

NVME_LOG_TELEM_HOST_LSP_RETAIN = _nvme.NVME_LOG_TELEM_HOST_LSP_RETAIN

NVME_LOG_TELEM_HOST_LSP_CREATE = _nvme.NVME_LOG_TELEM_HOST_LSP_CREATE

NVME_TELEMETRY_DA_CTRL_DETERMINE = _nvme.NVME_TELEMETRY_DA_CTRL_DETERMINE

NVME_TELEMETRY_DA_1 = _nvme.NVME_TELEMETRY_DA_1

NVME_TELEMETRY_DA_2 = _nvme.NVME_TELEMETRY_DA_2

NVME_TELEMETRY_DA_3 = _nvme.NVME_TELEMETRY_DA_3

NVME_TELEMETRY_DA_4 = _nvme.NVME_TELEMETRY_DA_4

NVME_EG_CRITICAL_WARNING_SPARE = _nvme.NVME_EG_CRITICAL_WARNING_SPARE

NVME_EG_CRITICAL_WARNING_DEGRADED = _nvme.NVME_EG_CRITICAL_WARNING_DEGRADED

NVME_EG_CRITICAL_WARNING_READ_ONLY = _nvme.NVME_EG_CRITICAL_WARNING_READ_ONLY

NVME_NVMSET_PL_STATUS_DISABLED = _nvme.NVME_NVMSET_PL_STATUS_DISABLED

NVME_NVMSET_PL_STATUS_DTWIN = _nvme.NVME_NVMSET_PL_STATUS_DTWIN

NVME_NVMSET_PL_STATUS_NDWIN = _nvme.NVME_NVMSET_PL_STATUS_NDWIN

NVME_NVMSET_PL_EVENT_DTWIN_READ_WARN = _nvme.NVME_NVMSET_PL_EVENT_DTWIN_READ_WARN

NVME_NVMSET_PL_EVENT_DTWIN_WRITE_WARN = _nvme.NVME_NVMSET_PL_EVENT_DTWIN_WRITE_WARN

NVME_NVMSET_PL_EVENT_DTWIN_TIME_WARN = _nvme.NVME_NVMSET_PL_EVENT_DTWIN_TIME_WARN

NVME_NVMSET_PL_EVENT_DTWIN_EXCEEDED = _nvme.NVME_NVMSET_PL_EVENT_DTWIN_EXCEEDED

NVME_NVMSET_PL_EVENT_DTWIN_EXCURSION = _nvme.NVME_NVMSET_PL_EVENT_DTWIN_EXCURSION

NVME_ANA_STATE_OPTIMIZED = _nvme.NVME_ANA_STATE_OPTIMIZED

NVME_ANA_STATE_NONOPTIMIZED = _nvme.NVME_ANA_STATE_NONOPTIMIZED

NVME_ANA_STATE_INACCESSIBLE = _nvme.NVME_ANA_STATE_INACCESSIBLE

NVME_ANA_STATE_PERSISTENT_LOSS = _nvme.NVME_ANA_STATE_PERSISTENT_LOSS

NVME_ANA_STATE_CHANGE = _nvme.NVME_ANA_STATE_CHANGE

NVME_PEL_RCI_RCPID_SHIFT = _nvme.NVME_PEL_RCI_RCPID_SHIFT

NVME_PEL_RCI_RCPIT_SHIFT = _nvme.NVME_PEL_RCI_RCPIT_SHIFT

NVME_PEL_RCI_RCE_SHIFT = _nvme.NVME_PEL_RCI_RCE_SHIFT

NVME_PEL_RCI_RSVD_SHIFT = _nvme.NVME_PEL_RCI_RSVD_SHIFT

NVME_PEL_RCI_RCPID_MASK = _nvme.NVME_PEL_RCI_RCPID_MASK

NVME_PEL_RCI_RCPIT_MASK = _nvme.NVME_PEL_RCI_RCPIT_MASK

NVME_PEL_RCI_RCE_MASK = _nvme.NVME_PEL_RCI_RCE_MASK

NVME_PEL_RCI_RSVD_MASK = _nvme.NVME_PEL_RCI_RSVD_MASK

NVME_PEL_RCI_RCPIT_NOT_EXIST = _nvme.NVME_PEL_RCI_RCPIT_NOT_EXIST

NVME_PEL_RCI_RCPIT_EST_PORT = _nvme.NVME_PEL_RCI_RCPIT_EST_PORT

NVME_PEL_RCI_RCPIT_EST_ME = _nvme.NVME_PEL_RCI_RCPIT_EST_ME

NVME_PEL_SMART_HEALTH_EVENT = _nvme.NVME_PEL_SMART_HEALTH_EVENT

NVME_PEL_FW_COMMIT_EVENT = _nvme.NVME_PEL_FW_COMMIT_EVENT

NVME_PEL_TIMESTAMP_EVENT = _nvme.NVME_PEL_TIMESTAMP_EVENT

NVME_PEL_POWER_ON_RESET_EVENT = _nvme.NVME_PEL_POWER_ON_RESET_EVENT

NVME_PEL_NSS_HW_ERROR_EVENT = _nvme.NVME_PEL_NSS_HW_ERROR_EVENT

NVME_PEL_CHANGE_NS_EVENT = _nvme.NVME_PEL_CHANGE_NS_EVENT

NVME_PEL_FORMAT_START_EVENT = _nvme.NVME_PEL_FORMAT_START_EVENT

NVME_PEL_FORMAT_COMPLETION_EVENT = _nvme.NVME_PEL_FORMAT_COMPLETION_EVENT

NVME_PEL_SANITIZE_START_EVENT = _nvme.NVME_PEL_SANITIZE_START_EVENT

NVME_PEL_SANITIZE_COMPLETION_EVENT = _nvme.NVME_PEL_SANITIZE_COMPLETION_EVENT

NVME_PEL_SET_FEATURE_EVENT = _nvme.NVME_PEL_SET_FEATURE_EVENT

NVME_PEL_TELEMETRY_CRT = _nvme.NVME_PEL_TELEMETRY_CRT

NVME_PEL_THERMAL_EXCURSION_EVENT = _nvme.NVME_PEL_THERMAL_EXCURSION_EVENT

NVME_PEL_SANITIZE_MEDIA_VERIF_EVENT = _nvme.NVME_PEL_SANITIZE_MEDIA_VERIF_EVENT

NVME_PEL_VENDOR_SPECIFIC_EVENT = _nvme.NVME_PEL_VENDOR_SPECIFIC_EVENT

NVME_PEL_TCG_DEFINED_EVENT = _nvme.NVME_PEL_TCG_DEFINED_EVENT

NVME_PEL_EHAI_PIT_SHIFT = _nvme.NVME_PEL_EHAI_PIT_SHIFT

NVME_PEL_EHAI_RSVD_SHIFT = _nvme.NVME_PEL_EHAI_RSVD_SHIFT

NVME_PEL_EHAI_PIT_MASK = _nvme.NVME_PEL_EHAI_PIT_MASK

NVME_PEL_EHAI_RSVD_MASK = _nvme.NVME_PEL_EHAI_RSVD_MASK

NVME_PEL_EHAI_PIT_NOT_REPORTED = _nvme.NVME_PEL_EHAI_PIT_NOT_REPORTED

NVME_PEL_EHAI_PIT_NSS_PORT = _nvme.NVME_PEL_EHAI_PIT_NSS_PORT

NVME_PEL_EHAI_PIT_NMI_PORT = _nvme.NVME_PEL_EHAI_PIT_NMI_PORT

NVME_PEL_EHAI_PIT_NOT_ASSOCIATED = _nvme.NVME_PEL_EHAI_PIT_NOT_ASSOCIATED

NVME_SET_FEAT_EVENT_DW_COUNT_SHIFT = _nvme.NVME_SET_FEAT_EVENT_DW_COUNT_SHIFT

NVME_SET_FEAT_EVENT_CC_DW0_SHIFT = _nvme.NVME_SET_FEAT_EVENT_CC_DW0_SHIFT

NVME_SET_FEAT_EVENT_MB_COUNT_SHIFT = _nvme.NVME_SET_FEAT_EVENT_MB_COUNT_SHIFT

NVME_SET_FEAT_EVENT_DW_COUNT_MASK = _nvme.NVME_SET_FEAT_EVENT_DW_COUNT_MASK

NVME_SET_FEAT_EVENT_CC_DW0_MASK = _nvme.NVME_SET_FEAT_EVENT_CC_DW0_MASK

NVME_SET_FEAT_EVENT_MB_COUNT_MASK = _nvme.NVME_SET_FEAT_EVENT_MB_COUNT_MASK

NVME_LBA_STATUS_ATYPE_ALLOCATED = _nvme.NVME_LBA_STATUS_ATYPE_ALLOCATED

NVME_LBA_STATUS_ATYPE_SCAN_UNTRACKED = _nvme.NVME_LBA_STATUS_ATYPE_SCAN_UNTRACKED

NVME_LBA_STATUS_ATYPE_TRACKED = _nvme.NVME_LBA_STATUS_ATYPE_TRACKED

NVME_FID_SUPPORTED_EFFECTS_FSUPP = _nvme.NVME_FID_SUPPORTED_EFFECTS_FSUPP

NVME_FID_SUPPORTED_EFFECTS_UDCC = _nvme.NVME_FID_SUPPORTED_EFFECTS_UDCC

NVME_FID_SUPPORTED_EFFECTS_NCC = _nvme.NVME_FID_SUPPORTED_EFFECTS_NCC

NVME_FID_SUPPORTED_EFFECTS_NIC = _nvme.NVME_FID_SUPPORTED_EFFECTS_NIC

NVME_FID_SUPPORTED_EFFECTS_CCC = _nvme.NVME_FID_SUPPORTED_EFFECTS_CCC

NVME_FID_SUPPORTED_EFFECTS_UUID_SEL = _nvme.NVME_FID_SUPPORTED_EFFECTS_UUID_SEL

NVME_FID_SUPPORTED_EFFECTS_SCOPE_SHIFT = _nvme.NVME_FID_SUPPORTED_EFFECTS_SCOPE_SHIFT

NVME_FID_SUPPORTED_EFFECTS_SCOPE_MASK = _nvme.NVME_FID_SUPPORTED_EFFECTS_SCOPE_MASK

NVME_FID_SUPPORTED_EFFECTS_SCOPE_NS = _nvme.NVME_FID_SUPPORTED_EFFECTS_SCOPE_NS

NVME_FID_SUPPORTED_EFFECTS_SCOPE_CTRL = _nvme.NVME_FID_SUPPORTED_EFFECTS_SCOPE_CTRL

NVME_FID_SUPPORTED_EFFECTS_SCOPE_NVM_SET = _nvme.NVME_FID_SUPPORTED_EFFECTS_SCOPE_NVM_SET

NVME_FID_SUPPORTED_EFFECTS_SCOPE_ENDGRP = _nvme.NVME_FID_SUPPORTED_EFFECTS_SCOPE_ENDGRP

NVME_FID_SUPPORTED_EFFECTS_SCOPE_DOMAIN = _nvme.NVME_FID_SUPPORTED_EFFECTS_SCOPE_DOMAIN

NVME_FID_SUPPORTED_EFFECTS_SCOPE_NSS = _nvme.NVME_FID_SUPPORTED_EFFECTS_SCOPE_NSS

NVME_FID_SUPPORTED_EFFECTS_CDQSCP = _nvme.NVME_FID_SUPPORTED_EFFECTS_CDQSCP

NVME_MI_CMD_SUPPORTED_EFFECTS_CSUPP = _nvme.NVME_MI_CMD_SUPPORTED_EFFECTS_CSUPP

NVME_MI_CMD_SUPPORTED_EFFECTS_UDCC = _nvme.NVME_MI_CMD_SUPPORTED_EFFECTS_UDCC

NVME_MI_CMD_SUPPORTED_EFFECTS_NCC = _nvme.NVME_MI_CMD_SUPPORTED_EFFECTS_NCC

NVME_MI_CMD_SUPPORTED_EFFECTS_NIC = _nvme.NVME_MI_CMD_SUPPORTED_EFFECTS_NIC

NVME_MI_CMD_SUPPORTED_EFFECTS_CCC = _nvme.NVME_MI_CMD_SUPPORTED_EFFECTS_CCC

NVME_MI_CMD_SUPPORTED_EFFECTS_SCOPE_SHIFT = _nvme.NVME_MI_CMD_SUPPORTED_EFFECTS_SCOPE_SHIFT

NVME_MI_CMD_SUPPORTED_EFFECTS_SCOPE_MASK = _nvme.NVME_MI_CMD_SUPPORTED_EFFECTS_SCOPE_MASK

NVME_MI_CMD_SUPPORTED_EFFECTS_SCOPE_NS = _nvme.NVME_MI_CMD_SUPPORTED_EFFECTS_SCOPE_NS

NVME_MI_CMD_SUPPORTED_EFFECTS_SCOPE_CTRL = _nvme.NVME_MI_CMD_SUPPORTED_EFFECTS_SCOPE_CTRL

NVME_MI_CMD_SUPPORTED_EFFECTS_SCOPE_NVM_SET = _nvme.NVME_MI_CMD_SUPPORTED_EFFECTS_SCOPE_NVM_SET

NVME_MI_CMD_SUPPORTED_EFFECTS_SCOPE_ENDGRP = _nvme.NVME_MI_CMD_SUPPORTED_EFFECTS_SCOPE_ENDGRP

NVME_MI_CMD_SUPPORTED_EFFECTS_SCOPE_DOMAIN = _nvme.NVME_MI_CMD_SUPPORTED_EFFECTS_SCOPE_DOMAIN

NVME_MI_CMD_SUPPORTED_EFFECTS_SCOPE_NSS = _nvme.NVME_MI_CMD_SUPPORTED_EFFECTS_SCOPE_NSS

NVME_BOOT_PARTITION_INFO_BPSZ_SHIFT = _nvme.NVME_BOOT_PARTITION_INFO_BPSZ_SHIFT

NVME_BOOT_PARTITION_INFO_ABPID_SHIFT = _nvme.NVME_BOOT_PARTITION_INFO_ABPID_SHIFT

NVME_BOOT_PARTITION_INFO_BPSZ_MASK = _nvme.NVME_BOOT_PARTITION_INFO_BPSZ_MASK

NVME_BOOT_PARTITION_INFO_ABPID_MASK = _nvme.NVME_BOOT_PARTITION_INFO_ABPID_MASK

NVME_EOM_ODP_PEFP_SHIFT = _nvme.NVME_EOM_ODP_PEFP_SHIFT

NVME_EOM_ODP_EDFP_SHIFT = _nvme.NVME_EOM_ODP_EDFP_SHIFT

NVME_EOM_ODP_RSVD_SHIFT = _nvme.NVME_EOM_ODP_RSVD_SHIFT

NVME_EOM_ODP_PEFP_MASK = _nvme.NVME_EOM_ODP_PEFP_MASK

NVME_EOM_ODP_EDFP_MASK = _nvme.NVME_EOM_ODP_EDFP_MASK

NVME_EOM_ODP_RSVD_MASK = _nvme.NVME_EOM_ODP_RSVD_MASK

NVME_EOM_PRINTABLE_EYE_PRESENT = _nvme.NVME_EOM_PRINTABLE_EYE_PRESENT

NVME_EOM_EYE_DATA_PRESENT = _nvme.NVME_EOM_EYE_DATA_PRESENT

NVME_PHY_RX_EOM_NOT_STARTED = _nvme.NVME_PHY_RX_EOM_NOT_STARTED

NVME_PHY_RX_EOM_IN_PROGRESS = _nvme.NVME_PHY_RX_EOM_IN_PROGRESS

NVME_PHY_RX_EOM_COMPLETED = _nvme.NVME_PHY_RX_EOM_COMPLETED

NVME_RESV_NOTIFY_RNLPT_EMPTY = _nvme.NVME_RESV_NOTIFY_RNLPT_EMPTY

NVME_RESV_NOTIFY_RNLPT_REGISTRATION_PREEMPTED = _nvme.NVME_RESV_NOTIFY_RNLPT_REGISTRATION_PREEMPTED

NVME_RESV_NOTIFY_RNLPT_RESERVATION_RELEASED = _nvme.NVME_RESV_NOTIFY_RNLPT_RESERVATION_RELEASED

NVME_RESV_NOTIFY_RNLPT_RESERVATION_PREEMPTED = _nvme.NVME_RESV_NOTIFY_RNLPT_RESERVATION_PREEMPTED

NVME_SANITIZE_SSTAT_STATUS_SHIFT = _nvme.NVME_SANITIZE_SSTAT_STATUS_SHIFT

NVME_SANITIZE_SSTAT_STATUS_MASK = _nvme.NVME_SANITIZE_SSTAT_STATUS_MASK

NVME_SANITIZE_SSTAT_STATUS_NEVER_SANITIZED = _nvme.NVME_SANITIZE_SSTAT_STATUS_NEVER_SANITIZED

NVME_SANITIZE_SSTAT_STATUS_COMPLETE_SUCCESS = _nvme.NVME_SANITIZE_SSTAT_STATUS_COMPLETE_SUCCESS

NVME_SANITIZE_SSTAT_STATUS_IN_PROGESS = _nvme.NVME_SANITIZE_SSTAT_STATUS_IN_PROGESS

NVME_SANITIZE_SSTAT_STATUS_COMPLETED_FAILED = _nvme.NVME_SANITIZE_SSTAT_STATUS_COMPLETED_FAILED

NVME_SANITIZE_SSTAT_STATUS_ND_COMPLETE_SUCCESS = _nvme.NVME_SANITIZE_SSTAT_STATUS_ND_COMPLETE_SUCCESS

NVME_SANITIZE_SSTAT_COMPLETED_PASSES_SHIFT = _nvme.NVME_SANITIZE_SSTAT_COMPLETED_PASSES_SHIFT

NVME_SANITIZE_SSTAT_COMPLETED_PASSES_MASK = _nvme.NVME_SANITIZE_SSTAT_COMPLETED_PASSES_MASK

NVME_SANITIZE_SSTAT_GLOBAL_DATA_ERASED_SHIFT = _nvme.NVME_SANITIZE_SSTAT_GLOBAL_DATA_ERASED_SHIFT

NVME_SANITIZE_SSTAT_GLOBAL_DATA_ERASED_MASK = _nvme.NVME_SANITIZE_SSTAT_GLOBAL_DATA_ERASED_MASK

NVME_SANITIZE_SSTAT_GLOBAL_DATA_ERASED = _nvme.NVME_SANITIZE_SSTAT_GLOBAL_DATA_ERASED

NVME_SANITIZE_SSTAT_MVCNCLD_SHIFT = _nvme.NVME_SANITIZE_SSTAT_MVCNCLD_SHIFT

NVME_SANITIZE_SSTAT_MVCNCLD_MASK = _nvme.NVME_SANITIZE_SSTAT_MVCNCLD_MASK

NVME_SANITIZE_SSI_SANS_SHIFT = _nvme.NVME_SANITIZE_SSI_SANS_SHIFT

NVME_SANITIZE_SSI_SANS_MASK = _nvme.NVME_SANITIZE_SSI_SANS_MASK

NVME_SANITIZE_SSI_FAILS_SHIFT = _nvme.NVME_SANITIZE_SSI_FAILS_SHIFT

NVME_SANITIZE_SSI_FAILS_MASK = _nvme.NVME_SANITIZE_SSI_FAILS_MASK

NVME_SANITIZE_SSI_IDLE = _nvme.NVME_SANITIZE_SSI_IDLE

NVME_SANITIZE_SSI_RESTRICT_PROCESSING = _nvme.NVME_SANITIZE_SSI_RESTRICT_PROCESSING

NVME_SANITIZE_SSI_RESTRICT_FAILURE = _nvme.NVME_SANITIZE_SSI_RESTRICT_FAILURE

NVME_SANITIZE_SSI_UNRESTRICT_PROCESSING = _nvme.NVME_SANITIZE_SSI_UNRESTRICT_PROCESSING

NVME_SANITIZE_SSI_UNRESTRICT_FAILURE = _nvme.NVME_SANITIZE_SSI_UNRESTRICT_FAILURE

NVME_SANITIZE_SSI_MEDIA_VERIFICATION = _nvme.NVME_SANITIZE_SSI_MEDIA_VERIFICATION

NVME_SANITIZE_SSI_POST_VERIF_DEALLOC = _nvme.NVME_SANITIZE_SSI_POST_VERIF_DEALLOC

NVME_ZONE_TYPE_SEQWRITE_REQ = _nvme.NVME_ZONE_TYPE_SEQWRITE_REQ

NVME_ZNS_ZA_ZFC = _nvme.NVME_ZNS_ZA_ZFC

NVME_ZNS_ZA_FZR = _nvme.NVME_ZNS_ZA_FZR

NVME_ZNS_ZA_RZR = _nvme.NVME_ZNS_ZA_RZR

NVME_ZNS_ZA_ZRWAV = _nvme.NVME_ZNS_ZA_ZRWAV

NVME_ZNS_ZA_ZDEV = _nvme.NVME_ZNS_ZA_ZDEV

NVME_ZNS_ZS_EMPTY = _nvme.NVME_ZNS_ZS_EMPTY

NVME_ZNS_ZS_IMPL_OPEN = _nvme.NVME_ZNS_ZS_IMPL_OPEN

NVME_ZNS_ZS_EXPL_OPEN = _nvme.NVME_ZNS_ZS_EXPL_OPEN

NVME_ZNS_ZS_CLOSED = _nvme.NVME_ZNS_ZS_CLOSED

NVME_ZNS_ZS_READ_ONLY = _nvme.NVME_ZNS_ZS_READ_ONLY

NVME_ZNS_ZS_FULL = _nvme.NVME_ZNS_ZS_FULL

NVME_ZNS_ZS_OFFLINE = _nvme.NVME_ZNS_ZS_OFFLINE

NVME_FDP_RUHT_INITIALLY_ISOLATED = _nvme.NVME_FDP_RUHT_INITIALLY_ISOLATED

NVME_FDP_RUHT_PERSISTENTLY_ISOLATED = _nvme.NVME_FDP_RUHT_PERSISTENTLY_ISOLATED

NVME_FDP_CONFIG_FDPA_RGIF_SHIFT = _nvme.NVME_FDP_CONFIG_FDPA_RGIF_SHIFT

NVME_FDP_CONFIG_FDPA_RGIF_MASK = _nvme.NVME_FDP_CONFIG_FDPA_RGIF_MASK

NVME_FDP_CONFIG_FDPA_FDPVWC_SHIFT = _nvme.NVME_FDP_CONFIG_FDPA_FDPVWC_SHIFT

NVME_FDP_CONFIG_FDPA_FDPVWC_MASK = _nvme.NVME_FDP_CONFIG_FDPA_FDPVWC_MASK

NVME_FDP_CONFIG_FDPA_VALID_SHIFT = _nvme.NVME_FDP_CONFIG_FDPA_VALID_SHIFT

NVME_FDP_CONFIG_FDPA_VALID_MASK = _nvme.NVME_FDP_CONFIG_FDPA_VALID_MASK

NVME_LOCKDOWN_ADMIN_CMD = _nvme.NVME_LOCKDOWN_ADMIN_CMD

NVME_LOCKDOWN_FEATURE_ID = _nvme.NVME_LOCKDOWN_FEATURE_ID

NVME_LOCKDOWN_MI_CMD_SET = _nvme.NVME_LOCKDOWN_MI_CMD_SET

NVME_LOCKDOWN_PCI_CMD_SET = _nvme.NVME_LOCKDOWN_PCI_CMD_SET

NVME_LOCKDOWN_SUPPORTED_CMD = _nvme.NVME_LOCKDOWN_SUPPORTED_CMD

NVME_LOCKDOWN_PROHIBITED_CMD = _nvme.NVME_LOCKDOWN_PROHIBITED_CMD

NVME_LOCKDOWN_PROHIBITED_OUTOFBAND_CMD = _nvme.NVME_LOCKDOWN_PROHIBITED_OUTOFBAND_CMD

NVME_LOCKDOWN_SS_SHIFT = _nvme.NVME_LOCKDOWN_SS_SHIFT

NVME_LOCKDOWN_SS_MASK = _nvme.NVME_LOCKDOWN_SS_MASK

NVME_LOCKDOWN_CS_SHIFT = _nvme.NVME_LOCKDOWN_CS_SHIFT

NVME_LOCKDOWN_CS_MASK = _nvme.NVME_LOCKDOWN_CS_MASK

NVME_FDP_RUHA_HOST_SHIFT = _nvme.NVME_FDP_RUHA_HOST_SHIFT

NVME_FDP_RUHA_HOST_MASK = _nvme.NVME_FDP_RUHA_HOST_MASK

NVME_FDP_RUHA_CTRL_SHIFT = _nvme.NVME_FDP_RUHA_CTRL_SHIFT

NVME_FDP_RUHA_CTRL_MASK = _nvme.NVME_FDP_RUHA_CTRL_MASK

NVME_FDP_EVENT_RUNFW = _nvme.NVME_FDP_EVENT_RUNFW

NVME_FDP_EVENT_RUTLE = _nvme.NVME_FDP_EVENT_RUTLE

NVME_FDP_EVENT_RESET = _nvme.NVME_FDP_EVENT_RESET

NVME_FDP_EVENT_PID = _nvme.NVME_FDP_EVENT_PID

NVME_FDP_EVENT_REALLOC = _nvme.NVME_FDP_EVENT_REALLOC

NVME_FDP_EVENT_MODIFY = _nvme.NVME_FDP_EVENT_MODIFY

NVME_FDP_EVENT_REALLOC_F_LBAV = _nvme.NVME_FDP_EVENT_REALLOC_F_LBAV

NVME_FDP_EVENT_F_PIV = _nvme.NVME_FDP_EVENT_F_PIV

NVME_FDP_EVENT_F_NSIDV = _nvme.NVME_FDP_EVENT_F_NSIDV

NVME_FDP_EVENT_F_LV = _nvme.NVME_FDP_EVENT_F_LV

NVME_FDP_SUPP_EVENT_ENABLED_SHIFT = _nvme.NVME_FDP_SUPP_EVENT_ENABLED_SHIFT

NVME_FDP_SUPP_EVENT_ENABLED_MASK = _nvme.NVME_FDP_SUPP_EVENT_ENABLED_MASK

NVME_LBA_STATUS_CMPC_NO_CMPC = _nvme.NVME_LBA_STATUS_CMPC_NO_CMPC

NVME_LBA_STATUS_CMPC_INCOMPLETE = _nvme.NVME_LBA_STATUS_CMPC_INCOMPLETE

NVME_LBA_STATUS_CMPC_COMPLETE = _nvme.NVME_LBA_STATUS_CMPC_COMPLETE

NVME_APST_ENTRY_ITPS_SHIFT = _nvme.NVME_APST_ENTRY_ITPS_SHIFT

NVME_APST_ENTRY_ITPT_SHIFT = _nvme.NVME_APST_ENTRY_ITPT_SHIFT

NVME_APST_ENTRY_ITPS_MASK = _nvme.NVME_APST_ENTRY_ITPS_MASK

NVME_APST_ENTRY_ITPT_MASK = _nvme.NVME_APST_ENTRY_ITPT_MASK

NVME_CTRL_METADATA_OS_CTRL_NAME = _nvme.NVME_CTRL_METADATA_OS_CTRL_NAME

NVME_CTRL_METADATA_OS_DRIVER_NAME = _nvme.NVME_CTRL_METADATA_OS_DRIVER_NAME

NVME_CTRL_METADATA_OS_DRIVER_VER = _nvme.NVME_CTRL_METADATA_OS_DRIVER_VER

NVME_CTRL_METADATA_PRE_BOOT_CTRL_NAME = _nvme.NVME_CTRL_METADATA_PRE_BOOT_CTRL_NAME

NVME_CTRL_METADATA_PRE_BOOT_DRIVER_NAME = _nvme.NVME_CTRL_METADATA_PRE_BOOT_DRIVER_NAME

NVME_CTRL_METADATA_PRE_BOOT_DRIVER_VER = _nvme.NVME_CTRL_METADATA_PRE_BOOT_DRIVER_VER

NVME_CTRL_METADATA_SYS_PROC_MODEL = _nvme.NVME_CTRL_METADATA_SYS_PROC_MODEL

NVME_CTRL_METADATA_CHIPSET_DRV_NAME = _nvme.NVME_CTRL_METADATA_CHIPSET_DRV_NAME

NVME_CTRL_METADATA_CHIPSET_DRV_VERSION = _nvme.NVME_CTRL_METADATA_CHIPSET_DRV_VERSION

NVME_CTRL_METADATA_OS_NAME_AND_BUILD = _nvme.NVME_CTRL_METADATA_OS_NAME_AND_BUILD

NVME_CTRL_METADATA_SYS_PROD_NAME = _nvme.NVME_CTRL_METADATA_SYS_PROD_NAME

NVME_CTRL_METADATA_FIRMWARE_VERSION = _nvme.NVME_CTRL_METADATA_FIRMWARE_VERSION

NVME_CTRL_METADATA_OS_DRIVER_FILENAME = _nvme.NVME_CTRL_METADATA_OS_DRIVER_FILENAME

NVME_CTRL_METADATA_DISPLAY_DRV_NAME = _nvme.NVME_CTRL_METADATA_DISPLAY_DRV_NAME

NVME_CTRL_METADATA_DISPLAY_DRV_VERSION = _nvme.NVME_CTRL_METADATA_DISPLAY_DRV_VERSION

NVME_CTRL_METADATA_HOST_DET_FAIL_REC = _nvme.NVME_CTRL_METADATA_HOST_DET_FAIL_REC

NVME_NS_METADATA_OS_NS_NAME = _nvme.NVME_NS_METADATA_OS_NS_NAME

NVME_NS_METADATA_PRE_BOOT_NS_NAME = _nvme.NVME_NS_METADATA_PRE_BOOT_NS_NAME

NVME_NS_METADATA_OS_NS_QUAL_1 = _nvme.NVME_NS_METADATA_OS_NS_QUAL_1

NVME_NS_METADATA_OS_NS_QUAL_2 = _nvme.NVME_NS_METADATA_OS_NS_QUAL_2

NVME_LBART_TYPE_GP = _nvme.NVME_LBART_TYPE_GP

NVME_LBART_TYPE_FS = _nvme.NVME_LBART_TYPE_FS

NVME_LBART_TYPE_RAID = _nvme.NVME_LBART_TYPE_RAID

NVME_LBART_TYPE_CACHE = _nvme.NVME_LBART_TYPE_CACHE

NVME_LBART_TYPE_SWAP = _nvme.NVME_LBART_TYPE_SWAP

NVME_LBART_ATTRIB_TEMP = _nvme.NVME_LBART_ATTRIB_TEMP

NVME_LBART_ATTRIB_HIDE = _nvme.NVME_LBART_ATTRIB_HIDE

NVME_ENABLE_ACRE = _nvme.NVME_ENABLE_ACRE

NVME_COPY_SOPT_FCO = _nvme.NVME_COPY_SOPT_FCO

NVME_ID_DIR_ID_BIT = _nvme.NVME_ID_DIR_ID_BIT

NVME_ID_DIR_SD_BIT = _nvme.NVME_ID_DIR_SD_BIT

NVME_ID_DIR_DP_BIT = _nvme.NVME_ID_DIR_DP_BIT

NVME_AER_ERROR = _nvme.NVME_AER_ERROR

NVME_AER_SMART = _nvme.NVME_AER_SMART

NVME_AER_NOTICE = _nvme.NVME_AER_NOTICE

NVME_AER_IMMEDIATE = _nvme.NVME_AER_IMMEDIATE

NVME_AER_ONESHOT = _nvme.NVME_AER_ONESHOT

NVME_AER_CSS = _nvme.NVME_AER_CSS

NVME_AER_VS = _nvme.NVME_AER_VS

NVME_AER_ERROR_INVALID_DB_REG = _nvme.NVME_AER_ERROR_INVALID_DB_REG

NVME_AER_ERROR_INVALID_DB_VAL = _nvme.NVME_AER_ERROR_INVALID_DB_VAL

NVME_AER_ERROR_DIAG_FAILURE = _nvme.NVME_AER_ERROR_DIAG_FAILURE

NVME_AER_ERROR_PERSISTENT_INTERNAL_ERROR = _nvme.NVME_AER_ERROR_PERSISTENT_INTERNAL_ERROR

NVME_AER_ERROR_TRANSIENT_INTERNAL_ERROR = _nvme.NVME_AER_ERROR_TRANSIENT_INTERNAL_ERROR

NVME_AER_ERROR_FW_IMAGE_LOAD_ERROR = _nvme.NVME_AER_ERROR_FW_IMAGE_LOAD_ERROR

NVME_AER_SMART_SUBSYSTEM_RELIABILITY = _nvme.NVME_AER_SMART_SUBSYSTEM_RELIABILITY

NVME_AER_SMART_TEMPERATURE_THRESHOLD = _nvme.NVME_AER_SMART_TEMPERATURE_THRESHOLD

NVME_AER_SMART_SPARE_THRESHOLD = _nvme.NVME_AER_SMART_SPARE_THRESHOLD

NVME_AER_CSS_NVM_RESERVATION = _nvme.NVME_AER_CSS_NVM_RESERVATION

NVME_AER_CSS_NVM_SANITIZE_COMPLETED = _nvme.NVME_AER_CSS_NVM_SANITIZE_COMPLETED

NVME_AER_CSS_NVM_UNEXPECTED_SANITIZE_DEALLOC = _nvme.NVME_AER_CSS_NVM_UNEXPECTED_SANITIZE_DEALLOC

NVME_AER_NOTICE_NS_CHANGED = _nvme.NVME_AER_NOTICE_NS_CHANGED

NVME_AER_NOTICE_FW_ACT_STARTING = _nvme.NVME_AER_NOTICE_FW_ACT_STARTING

NVME_AER_NOTICE_TELEMETRY = _nvme.NVME_AER_NOTICE_TELEMETRY

NVME_AER_NOTICE_ANA = _nvme.NVME_AER_NOTICE_ANA

NVME_AER_NOTICE_PL_EVENT = _nvme.NVME_AER_NOTICE_PL_EVENT

NVME_AER_NOTICE_LBA_STATUS_ALERT = _nvme.NVME_AER_NOTICE_LBA_STATUS_ALERT

NVME_AER_NOTICE_EG_EVENT = _nvme.NVME_AER_NOTICE_EG_EVENT

NVME_AER_NOTICE_DISC_CHANGED = _nvme.NVME_AER_NOTICE_DISC_CHANGED

NVME_NQN_DISC = _nvme.NVME_NQN_DISC

NVME_NQN_NVME = _nvme.NVME_NQN_NVME

NVME_NQN_CURR = _nvme.NVME_NQN_CURR

NVME_DISC_SUBSYS_NAME = _nvme.NVME_DISC_SUBSYS_NAME

NVME_RDMA_IP_PORT = _nvme.NVME_RDMA_IP_PORT

NVME_DISC_IP_PORT = _nvme.NVME_DISC_IP_PORT

NVMF_NQN_SIZE = _nvme.NVMF_NQN_SIZE

NVMF_TRSVCID_SIZE = _nvme.NVMF_TRSVCID_SIZE

NVMF_DISC_EFLAGS_NONE = _nvme.NVMF_DISC_EFLAGS_NONE

NVMF_DISC_EFLAGS_DUPRETINFO = _nvme.NVMF_DISC_EFLAGS_DUPRETINFO

NVMF_DISC_EFLAGS_EPCSD = _nvme.NVMF_DISC_EFLAGS_EPCSD

NVMF_DISC_EFLAGS_NCC = _nvme.NVMF_DISC_EFLAGS_NCC

NVMF_TRTYPE_UNSPECIFIED = _nvme.NVMF_TRTYPE_UNSPECIFIED

NVMF_TRTYPE_RDMA = _nvme.NVMF_TRTYPE_RDMA

NVMF_TRTYPE_FC = _nvme.NVMF_TRTYPE_FC

NVMF_TRTYPE_TCP = _nvme.NVMF_TRTYPE_TCP

NVMF_TRTYPE_LOOP = _nvme.NVMF_TRTYPE_LOOP

NVMF_TRTYPE_MAX = _nvme.NVMF_TRTYPE_MAX

NVMF_ADDR_FAMILY_PCI = _nvme.NVMF_ADDR_FAMILY_PCI

NVMF_ADDR_FAMILY_IP4 = _nvme.NVMF_ADDR_FAMILY_IP4

NVMF_ADDR_FAMILY_IP6 = _nvme.NVMF_ADDR_FAMILY_IP6

NVMF_ADDR_FAMILY_IB = _nvme.NVMF_ADDR_FAMILY_IB

NVMF_ADDR_FAMILY_FC = _nvme.NVMF_ADDR_FAMILY_FC

NVMF_ADDR_FAMILY_LOOP = _nvme.NVMF_ADDR_FAMILY_LOOP

NVMF_TREQ_NOT_SPECIFIED = _nvme.NVMF_TREQ_NOT_SPECIFIED

NVMF_TREQ_REQUIRED = _nvme.NVMF_TREQ_REQUIRED

NVMF_TREQ_NOT_REQUIRED = _nvme.NVMF_TREQ_NOT_REQUIRED

NVMF_TREQ_DISABLE_SQFLOW = _nvme.NVMF_TREQ_DISABLE_SQFLOW

NVMF_RDMA_QPTYPE_CONNECTED = _nvme.NVMF_RDMA_QPTYPE_CONNECTED

NVMF_RDMA_QPTYPE_DATAGRAM = _nvme.NVMF_RDMA_QPTYPE_DATAGRAM

NVMF_RDMA_PRTYPE_NOT_SPECIFIED = _nvme.NVMF_RDMA_PRTYPE_NOT_SPECIFIED

NVMF_RDMA_PRTYPE_IB = _nvme.NVMF_RDMA_PRTYPE_IB

NVMF_RDMA_PRTYPE_ROCE = _nvme.NVMF_RDMA_PRTYPE_ROCE

NVMF_RDMA_PRTYPE_ROCEV2 = _nvme.NVMF_RDMA_PRTYPE_ROCEV2

NVMF_RDMA_PRTYPE_IWARP = _nvme.NVMF_RDMA_PRTYPE_IWARP

NVMF_RDMA_CMS_RDMA_CM = _nvme.NVMF_RDMA_CMS_RDMA_CM

NVMF_TCP_SECTYPE_NONE = _nvme.NVMF_TCP_SECTYPE_NONE

NVMF_TCP_SECTYPE_TLS = _nvme.NVMF_TCP_SECTYPE_TLS

NVMF_TCP_SECTYPE_TLS13 = _nvme.NVMF_TCP_SECTYPE_TLS13

NVMF_LOG_DISC_LID_NONE = _nvme.NVMF_LOG_DISC_LID_NONE

NVMF_LOG_DISC_LID_EXTDLPES = _nvme.NVMF_LOG_DISC_LID_EXTDLPES

NVMF_LOG_DISC_LID_PLEOS = _nvme.NVMF_LOG_DISC_LID_PLEOS

NVMF_LOG_DISC_LID_ALLSUBES = _nvme.NVMF_LOG_DISC_LID_ALLSUBES

NVMF_LOG_DISC_LSP_NONE = _nvme.NVMF_LOG_DISC_LSP_NONE

NVMF_LOG_DISC_LSP_EXTDLPE = _nvme.NVMF_LOG_DISC_LSP_EXTDLPE

NVMF_LOG_DISC_LSP_PLEO = _nvme.NVMF_LOG_DISC_LSP_PLEO

NVMF_LOG_DISC_LSP_ALLSUBE = _nvme.NVMF_LOG_DISC_LSP_ALLSUBE

NVMF_ENAME_LEN = _nvme.NVMF_ENAME_LEN

NVMF_EVER_LEN = _nvme.NVMF_EVER_LEN

NVMF_DIM_TAS_REGISTER = _nvme.NVMF_DIM_TAS_REGISTER

NVMF_DIM_TAS_DEREGISTER = _nvme.NVMF_DIM_TAS_DEREGISTER

NVMF_DIM_TAS_UPDATE = _nvme.NVMF_DIM_TAS_UPDATE

NVMF_DIM_ENTFMT_BASIC = _nvme.NVMF_DIM_ENTFMT_BASIC

NVMF_DIM_ENTFMT_EXTENDED = _nvme.NVMF_DIM_ENTFMT_EXTENDED

NVMF_DIM_ETYPE_HOST = _nvme.NVMF_DIM_ETYPE_HOST

NVMF_DIM_ETYPE_DDC = _nvme.NVMF_DIM_ETYPE_DDC

NVMF_DIM_ETYPE_CDC = _nvme.NVMF_DIM_ETYPE_CDC

NVMF_EXATTYPE_HOSTID = _nvme.NVMF_EXATTYPE_HOSTID

NVMF_EXATTYPE_SYMNAME = _nvme.NVMF_EXATTYPE_SYMNAME

NVME_MI_CCS_RDY = _nvme.NVME_MI_CCS_RDY

NVME_MI_CCS_CFS = _nvme.NVME_MI_CCS_CFS

NVME_MI_CCS_SHST = _nvme.NVME_MI_CCS_SHST

NVME_MI_CCS_NSSRO = _nvme.NVME_MI_CCS_NSSRO

NVME_MI_CCS_CECO = _nvme.NVME_MI_CCS_CECO

NVME_MI_CCS_NAC = _nvme.NVME_MI_CCS_NAC

NVME_MI_CCS_FA = _nvme.NVME_MI_CCS_FA

NVME_MI_CCS_CSTS = _nvme.NVME_MI_CCS_CSTS

NVME_MI_CCS_CTEMP = _nvme.NVME_MI_CCS_CTEMP

NVME_MI_CCS_PDLU = _nvme.NVME_MI_CCS_PDLU

NVME_MI_CCS_SPARE = _nvme.NVME_MI_CCS_SPARE

NVME_MI_CCS_CCWARN = _nvme.NVME_MI_CCS_CCWARN

NVME_MI_CSTS_RDY = _nvme.NVME_MI_CSTS_RDY

NVME_MI_CSTS_CFS = _nvme.NVME_MI_CSTS_CFS

NVME_MI_CSTS_SHST = _nvme.NVME_MI_CSTS_SHST

NVME_MI_CSTS_NSSRO = _nvme.NVME_MI_CSTS_NSSRO

NVME_MI_CSTS_CECO = _nvme.NVME_MI_CSTS_CECO

NVME_MI_CSTS_NAC = _nvme.NVME_MI_CSTS_NAC

NVME_MI_CSTS_FA = _nvme.NVME_MI_CSTS_FA

NVME_MI_CWARN_ST = _nvme.NVME_MI_CWARN_ST

NVME_MI_CWARN_TAUT = _nvme.NVME_MI_CWARN_TAUT

NVME_MI_CWARN_RD = _nvme.NVME_MI_CWARN_RD

NVME_MI_CWARN_RO = _nvme.NVME_MI_CWARN_RO

NVME_MI_CWARN_VMBF = _nvme.NVME_MI_CWARN_VMBF

NVME_MI_ELEM_EED = _nvme.NVME_MI_ELEM_EED

NVME_MI_ELEM_USCE = _nvme.NVME_MI_ELEM_USCE

NVME_MI_ELEM_ECED = _nvme.NVME_MI_ELEM_ECED

NVME_MI_ELEM_LED = _nvme.NVME_MI_ELEM_LED

NVME_MI_ELEM_SMBMED = _nvme.NVME_MI_ELEM_SMBMED

NVME_MI_ELEM_PCIESED = _nvme.NVME_MI_ELEM_PCIESED

NVME_MI_ELEM_NVMED = _nvme.NVME_MI_ELEM_NVMED

NVME_SCT_GENERIC = _nvme.NVME_SCT_GENERIC

NVME_SCT_CMD_SPECIFIC = _nvme.NVME_SCT_CMD_SPECIFIC

NVME_SCT_MEDIA = _nvme.NVME_SCT_MEDIA

NVME_SCT_PATH = _nvme.NVME_SCT_PATH

NVME_SCT_VS = _nvme.NVME_SCT_VS

NVME_SCT_MASK = _nvme.NVME_SCT_MASK

NVME_SCT_SHIFT = _nvme.NVME_SCT_SHIFT

NVME_SC_MASK = _nvme.NVME_SC_MASK

NVME_SC_SHIFT = _nvme.NVME_SC_SHIFT

NVME_SC_SUCCESS = _nvme.NVME_SC_SUCCESS

NVME_SC_INVALID_OPCODE = _nvme.NVME_SC_INVALID_OPCODE

NVME_SC_INVALID_FIELD = _nvme.NVME_SC_INVALID_FIELD

NVME_SC_CMDID_CONFLICT = _nvme.NVME_SC_CMDID_CONFLICT

NVME_SC_DATA_XFER_ERROR = _nvme.NVME_SC_DATA_XFER_ERROR

NVME_SC_POWER_LOSS = _nvme.NVME_SC_POWER_LOSS

NVME_SC_INTERNAL = _nvme.NVME_SC_INTERNAL

NVME_SC_ABORT_REQ = _nvme.NVME_SC_ABORT_REQ

NVME_SC_ABORT_QUEUE = _nvme.NVME_SC_ABORT_QUEUE

NVME_SC_FUSED_FAIL = _nvme.NVME_SC_FUSED_FAIL

NVME_SC_FUSED_MISSING = _nvme.NVME_SC_FUSED_MISSING

NVME_SC_INVALID_NS = _nvme.NVME_SC_INVALID_NS

NVME_SC_CMD_SEQ_ERROR = _nvme.NVME_SC_CMD_SEQ_ERROR

NVME_SC_SGL_INVALID_LAST = _nvme.NVME_SC_SGL_INVALID_LAST

NVME_SC_SGL_INVALID_COUNT = _nvme.NVME_SC_SGL_INVALID_COUNT

NVME_SC_SGL_INVALID_DATA = _nvme.NVME_SC_SGL_INVALID_DATA

NVME_SC_SGL_INVALID_METADATA = _nvme.NVME_SC_SGL_INVALID_METADATA

NVME_SC_SGL_INVALID_TYPE = _nvme.NVME_SC_SGL_INVALID_TYPE

NVME_SC_CMB_INVALID_USE = _nvme.NVME_SC_CMB_INVALID_USE

NVME_SC_PRP_INVALID_OFFSET = _nvme.NVME_SC_PRP_INVALID_OFFSET

NVME_SC_AWU_EXCEEDED = _nvme.NVME_SC_AWU_EXCEEDED

NVME_SC_OP_DENIED = _nvme.NVME_SC_OP_DENIED

NVME_SC_SGL_INVALID_OFFSET = _nvme.NVME_SC_SGL_INVALID_OFFSET

NVME_SC_HOSTID_FORMAT = _nvme.NVME_SC_HOSTID_FORMAT

NVME_SC_KAT_EXPIRED = _nvme.NVME_SC_KAT_EXPIRED

NVME_SC_KAT_INVALID = _nvme.NVME_SC_KAT_INVALID

NVME_SC_CMD_ABORTED_PREMEPT = _nvme.NVME_SC_CMD_ABORTED_PREMEPT

NVME_SC_SANITIZE_FAILED = _nvme.NVME_SC_SANITIZE_FAILED

NVME_SC_SANITIZE_IN_PROGRESS = _nvme.NVME_SC_SANITIZE_IN_PROGRESS

NVME_SC_SGL_INVALID_GRANULARITY = _nvme.NVME_SC_SGL_INVALID_GRANULARITY

NVME_SC_CMD_IN_CMBQ_NOT_SUPP = _nvme.NVME_SC_CMD_IN_CMBQ_NOT_SUPP

NVME_SC_NS_WRITE_PROTECTED = _nvme.NVME_SC_NS_WRITE_PROTECTED

NVME_SC_CMD_INTERRUPTED = _nvme.NVME_SC_CMD_INTERRUPTED

NVME_SC_TRAN_TPORT_ERROR = _nvme.NVME_SC_TRAN_TPORT_ERROR

NVME_SC_PROHIBITED_BY_CMD_AND_FEAT = _nvme.NVME_SC_PROHIBITED_BY_CMD_AND_FEAT

NVME_SC_ADMIN_CMD_MEDIA_NOT_READY = _nvme.NVME_SC_ADMIN_CMD_MEDIA_NOT_READY

NVME_SC_INVALID_KEY_TAG = _nvme.NVME_SC_INVALID_KEY_TAG

NVME_SC_HOST_DISPERSED_NS_NOT_ENABLED = _nvme.NVME_SC_HOST_DISPERSED_NS_NOT_ENABLED

NVME_SC_HOST_ID_NOT_INITIALIZED = _nvme.NVME_SC_HOST_ID_NOT_INITIALIZED

NVME_SC_INCORRECT_KEY = _nvme.NVME_SC_INCORRECT_KEY

NVME_SC_FDP_DISABLED = _nvme.NVME_SC_FDP_DISABLED

NVME_SC_INVALID_PLACEMENT_HANDLE_LIST = _nvme.NVME_SC_INVALID_PLACEMENT_HANDLE_LIST

NVME_SC_LBA_RANGE = _nvme.NVME_SC_LBA_RANGE

NVME_SC_CAP_EXCEEDED = _nvme.NVME_SC_CAP_EXCEEDED

NVME_SC_NS_NOT_READY = _nvme.NVME_SC_NS_NOT_READY

NVME_SC_RESERVATION_CONFLICT = _nvme.NVME_SC_RESERVATION_CONFLICT

NVME_SC_FORMAT_IN_PROGRESS = _nvme.NVME_SC_FORMAT_IN_PROGRESS

NVME_SC_INVALID_VALUE_SIZE = _nvme.NVME_SC_INVALID_VALUE_SIZE

NVME_SC_INVALID_KEY_SIZE = _nvme.NVME_SC_INVALID_KEY_SIZE

NVME_SC_KV_KEY_NOT_EXISTS = _nvme.NVME_SC_KV_KEY_NOT_EXISTS

NVME_SC_UNRECOVERED_ERROR = _nvme.NVME_SC_UNRECOVERED_ERROR

NVME_SC_KEY_EXISTS = _nvme.NVME_SC_KEY_EXISTS

NVME_SC_CQ_INVALID = _nvme.NVME_SC_CQ_INVALID

NVME_SC_QID_INVALID = _nvme.NVME_SC_QID_INVALID

NVME_SC_QUEUE_SIZE = _nvme.NVME_SC_QUEUE_SIZE

NVME_SC_ABORT_LIMIT = _nvme.NVME_SC_ABORT_LIMIT

NVME_SC_ABORT_MISSING = _nvme.NVME_SC_ABORT_MISSING

NVME_SC_ASYNC_LIMIT = _nvme.NVME_SC_ASYNC_LIMIT

NVME_SC_FIRMWARE_SLOT = _nvme.NVME_SC_FIRMWARE_SLOT

NVME_SC_FIRMWARE_IMAGE = _nvme.NVME_SC_FIRMWARE_IMAGE

NVME_SC_INVALID_VECTOR = _nvme.NVME_SC_INVALID_VECTOR

NVME_SC_INVALID_LOG_PAGE = _nvme.NVME_SC_INVALID_LOG_PAGE

NVME_SC_INVALID_FORMAT = _nvme.NVME_SC_INVALID_FORMAT

NVME_SC_FW_NEEDS_CONV_RESET = _nvme.NVME_SC_FW_NEEDS_CONV_RESET

NVME_SC_INVALID_QUEUE = _nvme.NVME_SC_INVALID_QUEUE

NVME_SC_FEATURE_NOT_SAVEABLE = _nvme.NVME_SC_FEATURE_NOT_SAVEABLE

NVME_SC_FEATURE_NOT_CHANGEABLE = _nvme.NVME_SC_FEATURE_NOT_CHANGEABLE

NVME_SC_FEATURE_NOT_PER_NS = _nvme.NVME_SC_FEATURE_NOT_PER_NS

NVME_SC_FW_NEEDS_SUBSYS_RESET = _nvme.NVME_SC_FW_NEEDS_SUBSYS_RESET

NVME_SC_FW_NEEDS_RESET = _nvme.NVME_SC_FW_NEEDS_RESET

NVME_SC_FW_NEEDS_MAX_TIME = _nvme.NVME_SC_FW_NEEDS_MAX_TIME

NVME_SC_FW_ACTIVATE_PROHIBITED = _nvme.NVME_SC_FW_ACTIVATE_PROHIBITED

NVME_SC_OVERLAPPING_RANGE = _nvme.NVME_SC_OVERLAPPING_RANGE

NVME_SC_NS_INSUFFICIENT_CAP = _nvme.NVME_SC_NS_INSUFFICIENT_CAP

NVME_SC_NS_ID_UNAVAILABLE = _nvme.NVME_SC_NS_ID_UNAVAILABLE

NVME_SC_NS_ALREADY_ATTACHED = _nvme.NVME_SC_NS_ALREADY_ATTACHED

NVME_SC_NS_IS_PRIVATE = _nvme.NVME_SC_NS_IS_PRIVATE

NVME_SC_NS_NOT_ATTACHED = _nvme.NVME_SC_NS_NOT_ATTACHED

NVME_SC_THIN_PROV_NOT_SUPP = _nvme.NVME_SC_THIN_PROV_NOT_SUPP

NVME_SC_CTRL_LIST_INVALID = _nvme.NVME_SC_CTRL_LIST_INVALID

NVME_SC_SELF_TEST_IN_PROGRESS = _nvme.NVME_SC_SELF_TEST_IN_PROGRESS

NVME_SC_BP_WRITE_PROHIBITED = _nvme.NVME_SC_BP_WRITE_PROHIBITED

NVME_SC_INVALID_CTRL_ID = _nvme.NVME_SC_INVALID_CTRL_ID

NVME_SC_INVALID_SEC_CTRL_STATE = _nvme.NVME_SC_INVALID_SEC_CTRL_STATE

NVME_SC_INVALID_CTRL_RESOURCES = _nvme.NVME_SC_INVALID_CTRL_RESOURCES

NVME_SC_INVALID_RESOURCE_ID = _nvme.NVME_SC_INVALID_RESOURCE_ID

NVME_SC_PMR_SAN_PROHIBITED = _nvme.NVME_SC_PMR_SAN_PROHIBITED

NVME_SC_ANA_GROUP_ID_INVALID = _nvme.NVME_SC_ANA_GROUP_ID_INVALID

NVME_SC_ANA_ATTACH_FAILED = _nvme.NVME_SC_ANA_ATTACH_FAILED

NVME_SC_INSUFFICIENT_CAP = _nvme.NVME_SC_INSUFFICIENT_CAP

NVME_SC_NS_ATTACHMENT_LIMIT_EXCEEDED = _nvme.NVME_SC_NS_ATTACHMENT_LIMIT_EXCEEDED

NVME_SC_PROHIBIT_CMD_EXEC_NOT_SUPPORTED = _nvme.NVME_SC_PROHIBIT_CMD_EXEC_NOT_SUPPORTED

NVME_SC_IOCS_NOT_SUPPORTED = _nvme.NVME_SC_IOCS_NOT_SUPPORTED

NVME_SC_IOCS_NOT_ENABLED = _nvme.NVME_SC_IOCS_NOT_ENABLED

NVME_SC_IOCS_COMBINATION_REJECTED = _nvme.NVME_SC_IOCS_COMBINATION_REJECTED

NVME_SC_INVALID_IOCS = _nvme.NVME_SC_INVALID_IOCS

NVME_SC_ID_UNAVAILABLE = _nvme.NVME_SC_ID_UNAVAILABLE

NVME_SC_INVALID_DISCOVERY_INFO = _nvme.NVME_SC_INVALID_DISCOVERY_INFO

NVME_SC_ZONING_DATA_STRUCT_LOCKED = _nvme.NVME_SC_ZONING_DATA_STRUCT_LOCKED

NVME_SC_ZONING_DATA_STRUCT_NOTFND = _nvme.NVME_SC_ZONING_DATA_STRUCT_NOTFND

NVME_SC_INSUFFICIENT_DISC_RES = _nvme.NVME_SC_INSUFFICIENT_DISC_RES

NVME_SC_REQSTD_FUNCTION_DISABLED = _nvme.NVME_SC_REQSTD_FUNCTION_DISABLED

NVME_SC_ZONEGRP_ORIGINATOR_INVLD = _nvme.NVME_SC_ZONEGRP_ORIGINATOR_INVLD

NVME_SC_INVALID_CONTROLER_DATA_QUEUE = _nvme.NVME_SC_INVALID_CONTROLER_DATA_QUEUE

NVME_SC_NOT_ENOUGH_RESOURCES = _nvme.NVME_SC_NOT_ENOUGH_RESOURCES

NVME_SC_CONTROLLER_SUSPENDED = _nvme.NVME_SC_CONTROLLER_SUSPENDED

NVME_SC_CONTROLLER_NOT_SUSPENDED = _nvme.NVME_SC_CONTROLLER_NOT_SUSPENDED

NVME_SC_CONTROLLER_DATA_QUEUE_FULL = _nvme.NVME_SC_CONTROLLER_DATA_QUEUE_FULL

NVME_SC_BAD_ATTRIBUTES = _nvme.NVME_SC_BAD_ATTRIBUTES

NVME_SC_INVALID_PI = _nvme.NVME_SC_INVALID_PI

NVME_SC_READ_ONLY = _nvme.NVME_SC_READ_ONLY

NVME_SC_CMD_SIZE_LIMIT_EXCEEDED = _nvme.NVME_SC_CMD_SIZE_LIMIT_EXCEEDED

NVME_SC_INCOMPATIBLE_NS = _nvme.NVME_SC_INCOMPATIBLE_NS

NVME_SC_FAST_COPY_NOT_POSSIBLE = _nvme.NVME_SC_FAST_COPY_NOT_POSSIBLE

NVME_SC_OVERLAPPING_IO_RANGE = _nvme.NVME_SC_OVERLAPPING_IO_RANGE

NVME_SC_INSUFFICIENT_RESOURCES = _nvme.NVME_SC_INSUFFICIENT_RESOURCES

NVME_SC_CONNECT_FORMAT = _nvme.NVME_SC_CONNECT_FORMAT

NVME_SC_CONNECT_CTRL_BUSY = _nvme.NVME_SC_CONNECT_CTRL_BUSY

NVME_SC_CONNECT_INVALID_PARAM = _nvme.NVME_SC_CONNECT_INVALID_PARAM

NVME_SC_CONNECT_RESTART_DISC = _nvme.NVME_SC_CONNECT_RESTART_DISC

NVME_SC_CONNECT_INVALID_HOST = _nvme.NVME_SC_CONNECT_INVALID_HOST

NVME_SC_DISCONNECT_INVALID_QTYPE = _nvme.NVME_SC_DISCONNECT_INVALID_QTYPE

NVME_SC_DISCOVERY_RESTART = _nvme.NVME_SC_DISCOVERY_RESTART

NVME_SC_AUTH_REQUIRED = _nvme.NVME_SC_AUTH_REQUIRED

NVME_SC_ZNS_INVALID_OP_REQUEST = _nvme.NVME_SC_ZNS_INVALID_OP_REQUEST

NVME_SC_ZNS_ZRWA_RESOURCES_UNAVAILABLE = _nvme.NVME_SC_ZNS_ZRWA_RESOURCES_UNAVAILABLE

NVME_SC_ZNS_BOUNDARY_ERROR = _nvme.NVME_SC_ZNS_BOUNDARY_ERROR

NVME_SC_ZNS_FULL = _nvme.NVME_SC_ZNS_FULL

NVME_SC_ZNS_READ_ONLY = _nvme.NVME_SC_ZNS_READ_ONLY

NVME_SC_ZNS_OFFLINE = _nvme.NVME_SC_ZNS_OFFLINE

NVME_SC_ZNS_INVALID_WRITE = _nvme.NVME_SC_ZNS_INVALID_WRITE

NVME_SC_ZNS_TOO_MANY_ACTIVE = _nvme.NVME_SC_ZNS_TOO_MANY_ACTIVE

NVME_SC_ZNS_TOO_MANY_OPENS = _nvme.NVME_SC_ZNS_TOO_MANY_OPENS

NVME_SC_ZNS_INVAL_TRANSITION = _nvme.NVME_SC_ZNS_INVAL_TRANSITION

NVME_SC_WRITE_FAULT = _nvme.NVME_SC_WRITE_FAULT

NVME_SC_READ_ERROR = _nvme.NVME_SC_READ_ERROR

NVME_SC_GUARD_CHECK = _nvme.NVME_SC_GUARD_CHECK

NVME_SC_APPTAG_CHECK = _nvme.NVME_SC_APPTAG_CHECK

NVME_SC_REFTAG_CHECK = _nvme.NVME_SC_REFTAG_CHECK

NVME_SC_COMPARE_FAILED = _nvme.NVME_SC_COMPARE_FAILED

NVME_SC_ACCESS_DENIED = _nvme.NVME_SC_ACCESS_DENIED

NVME_SC_UNWRITTEN_BLOCK = _nvme.NVME_SC_UNWRITTEN_BLOCK

NVME_SC_STORAGE_TAG_CHECK = _nvme.NVME_SC_STORAGE_TAG_CHECK

NVME_SC_ANA_INTERNAL_PATH_ERROR = _nvme.NVME_SC_ANA_INTERNAL_PATH_ERROR

NVME_SC_ANA_PERSISTENT_LOSS = _nvme.NVME_SC_ANA_PERSISTENT_LOSS

NVME_SC_ANA_INACCESSIBLE = _nvme.NVME_SC_ANA_INACCESSIBLE

NVME_SC_ANA_TRANSITION = _nvme.NVME_SC_ANA_TRANSITION

NVME_SC_CTRL_PATH_ERROR = _nvme.NVME_SC_CTRL_PATH_ERROR

NVME_SC_HOST_PATH_ERROR = _nvme.NVME_SC_HOST_PATH_ERROR

NVME_SC_CMD_ABORTED_BY_HOST = _nvme.NVME_SC_CMD_ABORTED_BY_HOST

NVME_SC_CRD = _nvme.NVME_SC_CRD

NVME_SC_MORE = _nvme.NVME_SC_MORE

NVME_SC_DNR = _nvme.NVME_SC_DNR

NVME_STATUS_TYPE_SHIFT = _nvme.NVME_STATUS_TYPE_SHIFT

NVME_STATUS_TYPE_MASK = _nvme.NVME_STATUS_TYPE_MASK

NVME_STATUS_TYPE_NVME = _nvme.NVME_STATUS_TYPE_NVME

NVME_STATUS_TYPE_MI = _nvme.NVME_STATUS_TYPE_MI

nvme_admin_delete_sq = _nvme.nvme_admin_delete_sq

nvme_admin_create_sq = _nvme.nvme_admin_create_sq

nvme_admin_get_log_page = _nvme.nvme_admin_get_log_page

nvme_admin_delete_cq = _nvme.nvme_admin_delete_cq

nvme_admin_create_cq = _nvme.nvme_admin_create_cq

nvme_admin_identify = _nvme.nvme_admin_identify

nvme_admin_abort_cmd = _nvme.nvme_admin_abort_cmd

nvme_admin_set_features = _nvme.nvme_admin_set_features

nvme_admin_get_features = _nvme.nvme_admin_get_features

nvme_admin_async_event = _nvme.nvme_admin_async_event

nvme_admin_ns_mgmt = _nvme.nvme_admin_ns_mgmt

nvme_admin_fw_commit = _nvme.nvme_admin_fw_commit

nvme_admin_fw_activate = _nvme.nvme_admin_fw_activate

nvme_admin_fw_download = _nvme.nvme_admin_fw_download

nvme_admin_dev_self_test = _nvme.nvme_admin_dev_self_test

nvme_admin_ns_attach = _nvme.nvme_admin_ns_attach

nvme_admin_keep_alive = _nvme.nvme_admin_keep_alive

nvme_admin_directive_send = _nvme.nvme_admin_directive_send

nvme_admin_directive_recv = _nvme.nvme_admin_directive_recv

nvme_admin_virtual_mgmt = _nvme.nvme_admin_virtual_mgmt

nvme_admin_nvme_mi_send = _nvme.nvme_admin_nvme_mi_send

nvme_admin_nvme_mi_recv = _nvme.nvme_admin_nvme_mi_recv

nvme_admin_capacity_mgmt = _nvme.nvme_admin_capacity_mgmt

nvme_admin_discovery_info_mgmt = _nvme.nvme_admin_discovery_info_mgmt

nvme_admin_fabric_zoning_recv = _nvme.nvme_admin_fabric_zoning_recv

nvme_admin_lockdown = _nvme.nvme_admin_lockdown

nvme_admin_fabric_zoning_lookup = _nvme.nvme_admin_fabric_zoning_lookup

nvme_admin_clear_export_nvm_res = _nvme.nvme_admin_clear_export_nvm_res

nvme_admin_fabric_zoning_send = _nvme.nvme_admin_fabric_zoning_send

nvme_admin_create_export_nvms = _nvme.nvme_admin_create_export_nvms

nvme_admin_manage_export_nvms = _nvme.nvme_admin_manage_export_nvms

nvme_admin_manage_export_ns = _nvme.nvme_admin_manage_export_ns

nvme_admin_manage_export_port = _nvme.nvme_admin_manage_export_port

nvme_admin_send_disc_log_page = _nvme.nvme_admin_send_disc_log_page

nvme_admin_track_send = _nvme.nvme_admin_track_send

nvme_admin_track_receive = _nvme.nvme_admin_track_receive

nvme_admin_migration_send = _nvme.nvme_admin_migration_send

nvme_admin_migration_receive = _nvme.nvme_admin_migration_receive

nvme_admin_ctrl_data_queue = _nvme.nvme_admin_ctrl_data_queue

nvme_admin_dbbuf = _nvme.nvme_admin_dbbuf

nvme_admin_fabrics = _nvme.nvme_admin_fabrics

nvme_admin_format_nvm = _nvme.nvme_admin_format_nvm

nvme_admin_security_send = _nvme.nvme_admin_security_send

nvme_admin_security_recv = _nvme.nvme_admin_security_recv

nvme_admin_sanitize_nvm = _nvme.nvme_admin_sanitize_nvm

nvme_admin_load_program = _nvme.nvme_admin_load_program

nvme_admin_get_lba_status = _nvme.nvme_admin_get_lba_status

nvme_admin_program_act_mgmt = _nvme.nvme_admin_program_act_mgmt

nvme_admin_mem_range_set_mgmt = _nvme.nvme_admin_mem_range_set_mgmt

NVME_IDENTIFY_CNS_NS = _nvme.NVME_IDENTIFY_CNS_NS

NVME_IDENTIFY_CNS_CTRL = _nvme.NVME_IDENTIFY_CNS_CTRL

NVME_IDENTIFY_CNS_NS_ACTIVE_LIST = _nvme.NVME_IDENTIFY_CNS_NS_ACTIVE_LIST

NVME_IDENTIFY_CNS_NS_DESC_LIST = _nvme.NVME_IDENTIFY_CNS_NS_DESC_LIST

NVME_IDENTIFY_CNS_NVMSET_LIST = _nvme.NVME_IDENTIFY_CNS_NVMSET_LIST

NVME_IDENTIFY_CNS_CSI_NS = _nvme.NVME_IDENTIFY_CNS_CSI_NS

NVME_IDENTIFY_CNS_CSI_CTRL = _nvme.NVME_IDENTIFY_CNS_CSI_CTRL

NVME_IDENTIFY_CNS_CSI_NS_ACTIVE_LIST = _nvme.NVME_IDENTIFY_CNS_CSI_NS_ACTIVE_LIST

NVME_IDENTIFY_CNS_CSI_INDEPENDENT_ID_NS = _nvme.NVME_IDENTIFY_CNS_CSI_INDEPENDENT_ID_NS

NVME_IDENTIFY_CNS_NS_USER_DATA_FORMAT = _nvme.NVME_IDENTIFY_CNS_NS_USER_DATA_FORMAT

NVME_IDENTIFY_CNS_CSI_NS_USER_DATA_FORMAT = _nvme.NVME_IDENTIFY_CNS_CSI_NS_USER_DATA_FORMAT

NVME_IDENTIFY_CNS_ALLOCATED_NS_LIST = _nvme.NVME_IDENTIFY_CNS_ALLOCATED_NS_LIST

NVME_IDENTIFY_CNS_ALLOCATED_NS = _nvme.NVME_IDENTIFY_CNS_ALLOCATED_NS

NVME_IDENTIFY_CNS_NS_CTRL_LIST = _nvme.NVME_IDENTIFY_CNS_NS_CTRL_LIST

NVME_IDENTIFY_CNS_CTRL_LIST = _nvme.NVME_IDENTIFY_CNS_CTRL_LIST

NVME_IDENTIFY_CNS_PRIMARY_CTRL_CAP = _nvme.NVME_IDENTIFY_CNS_PRIMARY_CTRL_CAP

NVME_IDENTIFY_CNS_SECONDARY_CTRL_LIST = _nvme.NVME_IDENTIFY_CNS_SECONDARY_CTRL_LIST

NVME_IDENTIFY_CNS_NS_GRANULARITY = _nvme.NVME_IDENTIFY_CNS_NS_GRANULARITY

NVME_IDENTIFY_CNS_UUID_LIST = _nvme.NVME_IDENTIFY_CNS_UUID_LIST

NVME_IDENTIFY_CNS_DOMAIN_LIST = _nvme.NVME_IDENTIFY_CNS_DOMAIN_LIST

NVME_IDENTIFY_CNS_ENDURANCE_GROUP_ID = _nvme.NVME_IDENTIFY_CNS_ENDURANCE_GROUP_ID

NVME_IDENTIFY_CNS_CSI_ALLOCATED_NS_LIST = _nvme.NVME_IDENTIFY_CNS_CSI_ALLOCATED_NS_LIST

NVME_IDENTIFY_CNS_CSI_ID_NS_DATA_STRUCTURE = _nvme.NVME_IDENTIFY_CNS_CSI_ID_NS_DATA_STRUCTURE

NVME_IDENTIFY_CNS_COMMAND_SET_STRUCTURE = _nvme.NVME_IDENTIFY_CNS_COMMAND_SET_STRUCTURE

NVME_IDENTIFY_CNS_UNDERLYING_NS_LIST = _nvme.NVME_IDENTIFY_CNS_UNDERLYING_NS_LIST

NVME_IDENTIFY_CNS_PORTS_LIST = _nvme.NVME_IDENTIFY_CNS_PORTS_LIST

NVME_IDENTIFY_CNS_IOCS_IND_ID_ALLOC_NS = _nvme.NVME_IDENTIFY_CNS_IOCS_IND_ID_ALLOC_NS

NVME_IDENTIFY_CNS_SUPPORTED_CTRL_STATE_FORMATS = _nvme.NVME_IDENTIFY_CNS_SUPPORTED_CTRL_STATE_FORMATS

NVME_LOG_LID_SUPPORTED_LOG_PAGES = _nvme.NVME_LOG_LID_SUPPORTED_LOG_PAGES

NVME_LOG_LID_ERROR = _nvme.NVME_LOG_LID_ERROR

NVME_LOG_LID_SMART = _nvme.NVME_LOG_LID_SMART

NVME_LOG_LID_FW_SLOT = _nvme.NVME_LOG_LID_FW_SLOT

NVME_LOG_LID_CHANGED_NS = _nvme.NVME_LOG_LID_CHANGED_NS

NVME_LOG_LID_CMD_EFFECTS = _nvme.NVME_LOG_LID_CMD_EFFECTS

NVME_LOG_LID_DEVICE_SELF_TEST = _nvme.NVME_LOG_LID_DEVICE_SELF_TEST

NVME_LOG_LID_TELEMETRY_HOST = _nvme.NVME_LOG_LID_TELEMETRY_HOST

NVME_LOG_LID_TELEMETRY_CTRL = _nvme.NVME_LOG_LID_TELEMETRY_CTRL

NVME_LOG_LID_ENDURANCE_GROUP = _nvme.NVME_LOG_LID_ENDURANCE_GROUP

NVME_LOG_LID_PREDICTABLE_LAT_NVMSET = _nvme.NVME_LOG_LID_PREDICTABLE_LAT_NVMSET

NVME_LOG_LID_PREDICTABLE_LAT_AGG = _nvme.NVME_LOG_LID_PREDICTABLE_LAT_AGG

NVME_LOG_LID_ANA = _nvme.NVME_LOG_LID_ANA

NVME_LOG_LID_PERSISTENT_EVENT = _nvme.NVME_LOG_LID_PERSISTENT_EVENT

NVME_LOG_LID_LBA_STATUS = _nvme.NVME_LOG_LID_LBA_STATUS

NVME_LOG_LID_ENDURANCE_GRP_EVT = _nvme.NVME_LOG_LID_ENDURANCE_GRP_EVT

NVME_LOG_LID_MEDIA_UNIT_STATUS = _nvme.NVME_LOG_LID_MEDIA_UNIT_STATUS

NVME_LOG_LID_SUPPORTED_CAP_CONFIG_LIST = _nvme.NVME_LOG_LID_SUPPORTED_CAP_CONFIG_LIST

NVME_LOG_LID_FID_SUPPORTED_EFFECTS = _nvme.NVME_LOG_LID_FID_SUPPORTED_EFFECTS

NVME_LOG_LID_MI_CMD_SUPPORTED_EFFECTS = _nvme.NVME_LOG_LID_MI_CMD_SUPPORTED_EFFECTS

NVME_LOG_LID_CMD_AND_FEAT_LOCKDOWN = _nvme.NVME_LOG_LID_CMD_AND_FEAT_LOCKDOWN

NVME_LOG_LID_BOOT_PARTITION = _nvme.NVME_LOG_LID_BOOT_PARTITION

NVME_LOG_LID_ROTATIONAL_MEDIA_INFO = _nvme.NVME_LOG_LID_ROTATIONAL_MEDIA_INFO

NVME_LOG_LID_DISPERSED_NS_PARTICIPATING_NSS = _nvme.NVME_LOG_LID_DISPERSED_NS_PARTICIPATING_NSS

NVME_LOG_LID_MGMT_ADDR_LIST = _nvme.NVME_LOG_LID_MGMT_ADDR_LIST

NVME_LOG_LID_PHY_RX_EOM = _nvme.NVME_LOG_LID_PHY_RX_EOM

NVME_LOG_LID_REACHABILITY_GROUPS = _nvme.NVME_LOG_LID_REACHABILITY_GROUPS

NVME_LOG_LID_REACHABILITY_ASSOCIATIONS = _nvme.NVME_LOG_LID_REACHABILITY_ASSOCIATIONS

NVME_LOG_LID_CHANGED_ALLOC_NS_LIST = _nvme.NVME_LOG_LID_CHANGED_ALLOC_NS_LIST

NVME_LOG_LID_FDP_CONFIGS = _nvme.NVME_LOG_LID_FDP_CONFIGS

NVME_LOG_LID_FDP_RUH_USAGE = _nvme.NVME_LOG_LID_FDP_RUH_USAGE

NVME_LOG_LID_FDP_STATS = _nvme.NVME_LOG_LID_FDP_STATS

NVME_LOG_LID_FDP_EVENTS = _nvme.NVME_LOG_LID_FDP_EVENTS

NVME_LOG_LID_DISCOVER = _nvme.NVME_LOG_LID_DISCOVER

NVME_LOG_LID_HOST_DISCOVER = _nvme.NVME_LOG_LID_HOST_DISCOVER

NVME_LOG_LID_AVE_DISCOVER = _nvme.NVME_LOG_LID_AVE_DISCOVER

NVME_LOG_LID_PULL_MODEL_DDC_REQ = _nvme.NVME_LOG_LID_PULL_MODEL_DDC_REQ

NVME_LOG_LID_RESERVATION = _nvme.NVME_LOG_LID_RESERVATION

NVME_LOG_LID_SANITIZE = _nvme.NVME_LOG_LID_SANITIZE

NVME_LOG_LID_ZNS_CHANGED_ZONES = _nvme.NVME_LOG_LID_ZNS_CHANGED_ZONES

NVME_FEAT_FID_ARBITRATION = _nvme.NVME_FEAT_FID_ARBITRATION

NVME_FEAT_FID_POWER_MGMT = _nvme.NVME_FEAT_FID_POWER_MGMT

NVME_FEAT_FID_LBA_RANGE = _nvme.NVME_FEAT_FID_LBA_RANGE

NVME_FEAT_FID_TEMP_THRESH = _nvme.NVME_FEAT_FID_TEMP_THRESH

NVME_FEAT_FID_ERR_RECOVERY = _nvme.NVME_FEAT_FID_ERR_RECOVERY

NVME_FEAT_FID_VOLATILE_WC = _nvme.NVME_FEAT_FID_VOLATILE_WC

NVME_FEAT_FID_NUM_QUEUES = _nvme.NVME_FEAT_FID_NUM_QUEUES

NVME_FEAT_FID_IRQ_COALESCE = _nvme.NVME_FEAT_FID_IRQ_COALESCE

NVME_FEAT_FID_IRQ_CONFIG = _nvme.NVME_FEAT_FID_IRQ_CONFIG

NVME_FEAT_FID_WRITE_ATOMIC = _nvme.NVME_FEAT_FID_WRITE_ATOMIC

NVME_FEAT_FID_ASYNC_EVENT = _nvme.NVME_FEAT_FID_ASYNC_EVENT

NVME_FEAT_FID_AUTO_PST = _nvme.NVME_FEAT_FID_AUTO_PST

NVME_FEAT_FID_HOST_MEM_BUF = _nvme.NVME_FEAT_FID_HOST_MEM_BUF

NVME_FEAT_FID_TIMESTAMP = _nvme.NVME_FEAT_FID_TIMESTAMP

NVME_FEAT_FID_KATO = _nvme.NVME_FEAT_FID_KATO

NVME_FEAT_FID_HCTM = _nvme.NVME_FEAT_FID_HCTM

NVME_FEAT_FID_NOPSC = _nvme.NVME_FEAT_FID_NOPSC

NVME_FEAT_FID_RRL = _nvme.NVME_FEAT_FID_RRL

NVME_FEAT_FID_PLM_CONFIG = _nvme.NVME_FEAT_FID_PLM_CONFIG

NVME_FEAT_FID_PLM_WINDOW = _nvme.NVME_FEAT_FID_PLM_WINDOW

NVME_FEAT_FID_LBA_STS_INTERVAL = _nvme.NVME_FEAT_FID_LBA_STS_INTERVAL

NVME_FEAT_FID_HOST_BEHAVIOR = _nvme.NVME_FEAT_FID_HOST_BEHAVIOR

NVME_FEAT_FID_SANITIZE = _nvme.NVME_FEAT_FID_SANITIZE

NVME_FEAT_FID_ENDURANCE_EVT_CFG = _nvme.NVME_FEAT_FID_ENDURANCE_EVT_CFG

NVME_FEAT_FID_IOCS_PROFILE = _nvme.NVME_FEAT_FID_IOCS_PROFILE

NVME_FEAT_FID_SPINUP_CONTROL = _nvme.NVME_FEAT_FID_SPINUP_CONTROL

NVME_FEAT_FID_POWER_LOSS_SIGNAL = _nvme.NVME_FEAT_FID_POWER_LOSS_SIGNAL

NVME_FEAT_FID_PERF_CHARACTERISTICS = _nvme.NVME_FEAT_FID_PERF_CHARACTERISTICS

NVME_FEAT_FID_FDP = _nvme.NVME_FEAT_FID_FDP

NVME_FEAT_FID_FDP_EVENTS = _nvme.NVME_FEAT_FID_FDP_EVENTS

NVME_FEAT_FID_NS_ADMIN_LABEL = _nvme.NVME_FEAT_FID_NS_ADMIN_LABEL

NVME_FEAT_FID_KEY_VALUE = _nvme.NVME_FEAT_FID_KEY_VALUE

NVME_FEAT_FID_CTRL_DATA_QUEUE = _nvme.NVME_FEAT_FID_CTRL_DATA_QUEUE

NVME_FEAT_FID_EMB_MGMT_CTRL_ADDR = _nvme.NVME_FEAT_FID_EMB_MGMT_CTRL_ADDR

NVME_FEAT_FID_HOST_MGMT_AGENT_ADDR = _nvme.NVME_FEAT_FID_HOST_MGMT_AGENT_ADDR

NVME_FEAT_FID_ENH_CTRL_METADATA = _nvme.NVME_FEAT_FID_ENH_CTRL_METADATA

NVME_FEAT_FID_CTRL_METADATA = _nvme.NVME_FEAT_FID_CTRL_METADATA

NVME_FEAT_FID_NS_METADATA = _nvme.NVME_FEAT_FID_NS_METADATA

NVME_FEAT_FID_SW_PROGRESS = _nvme.NVME_FEAT_FID_SW_PROGRESS

NVME_FEAT_FID_HOST_ID = _nvme.NVME_FEAT_FID_HOST_ID

NVME_FEAT_FID_RESV_MASK = _nvme.NVME_FEAT_FID_RESV_MASK

NVME_FEAT_FID_RESV_PERSIST = _nvme.NVME_FEAT_FID_RESV_PERSIST

NVME_FEAT_FID_WRITE_PROTECT = _nvme.NVME_FEAT_FID_WRITE_PROTECT

NVME_FEAT_FID_BP_WRITE_PROTECT = _nvme.NVME_FEAT_FID_BP_WRITE_PROTECT

NVME_FEAT_ARBITRATION_BURST_SHIFT = _nvme.NVME_FEAT_ARBITRATION_BURST_SHIFT

NVME_FEAT_ARBITRATION_BURST_MASK = _nvme.NVME_FEAT_ARBITRATION_BURST_MASK

NVME_FEAT_ARBITRATION_LPW_SHIFT = _nvme.NVME_FEAT_ARBITRATION_LPW_SHIFT

NVME_FEAT_ARBITRATION_LPW_MASK = _nvme.NVME_FEAT_ARBITRATION_LPW_MASK

NVME_FEAT_ARBITRATION_MPW_SHIFT = _nvme.NVME_FEAT_ARBITRATION_MPW_SHIFT

NVME_FEAT_ARBITRATION_MPW_MASK = _nvme.NVME_FEAT_ARBITRATION_MPW_MASK

NVME_FEAT_ARBITRATION_HPW_SHIFT = _nvme.NVME_FEAT_ARBITRATION_HPW_SHIFT

NVME_FEAT_ARBITRATION_HPW_MASK = _nvme.NVME_FEAT_ARBITRATION_HPW_MASK

NVME_FEAT_PWRMGMT_PS_SHIFT = _nvme.NVME_FEAT_PWRMGMT_PS_SHIFT

NVME_FEAT_PWRMGMT_PS_MASK = _nvme.NVME_FEAT_PWRMGMT_PS_MASK

NVME_FEAT_PWRMGMT_WH_SHIFT = _nvme.NVME_FEAT_PWRMGMT_WH_SHIFT

NVME_FEAT_PWRMGMT_WH_MASK = _nvme.NVME_FEAT_PWRMGMT_WH_MASK

NVME_FEAT_LBAR_NR_SHIFT = _nvme.NVME_FEAT_LBAR_NR_SHIFT

NVME_FEAT_LBAR_NR_MASK = _nvme.NVME_FEAT_LBAR_NR_MASK

NVME_FEAT_TT_TMPTH_SHIFT = _nvme.NVME_FEAT_TT_TMPTH_SHIFT

NVME_FEAT_TT_TMPTH_MASK = _nvme.NVME_FEAT_TT_TMPTH_MASK

NVME_FEAT_TT_TMPSEL_SHIFT = _nvme.NVME_FEAT_TT_TMPSEL_SHIFT

NVME_FEAT_TT_TMPSEL_MASK = _nvme.NVME_FEAT_TT_TMPSEL_MASK

NVME_FEAT_TT_THSEL_SHIFT = _nvme.NVME_FEAT_TT_THSEL_SHIFT

NVME_FEAT_TT_THSEL_MASK = _nvme.NVME_FEAT_TT_THSEL_MASK

NVME_FEAT_ERROR_RECOVERY_TLER_SHIFT = _nvme.NVME_FEAT_ERROR_RECOVERY_TLER_SHIFT

NVME_FEAT_ERROR_RECOVERY_TLER_MASK = _nvme.NVME_FEAT_ERROR_RECOVERY_TLER_MASK

NVME_FEAT_ERROR_RECOVERY_DULBE_SHIFT = _nvme.NVME_FEAT_ERROR_RECOVERY_DULBE_SHIFT

NVME_FEAT_ERROR_RECOVERY_DULBE_MASK = _nvme.NVME_FEAT_ERROR_RECOVERY_DULBE_MASK

NVME_FEAT_VWC_WCE_SHIFT = _nvme.NVME_FEAT_VWC_WCE_SHIFT

NVME_FEAT_VWC_WCE_MASK = _nvme.NVME_FEAT_VWC_WCE_MASK

NVME_FEAT_NRQS_NSQR_SHIFT = _nvme.NVME_FEAT_NRQS_NSQR_SHIFT

NVME_FEAT_NRQS_NSQR_MASK = _nvme.NVME_FEAT_NRQS_NSQR_MASK

NVME_FEAT_NRQS_NCQR_SHIFT = _nvme.NVME_FEAT_NRQS_NCQR_SHIFT

NVME_FEAT_NRQS_NCQR_MASK = _nvme.NVME_FEAT_NRQS_NCQR_MASK

NVME_FEAT_IRQC_THR_SHIFT = _nvme.NVME_FEAT_IRQC_THR_SHIFT

NVME_FEAT_IRQC_THR_MASK = _nvme.NVME_FEAT_IRQC_THR_MASK

NVME_FEAT_IRQC_TIME_SHIFT = _nvme.NVME_FEAT_IRQC_TIME_SHIFT

NVME_FEAT_IRQC_TIME_MASK = _nvme.NVME_FEAT_IRQC_TIME_MASK

NVME_FEAT_ICFG_IV_SHIFT = _nvme.NVME_FEAT_ICFG_IV_SHIFT

NVME_FEAT_ICFG_IV_MASK = _nvme.NVME_FEAT_ICFG_IV_MASK

NVME_FEAT_ICFG_CD_SHIFT = _nvme.NVME_FEAT_ICFG_CD_SHIFT

NVME_FEAT_ICFG_CD_MASK = _nvme.NVME_FEAT_ICFG_CD_MASK

NVME_FEAT_WA_DN_SHIFT = _nvme.NVME_FEAT_WA_DN_SHIFT

NVME_FEAT_WA_DN_MASK = _nvme.NVME_FEAT_WA_DN_MASK

NVME_FEAT_AE_SMART_SHIFT = _nvme.NVME_FEAT_AE_SMART_SHIFT

NVME_FEAT_AE_SMART_MASK = _nvme.NVME_FEAT_AE_SMART_MASK

NVME_FEAT_AE_NAN_SHIFT = _nvme.NVME_FEAT_AE_NAN_SHIFT

NVME_FEAT_AE_NAN_MASK = _nvme.NVME_FEAT_AE_NAN_MASK

NVME_FEAT_AE_FW_SHIFT = _nvme.NVME_FEAT_AE_FW_SHIFT

NVME_FEAT_AE_FW_MASK = _nvme.NVME_FEAT_AE_FW_MASK

NVME_FEAT_AE_TELEM_SHIFT = _nvme.NVME_FEAT_AE_TELEM_SHIFT

NVME_FEAT_AE_TELEM_MASK = _nvme.NVME_FEAT_AE_TELEM_MASK

NVME_FEAT_AE_ANA_SHIFT = _nvme.NVME_FEAT_AE_ANA_SHIFT

NVME_FEAT_AE_ANA_MASK = _nvme.NVME_FEAT_AE_ANA_MASK

NVME_FEAT_AE_PLA_SHIFT = _nvme.NVME_FEAT_AE_PLA_SHIFT

NVME_FEAT_AE_PLA_MASK = _nvme.NVME_FEAT_AE_PLA_MASK

NVME_FEAT_AE_LBAS_SHIFT = _nvme.NVME_FEAT_AE_LBAS_SHIFT

NVME_FEAT_AE_LBAS_MASK = _nvme.NVME_FEAT_AE_LBAS_MASK

NVME_FEAT_AE_EGA_SHIFT = _nvme.NVME_FEAT_AE_EGA_SHIFT

NVME_FEAT_AE_EGA_MASK = _nvme.NVME_FEAT_AE_EGA_MASK

NVME_FEAT_AE_NNSSHDN_SHIFT = _nvme.NVME_FEAT_AE_NNSSHDN_SHIFT

NVME_FEAT_AE_NNSSHDN_MASK = _nvme.NVME_FEAT_AE_NNSSHDN_MASK

NVME_FEAT_AE_TTHRY_SHIFT = _nvme.NVME_FEAT_AE_TTHRY_SHIFT

NVME_FEAT_AE_TTHRY_MASK = _nvme.NVME_FEAT_AE_TTHRY_MASK

NVME_FEAT_AE_RASSN_SHIFT = _nvme.NVME_FEAT_AE_RASSN_SHIFT

NVME_FEAT_AE_RASSN_MASK = _nvme.NVME_FEAT_AE_RASSN_MASK

NVME_FEAT_AE_RGRP0_SHIFT = _nvme.NVME_FEAT_AE_RGRP0_SHIFT

NVME_FEAT_AE_RGRP0_MASK = _nvme.NVME_FEAT_AE_RGRP0_MASK

NVME_FEAT_AE_ANSAN_SHIFT = _nvme.NVME_FEAT_AE_ANSAN_SHIFT

NVME_FEAT_AE_ANSAN_MASK = _nvme.NVME_FEAT_AE_ANSAN_MASK

NVME_FEAT_AE_ZDCN_SHIFT = _nvme.NVME_FEAT_AE_ZDCN_SHIFT

NVME_FEAT_AE_ZDCN_MASK = _nvme.NVME_FEAT_AE_ZDCN_MASK

NVME_FEAT_AE_PMDRLPCN_SHIFT = _nvme.NVME_FEAT_AE_PMDRLPCN_SHIFT

NVME_FEAT_AE_PMDRLPCN_MASK = _nvme.NVME_FEAT_AE_PMDRLPCN_MASK

NVME_FEAT_AE_ADLPCN_SHIFT = _nvme.NVME_FEAT_AE_ADLPCN_SHIFT

NVME_FEAT_AE_ADLPCN_MASK = _nvme.NVME_FEAT_AE_ADLPCN_MASK

NVME_FEAT_AE_HDLPCN_SHIFT = _nvme.NVME_FEAT_AE_HDLPCN_SHIFT

NVME_FEAT_AE_HDLPCN_MASK = _nvme.NVME_FEAT_AE_HDLPCN_MASK

NVME_FEAT_AE_DLPCN_SHIFT = _nvme.NVME_FEAT_AE_DLPCN_SHIFT

NVME_FEAT_AE_DLPCN_MASK = _nvme.NVME_FEAT_AE_DLPCN_MASK

NVME_FEAT_APST_APSTE_SHIFT = _nvme.NVME_FEAT_APST_APSTE_SHIFT

NVME_FEAT_APST_APSTE_MASK = _nvme.NVME_FEAT_APST_APSTE_MASK

NVME_FEAT_HMEM_EHM_SHIFT = _nvme.NVME_FEAT_HMEM_EHM_SHIFT

NVME_FEAT_HMEM_EHM_MASK = _nvme.NVME_FEAT_HMEM_EHM_MASK

NVME_FEAT_HCTM_TMT2_SHIFT = _nvme.NVME_FEAT_HCTM_TMT2_SHIFT

NVME_FEAT_HCTM_TMT2_MASK = _nvme.NVME_FEAT_HCTM_TMT2_MASK

NVME_FEAT_HCTM_TMT1_SHIFT = _nvme.NVME_FEAT_HCTM_TMT1_SHIFT

NVME_FEAT_HCTM_TMT1_MASK = _nvme.NVME_FEAT_HCTM_TMT1_MASK

NVME_FEAT_NOPS_NOPPME_SHIFT = _nvme.NVME_FEAT_NOPS_NOPPME_SHIFT

NVME_FEAT_NOPS_NOPPME_MASK = _nvme.NVME_FEAT_NOPS_NOPPME_MASK

NVME_FEAT_RRL_RRL_SHIFT = _nvme.NVME_FEAT_RRL_RRL_SHIFT

NVME_FEAT_RRL_RRL_MASK = _nvme.NVME_FEAT_RRL_RRL_MASK

NVME_FEAT_PLM_PLME_SHIFT = _nvme.NVME_FEAT_PLM_PLME_SHIFT

NVME_FEAT_PLM_PLME_MASK = _nvme.NVME_FEAT_PLM_PLME_MASK

NVME_FEAT_PLMW_WS_SHIFT = _nvme.NVME_FEAT_PLMW_WS_SHIFT

NVME_FEAT_PLMW_WS_MASK = _nvme.NVME_FEAT_PLMW_WS_MASK

NVME_FEAT_LBAS_LSIRI_SHIFT = _nvme.NVME_FEAT_LBAS_LSIRI_SHIFT

NVME_FEAT_LBAS_LSIRI_MASK = _nvme.NVME_FEAT_LBAS_LSIRI_MASK

NVME_FEAT_LBAS_LSIPI_SHIFT = _nvme.NVME_FEAT_LBAS_LSIPI_SHIFT

NVME_FEAT_LBAS_LSIPI_MASK = _nvme.NVME_FEAT_LBAS_LSIPI_MASK

NVME_FEAT_SC_NODRM_SHIFT = _nvme.NVME_FEAT_SC_NODRM_SHIFT

NVME_FEAT_SC_NODRM_MASK = _nvme.NVME_FEAT_SC_NODRM_MASK

NVME_FEAT_EG_ENDGID_SHIFT = _nvme.NVME_FEAT_EG_ENDGID_SHIFT

NVME_FEAT_EG_ENDGID_MASK = _nvme.NVME_FEAT_EG_ENDGID_MASK

NVME_FEAT_EG_EGCW_SHIFT = _nvme.NVME_FEAT_EG_EGCW_SHIFT

NVME_FEAT_EG_EGCW_MASK = _nvme.NVME_FEAT_EG_EGCW_MASK

NVME_FEAT_FDPE_PHNDL_SHIFT = _nvme.NVME_FEAT_FDPE_PHNDL_SHIFT

NVME_FEAT_FDPE_PHNDL_MASK = _nvme.NVME_FEAT_FDPE_PHNDL_MASK

NVME_FEAT_FDPE_NOET_SHIFT = _nvme.NVME_FEAT_FDPE_NOET_SHIFT

NVME_FEAT_FDPE_NOET_MASK = _nvme.NVME_FEAT_FDPE_NOET_MASK

NVME_FEAT_SPM_PBSLC_SHIFT = _nvme.NVME_FEAT_SPM_PBSLC_SHIFT

NVME_FEAT_SPM_PBSLC_MASK = _nvme.NVME_FEAT_SPM_PBSLC_MASK

NVME_FEAT_HOSTID_EXHID_SHIFT = _nvme.NVME_FEAT_HOSTID_EXHID_SHIFT

NVME_FEAT_HOSTID_EXHID_MASK = _nvme.NVME_FEAT_HOSTID_EXHID_MASK

NVME_FEAT_RM_REGPRE_SHIFT = _nvme.NVME_FEAT_RM_REGPRE_SHIFT

NVME_FEAT_RM_REGPRE_MASK = _nvme.NVME_FEAT_RM_REGPRE_MASK

NVME_FEAT_RM_RESREL_SHIFT = _nvme.NVME_FEAT_RM_RESREL_SHIFT

NVME_FEAT_RM_RESREL_MASK = _nvme.NVME_FEAT_RM_RESREL_MASK

NVME_FEAT_RM_RESPRE_SHIFT = _nvme.NVME_FEAT_RM_RESPRE_SHIFT

NVME_FEAT_RM_RESPRE_MASK = _nvme.NVME_FEAT_RM_RESPRE_MASK

NVME_FEAT_RP_PTPL_SHIFT = _nvme.NVME_FEAT_RP_PTPL_SHIFT

NVME_FEAT_RP_PTPL_MASK = _nvme.NVME_FEAT_RP_PTPL_MASK

NVME_FEAT_WP_WPS_SHIFT = _nvme.NVME_FEAT_WP_WPS_SHIFT

NVME_FEAT_WP_WPS_MASK = _nvme.NVME_FEAT_WP_WPS_MASK

NVME_FEAT_IOCSP_IOCSCI_SHIFT = _nvme.NVME_FEAT_IOCSP_IOCSCI_SHIFT

NVME_FEAT_IOCSP_IOCSCI_MASK = _nvme.NVME_FEAT_IOCSP_IOCSCI_MASK

NVME_FEAT_SPINUP_CONTROL_SHIFT = _nvme.NVME_FEAT_SPINUP_CONTROL_SHIFT

NVME_FEAT_SPINUP_CONTROL_MASK = _nvme.NVME_FEAT_SPINUP_CONTROL_MASK

NVME_FEAT_PLS_MODE_SHIFT = _nvme.NVME_FEAT_PLS_MODE_SHIFT

NVME_FEAT_PLS_MODE_MASK = _nvme.NVME_FEAT_PLS_MODE_MASK

NVME_FEAT_PERFC_ATTRI_SHIFT = _nvme.NVME_FEAT_PERFC_ATTRI_SHIFT

NVME_FEAT_PERFC_ATTRI_MASK = _nvme.NVME_FEAT_PERFC_ATTRI_MASK

NVME_FEAT_PERFC_RVSPA_SHIFT = _nvme.NVME_FEAT_PERFC_RVSPA_SHIFT

NVME_FEAT_PERFC_RVSPA_MASK = _nvme.NVME_FEAT_PERFC_RVSPA_MASK

NVME_FEAT_PERFC_ATTRTYP_SHIFT = _nvme.NVME_FEAT_PERFC_ATTRTYP_SHIFT

NVME_FEAT_PERFC_ATTRTYP_MASK = _nvme.NVME_FEAT_PERFC_ATTRTYP_MASK

NVME_FEAT_FDP_ENABLED_SHIFT = _nvme.NVME_FEAT_FDP_ENABLED_SHIFT

NVME_FEAT_FDP_ENABLED_MASK = _nvme.NVME_FEAT_FDP_ENABLED_MASK

NVME_FEAT_FDP_INDEX_SHIFT = _nvme.NVME_FEAT_FDP_INDEX_SHIFT

NVME_FEAT_FDP_INDEX_MASK = _nvme.NVME_FEAT_FDP_INDEX_MASK

NVME_FEAT_FDP_EVENTS_ENABLE_SHIFT = _nvme.NVME_FEAT_FDP_EVENTS_ENABLE_SHIFT

NVME_FEAT_FDP_EVENTS_ENABLE_MASK = _nvme.NVME_FEAT_FDP_EVENTS_ENABLE_MASK

NVME_GET_FEATURES_SEL_CURRENT = _nvme.NVME_GET_FEATURES_SEL_CURRENT

NVME_GET_FEATURES_SEL_DEFAULT = _nvme.NVME_GET_FEATURES_SEL_DEFAULT

NVME_GET_FEATURES_SEL_SAVED = _nvme.NVME_GET_FEATURES_SEL_SAVED

NVME_GET_FEATURES_SEL_SUPPORTED = _nvme.NVME_GET_FEATURES_SEL_SUPPORTED

NVME_FORMAT_MSET_SEPARATE = _nvme.NVME_FORMAT_MSET_SEPARATE

NVME_FORMAT_MSET_EXTENDED = _nvme.NVME_FORMAT_MSET_EXTENDED

NVME_FORMAT_PI_DISABLE = _nvme.NVME_FORMAT_PI_DISABLE

NVME_FORMAT_PI_TYPE1 = _nvme.NVME_FORMAT_PI_TYPE1

NVME_FORMAT_PI_TYPE2 = _nvme.NVME_FORMAT_PI_TYPE2

NVME_FORMAT_PI_TYPE3 = _nvme.NVME_FORMAT_PI_TYPE3

NVME_FORMAT_PIL_LAST = _nvme.NVME_FORMAT_PIL_LAST

NVME_FORMAT_PIL_FIRST = _nvme.NVME_FORMAT_PIL_FIRST

NVME_FORMAT_SES_NONE = _nvme.NVME_FORMAT_SES_NONE

NVME_FORMAT_SES_USER_DATA_ERASE = _nvme.NVME_FORMAT_SES_USER_DATA_ERASE

NVME_FORMAT_SES_CRYPTO_ERASE = _nvme.NVME_FORMAT_SES_CRYPTO_ERASE

NVME_NS_MGMT_SEL_CREATE = _nvme.NVME_NS_MGMT_SEL_CREATE

NVME_NS_MGMT_SEL_DELETE = _nvme.NVME_NS_MGMT_SEL_DELETE

NVME_NS_ATTACH_SEL_CTRL_ATTACH = _nvme.NVME_NS_ATTACH_SEL_CTRL_ATTACH

NVME_NS_ATTACH_SEL_CTRL_DEATTACH = _nvme.NVME_NS_ATTACH_SEL_CTRL_DEATTACH

NVME_FW_COMMIT_CA_REPLACE = _nvme.NVME_FW_COMMIT_CA_REPLACE

NVME_FW_COMMIT_CA_REPLACE_AND_ACTIVATE = _nvme.NVME_FW_COMMIT_CA_REPLACE_AND_ACTIVATE

NVME_FW_COMMIT_CA_SET_ACTIVE = _nvme.NVME_FW_COMMIT_CA_SET_ACTIVE

NVME_FW_COMMIT_CA_REPLACE_AND_ACTIVATE_IMMEDIATE = _nvme.NVME_FW_COMMIT_CA_REPLACE_AND_ACTIVATE_IMMEDIATE

NVME_FW_COMMIT_CA_REPLACE_BOOT_PARTITION = _nvme.NVME_FW_COMMIT_CA_REPLACE_BOOT_PARTITION

NVME_FW_COMMIT_CA_ACTIVATE_BOOT_PARTITION = _nvme.NVME_FW_COMMIT_CA_ACTIVATE_BOOT_PARTITION

NVME_DIRECTIVE_DTYPE_IDENTIFY = _nvme.NVME_DIRECTIVE_DTYPE_IDENTIFY

NVME_DIRECTIVE_DTYPE_STREAMS = _nvme.NVME_DIRECTIVE_DTYPE_STREAMS

NVME_DIRECTIVE_RECEIVE_IDENTIFY_DOPER_PARAM = _nvme.NVME_DIRECTIVE_RECEIVE_IDENTIFY_DOPER_PARAM

NVME_DIRECTIVE_RECEIVE_STREAMS_DOPER_PARAM = _nvme.NVME_DIRECTIVE_RECEIVE_STREAMS_DOPER_PARAM

NVME_DIRECTIVE_RECEIVE_STREAMS_DOPER_STATUS = _nvme.NVME_DIRECTIVE_RECEIVE_STREAMS_DOPER_STATUS

NVME_DIRECTIVE_RECEIVE_STREAMS_DOPER_RESOURCE = _nvme.NVME_DIRECTIVE_RECEIVE_STREAMS_DOPER_RESOURCE

NVME_DIRECTIVE_SEND_IDENTIFY_DOPER_ENDIR = _nvme.NVME_DIRECTIVE_SEND_IDENTIFY_DOPER_ENDIR

NVME_DIRECTIVE_SEND_STREAMS_DOPER_RELEASE_IDENTIFIER = _nvme.NVME_DIRECTIVE_SEND_STREAMS_DOPER_RELEASE_IDENTIFIER

NVME_DIRECTIVE_SEND_STREAMS_DOPER_RELEASE_RESOURCE = _nvme.NVME_DIRECTIVE_SEND_STREAMS_DOPER_RELEASE_RESOURCE

NVME_DIRECTIVE_SEND_IDENTIFY_ENDIR_DISABLE = _nvme.NVME_DIRECTIVE_SEND_IDENTIFY_ENDIR_DISABLE

NVME_DIRECTIVE_SEND_IDENTIFY_ENDIR_ENABLE = _nvme.NVME_DIRECTIVE_SEND_IDENTIFY_ENDIR_ENABLE

NVME_SANITIZE_SANACT_EXIT_FAILURE = _nvme.NVME_SANITIZE_SANACT_EXIT_FAILURE

NVME_SANITIZE_SANACT_START_BLOCK_ERASE = _nvme.NVME_SANITIZE_SANACT_START_BLOCK_ERASE

NVME_SANITIZE_SANACT_START_OVERWRITE = _nvme.NVME_SANITIZE_SANACT_START_OVERWRITE

NVME_SANITIZE_SANACT_START_CRYPTO_ERASE = _nvme.NVME_SANITIZE_SANACT_START_CRYPTO_ERASE

NVME_SANITIZE_SANACT_EXIT_MEDIA_VERIF = _nvme.NVME_SANITIZE_SANACT_EXIT_MEDIA_VERIF

NVME_DST_STC_SHORT = _nvme.NVME_DST_STC_SHORT

NVME_DST_STC_LONG = _nvme.NVME_DST_STC_LONG

NVME_DST_STC_HOST_INIT = _nvme.NVME_DST_STC_HOST_INIT

NVME_DST_STC_VS = _nvme.NVME_DST_STC_VS

NVME_DST_STC_ABORT = _nvme.NVME_DST_STC_ABORT

NVME_VIRT_MGMT_ACT_PRIM_CTRL_FLEX_ALLOC = _nvme.NVME_VIRT_MGMT_ACT_PRIM_CTRL_FLEX_ALLOC

NVME_VIRT_MGMT_ACT_OFFLINE_SEC_CTRL = _nvme.NVME_VIRT_MGMT_ACT_OFFLINE_SEC_CTRL

NVME_VIRT_MGMT_ACT_ASSIGN_SEC_CTRL = _nvme.NVME_VIRT_MGMT_ACT_ASSIGN_SEC_CTRL

NVME_VIRT_MGMT_ACT_ONLINE_SEC_CTRL = _nvme.NVME_VIRT_MGMT_ACT_ONLINE_SEC_CTRL

NVME_VIRT_MGMT_RT_VQ_RESOURCE = _nvme.NVME_VIRT_MGMT_RT_VQ_RESOURCE

NVME_VIRT_MGMT_RT_VI_RESOURCE = _nvme.NVME_VIRT_MGMT_RT_VI_RESOURCE

NVME_NS_WP_CFG_NONE = _nvme.NVME_NS_WP_CFG_NONE

NVME_NS_WP_CFG_PROTECT = _nvme.NVME_NS_WP_CFG_PROTECT

NVME_NS_WP_CFG_PROTECT_POWER_CYCLE = _nvme.NVME_NS_WP_CFG_PROTECT_POWER_CYCLE

NVME_NS_WP_CFG_PROTECT_PERMANENT = _nvme.NVME_NS_WP_CFG_PROTECT_PERMANENT

NVME_LOG_ANA_LSP_RGO_NAMESPACES = _nvme.NVME_LOG_ANA_LSP_RGO_NAMESPACES

NVME_LOG_ANA_LSP_RGO_GROUPS_ONLY = _nvme.NVME_LOG_ANA_LSP_RGO_GROUPS_ONLY

NVME_LOG_PHY_RX_EOM_READ = _nvme.NVME_LOG_PHY_RX_EOM_READ

NVME_LOG_PHY_RX_EOM_START_READ = _nvme.NVME_LOG_PHY_RX_EOM_START_READ

NVME_LOG_PHY_RX_EOM_ABORT_CLEAR = _nvme.NVME_LOG_PHY_RX_EOM_ABORT_CLEAR

NVME_LOG_PHY_RX_EOM_GOOD = _nvme.NVME_LOG_PHY_RX_EOM_GOOD

NVME_LOG_PHY_RX_EOM_BETTER = _nvme.NVME_LOG_PHY_RX_EOM_BETTER

NVME_LOG_PHY_RX_EOM_BEST = _nvme.NVME_LOG_PHY_RX_EOM_BEST

NVME_PEVENT_LOG_READ = _nvme.NVME_PEVENT_LOG_READ

NVME_PEVENT_LOG_EST_CTX_AND_READ = _nvme.NVME_PEVENT_LOG_EST_CTX_AND_READ

NVME_PEVENT_LOG_RELEASE_CTX = _nvme.NVME_PEVENT_LOG_RELEASE_CTX

NVME_FEATURE_TEMPTHRESH_THSEL_OVER = _nvme.NVME_FEATURE_TEMPTHRESH_THSEL_OVER

NVME_FEATURE_TEMPTHRESH_THSEL_UNDER = _nvme.NVME_FEATURE_TEMPTHRESH_THSEL_UNDER

NVME_FEATURE_AENCFG_SMART_CRIT_SPARE = _nvme.NVME_FEATURE_AENCFG_SMART_CRIT_SPARE

NVME_FEATURE_AENCFG_SMART_CRIT_TEMPERATURE = _nvme.NVME_FEATURE_AENCFG_SMART_CRIT_TEMPERATURE

NVME_FEATURE_AENCFG_SMART_CRIT_DEGRADED = _nvme.NVME_FEATURE_AENCFG_SMART_CRIT_DEGRADED

NVME_FEATURE_AENCFG_SMART_CRIT_READ_ONLY = _nvme.NVME_FEATURE_AENCFG_SMART_CRIT_READ_ONLY

NVME_FEATURE_AENCFG_SMART_CRIT_VOLATILE_BACKUP = _nvme.NVME_FEATURE_AENCFG_SMART_CRIT_VOLATILE_BACKUP

NVME_FEATURE_AENCFG_SMART_CRIT_READ_ONLY_PMR = _nvme.NVME_FEATURE_AENCFG_SMART_CRIT_READ_ONLY_PMR

NVME_FEATURE_AENCFG_NOTICE_NAMESPACE_ATTRIBUTES = _nvme.NVME_FEATURE_AENCFG_NOTICE_NAMESPACE_ATTRIBUTES

NVME_FEATURE_AENCFG_NOTICE_FIRMWARE_ACTIVATION = _nvme.NVME_FEATURE_AENCFG_NOTICE_FIRMWARE_ACTIVATION

NVME_FEATURE_AENCFG_NOTICE_TELEMETRY_LOG = _nvme.NVME_FEATURE_AENCFG_NOTICE_TELEMETRY_LOG

NVME_FEATURE_AENCFG_NOTICE_ANA_CHANGE = _nvme.NVME_FEATURE_AENCFG_NOTICE_ANA_CHANGE

NVME_FEATURE_AENCFG_NOTICE_PL_EVENT = _nvme.NVME_FEATURE_AENCFG_NOTICE_PL_EVENT

NVME_FEATURE_AENCFG_NOTICE_LBA_STATUS = _nvme.NVME_FEATURE_AENCFG_NOTICE_LBA_STATUS

NVME_FEATURE_AENCFG_NOTICE_EG_EVENT = _nvme.NVME_FEATURE_AENCFG_NOTICE_EG_EVENT

NVME_FEATURE_AENCFG_NOTICE_DISCOVERY_CHANGE = _nvme.NVME_FEATURE_AENCFG_NOTICE_DISCOVERY_CHANGE

NVME_FEATURE_PLM_DTWIN = _nvme.NVME_FEATURE_PLM_DTWIN

NVME_FEATURE_PLM_NDWIN = _nvme.NVME_FEATURE_PLM_NDWIN

NVME_FEAT_RESV_NOTIFY_REGPRE = _nvme.NVME_FEAT_RESV_NOTIFY_REGPRE

NVME_FEAT_RESV_NOTIFY_RESREL = _nvme.NVME_FEAT_RESV_NOTIFY_RESREL

NVME_FEAT_RESV_NOTIFY_RESPRE = _nvme.NVME_FEAT_RESV_NOTIFY_RESPRE

NVME_FEAT_NS_NO_WRITE_PROTECT = _nvme.NVME_FEAT_NS_NO_WRITE_PROTECT

NVME_FEAT_NS_WRITE_PROTECT = _nvme.NVME_FEAT_NS_WRITE_PROTECT

NVME_FEAT_NS_WRITE_PROTECT_PWR_CYCLE = _nvme.NVME_FEAT_NS_WRITE_PROTECT_PWR_CYCLE

NVME_FEAT_NS_WRITE_PROTECT_PERMANENT = _nvme.NVME_FEAT_NS_WRITE_PROTECT_PERMANENT

nvme_fabrics_type_property_set = _nvme.nvme_fabrics_type_property_set

nvme_fabrics_type_connect = _nvme.nvme_fabrics_type_connect

nvme_fabrics_type_property_get = _nvme.nvme_fabrics_type_property_get

nvme_fabrics_type_auth_send = _nvme.nvme_fabrics_type_auth_send

nvme_fabrics_type_auth_receive = _nvme.nvme_fabrics_type_auth_receive

nvme_fabrics_type_disconnect = _nvme.nvme_fabrics_type_disconnect

NVME_DATA_TFR_NO_DATA_TFR = _nvme.NVME_DATA_TFR_NO_DATA_TFR

NVME_DATA_TFR_HOST_TO_CTRL = _nvme.NVME_DATA_TFR_HOST_TO_CTRL

NVME_DATA_TFR_CTRL_TO_HOST = _nvme.NVME_DATA_TFR_CTRL_TO_HOST

NVME_DATA_TFR_BIDIRECTIONAL = _nvme.NVME_DATA_TFR_BIDIRECTIONAL

nvme_cmd_flush = _nvme.nvme_cmd_flush

nvme_cmd_write = _nvme.nvme_cmd_write

nvme_cmd_read = _nvme.nvme_cmd_read

nvme_cmd_write_uncor = _nvme.nvme_cmd_write_uncor

nvme_cmd_compare = _nvme.nvme_cmd_compare

nvme_cmd_write_zeroes = _nvme.nvme_cmd_write_zeroes

nvme_cmd_dsm = _nvme.nvme_cmd_dsm

nvme_cmd_verify = _nvme.nvme_cmd_verify

nvme_cmd_resv_register = _nvme.nvme_cmd_resv_register

nvme_cmd_resv_report = _nvme.nvme_cmd_resv_report

nvme_cmd_resv_acquire = _nvme.nvme_cmd_resv_acquire

nvme_cmd_io_mgmt_recv = _nvme.nvme_cmd_io_mgmt_recv

nvme_cmd_resv_release = _nvme.nvme_cmd_resv_release

nvme_cmd_cancel = _nvme.nvme_cmd_cancel

nvme_cmd_copy = _nvme.nvme_cmd_copy

nvme_cmd_io_mgmt_send = _nvme.nvme_cmd_io_mgmt_send

nvme_zns_cmd_mgmt_send = _nvme.nvme_zns_cmd_mgmt_send

nvme_zns_cmd_mgmt_recv = _nvme.nvme_zns_cmd_mgmt_recv

nvme_zns_cmd_append = _nvme.nvme_zns_cmd_append

nvme_cmd_fabric = _nvme.nvme_cmd_fabric

nvme_kv_cmd_flush = _nvme.nvme_kv_cmd_flush

nvme_kv_cmd_store = _nvme.nvme_kv_cmd_store

nvme_kv_cmd_retrieve = _nvme.nvme_kv_cmd_retrieve

nvme_kv_cmd_list = _nvme.nvme_kv_cmd_list

nvme_kv_cmd_resv_register = _nvme.nvme_kv_cmd_resv_register

nvme_kv_cmd_resv_report = _nvme.nvme_kv_cmd_resv_report

nvme_kv_cmd_delete = _nvme.nvme_kv_cmd_delete

nvme_kv_cmd_resv_acquire = _nvme.nvme_kv_cmd_resv_acquire

nvme_kv_cmd_exist = _nvme.nvme_kv_cmd_exist

nvme_kv_cmd_resv_release = _nvme.nvme_kv_cmd_resv_release

NVME_IO_DTYPE_STREAMS = _nvme.NVME_IO_DTYPE_STREAMS

NVME_IO_NSZ = _nvme.NVME_IO_NSZ

NVME_IO_STC = _nvme.NVME_IO_STC

NVME_IO_DEAC = _nvme.NVME_IO_DEAC

NVME_IO_ZNS_APPEND_PIREMAP = _nvme.NVME_IO_ZNS_APPEND_PIREMAP

NVME_IO_PRINFO_PRCHK_REF = _nvme.NVME_IO_PRINFO_PRCHK_REF

NVME_IO_PRINFO_PRCHK_APP = _nvme.NVME_IO_PRINFO_PRCHK_APP

NVME_IO_PRINFO_PRCHK_GUARD = _nvme.NVME_IO_PRINFO_PRCHK_GUARD

NVME_IO_PRINFO_PRACT = _nvme.NVME_IO_PRINFO_PRACT

NVME_IO_FUA = _nvme.NVME_IO_FUA

NVME_IO_LR = _nvme.NVME_IO_LR

NVME_IO_DSM_FREQ_UNSPEC = _nvme.NVME_IO_DSM_FREQ_UNSPEC

NVME_IO_DSM_FREQ_TYPICAL = _nvme.NVME_IO_DSM_FREQ_TYPICAL

NVME_IO_DSM_FREQ_RARE = _nvme.NVME_IO_DSM_FREQ_RARE

NVME_IO_DSM_FREQ_READS = _nvme.NVME_IO_DSM_FREQ_READS

NVME_IO_DSM_FREQ_WRITES = _nvme.NVME_IO_DSM_FREQ_WRITES

NVME_IO_DSM_FREQ_RW = _nvme.NVME_IO_DSM_FREQ_RW

NVME_IO_DSM_FREQ_ONCE = _nvme.NVME_IO_DSM_FREQ_ONCE

NVME_IO_DSM_FREQ_PREFETCH = _nvme.NVME_IO_DSM_FREQ_PREFETCH

NVME_IO_DSM_FREQ_TEMP = _nvme.NVME_IO_DSM_FREQ_TEMP

NVME_IO_DSM_LATENCY_NONE = _nvme.NVME_IO_DSM_LATENCY_NONE

NVME_IO_DSM_LATENCY_IDLE = _nvme.NVME_IO_DSM_LATENCY_IDLE

NVME_IO_DSM_LATENCY_NORM = _nvme.NVME_IO_DSM_LATENCY_NORM

NVME_IO_DSM_LATENCY_LOW = _nvme.NVME_IO_DSM_LATENCY_LOW

NVME_IO_DSM_SEQ_REQ = _nvme.NVME_IO_DSM_SEQ_REQ

NVME_IO_DSM_COMPRESSED = _nvme.NVME_IO_DSM_COMPRESSED

NVME_DSMGMT_IDR = _nvme.NVME_DSMGMT_IDR

NVME_DSMGMT_IDW = _nvme.NVME_DSMGMT_IDW

NVME_DSMGMT_AD = _nvme.NVME_DSMGMT_AD

NVME_RESERVATION_RTYPE_WE = _nvme.NVME_RESERVATION_RTYPE_WE

NVME_RESERVATION_RTYPE_EA = _nvme.NVME_RESERVATION_RTYPE_EA

NVME_RESERVATION_RTYPE_WERO = _nvme.NVME_RESERVATION_RTYPE_WERO

NVME_RESERVATION_RTYPE_EARO = _nvme.NVME_RESERVATION_RTYPE_EARO

NVME_RESERVATION_RTYPE_WEAR = _nvme.NVME_RESERVATION_RTYPE_WEAR

NVME_RESERVATION_RTYPE_EAAR = _nvme.NVME_RESERVATION_RTYPE_EAAR

NVME_RESERVATION_RACQA_ACQUIRE = _nvme.NVME_RESERVATION_RACQA_ACQUIRE

NVME_RESERVATION_RACQA_PREEMPT = _nvme.NVME_RESERVATION_RACQA_PREEMPT

NVME_RESERVATION_RACQA_PREEMPT_AND_ABORT = _nvme.NVME_RESERVATION_RACQA_PREEMPT_AND_ABORT

NVME_RESERVATION_RREGA_REGISTER_KEY = _nvme.NVME_RESERVATION_RREGA_REGISTER_KEY

NVME_RESERVATION_RREGA_UNREGISTER_KEY = _nvme.NVME_RESERVATION_RREGA_UNREGISTER_KEY

NVME_RESERVATION_RREGA_REPLACE_KEY = _nvme.NVME_RESERVATION_RREGA_REPLACE_KEY

NVME_RESERVATION_CPTPL_NO_CHANGE = _nvme.NVME_RESERVATION_CPTPL_NO_CHANGE

NVME_RESERVATION_CPTPL_CLEAR = _nvme.NVME_RESERVATION_CPTPL_CLEAR

NVME_RESERVATION_CPTPL_PERSIST = _nvme.NVME_RESERVATION_CPTPL_PERSIST

NVME_RESERVATION_RRELA_RELEASE = _nvme.NVME_RESERVATION_RRELA_RELEASE

NVME_RESERVATION_RRELA_CLEAR = _nvme.NVME_RESERVATION_RRELA_CLEAR

NVME_ZNS_ZSA_CLOSE = _nvme.NVME_ZNS_ZSA_CLOSE

NVME_ZNS_ZSA_FINISH = _nvme.NVME_ZNS_ZSA_FINISH

NVME_ZNS_ZSA_OPEN = _nvme.NVME_ZNS_ZSA_OPEN

NVME_ZNS_ZSA_RESET = _nvme.NVME_ZNS_ZSA_RESET

NVME_ZNS_ZSA_OFFLINE = _nvme.NVME_ZNS_ZSA_OFFLINE

NVME_ZNS_ZSA_SET_DESC_EXT = _nvme.NVME_ZNS_ZSA_SET_DESC_EXT

NVME_ZNS_ZSA_ZRWA_FLUSH = _nvme.NVME_ZNS_ZSA_ZRWA_FLUSH

NVME_ZNS_ZRA_REPORT_ZONES = _nvme.NVME_ZNS_ZRA_REPORT_ZONES

NVME_ZNS_ZRA_EXTENDED_REPORT_ZONES = _nvme.NVME_ZNS_ZRA_EXTENDED_REPORT_ZONES

NVME_ZNS_ZRAS_REPORT_ALL = _nvme.NVME_ZNS_ZRAS_REPORT_ALL

NVME_ZNS_ZRAS_REPORT_EMPTY = _nvme.NVME_ZNS_ZRAS_REPORT_EMPTY

NVME_ZNS_ZRAS_REPORT_IMPL_OPENED = _nvme.NVME_ZNS_ZRAS_REPORT_IMPL_OPENED

NVME_ZNS_ZRAS_REPORT_EXPL_OPENED = _nvme.NVME_ZNS_ZRAS_REPORT_EXPL_OPENED

NVME_ZNS_ZRAS_REPORT_CLOSED = _nvme.NVME_ZNS_ZRAS_REPORT_CLOSED

NVME_ZNS_ZRAS_REPORT_FULL = _nvme.NVME_ZNS_ZRAS_REPORT_FULL

NVME_ZNS_ZRAS_REPORT_READ_ONLY = _nvme.NVME_ZNS_ZRAS_REPORT_READ_ONLY

NVME_ZNS_ZRAS_REPORT_OFFLINE = _nvme.NVME_ZNS_ZRAS_REPORT_OFFLINE

NVME_IO_MGMT_RECV_RUH_STATUS = _nvme.NVME_IO_MGMT_RECV_RUH_STATUS

NVME_IO_MGMT_SEND_RUH_UPDATE = _nvme.NVME_IO_MGMT_SEND_RUH_UPDATE

NVME_LM_CDQ_MOS_SHIFT = _nvme.NVME_LM_CDQ_MOS_SHIFT

NVME_LM_CDQ_MOS_MASK = _nvme.NVME_LM_CDQ_MOS_MASK

NVME_LM_CDQ_SEL_SHIFT = _nvme.NVME_LM_CDQ_SEL_SHIFT

NVME_LM_CDQ_SEL_MASK = _nvme.NVME_LM_CDQ_SEL_MASK

NVME_LM_SEL_CREATE_CDQ = _nvme.NVME_LM_SEL_CREATE_CDQ

NVME_LM_SEL_DELETE_CDQ = _nvme.NVME_LM_SEL_DELETE_CDQ

NVME_LM_QT_SHIFT = _nvme.NVME_LM_QT_SHIFT

NVME_LM_QT_MASK = _nvme.NVME_LM_QT_MASK

NVME_LM_QT_USER_DATA_MIGRATION_QUEUE = _nvme.NVME_LM_QT_USER_DATA_MIGRATION_QUEUE

NVME_LM_CREATE_CDQ_PC = _nvme.NVME_LM_CREATE_CDQ_PC

NVME_LM_CREATE_CDQ_CNTLID_SHIFT = _nvme.NVME_LM_CREATE_CDQ_CNTLID_SHIFT

NVME_LM_CREATE_CDQ_CNTLID_MASK = _nvme.NVME_LM_CREATE_CDQ_CNTLID_MASK

NVME_LM_DELETE_CDQ_CDQID_SHIFT = _nvme.NVME_LM_DELETE_CDQ_CDQID_SHIFT

NVME_LM_DELETE_CDQ_CDQID_MASK = _nvme.NVME_LM_DELETE_CDQ_CDQID_MASK

NVME_LM_CREATE_CDQ_CDQID_SHIFT = _nvme.NVME_LM_CREATE_CDQ_CDQID_SHIFT

NVME_LM_CREATE_CDQ_CDQID_MASK = _nvme.NVME_LM_CREATE_CDQ_CDQID_MASK

NVME_LM_TRACK_SEND_MOS_SHIFT = _nvme.NVME_LM_TRACK_SEND_MOS_SHIFT

NVME_LM_TRACK_SEND_MOS_MASK = _nvme.NVME_LM_TRACK_SEND_MOS_MASK

NVME_LM_TRACK_SEND_SEL_SHIFT = _nvme.NVME_LM_TRACK_SEND_SEL_SHIFT

NVME_LM_TRACK_SEND_SEL_MASK = _nvme.NVME_LM_TRACK_SEND_SEL_MASK

NVME_LM_SEL_LOG_USER_DATA_CHANGES = _nvme.NVME_LM_SEL_LOG_USER_DATA_CHANGES

NVME_LM_SEL_TRACK_MEMORY_CHANGES = _nvme.NVME_LM_SEL_TRACK_MEMORY_CHANGES

NVME_LM_LACT_SHIFT = _nvme.NVME_LM_LACT_SHIFT

NVME_LM_LACT_MASK = _nvme.NVME_LM_LACT_MASK

NVME_LM_LACT_STOP_LOGGING = _nvme.NVME_LM_LACT_STOP_LOGGING

NVME_LM_LACT_START_LOGGING = _nvme.NVME_LM_LACT_START_LOGGING

NVME_LM_MIGRATION_SEND_MOS_SHIFT = _nvme.NVME_LM_MIGRATION_SEND_MOS_SHIFT

NVME_LM_MIGRATION_SEND_MOS_MASK = _nvme.NVME_LM_MIGRATION_SEND_MOS_MASK

NVME_LM_MIGRATION_SEND_SEL_SHIFT = _nvme.NVME_LM_MIGRATION_SEND_SEL_SHIFT

NVME_LM_MIGRATION_SEND_SEL_MASK = _nvme.NVME_LM_MIGRATION_SEND_SEL_MASK

NVME_LM_SEL_SUSPEND = _nvme.NVME_LM_SEL_SUSPEND

NVME_LM_SEL_RESUME = _nvme.NVME_LM_SEL_RESUME

NVME_LM_SEL_SET_CONTROLLER_STATE = _nvme.NVME_LM_SEL_SET_CONTROLLER_STATE

NVME_LM_MIGRATION_SEND_UIDX_SHIFT = _nvme.NVME_LM_MIGRATION_SEND_UIDX_SHIFT

NVME_LM_MIGRATION_SEND_UIDX_MASK = _nvme.NVME_LM_MIGRATION_SEND_UIDX_MASK

NVME_LM_DUDMQ = _nvme.NVME_LM_DUDMQ

NVME_LM_STYPE_SHIFT = _nvme.NVME_LM_STYPE_SHIFT

NVME_LM_STYPE_MASK = _nvme.NVME_LM_STYPE_MASK

NVME_LM_STYPE_SUSPEND_NOTIFICATION = _nvme.NVME_LM_STYPE_SUSPEND_NOTIFICATION

NVME_LM_STYPE_SUSPEND = _nvme.NVME_LM_STYPE_SUSPEND

NVME_LM_SUSPEND_CNTLID_SHIFT = _nvme.NVME_LM_SUSPEND_CNTLID_SHIFT

NVME_LM_SUSPEND_CNTLID_MASK = _nvme.NVME_LM_SUSPEND_CNTLID_MASK

NVME_LM_RESUME_CNTLID_SHIFT = _nvme.NVME_LM_RESUME_CNTLID_SHIFT

NVME_LM_RESUME_CNTLID_MASK = _nvme.NVME_LM_RESUME_CNTLID_MASK

NVME_LM_SEQIND_SHIFT = _nvme.NVME_LM_SEQIND_SHIFT

NVME_LM_SEQIND_MASK = _nvme.NVME_LM_SEQIND_MASK

NVME_LM_SEQIND_NOT_FIRST_NOT_LAST = _nvme.NVME_LM_SEQIND_NOT_FIRST_NOT_LAST

NVME_LM_SEQIND_FIRST = _nvme.NVME_LM_SEQIND_FIRST

NVME_LM_SEQIND_LAST = _nvme.NVME_LM_SEQIND_LAST

NVME_LM_SEQIND_ENTIRE = _nvme.NVME_LM_SEQIND_ENTIRE

NVME_LM_SET_CONTROLLER_STATE_CSUUIDI_SHIFT = _nvme.NVME_LM_SET_CONTROLLER_STATE_CSUUIDI_SHIFT

NVME_LM_SET_CONTROLLER_STATE_CSUUIDI_MASK = _nvme.NVME_LM_SET_CONTROLLER_STATE_CSUUIDI_MASK

NVME_LM_SET_CONTROLLER_STATE_CSVI_SHIFT = _nvme.NVME_LM_SET_CONTROLLER_STATE_CSVI_SHIFT

NVME_LM_SET_CONTROLLER_STATE_CSVI_MASK = _nvme.NVME_LM_SET_CONTROLLER_STATE_CSVI_MASK

NVME_LM_SET_CONTROLLER_STATE_CNTLID_SHIFT = _nvme.NVME_LM_SET_CONTROLLER_STATE_CNTLID_SHIFT

NVME_LM_SET_CONTROLLER_STATE_CNTLID_MASK = _nvme.NVME_LM_SET_CONTROLLER_STATE_CNTLID_MASK

NVME_LM_MIGRATION_RECV_MOS_SHIFT = _nvme.NVME_LM_MIGRATION_RECV_MOS_SHIFT

NVME_LM_MIGRATION_RECV_MOS_MASK = _nvme.NVME_LM_MIGRATION_RECV_MOS_MASK

NVME_LM_MIGRATION_RECV_SEL_SHIFT = _nvme.NVME_LM_MIGRATION_RECV_SEL_SHIFT

NVME_LM_MIGRATION_RECV_SEL_MASK = _nvme.NVME_LM_MIGRATION_RECV_SEL_MASK

NVME_LM_SEL_GET_CONTROLLER_STATE = _nvme.NVME_LM_SEL_GET_CONTROLLER_STATE

NVME_LM_MIGRATION_RECV_UIDX_SHIFT = _nvme.NVME_LM_MIGRATION_RECV_UIDX_SHIFT

NVME_LM_MIGRATION_RECV_UIDX_MASK = _nvme.NVME_LM_MIGRATION_RECV_UIDX_MASK

NVME_LM_GET_CONTROLLER_STATE_CSVI_SHIFT = _nvme.NVME_LM_GET_CONTROLLER_STATE_CSVI_SHIFT

NVME_LM_GET_CONTROLLER_STATE_CSVI_MASK = _nvme.NVME_LM_GET_CONTROLLER_STATE_CSVI_MASK

NVME_LM_GET_CONTROLLER_STATE_CSUIDXP_SHIFT = _nvme.NVME_LM_GET_CONTROLLER_STATE_CSUIDXP_SHIFT

NVME_LM_GET_CONTROLLER_STATE_CSUIDXP_MASK = _nvme.NVME_LM_GET_CONTROLLER_STATE_CSUIDXP_MASK

NVME_LM_GET_CONTROLLER_STATE_CSUUIDI_SHIFT = _nvme.NVME_LM_GET_CONTROLLER_STATE_CSUUIDI_SHIFT

NVME_LM_GET_CONTROLLER_STATE_CSUUIDI_MASK = _nvme.NVME_LM_GET_CONTROLLER_STATE_CSUUIDI_MASK

NVME_LM_GET_CONTROLLER_STATE_CNTLID_SHIFT = _nvme.NVME_LM_GET_CONTROLLER_STATE_CNTLID_SHIFT

NVME_LM_GET_CONTROLLER_STATE_CNTLID_MASK = _nvme.NVME_LM_GET_CONTROLLER_STATE_CNTLID_MASK

NVME_LM_GET_CONTROLLER_STATE_CSUP = _nvme.NVME_LM_GET_CONTROLLER_STATE_CSUP

NVME_LM_IOSQPC_MASK = _nvme.NVME_LM_IOSQPC_MASK

NVME_LM_IOSQPC_SHIFT = _nvme.NVME_LM_IOSQPC_SHIFT

NVME_LM_IOSQPRIO_MASK = _nvme.NVME_LM_IOSQPRIO_MASK

NVME_LM_IOSQPRIO_SHIFT = _nvme.NVME_LM_IOSQPRIO_SHIFT

NVME_LM_IOCQPC_MASK = _nvme.NVME_LM_IOCQPC_MASK

NVME_LM_IOCQPC_SHIFT = _nvme.NVME_LM_IOCQPC_SHIFT

NVME_LM_IOCQIEN_MASK = _nvme.NVME_LM_IOCQIEN_MASK

NVME_LM_IOCQIEN_SHIFT = _nvme.NVME_LM_IOCQIEN_SHIFT

NVME_LM_S0PT_MASK = _nvme.NVME_LM_S0PT_MASK

NVME_LM_S0PT_SHIFT = _nvme.NVME_LM_S0PT_SHIFT

NVME_LM_IOCQIV_MASK = _nvme.NVME_LM_IOCQIV_MASK

NVME_LM_IOCQIV_SHIFT = _nvme.NVME_LM_IOCQIV_SHIFT

NVME_LM_CTRL_DATA_QUEUE_ETPT_MASK = _nvme.NVME_LM_CTRL_DATA_QUEUE_ETPT_MASK

NVME_LM_CTRL_DATA_QUEUE_ETPT_SHIFT = _nvme.NVME_LM_CTRL_DATA_QUEUE_ETPT_SHIFT


