/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.Tag;
import org.languagetool.UserConfig;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleOption;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tools.Tools;

public class LongParagraphRule
extends TextLevelRule {
    public static final String RULE_ID = "TOO_LONG_PARAGRAPH";
    private static final boolean DEFAULT_ACTIVATION = false;
    private static final int DEFAULT_MAX_WORDS = 220;
    private static final int LIMIT_MAX_WORDS = 300;
    private final Language lang;
    private int maxWords = 220;

    public LongParagraphRule(ResourceBundle messages, Language lang, UserConfig userConfig, int defaultWords, boolean defaultActive) {
        super(messages);
        Object[] cf;
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.lang = lang;
        this.setDefaultOff();
        this.setOfficeDefaultOn();
        if (defaultWords > 0) {
            this.maxWords = defaultWords;
        }
        if (userConfig != null && (cf = userConfig.getConfigValueByID(this.getId())) != null) {
            this.maxWords = (Integer)cf[0];
        }
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.setTags(Arrays.asList(Tag.picky));
    }

    public LongParagraphRule(ResourceBundle messages, Language lang, UserConfig userConfig, int defaultWords) {
        this(messages, lang, userConfig, defaultWords, false);
    }

    public LongParagraphRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        this(messages, lang, userConfig, -1, true);
    }

    @Override
    public String getDescription() {
        return MessageFormat.format(this.messages.getString("long_paragraph_rule_desc"), this.maxWords);
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public RuleOption[] getRuleOptions() {
        RuleOption[] ruleOptions = new RuleOption[]{new RuleOption(this.maxWords, MessageFormat.format(this.messages.getString("guiLongParagraphsText"), 300), 5, 300)};
        return ruleOptions;
    }

    public String getMessage() {
        return MessageFormat.format(this.messages.getString("long_paragraph_rule_msg"), this.maxWords);
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        int startPos = 0;
        int endPos = 0;
        int wordCount = 0;
        boolean paraHasLinebreaks = false;
        for (int n = 0; n < sentences.size(); ++n) {
            AnalyzedTokenReadings[] tokens;
            AnalyzedSentence sentence = sentences.get(n);
            boolean paragraphEnd = Tools.isParagraphEnd(sentences, n, this.lang);
            if (!paragraphEnd && sentence.getText().replaceFirst("^\n+", "").contains("\n")) {
                paraHasLinebreaks = true;
            }
            for (AnalyzedTokenReadings token : tokens = sentence.getTokensWithoutWhitespace()) {
                if (token.isWhitespace() || token.isSentenceStart() || token.isNonWord()) continue;
                if (++wordCount == this.maxWords) {
                    endPos = token.getEndPos() + pos;
                    continue;
                }
                if (wordCount != this.maxWords - 1) continue;
                startPos = token.getStartPos() + pos;
            }
            if (paragraphEnd) {
                if (wordCount > this.maxWords + 5 && !paraHasLinebreaks) {
                    RuleMatch ruleMatch = new RuleMatch(this, sentence, startPos, endPos, this.getMessage());
                    ruleMatches.add(ruleMatch);
                }
                wordCount = 0;
                paraHasLinebreaks = false;
            }
            pos += sentence.getCorrectedTextLength();
        }
        if (wordCount > this.maxWords) {
            RuleMatch ruleMatch = new RuleMatch(this, startPos, endPos, this.getMessage());
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return 0;
    }
}

