/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.infinispan.module.configuration.global;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.keycloak.infinispan.module.certificates.JGroupsCertificateHolder;
import org.keycloak.infinispan.module.configuration.global.KeycloakConfigurationBuilder;
import org.keycloak.models.KeycloakSessionFactory;

@BuiltBy(value=KeycloakConfigurationBuilder.class)
public class KeycloakConfiguration {
    static final AttributeDefinition<KeycloakSessionFactory> KEYCLOAK_SESSION_FACTORY = AttributeDefinition.builder((String)"keycloak-session-factory", null, KeycloakSessionFactory.class).global(true).autoPersist(false).immutable().build();
    static final AttributeDefinition<JGroupsCertificateHolder> JGROUPS_CERTIFICATE_HOLDER = AttributeDefinition.builder((String)"jgroups-certificate-holder", null, JGroupsCertificateHolder.class).global(true).autoPersist(false).immutable().build();
    static final AttributeDefinition<Integer> JGROUPS_CERTIFICATE_ROTATION = AttributeDefinition.builder((String)"jgroups-certificate-rotation", (Object)30, Integer.class).global(true).autoPersist(false).immutable().build();
    private final AttributeSet attributes;

    static AttributeSet attributeSet() {
        return new AttributeSet(KeycloakConfiguration.class, new AttributeDefinition[]{KEYCLOAK_SESSION_FACTORY, JGROUPS_CERTIFICATE_HOLDER, JGROUPS_CERTIFICATE_ROTATION});
    }

    KeycloakConfiguration(AttributeSet attributes) {
        this.attributes = attributes;
    }

    AttributeSet attributes() {
        return this.attributes;
    }

    public KeycloakSessionFactory keycloakSessionFactory() {
        return (KeycloakSessionFactory)this.attributes.attribute(KEYCLOAK_SESSION_FACTORY).get();
    }

    public JGroupsCertificateHolder jGroupsCertificateHolder() {
        return (JGroupsCertificateHolder)this.attributes.attribute(JGROUPS_CERTIFICATE_HOLDER).get();
    }

    public int jgroupsCertificateRotation() {
        return (Integer)this.attributes.attribute(JGROUPS_CERTIFICATE_ROTATION).get();
    }
}

