Clazz.declarePackage("JM");
Clazz.load(["JM.AlphaPolymer"], "JM.AminoPolymer", ["JU.Measure", "$.P3", "$.V3", "J.c.STR", "JM.HBond", "JU.Logger"], function(){
var c$ = Clazz.decorateAsClass(function(){
this.structureList = null;
Clazz.instantialize(this, arguments);}, JM, "AminoPolymer", JM.AlphaPolymer);
Clazz.makeConstructor(c$, 
function(monomers, pt0){
Clazz.superConstructor(this, JM.AminoPolymer, [monomers, pt0]);
this.type = 1;
for (var i = 0; i < this.monomerCount; ++i) if (!(monomers[i]).hasOAtom()) return;

this.hasWingPoints = true;
}, "~A,~N");
Clazz.overrideMethod(c$, "resetHydrogenPoints", 
function(){
var ps;
var psLast = null;
for (var i = 0; i < this.monomerCount; i++) {
if ((ps = this.getProteinStructure(i)) != null && ps !== psLast) (psLast = ps).resetAxes();
(this.monomers[i]).resetHydrogenPoint();
}
});
Clazz.overrideMethod(c$, "calcPhiPsiAngles", 
function(){
for (var i = 0; i < this.monomerCount - 1; ++i) this.calcPhiPsiAngles2(this.monomers[i], this.monomers[i + 1]);

return true;
});
Clazz.defineMethod(c$, "calcPhiPsiAngles2", 
function(residue1, residue2){
var nitrogen1 = residue1.getNitrogenAtom();
var alphacarbon1 = residue1.getLeadAtom();
var carbon1 = residue1.getCarbonylCarbonAtom();
var nitrogen2 = residue2.getNitrogenAtom();
var alphacarbon2 = residue2.getLeadAtom();
var carbon2 = residue2.getCarbonylCarbonAtom();
residue2.setGroupParameter(1111490569, JU.Measure.computeTorsion(carbon1, nitrogen2, alphacarbon2, carbon2, true));
residue1.setGroupParameter(1111490570, JU.Measure.computeTorsion(nitrogen1, alphacarbon1, carbon1, nitrogen2, true));
residue1.setGroupParameter(1111490568, JU.Measure.computeTorsion(alphacarbon1, carbon1, nitrogen2, alphacarbon2, true));
}, "JM.AminoMonomer,JM.AminoMonomer");
Clazz.overrideMethod(c$, "calculateRamachandranHelixAngle", 
function(m, qtype){
var psiLast = (m == 0 ? NaN : this.monomers[m - 1].getGroupParameter(1111490570));
var psi = this.monomers[m].getGroupParameter(1111490570);
var phi = this.monomers[m].getGroupParameter(1111490569);
var phiNext = (m == this.monomerCount - 1 ? NaN : this.monomers[m + 1].getGroupParameter(1111490569));
var psiNext = (m == this.monomerCount - 1 ? NaN : this.monomers[m + 1].getGroupParameter(1111490570));
switch ((qtype).charCodeAt(0)) {
default:
case 112:
case 114:
case 80:
var dPhi = ((phiNext - phi) / 2 * 3.141592653589793 / 180);
var dPsi = ((psiNext - psi) / 2 * 3.141592653589793 / 180);
return (57.29577951308232 * 2 * Math.acos(Math.cos(dPsi) * Math.cos(dPhi) - Math.sin(dPsi) * Math.sin(dPhi) / 3));
case 99:
case 67:
return (psi - psiLast + phiNext - phi);
}
}, "~N,~S");
Clazz.overrideMethod(c$, "calcRasmolHydrogenBonds", 
function(polymer, bsA, bsB, vHBonds, nMaxPerResidue, min, checkDistances, dsspIgnoreHydrogens){
if (polymer == null) polymer = this;
if (!(Clazz.instanceOf(polymer,"JM.AminoPolymer"))) return;
var pt =  new JU.P3();
var vNH =  new JU.V3();
var source;
var min1 = (min == null ?  Clazz.newIntArray (2, 3, 0) : null);
for (var i = 1; i < this.monomerCount; ++i) {
if (min == null) {
min1[0][0] = min1[1][0] = this.bioPolymerIndexInModel;
min1[0][1] = min1[1][1] = -2147483648;
min1[0][2] = min1[1][2] = 0;
} else {
min1 = min[i];
}if ((source = (this.monomers[i])).getNHPoint(pt, vNH, checkDistances, dsspIgnoreHydrogens)) {
var isInA = (bsA == null || bsA.get(source.getNitrogenAtom().i));
if (!isInA) continue;
if (!checkDistances && source.getCarbonylOxygenAtom() == null) continue;
this.checkRasmolHydrogenBond(source, polymer, i, pt, (isInA ? bsB : bsA), vHBonds, min1, checkDistances);
}}
}, "JM.BioPolymer,JU.BS,JU.BS,JU.Lst,~N,~A,~B,~B");
Clazz.defineMethod(c$, "checkRasmolHydrogenBond", 
function(source, polymer, indexDonor, hydrogenPoint, bsB, vHBonds, min, checkDistances){
var sourceAlphaPoint = source.getLeadAtom();
var sourceNitrogenPoint = source.getNitrogenAtom();
var nitrogen = source.getNitrogenAtom();
var m;
for (var i = polymer.monomerCount; --i >= 0; ) {
if (polymer === this && (i == indexDonor || i + 1 == indexDonor)) continue;
var target = polymer.monomers[i];
var oxygen = target.getCarbonylOxygenAtom();
if (oxygen == null || bsB != null && !bsB.get(oxygen.i)) continue;
var targetAlphaPoint = target.getLeadAtom();
var dist2 = sourceAlphaPoint.distanceSquared(targetAlphaPoint);
if (dist2 >= 81.0) continue;
var energy = this.calcHbondEnergy(sourceNitrogenPoint, hydrogenPoint, target, checkDistances);
if (energy < min[0][2]) {
m = min[1];
min[1] = min[0];
min[0] = m;
} else if (energy < min[1][2]) {
m = min[1];
} else {
continue;
}m[0] = polymer.bioPolymerIndexInModel;
m[1] = (energy < -500 ? i : -1 - i);
m[2] = energy;
}
if (vHBonds != null) for (var i = 0; i < 2; i++) if (min[i][1] >= 0) this.addResidueHydrogenBond(nitrogen, ((polymer).monomers[min[i][1]]).getCarbonylOxygenAtom(), (polymer === this ? indexDonor : -99), min[i][1], min[i][2] / 1000, vHBonds);

}, "JM.AminoMonomer,JM.BioPolymer,~N,JU.P3,JU.BS,JU.Lst,~A,~B");
Clazz.defineMethod(c$, "calcHbondEnergy", 
function(nitrogenPoint, hydrogenPoint, target, checkDistances){
var targetOxygenPoint = target.getCarbonylOxygenAtom();
if (targetOxygenPoint == null) return 0;
var distON2 = targetOxygenPoint.distanceSquared(nitrogenPoint);
if (distON2 < 0.25) return 0;
var distOH2 = targetOxygenPoint.distanceSquared(hydrogenPoint);
if (distOH2 < 0.25) return 0;
var targetCarbonPoint = target.getCarbonylCarbonAtom();
var distCH2 = targetCarbonPoint.distanceSquared(hydrogenPoint);
if (distCH2 < 0.25) return 0;
var distCN2 = targetCarbonPoint.distanceSquared(nitrogenPoint);
if (distCN2 < 0.25) return 0;
var distOH = Math.sqrt(distOH2);
var distCH = Math.sqrt(distCH2);
var distCN = Math.sqrt(distCN2);
var distON = Math.sqrt(distON2);
var energy = JM.HBond.calcEnergy(distOH, distCH, distCN, distON);
var isHbond = (energy < -500 && (!checkDistances || distCN > distCH && distOH <= 3.0));
return (!isHbond && checkDistances || energy < -9900 ? 0 : energy);
}, "JU.P3,JU.P3,JM.AminoMonomer,~B");
Clazz.defineMethod(c$, "addResidueHydrogenBond", 
function(nitrogen, oxygen, indexAminoGroup, indexCarbonylGroup, energy, vHBonds){
var order;
switch (indexAminoGroup - indexCarbonylGroup) {
case 2:
order = 6144;
break;
case 3:
order = 8192;
break;
case 4:
order = 10240;
break;
case 5:
order = 12288;
break;
case -3:
order = 14336;
break;
case -4:
order = 16384;
break;
default:
order = 4096;
}
vHBonds.addLast( new JM.HBond(nitrogen, oxygen, order, 1, 0, energy));
}, "JM.Atom,JM.Atom,~N,~N,~N,JU.Lst");
Clazz.overrideMethod(c$, "calculateStructures", 
function(alphaOnly){
if (alphaOnly) return;
if (this.structureList == null) this.structureList = this.model.ms.getStructureList();
var structureTags =  Clazz.newCharArray (this.monomerCount, '\0');
for (var i = 0; i < this.monomerCount - 1; ++i) {
var leadingResidue = this.monomers[i];
var trailingResidue = this.monomers[i + 1];
var phi = trailingResidue.getGroupParameter(1111490569);
var psi = leadingResidue.getGroupParameter(1111490570);
if (this.isHelix(psi, phi)) {
structureTags[i] = (phi < 0 && psi < 25 ? '4' : '3');
} else if (this.isSheet(psi, phi)) {
structureTags[i] = 's';
} else if (this.isTurn(psi, phi)) {
structureTags[i] = 't';
} else {
structureTags[i] = 'n';
}if (JU.Logger.debugging) JU.Logger.debug((0 + this.monomers[0].chain.chainID) + " aminopolymer:" + i + " " + trailingResidue.getGroupParameter(1111490569) + "," + leadingResidue.getGroupParameter(1111490570) + " " + structureTags[i]);
}
for (var start = 0; start < this.monomerCount; ++start) {
if (structureTags[start] == '4') {
var end;
for (end = start + 1; end < this.monomerCount && structureTags[end] == '4'; ++end) {
}
end--;
if (end >= start + 3) {
this.addStructureProtected(J.c.STR.HELIX, null, null, 0, start, end);
}start = end;
}}
for (var start = 0; start < this.monomerCount; ++start) {
if (structureTags[start] == '3') {
var end;
for (end = start + 1; end < this.monomerCount && structureTags[end] == '3'; ++end) {
}
end--;
if (end >= start + 3) {
this.addStructureProtected(J.c.STR.HELIX, null, null, 0, start, end);
}start = end;
}}
for (var start = 0; start < this.monomerCount; ++start) {
if (structureTags[start] == 's') {
var end;
for (end = start + 1; end < this.monomerCount && structureTags[end] == 's'; ++end) {
}
end--;
if (end >= start + 2) {
this.addStructureProtected(J.c.STR.SHEET, null, null, 0, start, end);
}start = end;
}}
for (var start = 0; start < this.monomerCount; ++start) {
if (structureTags[start] == 't') {
var end;
for (end = start + 1; end < this.monomerCount && structureTags[end] == 't'; ++end) {
}
end--;
if (end >= start + 2) {
this.addStructureProtected(J.c.STR.TURN, null, null, 0, start, end);
}start = end;
}}
}, "~B");
Clazz.defineMethod(c$, "isTurn", 
function(psi, phi){
return JM.AminoPolymer.checkPhiPsi(this.structureList.get(J.c.STR.TURN), psi, phi);
}, "~N,~N");
Clazz.defineMethod(c$, "isSheet", 
function(psi, phi){
return JM.AminoPolymer.checkPhiPsi(this.structureList.get(J.c.STR.SHEET), psi, phi);
}, "~N,~N");
Clazz.defineMethod(c$, "isHelix", 
function(psi, phi){
return JM.AminoPolymer.checkPhiPsi(this.structureList.get(J.c.STR.HELIX), psi, phi);
}, "~N,~N");
c$.checkPhiPsi = Clazz.defineMethod(c$, "checkPhiPsi", 
function(list, psi, phi){
for (var i = 0; i < list.length; i += 4) if (phi >= list[i] && phi <= list[i + 1] && psi >= list[i + 2] && psi <= list[i + 3]) return true;

return false;
}, "~A,~N,~N");
Clazz.defineMethod(c$, "setStructureList", 
function(structureList){
this.structureList = structureList;
}, "java.util.Map");
});
;//5.0.1-v7 Mon Jun 09 21:25:18 CEST 2025
