#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.32.1
visibility:           public
id:                   hledger-web-1.32.1-ADiWgoptl3Z8tC62d17QU2
key:                  hledger-web-1.32.1-ADiWgoptl3Z8tC62d17QU2
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  0c8e8050a8a4efd1ddae034553f24fec
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.Foundation Hledger.Web.Handler.AddR
    Hledger.Web.Handler.EditR Hledger.Web.Handler.JournalR
    Hledger.Web.Handler.MiscR Hledger.Web.Handler.RegisterR
    Hledger.Web.Handler.UploadR Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.32.1-ADiWgoptl3Z8tC62d17QU2
depends:
    Decimal-0.5.2-EvRcqUIPT9uHP0LYQhNTSg
    aeson-2.1.2.1-LS8mizUYnpf1U9zpV4sjcf base-4.17.2.1
    base64-0.4.2.4-31WPpcDxxba703UJmwu2og
    blaze-html-0.9.2.0-7T5tBdPknWXDUJ5NeSXWzj
    blaze-markup-0.8.3.0-4zGQB5UMO8P5hF725cGajZ bytestring-0.11.5.3
    case-insensitive-1.2.1.0-FZkso54i68UDZy9QWLkbnV
    clientsession-0.9.2.0-GSmhzvB6LHA65VE2XMNPs0
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-LEKlJ5sjhOMOY4BoQvHAk
    conduit-extra-1.3.6-2wqo8ucVt5IGPwh2HHGSdk containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi directory-1.3.7.1
    extra-1.7.16-5m7TC0OmR1yJEj0luDg7V3 filepath-1.4.2.2
    hjsmin-0.2.1-BuVRcwWHvh4ERZy7VZxQnz
    hledger-1.32.1-FvRaUV9wvTeBP4UvsHr3W0
    hledger-lib-1.32.1-Lm5DBLxOgmC9X8dp0BBMVL
    hspec-2.10.9-LrKv2WLw3ll63lZh5sx0BW
    http-client-0.7.18-LXBlgncwp3M12RggVCuJyY
    http-conduit-2.3.9.1-6kcitIgkYMzASPRujG35V6
    http-types-0.12.4-3waRWhsRr1C4PfAAAPJbwc
    megaparsec-9.6.1-KkOPmPbRCEmCvB2XbKT9En mtl-2.2.2
    network-3.1.4.0-6CSLlS2XYBeLlFfm0MgCfu
    safe-0.3.21-D0Qa6qmXFrgLhocJR17U7j
    shakespeare-2.1.0.1-GM1d5JK2NZvLaPL2UA0TeM
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-compat-0.7.3-4KjQwvobFGi5CULM8PAvE4
    unordered-containers-0.2.20-vB8Yx6KwyeBrT13JKFJ0i
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-3SqC73n3qJdLTkLMbZrVoF
    wai-cors-0.2.7-DaVMqeGSJl4AtLaRRiTNvQ
    wai-extra-3.1.17-4Eyg1IyLbgR6NaO2piiz0G
    wai-handler-launch-3.0.3.1-IfPEOBwEuSD4cSAZP98Bw
    warp-3.3.30-Gi1JAQRG27SIrwRqtuxt3h
    yaml-0.11.11.2-3iCu9PejHEs3WcXBwsqmql
    yesod-1.6.2.1-5Yg9n9qmL9l2uvFL0Pfgfj
    yesod-core-1.6.27.0-KIFhQXJsy6pA2MOW2vk2EH
    yesod-form-1.7.9-GW0knFY6GiD3KMmkVPJHnK
    yesod-static-1.6.1.0-ETwChKnfi06KTqQuVKi5j0
    yesod-test-1.6.22-sW8ncSqiPdDCxkRhfq36Y

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

