#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 vty
version:              6.1
visibility:           public
id:                   vty-6.1-5hxZ33ogxWrHekvqlf61f0
key:                  vty-6.1-5hxZ33ogxWrHekvqlf61f0
license:              BSD-3-Clause
maintainer:           Jonathan Daugherty (cygnus@foobox.com)
author:               AUTHORS
homepage:             https://github.com/jtdaugherty/vty
synopsis:             A simple terminal UI library
description:
    vty is terminal GUI library in the niche of ncurses. It is intended to
    be easy to use and to provide good support for common terminal types.

    See the @vty-examples@ package as well as the program
    @examples/interactive_terminal_test.hs@ included in the @vty@
    repository for examples on how to use the library.

    Import the @Graphics.Vty@ convenience module to get access to the core
    parts of the library.

    &#169; 2006-2007 Stefan O'\''Rear; BSD3 license.

    &#169; Corey O'\''Connor; BSD3 license.

    &#169; Jonathan Daugherty; BSD3 license.

category:             User Interfaces
abi:                  d24dc98cee54254277b9a3f065f80955
exposed:              True
exposed-modules:
    Graphics.Text.Width Graphics.Vty Graphics.Vty.Attributes
    Graphics.Vty.Attributes.Color Graphics.Vty.Attributes.Color240
    Graphics.Vty.Config Graphics.Vty.Debug
    Graphics.Vty.DisplayAttributes Graphics.Vty.Error
    Graphics.Vty.Image Graphics.Vty.Image.Internal Graphics.Vty.Inline
    Graphics.Vty.Input Graphics.Vty.Input.Events Graphics.Vty.Output
    Graphics.Vty.Output.Mock Graphics.Vty.Picture
    Graphics.Vty.PictureToSpans Graphics.Vty.Span
    Graphics.Vty.UnicodeWidthTable.IO
    Graphics.Vty.UnicodeWidthTable.Install
    Graphics.Vty.UnicodeWidthTable.Main
    Graphics.Vty.UnicodeWidthTable.Query
    Graphics.Vty.UnicodeWidthTable.Types

import-dirs:          /usr/lib/ghc-9.4.8/site-local/vty-6.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/vty-6.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/vty-6.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-vty
hs-libraries:         HSvty-6.1-5hxZ33ogxWrHekvqlf61f0
depends:
    base-4.17.2.1 binary-0.8.9.1
    blaze-builder-0.4.2.3-1WUo1omsOYUH2PSkelI6MS bytestring-0.11.5.3
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-mtl-0.2.0.3-vQELA1onhlLfPXHvjZtx7
    microlens-th-0.4.3.17-Vfga0HXPTS6SXD3NuXqZ3 mtl-2.2.2
    parsec-3.1.16.1 stm-2.5.1.0 text-2.0.2
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    vector-0.13.2.0-KDCTRjRQ0urK2B6TNAGAn8

haddock-interfaces:   /usr/share/doc/haskell-vty/html/vty.haddock
haddock-html:         /usr/share/doc/haskell-vty/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

