#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 versions
version:              6.0.6
visibility:           public
id:                   versions-6.0.6-DhPriZ5sOJYI43d1xNEMdt
key:                  versions-6.0.6-DhPriZ5sOJYI43d1xNEMdt
license:              BSD-3-Clause
maintainer:           colin@fosskers.ca
author:               Colin Woodbury
homepage:             https://github.com/fosskers/versions
synopsis:             Types and parsers for software version numbers.
description:
    A library for parsing and comparing software version numbers. We like to give
    version numbers to our software in a myriad of ways. Some ways follow strict
    guidelines for incrementing and comparison. Some follow conventional wisdom
    and are generally self-consistent. Some are just plain asinine. This library
    provides a means of parsing and comparing /any/ style of versioning, be it a
    nice Semantic Version like this:

    > 1.2.3-r1+git123

    ...or a monstrosity like this:

    > 2:10.2+0.0093r3+1-1

    Please switch to <http://semver.org Semantic Versioning> if you aren'\''t
    currently using it. It provides consistency in version incrementing and has
    the best constraints on comparisons.

    This library implements version @2.0.0@ of the SemVer spec.

category:             Data
abi:                  dc109281c6ea3564301f973d9d2c11ed
exposed:              True
exposed-modules:      Data.Versions
import-dirs:          /usr/lib/ghc-9.4.8/site-local/versions-6.0.6
library-dirs:         /usr/lib/ghc-9.4.8/site-local/versions-6.0.6
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/versions-6.0.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-versions
hs-libraries:         HSversions-6.0.6-DhPriZ5sOJYI43d1xNEMdt
depends:
    base-4.17.2.1 deepseq-1.4.8.0
    hashable-1.4.4.0-Jc2uKL4S7Fl9QLNJZYpfiY
    megaparsec-9.6.1-KkOPmPbRCEmCvB2XbKT9En
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    template-haskell-2.19.0.0 text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-versions/html/versions.haddock
haddock-html:         /usr/share/doc/haskell-versions/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

