#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-7HhXCrlNrfXFxfhu2adJ82
key:                  trifecta-2.1.4-7HhXCrlNrfXFxfhu2adJ82
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  e09b719d7acf445ecbbf872144b0816a
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-7HhXCrlNrfXFxfhu2adJ82
depends:
    ansi-terminal-1.0.2-6TxOAUbfOQrDbPnWIRhRhS array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.2.3-1WUo1omsOYUH2PSkelI6MS
    blaze-html-0.9.2.0-7T5tBdPknWXDUJ5NeSXWzj
    blaze-markup-0.8.3.0-4zGQB5UMO8P5hF725cGajZ bytestring-0.11.5.3
    charset-0.3.12-JmDPQ9FbsapARinnh8cwZ3
    comonad-5.0.9-9xjKvPyIFa3z6kb3iLImI containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.5.0-LqJf8RwZyCzH9Wcvq2jau
    ghc-prim-0.9.1 hashable-1.4.4.0-Jc2uKL4S7Fl9QLNJZYpfiY
    indexed-traversable-0.1.4-GpzHE24npZbHvtNh8tX2xS
    lens-5.2.3-DzkbQ1V4DGJJfQUmuvkfoj mtl-2.2.2
    parsers-0.12.12-39k4tAcUKBMAMGdiIGgBr9
    prettyprinter-1.7.1-L5f5fQ72tN6KrwJu1IwhTZ
    prettyprinter-ansi-terminal-1.1.3-3gezl4y1Fis6b0vPmlsQhT
    profunctors-5.6.2-EsgLQtFnlIg5jr0U9yDwZT
    reducers-3.12.5-8Wz97JxRjCN4ApOxDPjs3A transformers-0.5.6.2
    unordered-containers-0.2.20-vB8Yx6KwyeBrT13JKFJ0i
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

