#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 streams
version:              3.3.3
visibility:           public
id:                   streams-3.3.3-K6DaEN50WLdJ4qGVWGJFnx
key:                  streams-3.3.3-K6DaEN50WLdJ4qGVWGJFnx
license:              BSD-3-Clause
copyright:
    Copyright 2011-2013 Edward Kmett
    Copyright 2010 Tony Morris, Oliver Taylor, Eelis van der Weegen
    Copyright 2007-2010 Wouter Swierstra, Bas van Dijk
    Copyright 2008 Iavor S. Diatchki

maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/streams
synopsis:             Various Haskell 2010 stream comonads
description:
    Various Haskell 2010 stream comonads.
    * "Data.Stream.Future" provides a coinductive anti-causal stream, or non-empty '\''ZipList'\''. The comonad provides access to only the
    tail of the stream. Like a conventional '\''ZipList'\'', this is /not/ a monad.

    > data Future a = Last a | a :< Future a

    * "Data.Stream.Future.Skew" provides a non-empty skew-binary random-access-list with the semantics of @Data.Stream.Future@. As with
    "Data.Stream.Future" this stream is not a '\''Monad'\'', since the '\''Applicative'\'' instance zips streams of potentially differing lengths.
    The random-access-list structure provides a number of operations logarithmic access time, but makes '\''Data.Stream.Future.Skew.cons'\''
    less productive. Where applicable "Data.Stream.Infinite.Skew" may be more efficient, due to a lazier and more efficient '\''Applicative'\''
    instance.

    >

    * "Data.Stream.Infinite" provides a coinductive infinite anti-causal stream. The '\''Comonad'\'' provides access to the tail of the
    stream and the '\''Applicative'\'' zips streams together. Unlike '\''Future'\'', infinite stream form a '\''Monad'\''. The monad diagonalizes
    the '\''Stream'\'', which is consistent with the behavior of the '\''Applicative'\'', and the view of a '\''Stream'\'' as a isomorphic to the reader
    monad from the natural numbers. Being infinite in length, there is no '\''Alternative'\'' instance.

    > data Stream a = a :< Stream a

    * "Data.Stream.Infinite.Skew" provides an infinite skew-binary random-access-list with the semantics of "Data.Stream.Infinite"
    Since every stream is infinite, the '\''Applicative'\'' instance can be considerably less strict than the corresponding instance for
    "Data.Stream.Future.Skew" and performs asymptotically better.

    >

    * "Data.Stream.Infinite.Functional.Zipper" provides a bi-infinite sequence, represented as a pure function with an accumulating
    parameter added to optimize moving the current focus.

    > data Zipper a = !Integer :~ (Integer -> a)

    * "Data.Stream.Supply" provides a comonadic supply of unique values, which are
    generated impurely as the tree is explored.

category:             Control, Comonads
abi:                  309fcac74f010c2ea1742cf1cdee169b
exposed:              True
exposed-modules:
    Data.Stream.Future Data.Stream.Future.Skew Data.Stream.Infinite
    Data.Stream.Infinite.Functional.Zipper Data.Stream.Infinite.Skew
    Data.Stream.Supply

import-dirs:          /usr/lib/ghc-9.4.8/site-local/streams-3.3.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/streams-3.3.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/streams-3.3.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-streams
hs-libraries:         HSstreams-3.3.3-K6DaEN50WLdJ4qGVWGJFnx
depends:
    adjunctions-4.4.3-ArvoXeENUnN7CtRvS3NtFU base-4.17.2.1
    boring-0.2.2-HI9VvaC9JR142cnMpyID0P
    comonad-5.0.9-LkJkT74yhsMAX9tSgmZsNW
    distributive-0.6.2.1-Gc8PUWM0btz9ZAWKtORd6a
    semigroupoids-6.0.1-4tZ3GUdbU6C6aZsHetCI4X

haddock-interfaces:   /usr/share/doc/haskell-streams/html/streams.haddock
haddock-html:         /usr/share/doc/haskell-streams/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

