#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 mod
version:              0.2.0.1
visibility:           public
id:                   mod-0.2.0.1-B0WDc4GgRLuAHc6ujRVfDN
key:                  mod-0.2.0.1-B0WDc4GgRLuAHc6ujRVfDN
license:              MIT
copyright:            2017-2022 Andrew Lelechenko
maintainer:           Andrew Lelechenko <andrew.lelechenko@gmail.com>
author:               Andrew Lelechenko <andrew.lelechenko@gmail.com>
homepage:             https://github.com/Bodigrim/mod
synopsis:             Fast type-safe modular arithmetic
description:
    <https://en.wikipedia.org/wiki/Modular_arithmetic Modular arithmetic>,
    promoting moduli to the type level, with an emphasis on performance.
    Originally part of the <https://hackage.haskell.org/package/arithmoi arithmoi> package.

category:             Math, Number Theory
abi:                  b6fac483f015c1135c1c9ccd67b9d7db
exposed:              True
exposed-modules:      Data.Mod Data.Mod.Word
hidden-modules:       Data.Mod.Compat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/mod-0.2.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/mod-0.2.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/mod-0.2.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-mod
hs-libraries:         HSmod-0.2.0.1-B0WDc4GgRLuAHc6ujRVfDN
depends:
    base-4.17.2.1 deepseq-1.4.8.0 ghc-bignum-1.3
    primitive-0.8.0.0-1110YmBHzhAERV5HY7EG3e
    semirings-0.6-L9nm7xwpU2c4FtT6PPNTlH
    vector-0.13.2.0-KDCTRjRQ0urK2B6TNAGAn8

haddock-interfaces:   /usr/share/doc/haskell-mod/html/mod.haddock
haddock-html:         /usr/share/doc/haskell-mod/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

