#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 integer-roots
version:              1.0.2.0
visibility:           public
id:                   integer-roots-1.0.2.0-B89iWzck3lT5fga7L7VDdN
key:                  integer-roots-1.0.2.0-B89iWzck3lT5fga7L7VDdN
license:              MIT
copyright:            (c) 2011 Daniel Fischer, 2016-2021 Andrew Lelechenko.
maintainer:           Andrew Lelechenko andrew dot lelechenko at gmail dot com
author:               Daniel Fischer, Andrew Lelechenko
homepage:             https://github.com/Bodigrim/integer-roots
synopsis:             Integer roots and perfect powers
description:
    Calculating integer roots and testing perfect powers of arbitrary precision. Originally part of <https://hackage.haskell.org/package/arithmoi arithmoi> package.

category:             Math, Algorithms, Number Theory
abi:                  c6a85557ca760e5a917a866cd4ee0075
exposed:              True
exposed-modules:      Math.NumberTheory.Roots
hidden-modules:
    Math.NumberTheory.Primes.Small Math.NumberTheory.Roots.Cubes
    Math.NumberTheory.Roots.Fourth Math.NumberTheory.Roots.General
    Math.NumberTheory.Roots.Squares
    Math.NumberTheory.Roots.Squares.Internal
    Math.NumberTheory.Utils.BitMask
    Math.NumberTheory.Utils.FromIntegral

import-dirs:          /usr/lib/ghc-9.4.8/site-local/integer-roots-1.0.2.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/integer-roots-1.0.2.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/integer-roots-1.0.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-integer-roots
hs-libraries:         HSinteger-roots-1.0.2.0-B89iWzck3lT5fga7L7VDdN
depends:              base-4.17.2.1 ghc-bignum-1.3
haddock-interfaces:
    /usr/share/doc/haskell-integer-roots/html/integer-roots.haddock

haddock-html:         /usr/share/doc/haskell-integer-roots/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

