#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.0
visibility:           public
id:                   hOpenPGP-2.10.0-8SiglwQoi30DJXmarfcdXI
key:                  hOpenPGP-2.10.0-8SiglwQoi30DJXmarfcdXI
license:              MIT
copyright:            2012-2024  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  0eb6c2a7bf9b777d6d8a1882e2b407bd
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Data.Conduit.OpenPGP.Compression Data.Conduit.OpenPGP.Decrypt
    Data.Conduit.OpenPGP.Filter Data.Conduit.OpenPGP.Keyring
    Data.Conduit.OpenPGP.Keyring.Instances Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.0-8SiglwQoi30DJXmarfcdXI
depends:
    aeson-2.1.2.1-LDBL5bcX1HC79scYyh3opi
    asn1-encoding-0.9.6-RO0MtPvMueEUvZE3gjiU7
    attoparsec-0.14.4-HXvPhgAZIYuDm9YtcrLhPL base-4.17.2.1
    base16-bytestring-1.0.2.0-C9exZvUOGWa30bfvxY0rP6
    bifunctors-5.6-H5gLaZGTtKN1h3rKcuS2CV binary-0.8.9.1
    binary-conduit-1.3.1-CrmEhzvA8N53CDoOSmYDMd bytestring-0.11.5.3
    bz2-1.0.1.1-E1R0s8v10Es4FN58vu7QFr
    conduit-1.3.6.1-AL3EmwxQHuQ1mZT9WLAkFR
    conduit-extra-1.3.6-6dO1xP5ViME37M1InDuSps containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-0.34-4bqmaNpvFyKLqEcEOMaVvT
    errors-2.3.0-JOY8YcEnvH83dF5Tui7fbX
    hashable-1.4.4.0-5O85VrI4oZ4EDBPYdTgwgk
    incremental-parser-0.5.1-41sULQnweLEGNMq5gVbt3M
    ixset-typed-0.5.1.0-BHhvBqDvYzt5HXTRziraKi
    lens-5.2.3-CV81uxSR0PiAcO8XtynZEb
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-EjZpKZ4F93eKYvVi9AsGV0
    openpgp-asciiarmor-0.1.2-4GxrVdHFbWx6gnqO9BfuoJ
    prettyprinter-1.7.1-BaAmjemZ9A8Bwhfteg2YYF
    resourcet-1.2.6-BEi0OW4T0Qo1xg4KkAo7Sv
    split-0.2.5-LghWP1sjueiF0Ln6STtUGf text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-2kG5VEC3Gy42AwINT9WJ9w
    zlib-0.6.3.0-INQT6AHIeCKDSccWzHoQ4A

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

