/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.metrics;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.library.metrics.MetricsComponent;
import com.tngtech.archunit.library.metrics.MetricsComponents;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.function.Predicate;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class VisibilityMetrics {
    private final ImmutableMap<String, ComponentVisibility> relativeVisibilityByComponentIdentifier;
    private final double averageRelativeVisibility;
    private final double globalRelativeVisibility;

    <T> VisibilityMetrics(MetricsComponents<T> components, Predicate<? super T> isVisible) {
        ImmutableMap.Builder<String, ComponentVisibility> relativeVisibilityByComponentIdentifierBuilder = ImmutableMap.builder();
        for (MetricsComponent metricsComponent : components) {
            relativeVisibilityByComponentIdentifierBuilder.put(metricsComponent.getIdentifier(), new ComponentVisibility(metricsComponent, isVisible));
        }
        this.relativeVisibilityByComponentIdentifier = relativeVisibilityByComponentIdentifierBuilder.build();
        this.averageRelativeVisibility = VisibilityMetrics.calculateAverageRelativeVisibility(this.relativeVisibilityByComponentIdentifier.values());
        this.globalRelativeVisibility = VisibilityMetrics.calculateGlobalRelativeVisibility(this.relativeVisibilityByComponentIdentifier.values());
    }

    private static double calculateAverageRelativeVisibility(Collection<ComponentVisibility> componentVisibilities) {
        double relativeVisibilitySum = componentVisibilities.stream().mapToDouble(componentVisibility -> componentVisibility.relativeVisibility).sum();
        return relativeVisibilitySum / (double)componentVisibilities.size();
    }

    private static double calculateGlobalRelativeVisibility(Collection<ComponentVisibility> componentVisibilities) {
        double numberOfVisibleElements = 0.0;
        double numberOfAllElements = 0.0;
        for (ComponentVisibility componentVisibility : componentVisibilities) {
            numberOfVisibleElements += (double)componentVisibility.numberOfVisibleElements;
            numberOfAllElements += (double)componentVisibility.numberOfAllElements;
        }
        return numberOfVisibleElements / numberOfAllElements;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public double getRelativeVisibility(String componentIdentifier) {
        return this.getComponentVisibility((String)componentIdentifier).relativeVisibility;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public double getAverageRelativeVisibility() {
        return this.averageRelativeVisibility;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public double getGlobalRelativeVisibility() {
        return this.globalRelativeVisibility;
    }

    private ComponentVisibility getComponentVisibility(String componentIdentifier) {
        ComponentVisibility result = this.relativeVisibilityByComponentIdentifier.get(componentIdentifier);
        Preconditions.checkArgument(result != null, "Unknown component with identifier '" + componentIdentifier + "'");
        return result;
    }

    private static class ComponentVisibility {
        final int numberOfVisibleElements;
        final int numberOfAllElements;
        final double relativeVisibility;

        <T> ComponentVisibility(MetricsComponent<T> component, Predicate<? super T> isVisible) {
            this.numberOfVisibleElements = (int)component.stream().filter(isVisible).count();
            this.numberOfAllElements = component.size();
            this.relativeVisibility = (double)this.numberOfVisibleElements / (double)this.numberOfAllElements;
        }
    }
}

