#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.1
visibility:           public
id:                   dhall-1.42.1-IR4wpxVrCPRTw0S8QNC9i
key:                  dhall-1.42.1-IR4wpxVrCPRTw0S8QNC9i
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  4686503c232519e4fd6f618627d0f81c
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.1-IR4wpxVrCPRTw0S8QNC9i
depends:
    Diff-0.4.1-94wHByfojTDaWJlRbLpnx
    aeson-2.1.2.1-LDBL5bcX1HC79scYyh3opi
    aeson-pretty-0.8.10-EmnmwX6oqUJE4ELkQEWzze
    ansi-terminal-1.0.2-6TxOAUbfOQrDbPnWIRhRhS
    atomic-write-0.2.1.1-J8tRDMsKzr3IKOCgNFCqel base-4.17.2.1
    base16-bytestring-1.0.2.0-C9exZvUOGWa30bfvxY0rP6
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-3jbMOlKTiDn4NCqaBZ47Ne
    cborg-0.2.9.0-4FbWrLirU9xBU3P0VFPPqL
    cborg-json-0.2.6.0-IDVSY6dLEp7FYt0DTVeNyu containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-5jB3xwiF87GLRh9OrINa2A
    data-fix-0.3.3-CieLCcxlaZrElGeYfqJFSJ deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.2-KJSurByLz86Ck4Hkzt9tEV exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.2-HTVYkQ2R5LP704IIh6Wa4D
    hashable-1.4.4.0-5O85VrI4oZ4EDBPYdTgwgk haskeline-0.8.2
    http-client-0.7.17-39vQCRHDS8Y4AZkwpcxUyW
    http-client-tls-0.3.6.4-8CeCL7zDXbKxhjkugWal5
    http-types-0.12.4-3FyJu2Ux8ftJoanRheHyWI
    indexed-traversable-0.1.4-5uvxwew3Uwx9YqKKWPbxP3
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-AHfz4qPwoQs815dRss8YYZ
    mmorph-1.2.0-3nIz0RIlBAUER45blfkK28 mtl-2.2.2
    network-uri-2.6.4.2-EjZpKZ4F93eKYvVi9AsGV0
    optparse-applicative-0.17.1.0-4tPjpOfYmOi9nj8To0UB1j
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-75fcA51k0S9J1QdyfPEl96
    pretty-simple-4.1.3.0-2v5xmmcPxjGMcUx4JbYHG
    prettyprinter-1.7.1-BaAmjemZ9A8Bwhfteg2YYF
    prettyprinter-ansi-terminal-1.1.3-3UaEd28yvERuzLBWT3ZVt
    profunctors-5.6.2-HcmQMl1CmCsL3Ph63hJBuk
    repline-0.4.2.0-KVntTSpWnVfIRYxV1mly8a
    scientific-0.3.7.0-EYP4lwU6ELFEdSU4sCeddu
    serialise-0.2.6.1-GHVdN93HX8FCB7biyuvypb template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-E3hmcJepHwS18Lf7AeTJbZ
    text-short-0.1.6-JxZmomqfmBPHr8e1Kgb0nA
    th-lift-instances-0.1.20-HDTg36ld1ngGfSx4POJgNm time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.3-FZLvposRpy5EPSL1bbufv9
    unordered-containers-0.2.20-2kG5VEC3Gy42AwINT9WJ9w
    vector-0.13.1.0-Dc65CzydytHE52tdajtbOv

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

