/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.ai.suggestion;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.jkiss.utils.CommonUtils;

public class TextRenderingUtils {
    private TextRenderingUtils() {
    }

    public static void drawFirstLine(String text, GC gc, StyledText textWidget, int widgetOffset) {
        Point origin;
        int line;
        if (gc == null) {
            return;
        }
        widgetOffset = Math.max(0, Math.min(widgetOffset, textWidget.getCharCount()));
        try {
            line = textWidget.getLineAtOffset(widgetOffset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        int bias = TextRenderingUtils.calculateBaselineOffset(gc, textWidget, line);
        try {
            origin = textWidget.getLocationAtOffset(widgetOffset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            origin = textWidget.getLocationAtOffset(textWidget.getCharCount() - 1);
            origin.y += textWidget.getLineHeight();
            origin.x = textWidget.getLeftMargin();
        }
        FontMetrics fm = gc.getFontMetrics();
        int fontHeight = fm.getHeight();
        int lineHeight = textWidget.getLineHeight();
        int verticalPosition = origin.y + (lineHeight - fontHeight) + bias;
        if (text != null) {
            text = TextRenderingUtils.trimOverlappingText(text, widgetOffset, textWidget);
            gc.drawString(text, origin.x, verticalPosition, true);
        }
    }

    public static void drawNextLines(String text, GC gc, StyledText textWidget, int offset) {
        int lineHeight = textWidget.getLineHeight();
        int fontHeight = gc.getFontMetrics().getHeight();
        Point origin = textWidget.getLocationAtOffset(offset);
        int x = textWidget.getLeftMargin();
        int y = origin.y + lineHeight + (lineHeight - fontHeight);
        gc.drawText(text, x, y, true);
    }

    public static String trimOverlappingText(String text, int offset, StyledText widget) {
        String remaining = TextRenderingUtils.getLineRemainder(offset, widget);
        if (!remaining.isEmpty() && text.endsWith(remaining)) {
            return text.substring(0, text.length() - remaining.length());
        }
        return text;
    }

    public static int calculateBaselineOffset(GC gc, StyledText textWidget, int widgetLine) {
        if (gc == null) {
            return 0;
        }
        int offset = textWidget.getOffsetAtLine(widgetLine);
        int widgetBaseline = textWidget.getBaseline(offset);
        FontMetrics fm = gc.getFontMetrics();
        int fontBaseline = fm.getAscent() + fm.getLeading();
        return Math.max(0, widgetBaseline - fontBaseline);
    }

    private static String getLineRemainder(int offset, StyledText widget) {
        int line = widget.getLineAtOffset(offset);
        int start = widget.getOffsetAtLine(line);
        String contents = widget.getLine(line);
        return contents.substring(offset - start);
    }

    public static int widgetOffset2ModelOffset(ITextViewer viewer, int widgetOffset) {
        int n;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 ext5 = (ITextViewerExtension5)viewer;
            n = ext5.widgetOffset2ModelOffset(widgetOffset);
        } else {
            n = widgetOffset;
        }
        return n;
    }

    public static String removeOverlap(String originalText, String suggestion) {
        if (CommonUtils.isEmpty((String)suggestion) || CommonUtils.isEmpty((String)originalText)) {
            return suggestion;
        }
        String endOfOriginal = originalText.length() <= 20 ? originalText : originalText.substring(originalText.length() - 20);
        endOfOriginal = endOfOriginal.replaceAll("\\s+", " ").toLowerCase();
        String cleanSuggestion = suggestion.replaceAll("\\s+", " ");
        int length = Math.min(endOfOriginal.length(), cleanSuggestion.length());
        while (length > 0) {
            if (endOfOriginal.length() >= length) {
                String endSubstring = endOfOriginal.substring(endOfOriginal.length() - length);
                if (cleanSuggestion.toLowerCase().startsWith(endSubstring)) {
                    return cleanSuggestion.substring(length).trim();
                }
            }
            --length;
        }
        return suggestion;
    }
}

