/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.internal.registry;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.ui.internal.registry.NavigatorNodeActionDescriptor;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.INavigatorNodeActionHandler;

public class NavigatorExtensionsRegistry {
    private static final Log log = Log.getLog(NavigatorExtensionsRegistry.class);
    private static NavigatorExtensionsRegistry instance = null;
    private List<NavigatorNodeActionDescriptor> nodeActions = new ArrayList<NavigatorNodeActionDescriptor>();

    public static synchronized NavigatorExtensionsRegistry getInstance() {
        if (instance == null) {
            instance = new NavigatorExtensionsRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    public NavigatorExtensionsRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.navigator.nodeAction");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("nodeAction".equals(ext.getName())) {
                NavigatorNodeActionDescriptor descriptor = new NavigatorNodeActionDescriptor(ext);
                this.nodeActions.add(descriptor);
            }
            ++n2;
        }
        this.nodeActions.sort(Comparator.comparingInt(NavigatorNodeActionDescriptor::getOrder));
    }

    public void dispose() {
        this.nodeActions.clear();
    }

    public List<INavigatorNodeActionHandler> getNodeActions(INavigatorModelView view, DBNNode node) {
        return this.nodeActions.stream().filter(nad -> (nad.appliesTo((DBPObject)node) || node instanceof DBNDatabaseNode && nad.appliesTo((DBPObject)((DBNDatabaseNode)node).getObject())) && nad.getHandler().isEnabledFor(view, node)).map(NavigatorNodeActionDescriptor::getHandler).collect(Collectors.toList());
    }
}

