/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyValueTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.utils.CommonUtils;

public class GenericCatalog
extends GenericObjectContainer
implements DBSCatalog {
    private final String catalogName;
    private List<GenericSchema> schemas;
    private boolean isInitialized = false;

    public GenericCatalog(@NotNull GenericDataSource dataSource, @NotNull String catalogName) {
        super(dataSource);
        this.catalogName = catalogName;
    }

    @Override
    public GenericCatalog getCatalog() {
        return this;
    }

    @Override
    public GenericSchema getSchema() {
        return null;
    }

    @Override
    public GenericCatalog getObject() {
        return this;
    }

    public Collection<GenericSchema> getSchemaList(DBRProgressMonitor monitor) throws DBException {
        if (this.getDataSource().isMergeEntities()) {
            return null;
        }
        return this.getSchemas(monitor);
    }

    @Association
    public Collection<GenericSchema> getSchemas(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.schemas == null && !this.isInitialized && !monitor.isForceCacheUsage()) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load catalog schemas");){
                this.schemas = this.getDataSource().getMetaModel().loadSchemas(session, this.getDataSource(), this);
                this.isInitialized = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this.schemas;
    }

    public GenericSchema getSchema(DBRProgressMonitor monitor, String name) throws DBException {
        return (GenericSchema)DBUtils.findObject(this.getSchemas(monitor), (String)name, (this.getDataSource().getSQLDialect().storesUnquotedCase() == DBPIdentifierCase.MIXED ? 1 : 0) != 0);
    }

    @Property(viewable=true, order=1, labelProvider=CatalogNameTermProvider.class)
    @NotNull
    public String getName() {
        return this.catalogName;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.getDataSource();
    }

    @Override
    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        if (CommonUtils.isEmpty(this.getSchemas(monitor))) {
            super.cacheStructure(monitor, scope);
        }
    }

    @Override
    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (!CommonUtils.isEmpty(this.getSchemas(monitor))) {
            return this.getSchemas(monitor);
        }
        return this.getTables(monitor);
    }

    @Override
    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        if (!CommonUtils.isEmpty(this.getSchemas(monitor))) {
            return this.getSchema(monitor, childName);
        }
        return super.getChild(monitor, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        if (!CommonUtils.isEmpty(this.schemas) || monitor != null && !CommonUtils.isEmpty(this.getSchemas(monitor))) {
            return GenericSchema.class;
        }
        return GenericTable.class;
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.schemas = null;
        this.isInitialized = false;
        return super.refreshObject(monitor);
    }

    public static class CatalogNameTermProvider
    implements IPropertyValueTransformer<DBSObject, String> {
        public String transform(DBSObject object, String value) throws IllegalArgumentException {
            String catalogTerm = object.getDataSource().getInfo().getCatalogTerm();
            if (!CommonUtils.isEmpty((String)catalogTerm)) {
                return catalogTerm + " " + ModelMessages.model_navigator_Name;
            }
            return ModelMessages.model_navigator_Name;
        }
    }
}

