/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.utils.CommonUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SQLScriptBindingType {
    EXTERNAL("N/A", "External binding (IDE resources)"){

        @Override
        public void appendSpec(DBPDataSourceContainer dataSource, StringBuilder spec) {
        }
    }
    ,
    ID("ID", SQLEditorMessages.sql_script_binding_type_radio_button_connection_unique){

        @Override
        public void appendSpec(DBPDataSourceContainer dataSource, StringBuilder spec) {
            spec.append("id").append("=").append(dataSource.getId());
        }
    }
    ,
    NAME("NAME", SQLEditorMessages.sql_script_binding_type_radio_button_connection_name){

        @Override
        public void appendSpec(DBPDataSourceContainer dataSource, StringBuilder spec) {
            spec.append("name").append("=").append(dataSource.getName());
        }
    }
    ,
    URL("URL", SQLEditorMessages.sql_script_binding_type_radio_button_connection_url){

        @Override
        public void appendSpec(DBPDataSourceContainer dataSource, StringBuilder spec) {
            spec.append("url").append("=").append(dataSource.getConnectionConfiguration().getUrl());
        }
    }
    ,
    PARAMS("PARAMS", SQLEditorMessages.sql_script_binding_type_radio_button_connection_parameters){

        @Override
        public void appendSpec(DBPDataSourceContainer dataSource, StringBuilder spec) {
            DBPConnectionConfiguration cfg = dataSource.getConnectionConfiguration();
            LinkedHashMap<Object, String> params = new LinkedHashMap<Object, String>();
            if (!CommonUtils.isEmpty((String)cfg.getServerName())) {
                params.put("server", cfg.getServerName());
            }
            if (!CommonUtils.isEmpty((String)cfg.getHostName())) {
                params.put("host", cfg.getHostName());
            }
            if (!CommonUtils.isEmpty((String)cfg.getHostPort())) {
                params.put("port", cfg.getHostPort());
            }
            if (!CommonUtils.isEmpty((String)cfg.getDatabaseName())) {
                params.put("database", cfg.getDatabaseName());
            }
            if (!CommonUtils.isEmpty((String)cfg.getUserName())) {
                params.put("user", cfg.getUserName());
            }
            for (DBWHandlerConfiguration handler : cfg.getHandlers()) {
                if (!handler.isEnabled()) continue;
                for (Map.Entry prop : handler.getProperties().entrySet()) {
                    String propName = (String)prop.getKey();
                    if (!propName.contains("server") && !propName.contains("host") && !propName.contains("port")) continue;
                    params.put("handler." + handler.getId() + "." + propName, CommonUtils.toString(prop.getValue()));
                }
            }
            boolean first = true;
            for (Map.Entry param : params.entrySet()) {
                if (!first) {
                    spec.append("|");
                }
                spec.append((String)param.getKey()).append("=").append((String)param.getValue());
                first = false;
            }
        }
    };

    private final String name;
    private final String description;

    private SQLScriptBindingType(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract void appendSpec(DBPDataSourceContainer var1, StringBuilder var2);
}

