/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeContainer;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectWithType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.utils.Pair;

public class SQLQueryRowsTableDataModel
extends SQLQueryRowsSourceModel
implements SQLQuerySymbolDefinition,
SQLQueryNodeModel.NodeSubtreeTraverseControl {
    private static final Log log = Log.getLog(SQLQueryRowsTableDataModel.class);
    @Nullable
    private final SQLQueryQualifiedName name;
    @Nullable
    private DBSEntity table = null;
    private final boolean forDdl;
    @Nullable
    private SQLQueryRowsSourceModel referencedSource;

    public SQLQueryRowsTableDataModel(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryQualifiedName name, boolean forDdl) {
        super(syntaxNode, new SQLQueryNodeModel[0]);
        this.name = name;
        this.forDdl = forDdl;
    }

    @Nullable
    public SQLQueryQualifiedName getName() {
        return this.name;
    }

    @Nullable
    public DBSEntity getTable() {
        return this.table;
    }

    @Override
    @NotNull
    public SQLQuerySymbolClass getSymbolClass() {
        return this.table != null ? SQLQuerySymbolClass.TABLE : SQLQuerySymbolClass.ERROR;
    }

    @NotNull
    private static SQLQuerySymbol prepareColumnSymbol(@NotNull SQLDialect dialect, @NotNull DBSEntityAttribute attr) {
        String name = SQLUtils.identifierToCanonicalForm((SQLDialect)dialect, (String)attr.getName(), (boolean)false, (boolean)true);
        SQLQuerySymbol symbol = new SQLQuerySymbol(name);
        symbol.setDefinition(new SQLQuerySymbolByDbObjectDefinition((DBSObject)attr, SQLQuerySymbolClass.COLUMN));
        return symbol;
    }

    @NotNull
    protected Pair<List<SQLQueryResultColumn>, List<SQLQueryResultPseudoColumn>> prepareResultColumnsList(@NotNull SQLQuerySymbolEntry cause, @NotNull SQLQueryDataContext attrsContext, @NotNull SQLQueryRecognitionContext statistics, @NotNull List<? extends DBSEntityAttribute> attributes) {
        return SQLQueryRowsTableDataModel.prepareResultColumnsList(cause, (SQLQueryRowsSourceModel)this, this.table, attrsContext, statistics, attributes);
    }

    @NotNull
    protected Pair<List<SQLQueryResultColumn>, List<SQLQueryResultPseudoColumn>> prepareResultColumnsList(@NotNull SQLQuerySymbolEntry cause, @NotNull SQLDialect dialect, @NotNull SQLQueryRecognitionContext statistics, @NotNull List<? extends DBSEntityAttribute> attributes) {
        return SQLQueryRowsTableDataModel.prepareResultColumnsList(cause, (SQLQueryRowsSourceModel)this, this.table, dialect, statistics, attributes);
    }

    @NotNull
    public static Pair<List<SQLQueryResultColumn>, List<SQLQueryResultPseudoColumn>> prepareResultColumnsList(@NotNull SQLQuerySymbolEntry cause, @NotNull SQLQueryRowsSourceModel rowsSourceModel, @Nullable DBSEntity table, @NotNull SQLQueryDataContext attrsContext, @NotNull SQLQueryRecognitionContext statistics, @NotNull List<? extends DBSEntityAttribute> attributes) {
        return SQLQueryRowsTableDataModel.prepareResultColumnsList(cause, rowsSourceModel, table, attrsContext.getDialect(), statistics, attributes);
    }

    @NotNull
    public static Pair<List<SQLQueryResultColumn>, List<SQLQueryResultPseudoColumn>> prepareResultColumnsList(@NotNull SQLQuerySymbolEntry cause, @NotNull SQLQueryRowsSourceModel rowsSourceModel, @Nullable DBSEntity table, @NotNull SQLDialect dialect, @NotNull SQLQueryRecognitionContext statistics, @NotNull List<? extends DBSEntityAttribute> attributes) {
        ArrayList<SQLQueryResultColumn> columns = new ArrayList<SQLQueryResultColumn>(attributes.size());
        ArrayList<SQLQueryResultPseudoColumn> pseudoColumns = new ArrayList<SQLQueryResultPseudoColumn>(attributes.size());
        for (DBSEntityAttribute dBSEntityAttribute : attributes) {
            if (DBUtils.isHiddenObject((Object)dBSEntityAttribute)) {
                pseudoColumns.add(new SQLQueryResultPseudoColumn(SQLQueryRowsTableDataModel.prepareColumnSymbol(dialect, dBSEntityAttribute), rowsSourceModel, table, SQLQueryRowsTableDataModel.obtainColumnType(cause, statistics, (DBSAttributeBase)dBSEntityAttribute), DBDPseudoAttribute.PropagationPolicy.TABLE_LOCAL, dBSEntityAttribute.getDescription()));
                continue;
            }
            columns.add(new SQLQueryResultColumn(columns.size(), SQLQueryRowsTableDataModel.prepareColumnSymbol(dialect, dBSEntityAttribute), rowsSourceModel, table, dBSEntityAttribute, SQLQueryRowsTableDataModel.obtainColumnType(cause, statistics, (DBSAttributeBase)dBSEntityAttribute)));
        }
        return Pair.of(columns, pseudoColumns);
    }

    @NotNull
    private static SQLQueryExprType obtainColumnType(@NotNull SQLQuerySymbolEntry reason, @NotNull SQLQueryRecognitionContext statistics, @NotNull DBSAttributeBase attr) {
        SQLQueryExprType type;
        try {
            type = SQLQueryExprType.forTypedObject(statistics.getMonitor(), (DBSTypedObject)attr, SQLQuerySymbolClass.COLUMN);
        }
        catch (DBException e) {
            log.debug((Object)e);
            statistics.appendError(reason, "Failed to resolve column type for column " + attr.getName(), e);
            type = SQLQueryExprType.UNKNOWN;
        }
        return type;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        block16: {
            block17: {
                block18: {
                    if (this.name == null) break block17;
                    rowsetRefOrigin = new SQLQuerySymbolOrigin.RowsetRefFromContext(context);
                    if (this.name.invalidPartsCount != 0) break block18;
                    if (!this.name.isNotClassified()) break block16;
                    nameStrings = this.name.toListOfStrings();
                    if (nameStrings.size() == 1 && this.name.entityName.getName().equalsIgnoreCase(context.getDialect().getDualTableName())) {
                        this.name.setSymbolClass(SQLQuerySymbolClass.TABLE);
                        return context.overrideResultTuple(this, Collections.emptyList(), Collections.emptyList());
                    }
                    refTarget = context.findRealObject(statistics.getMonitor(), RelationalObjectType.TYPE_UNKNOWN, nameStrings);
                    v0 = obj = this.forDdl != false ? refTarget : SQLQueryDataSourceContext.expandAliases(statistics.getMonitor(), refTarget);
                    if (!(obj instanceof DBSEntity)) ** GOTO lbl-1000
                    e = (DBSEntity)obj;
                    if (obj instanceof DBSTable || obj instanceof DBSView) {
                        v1 = e;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = this.table = null;
                    }
                    if (this.table != null) {
                        this.name.setDefinition(refTarget, (SQLQuerySymbolOrigin)rowsetRefOrigin);
                        context = context.extendWithRealTable(this.table, this);
                        try {
                            attributes = this.table.getAttributes(statistics.getMonitor());
                            if (attributes != null) {
                                columns = this.prepareResultColumnsList(this.name.entityName, context, statistics, (List<? extends DBSEntityAttribute>)attributes);
                                var12_15 = this.table;
                                if (var12_15 instanceof DBDPseudoAttributeContainer) {
                                    pac = (DBDPseudoAttributeContainer)var12_15;
                                    v2 /* !! */  = SQLQueryRowsTableDataModel.prepareResultPseudoColumnsList(context.getDialect(), this, this.table, Stream.of(pac.getAllPseudoAttributes(statistics.getMonitor())).filter((Predicate<DBDPseudoAttribute>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$0(org.jkiss.dbeaver.model.data.DBDPseudoAttribute ), (Lorg/jkiss/dbeaver/model/data/DBDPseudoAttribute;)Z)()));
                                } else {
                                    v2 /* !! */  = Collections.emptyList();
                                }
                                inferredPseudoColumns = v2 /* !! */ ;
                                pseudoColumns = Stream.of(new List[]{(List)columns.getSecond(), inferredPseudoColumns}).flatMap((Function<List, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/List;)Ljava/util/stream/Stream;)()).collect(Collectors.toList());
                                context = context.overrideResultTuple(this, (List)columns.getFirst(), pseudoColumns);
                            }
                            break block16;
                        }
                        catch (DBException ex) {
                            statistics.appendError(this.name.entityName, "Failed to resolve columns of the table " + this.name.toIdentifierString(), ex);
                        }
                    } else if (refTarget != null) {
                        if (obj instanceof DBSObjectWithType) {
                            to = (DBSObjectWithType)obj;
                            v3 = to.getObjectType().getTypeName();
                        } else {
                            v3 = obj.getClass().getSimpleName();
                        }
                        typeName = v3;
                        statistics.appendError(this.name.entityName, "Expected table name while given " + typeName);
                    } else {
                        rr = (context = context.markHasUnresolvedSource()).resolveSource(statistics.getMonitor(), nameStrings);
                        if (rr != null && rr.tableOrNull == null && rr.source != null && rr.aliasOrNull != null && nameStrings.size() == 1) {
                            this.name.entityName.setDefinition(rr.aliasOrNull.getDefinition());
                            context = context.overrideResultTuple(this, rr.source.getResultDataContext().getColumnsList(), Collections.emptyList());
                        } else {
                            tableSymbolClass = statistics.isTreatErrorsAsWarnings() != false ? SQLQuerySymbolClass.TABLE : SQLQuerySymbolClass.ERROR;
                            context = this.performPartialResolution(context, statistics, rowsetRefOrigin, tableSymbolClass);
                            statistics.appendError(this.name.entityName, "Table " + this.name.toIdentifierString() + " not found");
                        }
                    }
                    break block16;
                }
                context = this.performPartialResolution(context, statistics, rowsetRefOrigin, null);
                statistics.appendError(this.getSyntaxNode(), "Invalid table reference");
                break block16;
            }
            context = context.overrideResultTuple(this, Collections.emptyList(), Collections.emptyList()).markHasUnresolvedSource();
            statistics.appendError(this.getSyntaxNode(), "Table reference expected");
        }
        return context;
    }

    @NotNull
    private SQLQueryDataContext performPartialResolution(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics, @NotNull SQLQuerySymbolOrigin rowsetRefOrigin, @Nullable SQLQuerySymbolClass entityNameClass) {
        SQLQueryDataContext resolvedContext = context.overrideResultTuple(this, Collections.emptyList(), Collections.emptyList()).markHasUnresolvedSource();
        if (this.name != null && entityNameClass != null) {
            SQLQueryQualifiedName.performPartialResolution(resolvedContext, statistics, this.name, rowsetRefOrigin, Set.of(RelationalObjectType.TYPE_UNKNOWN), entityNameClass);
        }
        return resolvedContext;
    }

    public static List<SQLQueryResultPseudoColumn> prepareResultPseudoColumnsList(@NotNull SQLDialect dialect, @Nullable SQLQueryRowsSourceModel source, @Nullable DBSEntity table, @NotNull Stream<DBDPseudoAttribute> pseudoAttributes) {
        return pseudoAttributes.map(a -> new SQLQueryResultPseudoColumn(new SQLQuerySymbol(SQLUtils.identifierToCanonicalForm((SQLDialect)dialect, (String)a.getName(), (boolean)false, (boolean)false)), source, table, SQLQueryExprType.UNKNOWN, a.getPropagationPolicy(), a.getDescription())).collect(Collectors.toList());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected SQLQueryRowsSourceContext resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        block8: {
            block7: {
                rowsetRefOrigin = new SQLQuerySymbolOrigin.RowsSourceRef(context);
                if (this.name == null) {
                    statistics.appendError(this.getSyntaxNode(), "Invalid table reference");
                    return context.reset();
                }
                nameStrings = this.name.toListOfStrings();
                name = new SQLQueryComplexName(nameStrings);
                if (nameStrings.size() == 1 && this.name.entityName.getName().equalsIgnoreCase(context.getDialect().getDualTableName())) {
                    this.name.setSymbolClass(SQLQuerySymbolClass.TABLE);
                    return context.reset();
                }
                dynamicSource = context.findDynamicRowsSource(name);
                if (dynamicSource != null) break block7;
                refTarget = context.getConnectionInfo().findRealObject(statistics.getMonitor(), RelationalObjectType.TYPE_UNKNOWN, nameStrings);
                v0 = obj = this.forDdl != false ? refTarget : SQLQueryDataSourceContext.expandAliases(statistics.getMonitor(), refTarget);
                if (!(obj instanceof DBSEntity)) ** GOTO lbl-1000
                e = (DBSEntity)obj;
                if (obj instanceof DBSTable || obj instanceof DBSView) {
                    v1 = e;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = this.table = null;
                }
                if (this.table != null) {
                    context = context.reset().appendSource(this, name, this.table);
                    this.name.setDefinition((DBSObject)this.table, (SQLQuerySymbolOrigin)rowsetRefOrigin);
                } else {
                    tableSymbolClass = statistics.isTreatErrorsAsWarnings() != false ? SQLQuerySymbolClass.TABLE : SQLQuerySymbolClass.ERROR;
                    SQLQueryQualifiedName.performPartialResolution(context, statistics, this.name, (SQLQuerySymbolOrigin)rowsetRefOrigin, Set.of(RelationalObjectType.TYPE_UNKNOWN), tableSymbolClass);
                    context = context.reset();
                    statistics.appendError(this.name.entityName, "Table " + this.name.toIdentifierString() + " not found");
                }
                break block8;
            }
            this.referencedSource = dynamicSource.source;
            referenceName = dynamicSource.referenceName;
            if (referenceName != null && referenceName.qualifiedName() != null) {
                this.name.entityName.setDefinition(referenceName.qualifiedName().entityName);
            }
            context = context.reset().appendSource(this, name, null);
        }
        return context;
    }

    @Override
    @Nullable
    public List<SQLQueryNodeModel> getChildren() {
        return this.referencedSource == null ? null : List.of(this.referencedSource);
    }

    @Override
    protected SQLQueryRowsDataContext resolveRowDataImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryRowsDataContext result;
        block7: {
            if (this.table != null && this.name != null) {
                try {
                    List attributes = this.table.getAttributes(statistics.getMonitor());
                    if (attributes != null) {
                        List<Object> list;
                        Pair<List<SQLQueryResultColumn>, List<SQLQueryResultPseudoColumn>> columns = this.prepareResultColumnsList(this.name.entityName, this.getRowsSources().getDialect(), statistics, (List<? extends DBSEntityAttribute>)attributes);
                        DBSEntity dBSEntity = this.table;
                        if (dBSEntity instanceof DBDPseudoAttributeContainer) {
                            DBDPseudoAttributeContainer pac = (DBDPseudoAttributeContainer)dBSEntity;
                            list = SQLQueryRowsTableDataModel.prepareResultPseudoColumnsList(this.getRowsSources().getDialect(), this, this.table, Stream.of(pac.getAllPseudoAttributes(statistics.getMonitor())).filter(a -> a.getPropagationPolicy().providedByTable));
                        } else {
                            list = Collections.emptyList();
                        }
                        List inferredPseudoColumns = list;
                        List<SQLQueryResultPseudoColumn> pseudoColumns = Stream.of((List)columns.getSecond(), inferredPseudoColumns).flatMap(Collection::stream).collect(Collectors.toList());
                        result = this.getRowsSources().makeTuple((List)columns.getFirst(), pseudoColumns);
                        break block7;
                    }
                    result = this.getRowsSources().makeEmptyTuple();
                }
                catch (DBException ex) {
                    result = this.getRowsSources().makeEmptyTuple();
                    statistics.appendError(this.name.entityName, "Failed to resolve columns of the table " + this.name.toIdentifierString(), ex);
                }
            } else {
                result = this.referencedSource != null ? this.referencedSource.getRowsDataContext() : this.getRowsSources().makeEmptyTuple();
            }
        }
        return result;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsTableData(this, arg);
    }

    private static /* synthetic */ boolean lambda$0(DBDPseudoAttribute a) {
        return a.getPropagationPolicy().providedByTable;
    }
}

