/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.completion;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItem;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemVisitor;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;

public class SQLQueryCompletionExtraTextProvider
implements SQLQueryCompletionItemVisitor<String> {
    public static SQLQueryCompletionExtraTextProvider INSTANCE = new SQLQueryCompletionExtraTextProvider();

    private SQLQueryCompletionExtraTextProvider() {
    }

    @Override
    @NotNull
    public String visitSubqueryAlias(@NotNull SQLQueryCompletionItem.SQLRowsSourceAliasCompletionItem rowsSourceAlias) {
        return rowsSourceAlias.sourceInfo.tableOrNull != null ? " - Table alias" : " - Subquery alias";
    }

    @Nullable
    public static String prepareTypeNameString(@NotNull SQLQueryExprType type) {
        return type == null || type == SQLQueryExprType.UNKNOWN ? null : type.getDisplayName();
    }

    @Override
    @NotNull
    public String visitCompositeField(@NotNull SQLQueryCompletionItem.SQLCompositeFieldCompletionItem compositeField) {
        String typeName = SQLQueryCompletionExtraTextProvider.prepareTypeNameString(compositeField.memberInfo.type());
        return typeName == null ? " - Composite attribute" : " : " + typeName;
    }

    @Override
    @NotNull
    public String visitColumnName(@NotNull SQLQueryCompletionItem.SQLColumnNameCompletionItem columnName) {
        String typeName = SQLQueryCompletionExtraTextProvider.prepareTypeNameString(columnName.columnInfo.type);
        return typeName == null ? " - Column" : " : " + typeName;
    }

    @Override
    @NotNull
    public String visitTableName(@NotNull SQLQueryCompletionItem.SQLTableNameCompletionItem tableName) {
        return DBUtils.isView((DBSEntity)((DBSEntity)tableName.object)) ? " - View " : " - Table ";
    }

    @Override
    @Nullable
    public String visitReservedWord(@Nullable SQLQueryCompletionItem.SQLReservedWordCompletionItem reservedWord) {
        return null;
    }

    @Override
    @NotNull
    public String visitNamedObject(@NotNull SQLQueryCompletionItem.SQLDbNamedObjectCompletionItem namedObject) {
        DBSObject o = namedObject.object;
        String typeName = DBUtils.getObjectTypeName((DBSObject)o);
        if (typeName.equalsIgnoreCase("Object")) {
            typeName = o instanceof DBSSchema ? "Schema" : (o instanceof DBSCatalog ? "Catalog" : "");
        }
        return CommonUtils.isEmpty((String)typeName) ? null : " - " + typeName;
    }

    @Override
    @NotNull
    public String visitJoinCondition(@NotNull SQLQueryCompletionItem.SQLJoinConditionCompletionItem joinCondition) {
        return " - Known foreign key relation";
    }

    @Override
    @NotNull
    public String visitProcedure(@NotNull SQLQueryCompletionItem.SQLProcedureCompletionItem procedure) {
        return switch (((DBSProcedure)procedure.getObject()).getProcedureType()) {
            case DBSProcedureType.FUNCTION -> " - Function";
            case DBSProcedureType.PROCEDURE -> " - Procedure";
            default -> " - Stored routine";
        };
    }

    @Override
    @Nullable
    public String visitBuiltinFunction(@NotNull SQLQueryCompletionItem.SQLBuiltinFunctionCompletionItem function) {
        return " - Builtin function";
    }

    @Override
    @Nullable
    public String visitSpecialText(@NotNull SQLQueryCompletionItem.SQLSpecialTextCompletionItem specialText) {
        return " - Special substitution";
    }
}

