/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.launcher;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;

class LauncherUtils {
    LauncherUtils() {
    }

    static File toFileURL(String spec) {
        try {
            return new File(new URI(spec));
        }
        catch (IllegalArgumentException | URISyntaxException exception) {
            return new File(spec.substring(5));
        }
    }

    static URL adjustTrailingSlash(URL url, boolean trailingSlash) throws MalformedURLException {
        Object file = url.getFile();
        if (trailingSlash == ((String)file).endsWith("/")) {
            return url;
        }
        file = trailingSlash ? (String)file + "/" : ((String)file).substring(0, ((String)file).length() - 1);
        return new URL(url.getProtocol(), url.getHost(), (String)file);
    }

    static boolean canWrite(File installDir) {
        if (!installDir.isDirectory()) {
            return false;
        }
        if (Files.isWritable(installDir.toPath())) {
            return true;
        }
        File fileTest = null;
        try {
            try {
                fileTest = File.createTempFile("writableArea", ".dll", installDir);
            }
            catch (IOException iOException) {
                if (fileTest != null) {
                    fileTest.delete();
                }
                return false;
            }
        }
        finally {
            if (fileTest != null) {
                fileTest.delete();
            }
        }
        return true;
    }
}

