/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import joptsimple.MultipleArgumentsForOptionException;

public class OptionSet {
    private final Map detectedOptions = new HashMap();
    private final List nonOptionArguments = new ArrayList();

    OptionSet() {
    }

    public boolean wasDetected(String option) {
        return this.detectedOptions.containsKey(option);
    }

    public boolean has(String option) {
        return this.wasDetected(option);
    }

    public boolean hasArgument(String option) {
        return !this.valuesOf(option).isEmpty();
    }

    public String argumentOf(String option) {
        return (String)this.valueOf(option);
    }

    public List argumentsOf(String option) {
        return this.valuesOf(option);
    }

    public Object valueOf(String option) {
        List values = this.valuesOf(option);
        switch (values.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return values.get(0);
            }
        }
        throw new MultipleArgumentsForOptionException(option);
    }

    public List valuesOf(String option) {
        List values = (List)this.detectedOptions.get(option);
        return values == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(values);
    }

    public List nonOptionArguments() {
        return Collections.unmodifiableList(this.nonOptionArguments);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !this.getClass().equals(that.getClass())) {
            return false;
        }
        OptionSet other = (OptionSet)that;
        return ((Object)this.detectedOptions).equals(other.detectedOptions) && ((Object)this.nonOptionArguments).equals(other.nonOptionArguments());
    }

    public int hashCode() {
        return ((Object)this.detectedOptions).hashCode() ^ ((Object)this.nonOptionArguments).hashCode();
    }

    void add(String option) {
        this.addWithArgument(option, null);
    }

    void addWithArgument(String option, Object argument) {
        ArrayList<Object> optionArguments = (ArrayList<Object>)this.detectedOptions.get(option);
        if (optionArguments == null) {
            optionArguments = new ArrayList<Object>();
            this.detectedOptions.put(option, optionArguments);
        }
        if (argument != null) {
            optionArguments.add(argument);
        }
    }

    void addNonOptionArgument(String argument) {
        this.nonOptionArguments.add(argument);
    }

    void addAll(List options) {
        Iterator iter = options.iterator();
        while (iter.hasNext()) {
            this.add((String)iter.next());
        }
    }

    void addAllWithArgument(List options, Object argument) {
        Iterator iter = options.iterator();
        while (iter.hasNext()) {
            this.addWithArgument((String)iter.next(), argument);
        }
    }
}

