/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;

public abstract class WizardController
implements Controller {
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final PropertyChangeSupport propertyChangeSupport;
    private final PropertyChangeListener stepStatePropertyChangeListener;
    private DialogView wizardView;
    private WizardControllerStepState stepState;
    private boolean backStepEnabled;
    private boolean nextStepEnabled;
    private boolean lastStep;
    private View stepView;
    private URL stepIcon;
    private String title;
    private boolean resizable;

    public WizardController(UserPreferences userPreferences, ViewFactory viewFactory) {
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.stepStatePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                switch (WizardControllerStepState.Property.valueOf(propertyChangeEvent.getPropertyName()).ordinal()) {
                    case 1: {
                        WizardController.this.setBackStepEnabled(!WizardController.this.stepState.isFirstStep());
                        break;
                    }
                    case 2: {
                        WizardController.this.setLastStep(WizardController.this.stepState.isLastStep());
                        break;
                    }
                    case 0: {
                        WizardController.this.setNextStepEnabled(WizardController.this.stepState.isNextStepEnabled());
                    }
                }
            }
        };
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public DialogView getView() {
        if (this.wizardView == null) {
            this.wizardView = this.viewFactory.createWizardView(this.preferences, this);
        }
        return this.wizardView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    private void setBackStepEnabled(boolean bl) {
        if (bl != this.backStepEnabled) {
            this.backStepEnabled = bl;
            this.propertyChangeSupport.firePropertyChange(Property.BACK_STEP_ENABLED.name(), !bl, bl);
        }
    }

    public boolean isBackStepEnabled() {
        return this.backStepEnabled;
    }

    private void setNextStepEnabled(boolean bl) {
        if (bl != this.nextStepEnabled) {
            this.nextStepEnabled = bl;
            this.propertyChangeSupport.firePropertyChange(Property.NEXT_STEP_ENABLED.name(), !bl, bl);
        }
    }

    public boolean isNextStepEnabled() {
        return this.nextStepEnabled;
    }

    private void setLastStep(boolean bl) {
        if (bl != this.lastStep) {
            this.lastStep = bl;
            this.propertyChangeSupport.firePropertyChange(Property.LAST_STEP.name(), !bl, bl);
        }
    }

    public boolean isLastStep() {
        return this.lastStep;
    }

    private void setStepView(View view) {
        if (view != this.stepView) {
            View view2 = this.stepView;
            this.stepView = view;
            this.propertyChangeSupport.firePropertyChange(Property.STEP_VIEW.name(), view2, view);
        }
    }

    public View getStepView() {
        return this.stepView;
    }

    private void setStepIcon(URL uRL) {
        if (uRL != this.stepIcon) {
            URL uRL2 = this.stepIcon;
            this.stepIcon = uRL;
            this.propertyChangeSupport.firePropertyChange(Property.STEP_ICON.name(), uRL2, uRL);
        }
    }

    public URL getStepIcon() {
        return this.stepIcon;
    }

    public void setTitle(String string) {
        if (string != this.title) {
            String string2 = this.title;
            this.title = string;
            this.propertyChangeSupport.firePropertyChange(Property.TITLE.name(), string2, string);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setResizable(boolean bl) {
        if (bl != this.resizable) {
            this.resizable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.RESIZABLE.name(), !bl, bl);
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    protected void setStepState(WizardControllerStepState wizardControllerStepState) {
        if (this.stepState != null) {
            this.stepState.exit();
            this.stepState.removePropertyChangeListener(this.stepStatePropertyChangeListener);
        }
        this.stepState = wizardControllerStepState;
        this.setBackStepEnabled(!wizardControllerStepState.isFirstStep());
        this.setNextStepEnabled(wizardControllerStepState.isNextStepEnabled());
        this.setStepView(wizardControllerStepState.getView());
        this.setStepIcon(wizardControllerStepState.getIcon());
        this.setLastStep(wizardControllerStepState.isLastStep());
        this.stepState.addPropertyChangeListener(this.stepStatePropertyChangeListener);
        this.stepState.enter();
    }

    protected WizardControllerStepState getStepState() {
        return this.stepState;
    }

    public void goToNextStep() {
        this.stepState.goToNextStep();
    }

    public void goBackToPreviousStep() {
        this.stepState.goBackToPreviousStep();
    }

    public abstract void finish();

    protected static abstract class WizardControllerStepState {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
        private boolean firstStep;
        private boolean lastStep;
        private boolean nextStepEnabled;

        private void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        private void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        public void enter() {
        }

        public void exit() {
        }

        public abstract View getView();

        public URL getIcon() {
            return null;
        }

        public void goBackToPreviousStep() {
        }

        public void goToNextStep() {
        }

        public boolean isFirstStep() {
            return this.firstStep;
        }

        public void setFirstStep(boolean bl) {
            if (bl != this.firstStep) {
                this.firstStep = bl;
                this.propertyChangeSupport.firePropertyChange(Property.FIRST_STEP.name(), !bl, bl);
            }
        }

        public boolean isLastStep() {
            return this.lastStep;
        }

        public void setLastStep(boolean bl) {
            if (bl != this.lastStep) {
                this.lastStep = bl;
                this.propertyChangeSupport.firePropertyChange(Property.LAST_STEP.name(), !bl, bl);
            }
        }

        public boolean isNextStepEnabled() {
            return this.nextStepEnabled;
        }

        public void setNextStepEnabled(boolean bl) {
            if (bl != this.nextStepEnabled) {
                this.nextStepEnabled = bl;
                this.propertyChangeSupport.firePropertyChange(Property.NEXT_STEP_ENABLED.name(), !bl, bl);
            }
        }

        private static enum Property {
            NEXT_STEP_ENABLED,
            FIRST_STEP,
            LAST_STEP;

        }
    }

    public static enum Property {
        BACK_STEP_ENABLED,
        NEXT_STEP_ENABLED,
        LAST_STEP,
        STEP_VIEW,
        STEP_ICON,
        TITLE,
        RESIZABLE;

    }
}

