/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.AbstractPhotoRenderer;
import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.model.AspectRatio;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.HomeComponent3D;
import com.eteks.sweethome3d.swing.PhotoSizeAndQualityPanel;
import com.eteks.sweethome3d.swing.PlanComponent;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.Object3DFactory;
import com.eteks.sweethome3d.viewcontroller.VideoController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Point3f;

public class VideoPanel
extends JPanel
implements DialogView {
    private static final String VIDEO_DIALOG_X_VISUAL_PROPERTY = "com.eteks.sweethome3d.swing.VideoPanel.VideoDialogX";
    private static final String VIDEO_DIALOG_Y_VISUAL_PROPERTY = "com.eteks.sweethome3d.swing.VideoPanel.VideoDialogY";
    private static final String VIDEO_DIALOG_WIDTH_VISUAL_PROPERTY = "com.eteks.sweethome3d.swing.VideoPanel.VideoDialogWidth";
    private static final String VIDEO_DIALOG_HEIGHT_VISUAL_PROPERTY = "com.eteks.sweethome3d.swing.VideoPanel.VideoDialogHeight";
    private static final int MINIMUM_DELAY_BEFORE_DISCARDING_WITHOUT_WARNING = 30000;
    private static final VideoFormat[] VIDEO_FORMATS = new VideoFormat[]{new VideoFormat("jpeg", new Dimension(176, 132), -1, Format.byteArray, 12.0f), new VideoFormat("jpeg", new Dimension(320, 240), -1, Format.byteArray, 25.0f), new VideoFormat("jpeg", new Dimension(480, 360), -1, Format.byteArray, 25.0f), new VideoFormat("jpeg", new Dimension(640, 480), -1, Format.byteArray, 25.0f), new VideoFormat("jpeg", new Dimension(720, 540), -1, Format.byteArray, 25.0f), new VideoFormat("jpeg", new Dimension(1024, 768), -1, Format.byteArray, 25.0f), new VideoFormat("jpeg", new Dimension(1280, 960), -1, Format.byteArray, 25.0f), new VideoFormat("jpeg", new Dimension(720, 405), -1, Format.byteArray, 25.0f), new VideoFormat("jpeg", new Dimension(1280, 536), -1, Format.byteArray, 25.0f), new VideoFormat("jpeg", new Dimension(1280, 720), -1, Format.byteArray, 25.0f), new VideoFormat("jpeg", new Dimension(1920, 800), -1, Format.byteArray, 25.0f), new VideoFormat("jpeg", new Dimension(1920, 1080), -1, Format.byteArray, 25.0f), new VideoFormat("jpeg", new Dimension(3840, 2160), -1, Format.byteArray, 25.0f), new VideoFormat("jpeg", new Dimension(4096, 1728), -1, Format.byteArray, 25.0f), new VideoFormat("jpeg", new Dimension(7680, 4320), -1, Format.byteArray, 25.0f)};
    private static final String TIP_CARD = "tip";
    private static final String PROGRESS_CARD = "progress";
    private final Home home;
    private final UserPreferences preferences;
    private final Object3DFactory object3dFactory;
    private final VideoController controller;
    private PlanComponent planComponent;
    private JToolBar videoToolBar;
    private JButton playbackPauseButton;
    private Timer playbackTimer;
    private ListIterator<Camera> cameraPathIterator;
    private CardLayout statusLayout;
    private JPanel statusPanel;
    private JLabel tipLabel;
    private JLabel progressLabel;
    private JProgressBar progressBar;
    private JLabel videoFormatLabel;
    private JComboBox videoFormatComboBox;
    private String videoFormatComboBoxFormat;
    private JLabel qualityLabel;
    private JSlider qualitySlider;
    private Component advancedComponentsSeparator;
    private JLabel dateLabel;
    private JSpinner dateSpinner;
    private JLabel timeLabel;
    private JSpinner timeSpinner;
    private JLabel dayNightLabel;
    private JLabel rendererLabel;
    private JComboBox rendererComboBox;
    private JCheckBox ceilingLightEnabledCheckBox;
    private String dialogTitle;
    private ExecutorService videoCreationExecutor;
    private long videoCreationStartTime;
    private File videoFile;
    private JButton createButton;
    private JButton saveButton;
    private JButton closeButton;
    private static VideoPanel currentVideoPanel;

    public VideoPanel(Home home, UserPreferences userPreferences, VideoController videoController) {
        this(home, userPreferences, null, videoController);
    }

    public VideoPanel(Home home, UserPreferences userPreferences, Object3DFactory object3DFactory, VideoController videoController) {
        super(new GridBagLayout());
        this.home = home;
        this.preferences = userPreferences;
        this.object3dFactory = object3DFactory;
        this.controller = videoController;
        this.createActions(userPreferences);
        this.createComponents(home, userPreferences, videoController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(this));
    }

    private void createActions(UserPreferences userPreferences) {
        ActionMap actionMap = this.getActionMap();
        actionMap.put((Object)ActionType.PLAYBACK, new ResourceAction(userPreferences, VideoPanel.class, ActionType.PLAYBACK.name()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoPanel.this.playback();
            }
        });
        actionMap.put((Object)ActionType.PAUSE, new ResourceAction(userPreferences, VideoPanel.class, ActionType.PAUSE.name(), true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoPanel.this.pausePlayback();
            }
        });
        actionMap.put((Object)ActionType.RECORD, new ResourceAction(userPreferences, VideoPanel.class, ActionType.RECORD.name(), true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoPanel.this.recordCameraLocation();
            }
        });
        actionMap.put((Object)ActionType.SEEK_BACKWARD, new ResourceAction(userPreferences, VideoPanel.class, ActionType.SEEK_BACKWARD.name()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoPanel.this.seekBackward();
            }
        });
        actionMap.put((Object)ActionType.SEEK_FORWARD, new ResourceAction(userPreferences, VideoPanel.class, ActionType.SEEK_FORWARD.name()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoPanel.this.seekForward();
            }
        });
        actionMap.put((Object)ActionType.SKIP_BACKWARD, new ResourceAction(userPreferences, VideoPanel.class, ActionType.SKIP_BACKWARD.name()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoPanel.this.skipBackward();
            }
        });
        actionMap.put((Object)ActionType.SKIP_FORWARD, new ResourceAction(userPreferences, VideoPanel.class, ActionType.SKIP_FORWARD.name()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoPanel.this.skipForward();
            }
        });
        actionMap.put((Object)ActionType.DELETE_LAST_RECORD, new ResourceAction(userPreferences, VideoPanel.class, ActionType.DELETE_LAST_RECORD.name()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoPanel.this.deleteLastRecordedCameraLocation();
            }
        });
        actionMap.put((Object)ActionType.DELETE_CAMERA_PATH, new ResourceAction(userPreferences, VideoPanel.class, ActionType.DELETE_CAMERA_PATH.name()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoPanel.this.deleteCameraPath();
            }
        });
        actionMap.put((Object)ActionType.START_VIDEO_CREATION, new ResourceAction(userPreferences, VideoPanel.class, ActionType.START_VIDEO_CREATION.name()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoPanel.this.startVideoCreation();
            }
        });
        actionMap.put((Object)ActionType.STOP_VIDEO_CREATION, new ResourceAction(userPreferences, VideoPanel.class, ActionType.STOP_VIDEO_CREATION.name(), true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoPanel.this.stopVideoCreation(true);
            }
        });
        actionMap.put((Object)ActionType.SAVE_VIDEO, new ResourceAction(userPreferences, VideoPanel.class, ActionType.SAVE_VIDEO.name()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoPanel.this.saveVideo();
            }
        });
        actionMap.put((Object)ActionType.CLOSE, new ResourceAction(userPreferences, VideoPanel.class, ActionType.CLOSE.name(), true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoPanel.this.close();
            }
        });
    }

    private void createComponents(final Home home, final UserPreferences userPreferences, final VideoController videoController) {
        Serializable serializable;
        Object object;
        final Dimension dimension = new Dimension(this.getToolkit().getScreenSize().width <= 1024 ? 324 : 404, 404);
        this.planComponent = new PlanComponent(home, userPreferences, null){

            private void updateScale() {
                if (this.getWidth() > 0 && this.getHeight() > 0) {
                    float f = this.getScale();
                    Dimension dimension2 = super.getPreferredSize();
                    Insets insets = this.getInsets();
                    float f2 = (float)(dimension2.width - insets.left - insets.right) / f;
                    float f3 = (float)(dimension2.height - insets.top - insets.bottom) / f;
                    this.setScale(Math.min((float)(this.getWidth() - insets.left - insets.right) / f2, (float)(this.getHeight() - insets.top - insets.bottom) / f3));
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return dimension;
            }

            @Override
            public void revalidate() {
                super.revalidate();
                this.updateScale();
            }

            @Override
            public void setBounds(int n, int n2, int n3, int n4) {
                super.setBounds(n, n2, n3, n4);
                this.updateScale();
            }

            @Override
            protected List<Selectable> getPaintedItems() {
                List<Selectable> list = super.getPaintedItems();
                for (Camera camera : videoController.getCameraPath()) {
                    list.add(new ObserverCamera(camera.getX(), camera.getY(), camera.getZ(), camera.getYaw(), camera.getPitch(), camera.getFieldOfView()));
                }
                return list;
            }

            @Override
            protected Rectangle2D getItemBounds(Graphics graphics, Selectable selectable) {
                if (selectable instanceof ObserverCamera) {
                    return new Rectangle2D.Float(((ObserverCamera)selectable).getX() - 1.0f, ((ObserverCamera)selectable).getY() - 1.0f, 2.0f, 2.0f);
                }
                return super.getItemBounds(graphics, selectable);
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(graphics);
            }

            @Override
            protected void paintHomeItems(Graphics graphics, Level level, float f, Color color, Color color2, PlanComponent.PaintMode paintMode) throws InterruptedIOException {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.25f));
                super.paintHomeItems(graphics, level, f, color, color2, paintMode);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                graphics2D.setColor(this.getSelectionColor());
                float f2 = 7.0f / this.getScale();
                Ellipse2D.Float float_ = new Ellipse2D.Float(-f2, -f2, 2.0f * f2, 2.0f * f2);
                List<Camera> list = videoController.getCameraPath();
                for (int i = 0; i < list.size(); ++i) {
                    Camera camera = list.get(i);
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.translate(camera.getX(), camera.getY());
                    graphics2D.rotate(camera.getYaw());
                    graphics2D.fill(float_);
                    double d = (float)Math.sin(camera.getFieldOfView() / 2.0f);
                    double d2 = (float)Math.cos(camera.getFieldOfView() / 2.0f);
                    float f3 = (float)((double)(1.2f * f2) * d);
                    float f4 = (float)((double)(1.2f * f2) * d2);
                    float f5 = (float)((double)(2.5f * f2) * d);
                    float f6 = (float)((double)(2.5f * f2) * d2);
                    GeneralPath generalPath = new GeneralPath();
                    graphics2D.setStroke(new BasicStroke(1.0f / this.getScale()));
                    generalPath.moveTo(f3, f4);
                    generalPath.lineTo(f5, f6);
                    generalPath.moveTo(-f3, f4);
                    generalPath.lineTo(-f5, f6);
                    graphics2D.draw(generalPath);
                    graphics2D.setTransform(affineTransform);
                    if (i <= 0) continue;
                    graphics2D.setStroke(new BasicStroke(2.0f / this.getScale()));
                    graphics2D.draw(new Line2D.Float(camera.getX(), camera.getY(), list.get(i - 1).getX(), list.get(i - 1).getY()));
                }
                graphics2D.setComposite(composite);
            }
        };
        this.planComponent.setSelectedItemsOutlinePainted(false);
        this.planComponent.setBackgroundPainted(false);
        this.planComponent.setBorder(BorderFactory.createEtchedBorder());
        this.controller.addPropertyChangeListener(VideoController.Property.CAMERA_PATH, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                VideoPanel.this.planComponent.revalidate();
                VideoPanel.this.updatePlaybackTimer();
            }
        });
        this.videoToolBar = new JToolBar();
        this.videoToolBar.setFloatable(false);
        ActionMap actionMap = this.getActionMap();
        this.videoToolBar.add(actionMap.get((Object)ActionType.DELETE_CAMERA_PATH));
        this.videoToolBar.addSeparator();
        this.videoToolBar.add(actionMap.get((Object)ActionType.SKIP_BACKWARD));
        this.videoToolBar.add(actionMap.get((Object)ActionType.SEEK_BACKWARD));
        this.videoToolBar.add(actionMap.get((Object)ActionType.RECORD));
        this.playbackPauseButton = new JButton(actionMap.get((Object)ActionType.PLAYBACK));
        this.videoToolBar.add(this.playbackPauseButton);
        this.videoToolBar.add(actionMap.get((Object)ActionType.SEEK_FORWARD));
        this.videoToolBar.add(actionMap.get((Object)ActionType.SKIP_FORWARD));
        this.videoToolBar.addSeparator();
        this.videoToolBar.add(actionMap.get((Object)ActionType.DELETE_LAST_RECORD));
        for (int i = 0; i < this.videoToolBar.getComponentCount(); ++i) {
            object = this.videoToolBar.getComponent(i);
            if (!(object instanceof JButton)) continue;
            serializable = (JButton)object;
            serializable.setBorderPainted(true);
            serializable.setFocusable(true);
        }
        this.tipLabel = new JLabel();
        Font font = UIManager.getFont("ToolTip.font");
        this.tipLabel.setFont(font);
        this.progressLabel = new JLabel();
        this.progressLabel.setFont(font);
        this.progressLabel.setHorizontalAlignment(0);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.getModel().addChangeListener(new ChangeListener(){
            private long timeAfterFirstImage;

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = VideoPanel.this.progressBar.getValue();
                VideoPanel.this.progressBar.setIndeterminate(n <= VideoPanel.this.progressBar.getMinimum() + 1);
                if (n == VideoPanel.this.progressBar.getMinimum() || n == VideoPanel.this.progressBar.getMaximum()) {
                    VideoPanel.this.progressLabel.setText("");
                    if (n == VideoPanel.this.progressBar.getMinimum()) {
                        int n2 = VideoPanel.this.progressBar.getMaximum() - VideoPanel.this.progressBar.getMinimum();
                        String string = userPreferences.getLocalizedString(VideoPanel.class, "progressStartLabel.format", new Object[0]);
                        VideoPanel.this.progressLabel.setText(String.format(string, n2, this.formatDuration(n2 * 1000 / videoController.getFrameRate())));
                    }
                } else if (n == VideoPanel.this.progressBar.getMinimum() + 1) {
                    this.timeAfterFirstImage = System.currentTimeMillis();
                } else {
                    String string = userPreferences.getLocalizedString(VideoPanel.class, "progressLabel.format", new Object[0]);
                    long l = (System.currentTimeMillis() - this.timeAfterFirstImage) / (long)(n - 1 - VideoPanel.this.progressBar.getMinimum()) * (long)(VideoPanel.this.progressBar.getMaximum() - n - 1);
                    String string2 = this.formatDuration(l);
                    VideoPanel.this.progressLabel.setText(String.format(string, n, VideoPanel.this.progressBar.getMaximum(), string2));
                }
            }

            private String formatDuration(long l) {
                String string;
                long l2 = l / 1000L;
                if (l - l2 * 1000L >= 500L) {
                    ++l2;
                }
                if (l2 < 60L) {
                    string = String.format(userPreferences.getLocalizedString(VideoPanel.class, "seconds.format", new Object[0]), l2);
                } else if (l2 < 3600L) {
                    string = String.format(userPreferences.getLocalizedString(VideoPanel.class, "minutesSeconds.format", new Object[0]), l2 / 60L, l2 % 60L);
                } else {
                    long l3 = l2 / 3600L;
                    long l4 = l2 % 3600L / 60L;
                    string = String.format(userPreferences.getLocalizedString(VideoPanel.class, "hoursMinutes.format", new Object[0]), l3, l4);
                }
                return string;
            }
        });
        this.videoFormatLabel = new JLabel();
        this.videoFormatComboBox = new JComboBox<VideoFormat>(VIDEO_FORMATS);
        this.videoFormatComboBox.setMaximumRowCount(VIDEO_FORMATS.length);
        this.videoFormatComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string;
                VideoFormat videoFormat = (VideoFormat)object;
                Dimension dimension = videoFormat.getSize();
                switch (VideoPanel.this.getAspectRatio(dimension.width, dimension.height)) {
                    case RATIO_4_3: {
                        string = userPreferences.getLocalizedString(PhotoSizeAndQualityPanel.class, "aspectRatioComboBox.4_3Ratio.text", new Object[0]);
                        break;
                    }
                    case RATIO_24_10: {
                        string = userPreferences.getLocalizedString(PhotoSizeAndQualityPanel.class, "aspectRatioComboBox.2.40_1Ratio.text", new Object[0]);
                        break;
                    }
                    default: {
                        string = userPreferences.getLocalizedString(PhotoSizeAndQualityPanel.class, "aspectRatioComboBox.16_9Ratio.text", new Object[0]);
                    }
                }
                Dimension dimension2 = dimension;
                String string2 = String.format(VideoPanel.this.videoFormatComboBoxFormat, dimension2.width, dimension2.height, string, (int)videoFormat.getFrameRate());
                return super.getListCellRendererComponent((JList<?>)jList, string2, n, bl, bl2);
            }
        });
        this.videoFormatComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                VideoFormat videoFormat = (VideoFormat)VideoPanel.this.videoFormatComboBox.getSelectedItem();
                Dimension dimension = videoFormat.getSize();
                videoController.setWidth(videoFormat.getSize().width);
                videoController.setAspectRatio(VideoPanel.this.getAspectRatio(dimension.width, dimension.height));
                videoController.setFrameRate((int)videoFormat.getFrameRate());
            }
        });
        object = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                VideoPanel.this.videoFormatComboBox.setSelectedItem(VideoPanel.this.getVideoFormat(videoController.getWidth(), videoController.getAspectRatio(), videoController.getFrameRate()));
            }
        };
        videoController.addPropertyChangeListener(VideoController.Property.WIDTH, (PropertyChangeListener)object);
        videoController.addPropertyChangeListener(VideoController.Property.HEIGHT, (PropertyChangeListener)object);
        videoController.addPropertyChangeListener(VideoController.Property.ASPECT_RATIO, (PropertyChangeListener)object);
        videoController.addPropertyChangeListener(VideoController.Property.FRAME_RATE, (PropertyChangeListener)object);
        this.qualityLabel = new JLabel();
        try {
            serializable = SwingTools.getImageSizeInPixels(new ResourceURLContent(PhotoSizeAndQualityPanel.class, "resources/quality0.jpg"));
        }
        catch (IOException iOException) {
            serializable = null;
        }
        float f = SwingTools.getResolutionScale();
        final int n = (int)((float)((Dimension)serializable).width * f);
        final int n2 = (int)((float)((Dimension)serializable).height * f);
        this.qualitySlider = new JSlider(1, videoController.getQualityLevelCount()){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                float f = VideoPanel.this.getSliderValueAt(this, mouseEvent.getX(), userPreferences);
                float f2 = f - (float)Math.floor(f);
                if (f2 < 0.25f || f2 > 0.75f) {
                    URL uRL = new ResourceURLContent(VideoPanel.class, "resources/quality" + Math.round(f - (float)VideoPanel.this.qualitySlider.getMinimum()) + ".jpg").getURL();
                    String string = "<td><img border='1' width='" + n + "' height='" + n2 + "' src='" + uRL + "'></td>";
                    String string2 = userPreferences.getLocalizedString(PhotoSizeAndQualityPanel.class, "quality" + Math.round(f - (float)VideoPanel.this.qualitySlider.getMinimum()) + "DescriptionLabel.text", new Object[0]);
                    boolean bl = VideoPanel.this.qualitySlider.getComponentOrientation().isLeftToRight();
                    String string3 = "<td align='" + (bl ? "left" : "right") + "'>" + string2 + "</td>";
                    return "<html><table><tr valign='middle'>" + (bl ? string + string3 : string3 + string) + "</tr></table>";
                }
                return null;
            }
        };
        this.qualitySlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent mouseEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        float f = VideoPanel.this.getSliderValueAt(VideoPanel.this.qualitySlider, mouseEvent.getX(), userPreferences);
                        if (VideoPanel.this.qualitySlider.getValue() == Math.round(f)) {
                            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                            int n = toolTipManager.getInitialDelay();
                            toolTipManager.setInitialDelay(Math.min(n, 150));
                            toolTipManager.mouseMoved(mouseEvent);
                            toolTipManager.setInitialDelay(n);
                        }
                    }
                });
            }
        });
        this.qualitySlider.setPaintLabels(true);
        this.qualitySlider.setPaintTicks(true);
        this.qualitySlider.setMajorTickSpacing(1);
        this.qualitySlider.setSnapToTicks(true);
        final boolean bl = Component3DManager.getInstance().isOffScreenImageSupported();
        this.qualitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!bl) {
                    VideoPanel.this.qualitySlider.setValue(Math.max(VideoPanel.this.qualitySlider.getMinimum() + 2, VideoPanel.this.qualitySlider.getValue()));
                }
                videoController.setQuality(VideoPanel.this.qualitySlider.getValue() - VideoPanel.this.qualitySlider.getMinimum());
            }
        });
        videoController.addPropertyChangeListener(VideoController.Property.QUALITY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                VideoPanel.this.qualitySlider.setValue(VideoPanel.this.qualitySlider.getMinimum() + videoController.getQuality());
                VideoPanel.this.updateAdvancedComponents();
            }
        });
        this.qualitySlider.setValue(this.qualitySlider.getMinimum() + videoController.getQuality());
        this.advancedComponentsSeparator = new JSeparator();
        Date date = new Date(Camera.convertTimeToTimeZone(videoController.getTime(), TimeZone.getDefault().getID()));
        this.dateLabel = new JLabel();
        final SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
        spinnerDateModel.setValue(date);
        this.dateSpinner = new JSpinner(spinnerDateModel);
        String string = ((SimpleDateFormat)DateFormat.getDateInstance(3)).toPattern();
        if (string.indexOf("yyyy") == -1) {
            string = string.replace("yy", "yyyy");
        }
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.dateSpinner, string);
        this.dateSpinner.setEditor(dateEditor);
        SwingTools.addAutoSelectionOnFocusGain(dateEditor.getTextField());
        this.timeLabel = new JLabel();
        final SpinnerDateModel spinnerDateModel2 = new SpinnerDateModel();
        spinnerDateModel2.setValue(date);
        this.timeSpinner = new JSpinner(spinnerDateModel2);
        Object[] objectArray = new String[]{"AU", "BD", "CA", "CO", "EG", "HN", "JO", "MX", "MY", "NI", "NZ", "PH", "PK", "SA", "SV", "US", "VE"};
        SimpleDateFormat simpleDateFormat = "en".equals(Locale.getDefault().getLanguage()) ? (Arrays.binarySearch(objectArray, Locale.getDefault().getCountry()) >= 0 ? (SimpleDateFormat)DateFormat.getTimeInstance(3, Locale.US) : (SimpleDateFormat)DateFormat.getTimeInstance(3, Locale.UK)) : (SimpleDateFormat)DateFormat.getTimeInstance(3);
        JSpinner.DateEditor dateEditor2 = new JSpinner.DateEditor(this.timeSpinner, simpleDateFormat.toPattern());
        this.timeSpinner.setEditor(dateEditor2);
        SwingTools.addAutoSelectionOnFocusGain(dateEditor2.getTextField());
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Date date = new Date(Camera.convertTimeToTimeZone(videoController.getTime(), TimeZone.getDefault().getID()));
                spinnerDateModel.setValue(date);
                spinnerDateModel2.setValue(date);
            }
        };
        videoController.addPropertyChangeListener(VideoController.Property.TIME, propertyChangeListener);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                videoController.removePropertyChangeListener(VideoController.Property.TIME, propertyChangeListener);
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime((Date)spinnerDateModel.getValue());
                GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
                gregorianCalendar2.setTime((Date)spinnerDateModel2.getValue());
                GregorianCalendar gregorianCalendar3 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                gregorianCalendar3.set(1, gregorianCalendar.get(1));
                gregorianCalendar3.set(2, gregorianCalendar.get(2));
                gregorianCalendar3.set(5, gregorianCalendar.get(5));
                gregorianCalendar3.set(11, gregorianCalendar2.get(11));
                gregorianCalendar3.set(12, gregorianCalendar2.get(12));
                gregorianCalendar3.set(13, gregorianCalendar2.get(13));
                videoController.setTime(gregorianCalendar3.getTimeInMillis());
                videoController.addPropertyChangeListener(VideoController.Property.TIME, propertyChangeListener);
            }
        };
        spinnerDateModel.addChangeListener(changeListener);
        spinnerDateModel2.addChangeListener(changeListener);
        this.dayNightLabel = new JLabel();
        final ImageIcon imageIcon = SwingTools.getScaledImageIcon(VideoPanel.class.getResource("resources/day.png"));
        final ImageIcon imageIcon2 = SwingTools.getScaledImageIcon(VideoPanel.class.getResource("resources/night.png"));
        PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (home.getCompass().getSunElevation(Camera.convertTimeToTimeZone(videoController.getTime(), home.getCompass().getTimeZone())) > 0.0f) {
                    VideoPanel.this.dayNightLabel.setIcon(imageIcon);
                } else {
                    VideoPanel.this.dayNightLabel.setIcon(imageIcon2);
                }
            }
        };
        videoController.addPropertyChangeListener(VideoController.Property.TIME, propertyChangeListener2);
        home.getCompass().addPropertyChangeListener(propertyChangeListener2);
        propertyChangeListener2.propertyChange(null);
        this.rendererLabel = new JLabel();
        this.rendererComboBox = new JComboBox<Object>(AbstractPhotoRenderer.getAvailableRenderers().toArray());
        this.rendererComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string = AbstractPhotoRenderer.createInstance((String)object, home, VideoPanel.this.object3dFactory, AbstractPhotoRenderer.Quality.LOW).getName();
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        });
        this.rendererComboBox.setSelectedItem(videoController.getRenderer());
        videoController.addPropertyChangeListener(VideoController.Property.RENDERER, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                VideoPanel.this.rendererComboBox.setSelectedItem(videoController.getRenderer());
            }
        });
        this.rendererComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)VideoPanel.this.rendererComboBox.getSelectedItem();
                videoController.setRenderer(string);
            }
        });
        this.ceilingLightEnabledCheckBox = new JCheckBox();
        this.ceilingLightEnabledCheckBox.setSelected(videoController.getCeilingLightColor() > 0);
        videoController.addPropertyChangeListener(VideoController.Property.CEILING_LIGHT_COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                VideoPanel.this.ceilingLightEnabledCheckBox.setSelected(videoController.getCeilingLightColor() > 0);
            }
        });
        this.ceilingLightEnabledCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                videoController.setCeilingLightColor(VideoPanel.this.ceilingLightEnabledCheckBox.isSelected() ? 0xD0D0D0 : 0);
            }
        });
        this.createButton = new JButton(actionMap.get((Object)ActionType.START_VIDEO_CREATION));
        this.saveButton = new JButton(actionMap.get((Object)ActionType.SAVE_VIDEO));
        this.closeButton = new JButton(actionMap.get((Object)ActionType.CLOSE));
        this.setComponentTexts(userPreferences);
        this.updatePlaybackTimer();
        this.videoFormatComboBox.setSelectedItem(this.getVideoFormat(videoController.getWidth(), videoController.getAspectRatio(), videoController.getFrameRate()));
    }

    private VideoFormat getVideoFormat(int n, AspectRatio aspectRatio, int n2) {
        for (VideoFormat videoFormat : VIDEO_FORMATS) {
            if (videoFormat.getSize().width != n || this.getAspectRatio(videoFormat.getSize().width, videoFormat.getSize().height) != aspectRatio || videoFormat.getFrameRate() != (float)n2) continue;
            return videoFormat;
        }
        return VIDEO_FORMATS[0];
    }

    private float getSliderValueAt(JSlider jSlider, int n, UserPreferences userPreferences) {
        int n2 = OperatingSystem.isLinux() ? 0 : new JLabel((String)SwingTools.getLocalizedLabelText((UserPreferences)userPreferences, VideoPanel.class, (String)"fastLabel.text", (Object[])new Object[0])).getPreferredSize().width / 2;
        int n3 = OperatingSystem.isLinux() ? 0 : new JLabel((String)SwingTools.getLocalizedLabelText((UserPreferences)userPreferences, VideoPanel.class, (String)"bestLabel.text", (Object[])new Object[0])).getPreferredSize().width / 2;
        int n4 = jSlider.getWidth() - n2 - n3;
        return (float)jSlider.getMinimum() + (float)(jSlider.getComponentOrientation().isLeftToRight() ? n - n2 : n4 - n + n3) / (float)n4 * (float)(jSlider.getMaximum() - jSlider.getMinimum());
    }

    private void setComponentTexts(UserPreferences userPreferences) {
        this.tipLabel.setText(userPreferences.getLocalizedString(VideoPanel.class, "tipLabel.text", new Object[0]));
        this.videoFormatLabel.setText(userPreferences.getLocalizedString(VideoPanel.class, "videoFormatLabel.text", new Object[0]));
        this.videoFormatComboBoxFormat = userPreferences.getLocalizedString(VideoPanel.class, "videoFormatComboBox.format", new Object[0]);
        this.qualityLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, VideoPanel.class, "qualityLabel.text", new Object[0]));
        this.dateLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, VideoPanel.class, "dateLabel.text", new Object[0]));
        this.timeLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, VideoPanel.class, "timeLabel.text", new Object[0]));
        this.rendererLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, VideoPanel.class, "rendererLabel.text", new Object[0]));
        this.ceilingLightEnabledCheckBox.setText(SwingTools.getLocalizedLabelText(userPreferences, VideoPanel.class, "ceilingLightEnabledCheckBox.text", new Object[0]));
        JLabel jLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, VideoPanel.class, "fastLabel.text", new Object[0]));
        if (!Component3DManager.getInstance().isOffScreenImageSupported()) {
            jLabel.setEnabled(false);
        }
        JLabel jLabel2 = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, VideoPanel.class, "bestLabel.text", new Object[0]));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(this.qualitySlider.getMinimum(), jLabel);
        ((Dictionary)hashtable).put(this.qualitySlider.getMaximum(), jLabel2);
        this.qualitySlider.setLabelTable(hashtable);
        this.dialogTitle = userPreferences.getLocalizedString(VideoPanel.class, "createVideo.title", new Object[0]);
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            ((JDialog)window).setTitle(this.dialogTitle);
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.videoFormatLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(VideoPanel.class, "videoFormatLabel.mnemonic", new Object[0])).getKeyCode());
            this.videoFormatLabel.setLabelFor(this.videoFormatComboBox);
            this.qualityLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(VideoPanel.class, "qualityLabel.mnemonic", new Object[0])).getKeyCode());
            this.qualityLabel.setLabelFor(this.qualitySlider);
            this.dateLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(VideoPanel.class, "dateLabel.mnemonic", new Object[0])).getKeyCode());
            this.dateLabel.setLabelFor(this.dateSpinner);
            this.timeLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(VideoPanel.class, "timeLabel.mnemonic", new Object[0])).getKeyCode());
            this.timeLabel.setLabelFor(this.timeSpinner);
            this.rendererLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(VideoPanel.class, "rendererLabel.mnemonic", new Object[0])).getKeyCode());
            this.rendererLabel.setLabelFor(this.rendererComboBox);
            this.ceilingLightEnabledCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(VideoPanel.class, "ceilingLightEnabledCheckBox.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private void layoutComponents() {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        this.statusLayout = new CardLayout();
        this.statusPanel = new JPanel(this.statusLayout);
        this.statusPanel.add((Component)this.tipLabel, TIP_CARD);
        Dimension dimension = this.tipLabel.getPreferredSize();
        if (OperatingSystem.isWindows() && OperatingSystem.isJavaVersionGreaterOrEqual("1.9")) {
            dimension.width += Math.round(11.0f * SwingTools.getResolutionScale());
        }
        this.tipLabel.setMinimumSize(dimension);
        JPanel jPanel = new JPanel(new BorderLayout(5, 2));
        jPanel.add((Component)this.progressBar, "North");
        jPanel.add(this.progressLabel);
        this.statusPanel.add((Component)jPanel, PROGRESS_CARD);
        int n2 = Math.round(5.0f * SwingTools.getResolutionScale());
        this.add((Component)this.planComponent, new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, n, 1, new Insets(0, 0, n2, 0), 0, 0));
        this.add((Component)this.videoToolBar, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, n2, 0), 0, 0));
        this.add((Component)this.statusPanel, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, 3, 1, 6, 0.5, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(3, 3, 1, 6, 0.5, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.videoFormatLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, n2, n2), 0, 0));
        this.add((Component)this.videoFormatComboBox, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, n2, 10), -50, 0));
        this.add((Component)this.qualityLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 2, n2), 0, 0));
        this.add((Component)this.qualitySlider, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.add(this.advancedComponentsSeparator, new GridBagConstraints(1, 6, 4, 1, 0.0, 0.0, 10, 2, new Insets(3, 0, 3, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.dateLabel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, n2, n2), 0, 0));
        jPanel2.add((Component)this.dateSpinner, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, n2, 10), 1, 0));
        jPanel2.add((Component)this.timeLabel, new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, n2, n2), 0, 0));
        jPanel2.add((Component)this.timeSpinner, new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, n2, n2), 0, 0));
        jPanel2.add((Component)this.dayNightLabel, new GridBagConstraints(5, 7, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, n2, 0), 0, 0));
        jPanel2.add((Component)this.rendererLabel, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, n, 2, new Insets(0, 0, 0, n2), 0, 0));
        jPanel2.add((Component)this.rendererComboBox, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 10), 0, 0));
        jPanel2.add((Component)this.ceilingLightEnabledCheckBox, new GridBagConstraints(3, 8, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, 7, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void updateAdvancedComponents() {
        Component component = SwingUtilities.getRoot(this);
        if (component != null) {
            boolean bl = this.controller.getQuality() >= 2;
            boolean bl2 = this.advancedComponentsSeparator.isVisible();
            if (bl2 != bl) {
                int n = this.advancedComponentsSeparator.getPreferredSize().height + 6 + this.dateSpinner.getPreferredSize().height + 5 + this.ceilingLightEnabledCheckBox.getPreferredSize().height;
                this.advancedComponentsSeparator.setVisible(bl);
                this.dateLabel.setVisible(bl);
                this.dateSpinner.setVisible(bl);
                this.timeLabel.setVisible(bl);
                this.timeSpinner.setVisible(bl);
                this.dayNightLabel.setVisible(bl);
                this.rendererLabel.setVisible(bl);
                this.ceilingLightEnabledCheckBox.setVisible(bl);
                this.rendererComboBox.setVisible(bl);
                component.setSize(component.getWidth(), component.getHeight() + (bl2 ? -n : n));
            }
        }
    }

    @Override
    public void displayView(View view) {
        if (currentVideoPanel == this) {
            SwingUtilities.getWindowAncestor(this).toFront();
        } else {
            if (currentVideoPanel != null) {
                currentVideoPanel.close();
            }
            final JOptionPane jOptionPane = new JOptionPane(this, -1, 2, null, new Object[]{this.createButton, this.saveButton, this.closeButton}, this.createButton);
            final JDialog jDialog = jOptionPane.createDialog(SwingUtilities.getRootPane((Component)((Object)view)), this.dialogTitle);
            jDialog.applyComponentOrientation(view != null ? ((JComponent)((Object)view)).getComponentOrientation() : ComponentOrientation.getOrientation(Locale.getDefault()));
            jDialog.setModal(false);
            Component component = SwingUtilities.getRoot((Component)((Object)view));
            Point point = null;
            if (component != null) {
                Number number = this.home.getNumericProperty(VIDEO_DIALOG_X_VISUAL_PROPERTY);
                Number number2 = this.home.getNumericProperty(VIDEO_DIALOG_Y_VISUAL_PROPERTY);
                Number number3 = this.home.getNumericProperty(VIDEO_DIALOG_WIDTH_VISUAL_PROPERTY);
                Number number4 = this.home.getNumericProperty(VIDEO_DIALOG_HEIGHT_VISUAL_PROPERTY);
                int n = component.getX() + component.getWidth();
                Dimension dimension = this.getToolkit().getScreenSize();
                Insets insets = this.getToolkit().getScreenInsets(this.getGraphicsConfiguration());
                int n2 = dimension.width - insets.right;
                int n3 = dimension.width - insets.left - insets.right;
                int n4 = dimension.height - insets.top - insets.bottom;
                if (OperatingSystem.isLinux() && n4 == dimension.height) {
                    n4 -= 30;
                }
                int n5 = dimension.height - insets.bottom;
                int n6 = number3 != null ? Math.min(number3.intValue(), n3) : jDialog.getWidth() + (OperatingSystem.isWindows() && !OperatingSystem.isJavaVersionGreaterOrEqual("1.9") ? Math.round(11.0f * SwingTools.getResolutionScale()) : 0);
                int n7 = number4 != null ? Math.min(number4.intValue(), n4) : jDialog.getHeight();
                jDialog.setSize(n6, n7);
                if (number != null && number2 != null && number.intValue() + n6 <= n2 && number2.intValue() + n7 <= n5) {
                    point = new Point(number.intValue(), number2.intValue());
                } else if (n2 - n > n6 / 2 || n7 == n4) {
                    point = new Point(Math.min(n + 5, n2 - n6), Math.max(Math.min(component.getY() + jDialog.getInsets().top, dimension.height - n7 - insets.bottom), insets.top));
                }
            }
            if (point != null && SwingTools.isRectangleVisibleAtScreen(new Rectangle(point, jDialog.getSize()))) {
                jDialog.setLocationByPlatform(false);
                jDialog.setLocation(point);
            } else {
                jDialog.setLocationByPlatform(true);
            }
            jDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    VideoPanel.this.stopVideoCreation(false);
                    if (VideoPanel.this.playbackTimer != null) {
                        VideoPanel.this.pausePlayback();
                    }
                    if (VideoPanel.this.videoFile != null) {
                        VideoPanel.this.videoFile.delete();
                    }
                    currentVideoPanel = null;
                }
            });
            this.updateAdvancedComponents();
            ToolTipManager.sharedInstance().registerComponent(this.qualitySlider);
            jDialog.setDefaultCloseOperation(2);
            jDialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    if (jOptionPane.getValue() != null && jOptionPane.getValue() != JOptionPane.UNINITIALIZED_VALUE) {
                        VideoPanel.this.close();
                    }
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    VideoPanel.this.controller.setHomeProperty(VideoPanel.VIDEO_DIALOG_X_VISUAL_PROPERTY, String.valueOf(jDialog.getX()));
                    VideoPanel.this.controller.setHomeProperty(VideoPanel.VIDEO_DIALOG_Y_VISUAL_PROPERTY, String.valueOf(jDialog.getY()));
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    VideoPanel.this.controller.setHomeProperty(VideoPanel.VIDEO_DIALOG_WIDTH_VISUAL_PROPERTY, String.valueOf(jDialog.getWidth()));
                    VideoPanel.this.controller.setHomeProperty(VideoPanel.VIDEO_DIALOG_HEIGHT_VISUAL_PROPERTY, String.valueOf(jDialog.getHeight()));
                }
            });
            jDialog.setResizable(true);
            jDialog.setVisible(true);
            currentVideoPanel = this;
        }
    }

    private void recordCameraLocation() {
        List<Camera> list = this.controller.getCameraPath();
        Camera camera = this.home.getCamera();
        Camera camera2 = null;
        if (list.size() > 0) {
            camera2 = list.get(list.size() - 1);
        }
        if (camera2 == null || !this.compareCameraLocation(camera2, camera)) {
            list = new ArrayList<Camera>(list);
            Camera camera3 = (Camera)camera.duplicate();
            camera3.setLens(Camera.Lens.PINHOLE);
            camera3.setTime(this.controller.getTime());
            if (list.isEmpty()) {
                camera3.setRenderer(this.controller.getRenderer());
            }
            list.add(camera3);
            this.controller.setCameraPath(list);
        }
    }

    private boolean compareCameraLocation(Camera camera, Camera camera2) {
        return camera.getX() == camera2.getX() && camera.getY() == camera2.getY() && camera.getZ() == camera2.getZ() && camera.getYaw() == camera2.getYaw() && camera.getPitch() == camera2.getPitch() && camera.getFieldOfView() == camera2.getFieldOfView() && camera.getTime() == camera2.getTime();
    }

    private void updatePlaybackTimer() {
        boolean bl;
        final List<Camera> list = this.controller.getCameraPath();
        final ActionMap actionMap = this.getActionMap();
        boolean bl2 = bl = list.size() > 1;
        if (bl) {
            Camera[] cameraArray = this.getVideoFramesPath(this.controller.getSpeed(), 12);
            Camera camera = this.home.getCamera();
            int n = cameraArray.length;
            while (--n > 0 && !this.compareCameraLocation(cameraArray[n], camera)) {
            }
            if (n < 0 || n == cameraArray.length - 1) {
                n = cameraArray.length;
            }
            this.cameraPathIterator = Arrays.asList(cameraArray).listIterator(n);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Camera camera;
                    if ("backward".equals(actionEvent.getActionCommand())) {
                        if (VideoPanel.this.cameraPathIterator.hasPrevious()) {
                            camera = (Camera)VideoPanel.this.cameraPathIterator.previous();
                            VideoPanel.this.home.getCamera().setCamera(camera);
                            VideoPanel.this.controller.setTime(camera.getTime());
                        } else {
                            VideoPanel.this.pausePlayback();
                        }
                    } else if (VideoPanel.this.cameraPathIterator.hasNext()) {
                        camera = (Camera)VideoPanel.this.cameraPathIterator.next();
                        VideoPanel.this.home.getCamera().setCamera(camera);
                        VideoPanel.this.controller.setTime(camera.getTime());
                    } else {
                        VideoPanel.this.pausePlayback();
                    }
                    boolean bl = VideoPanel.this.videoCreationExecutor == null && !((Timer)actionEvent.getSource()).isRunning();
                    actionMap.get((Object)ActionType.RECORD).setEnabled(bl);
                    actionMap.get((Object)ActionType.DELETE_CAMERA_PATH).setEnabled(bl && list.size() > 0);
                    actionMap.get((Object)ActionType.DELETE_LAST_RECORD).setEnabled(bl && list.size() > 0);
                    actionMap.get((Object)ActionType.SEEK_BACKWARD).setEnabled(VideoPanel.this.cameraPathIterator.hasPrevious());
                    actionMap.get((Object)ActionType.SKIP_BACKWARD).setEnabled(VideoPanel.this.cameraPathIterator.hasPrevious());
                    actionMap.get((Object)ActionType.SEEK_FORWARD).setEnabled(VideoPanel.this.cameraPathIterator.hasNext());
                    actionMap.get((Object)ActionType.SKIP_FORWARD).setEnabled(VideoPanel.this.cameraPathIterator.hasNext());
                }
            };
            if (this.playbackTimer != null) {
                this.playbackTimer.stop();
            }
            this.playbackTimer = new Timer(83, actionListener);
            this.playbackTimer.setInitialDelay(0);
            this.playbackTimer.setCoalesce(false);
        }
        actionMap.get((Object)ActionType.PLAYBACK).setEnabled(bl);
        actionMap.get((Object)ActionType.RECORD).setEnabled(this.videoCreationExecutor == null);
        boolean bl3 = list.isEmpty();
        actionMap.get((Object)ActionType.DELETE_CAMERA_PATH).setEnabled(this.videoCreationExecutor == null && !bl3);
        actionMap.get((Object)ActionType.DELETE_LAST_RECORD).setEnabled(this.videoCreationExecutor == null && !bl3);
        actionMap.get((Object)ActionType.SEEK_BACKWARD).setEnabled(bl && this.cameraPathIterator.hasPrevious());
        actionMap.get((Object)ActionType.SKIP_BACKWARD).setEnabled(bl && this.cameraPathIterator.hasPrevious());
        actionMap.get((Object)ActionType.SEEK_FORWARD).setEnabled(bl && this.cameraPathIterator.hasNext());
        actionMap.get((Object)ActionType.SKIP_FORWARD).setEnabled(bl && this.cameraPathIterator.hasNext());
        actionMap.get((Object)ActionType.START_VIDEO_CREATION).setEnabled(bl);
    }

    private void deleteLastRecordedCameraLocation() {
        ArrayList<Camera> arrayList = new ArrayList<Camera>(this.controller.getCameraPath());
        arrayList.remove(arrayList.size() - 1);
        this.controller.setCameraPath(arrayList);
    }

    private void deleteCameraPath() {
        List<Camera> list = Collections.emptyList();
        this.controller.setCameraPath(list);
    }

    private void playback() {
        if (!this.cameraPathIterator.hasNext()) {
            this.skipBackward();
        }
        this.playbackTimer.start();
        this.playbackPauseButton.setAction(this.getActionMap().get((Object)ActionType.PAUSE));
    }

    private void pausePlayback() {
        this.playbackTimer.stop();
        this.playbackPauseButton.setAction(this.getActionMap().get((Object)ActionType.PLAYBACK));
        this.getActionMap().get((Object)ActionType.RECORD).setEnabled(this.videoCreationExecutor == null);
        boolean bl = this.controller.getCameraPath().isEmpty();
        this.getActionMap().get((Object)ActionType.DELETE_CAMERA_PATH).setEnabled(this.videoCreationExecutor == null && !bl);
        this.getActionMap().get((Object)ActionType.DELETE_LAST_RECORD).setEnabled(this.videoCreationExecutor == null && !bl);
    }

    private void seekBackward() {
        for (int i = 0; i < 10 && this.cameraPathIterator.hasPrevious(); ++i) {
            this.playbackTimer.getActionListeners()[0].actionPerformed(new ActionEvent(this.playbackTimer, 0, "backward", System.currentTimeMillis(), 0));
        }
    }

    private void seekForward() {
        for (int i = 0; i < 10 && this.cameraPathIterator.hasNext(); ++i) {
            this.playbackTimer.getActionListeners()[0].actionPerformed(new ActionEvent(this.playbackTimer, 0, "forward", System.currentTimeMillis(), 0));
        }
    }

    private void skipBackward() {
        while (this.cameraPathIterator.hasPrevious()) {
            this.seekBackward();
        }
    }

    private void skipForward() {
        while (this.cameraPathIterator.hasNext()) {
            this.seekForward();
        }
    }

    private Camera[] getVideoFramesPath(float f, int n) {
        ArrayList<Camera> arrayList = new ArrayList<Camera>();
        float f2 = f * 100.0f / (float)n;
        float f3 = (float)(0.7853981633974483 * (double)f / (double)n);
        float f4 = 345600 / n * 25;
        List<Camera> list = this.controller.getCameraPath();
        Camera camera = list.get(0);
        float f5 = camera.getX();
        float f6 = camera.getY();
        float f7 = camera.getZ();
        float f8 = camera.getYaw();
        float f9 = camera.getPitch();
        float f10 = camera.getFieldOfView();
        long l = camera.getTime();
        arrayList.add(camera.clone());
        for (int i = 1; i < list.size(); ++i) {
            camera = list.get(i);
            float f11 = camera.getX();
            float f12 = camera.getY();
            float f13 = camera.getZ();
            float f14 = camera.getYaw();
            float f15 = camera.getPitch();
            float f16 = camera.getFieldOfView();
            long l2 = camera.getTime();
            float f17 = new Point3f(f5, f6, f7).distance(new Point3f(f11, f12, f13));
            float f18 = f17 / f2;
            float f19 = Math.abs(f14 - f8) / f3;
            float f20 = Math.abs(f15 - f9) / f3;
            float f21 = Math.abs(f16 - f10) / f3;
            float f22 = (float)Math.abs(l2 - l) / f4;
            int n2 = (int)Math.max(f18, Math.max(f19, Math.max(f20, Math.max(f21, f22))));
            float f23 = (f11 - f5) / (float)n2;
            float f24 = (f12 - f6) / (float)n2;
            float f25 = (f13 - f7) / (float)n2;
            float f26 = (f14 - f8) / (float)n2;
            float f27 = (f15 - f9) / (float)n2;
            float f28 = (f16 - f10) / (float)n2;
            long l3 = Math.round(((double)l2 - (double)l) / (double)n2);
            for (int j = 1; j <= n2; ++j) {
                Camera camera2 = camera.clone();
                camera2.setX(f5 + f23 * (float)j);
                camera2.setY(f6 + f24 * (float)j);
                camera2.setZ(f7 + f25 * (float)j);
                camera2.setYaw(f8 + f26 * (float)j);
                camera2.setPitch(f9 + f27 * (float)j);
                camera2.setFieldOfView(f10 + f28 * (float)j);
                camera2.setTime(l + l3 * (long)j);
                camera2.setLens(Camera.Lens.PINHOLE);
                arrayList.add(camera2);
            }
            f5 = f11;
            f6 = f12;
            f7 = f13;
            f8 = f14;
            f9 = f15;
            f10 = f16;
            l = l2;
        }
        return arrayList.toArray(new Camera[arrayList.size()]);
    }

    private void startVideoCreation() {
        ActionMap actionMap = this.getActionMap();
        actionMap.get((Object)ActionType.SAVE_VIDEO).setEnabled(false);
        this.createButton.setAction(this.getActionMap().get((Object)ActionType.STOP_VIDEO_CREATION));
        actionMap.get((Object)ActionType.RECORD).setEnabled(false);
        actionMap.get((Object)ActionType.DELETE_CAMERA_PATH).setEnabled(false);
        actionMap.get((Object)ActionType.DELETE_LAST_RECORD).setEnabled(false);
        this.getRootPane().setDefaultButton(this.createButton);
        this.videoFormatComboBox.setEnabled(false);
        this.qualitySlider.setEnabled(false);
        this.dateSpinner.setEnabled(false);
        this.timeSpinner.setEnabled(false);
        this.rendererComboBox.setEnabled(false);
        this.ceilingLightEnabledCheckBox.setEnabled(false);
        this.statusLayout.show(this.statusPanel, PROGRESS_CARD);
        this.progressBar.setIndeterminate(true);
        this.progressLabel.setText("");
        final Home home = this.home.clone();
        List list = Collections.emptyList();
        home.setSelectedItems(list);
        this.videoCreationExecutor = Executors.newSingleThreadExecutor();
        this.videoCreationExecutor.execute(new Runnable(){

            @Override
            public void run() {
                VideoPanel.this.computeVideo(home);
            }
        });
    }

    /*
     * Exception decompiling
     */
    private void computeVideo(Home var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void showError(final String string, final String string2) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string3 = VideoPanel.this.preferences.getLocalizedString(VideoPanel.class, string, new Object[0]);
                SwingTools.showMessageDialog(VideoPanel.this, String.format(string3, string2), VideoPanel.this.preferences.getLocalizedString(VideoPanel.class, "videoError.title", new Object[0]), 0);
            }
        });
    }

    private void stopVideoCreation(boolean bl) {
        if (!(this.videoCreationExecutor == null || bl && System.currentTimeMillis() - this.videoCreationStartTime >= 30000L && JOptionPane.showConfirmDialog(this, this.preferences.getLocalizedString(VideoPanel.class, "confirmStopCreation.message", new Object[0]), this.preferences.getLocalizedString(VideoPanel.class, "confirmStopCreation.title", new Object[0]), 0, 2) != 0 || this.videoCreationExecutor == null)) {
            this.videoCreationExecutor.shutdownNow();
            this.videoCreationExecutor = null;
            this.createButton.setAction(this.getActionMap().get((Object)ActionType.START_VIDEO_CREATION));
        }
    }

    private void saveVideo() {
        final String string = this.controller.getContentManager().showSaveDialog(this, this.preferences.getLocalizedString(VideoPanel.class, "saveVideoDialog.title", new Object[0]), ContentManager.ContentType.MOV, this.home.getName());
        if (string != null) {
            final Component component = SwingUtilities.getRoot(this);
            final Cursor cursor = component.getCursor();
            component.setCursor(Cursor.getPredefinedCursor(3));
            ActionMap actionMap = this.getActionMap();
            final boolean[] blArray = new boolean[ActionType.values().length];
            for (ActionType actionType : ActionType.values()) {
                blArray[actionType.ordinal()] = actionMap.get((Object)actionType).isEnabled();
                actionMap.get((Object)actionType).setEnabled(false);
            }
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public void run() {
                    block32: {
                        Object object;
                        IOException iOException;
                        InputStream inputStream;
                        FileOutputStream fileOutputStream;
                        block29: {
                            int n;
                            fileOutputStream = null;
                            inputStream = null;
                            iOException = null;
                            fileOutputStream = new FileOutputStream(string);
                            object = new byte[8192];
                            inputStream = new FileInputStream(VideoPanel.this.videoFile);
                            while ((n = inputStream.read((byte[])object)) != -1 && VideoPanel.this.isDisplayable()) {
                                ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
                            }
                            try {
                                if (fileOutputStream != null) {
                                    ((OutputStream)fileOutputStream).close();
                                }
                            }
                            catch (IOException iOException2) {
                                if (iOException != null) break block29;
                                iOException = iOException2;
                            }
                        }
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException3) {
                            // empty catch block
                        }
                        if (iOException != null || !VideoPanel.this.isDisplayable()) {
                            new File(string).delete();
                            if (!VideoPanel.this.isDisplayable()) {
                                iOException = null;
                            }
                        }
                        object = iOException;
                        EventQueue.invokeLater(new Runnable((IOException)object){
                            final /* synthetic */ IOException val$caughtException;
                            {
                                this.val$caughtException = iOException;
                            }

                            @Override
                            public void run() {
                                ActionMap actionMap = VideoPanel.this.getActionMap();
                                for (ActionType actionType : ActionType.values()) {
                                    actionMap.get((Object)actionType).setEnabled(blArray[actionType.ordinal()]);
                                }
                                component.setCursor(cursor);
                                if (this.val$caughtException != null) {
                                    VideoPanel.this.showError("saveVideoError.message", this.val$caughtException.getMessage());
                                }
                            }
                        });
                        break block32;
                        catch (IOException iOException4) {
                            block30: {
                                try {
                                    iOException = iOException4;
                                }
                                catch (Throwable throwable) {
                                    block31: {
                                        try {
                                            if (fileOutputStream != null) {
                                                ((OutputStream)fileOutputStream).close();
                                            }
                                        }
                                        catch (IOException iOException5) {
                                            if (iOException != null) break block31;
                                            iOException = iOException5;
                                        }
                                    }
                                    try {
                                        if (inputStream != null) {
                                            inputStream.close();
                                        }
                                    }
                                    catch (IOException iOException6) {
                                        // empty catch block
                                    }
                                    if (iOException != null || !VideoPanel.this.isDisplayable()) {
                                        new File(string).delete();
                                        if (!VideoPanel.this.isDisplayable()) {
                                            iOException = null;
                                        }
                                    }
                                    IOException iOException7 = iOException;
                                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                    throw throwable;
                                }
                                try {
                                    if (fileOutputStream != null) {
                                        ((OutputStream)fileOutputStream).close();
                                    }
                                }
                                catch (IOException iOException8) {
                                    if (iOException != null) break block30;
                                    iOException = iOException8;
                                }
                            }
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            catch (IOException iOException9) {
                                // empty catch block
                            }
                            if (iOException != null || !VideoPanel.this.isDisplayable()) {
                                new File(string).delete();
                                if (!VideoPanel.this.isDisplayable()) {
                                    iOException = null;
                                }
                            }
                            IOException iOException10 = iOException;
                            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                }
            });
        }
    }

    private void close() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window.isDisplayable()) {
            ToolTipManager.sharedInstance().unregisterComponent(this.qualitySlider);
            window.dispose();
        }
    }

    private AspectRatio getAspectRatio(int n, int n2) {
        return Math.abs((float)n / (float)n2 - 1.3333334f) < 0.001f ? AspectRatio.RATIO_4_3 : (Math.abs((float)n / (float)n2 - 2.4f) < 0.03f ? AspectRatio.RATIO_24_10 : AspectRatio.RATIO_16_9);
    }

    private static class Image3DGenerator
    extends FrameGenerator {
        private final Home home;
        private HomeComponent3D homeComponent3D;
        private BufferedImage image;

        public Image3DGenerator(Home home, UserPreferences userPreferences, int n, int n2, Object3DFactory object3DFactory, boolean bl) {
            this.home = home;
            this.homeComponent3D = new HomeComponent3D(home, userPreferences, object3DFactory, bl, null);
            this.homeComponent3D.startOffscreenImagesCreation();
            this.image = new BufferedImage(n, n2, 1);
        }

        @Override
        public BufferedImage renderImageAt(Camera camera, boolean bl) throws IOException {
            try {
                this.checkLaunchingThreadIsntInterrupted();
                this.home.setCamera(camera);
                BufferedImage bufferedImage = this.homeComponent3D.getOffScreenImage(2 * this.image.getWidth(), 2 * this.image.getHeight());
                this.checkLaunchingThreadIsntInterrupted();
                Graphics graphics = this.image.getGraphics();
                graphics.drawImage(bufferedImage.getScaledInstance(this.image.getWidth(), this.image.getHeight(), 4), 0, 0, null);
                graphics.dispose();
                this.checkLaunchingThreadIsntInterrupted();
                BufferedImage bufferedImage2 = this.image;
                return bufferedImage2;
            }
            catch (InterruptedIOException interruptedIOException) {
                this.homeComponent3D.endOffscreenImagesCreation();
                throw interruptedIOException;
            }
            finally {
                if (bl) {
                    this.homeComponent3D.endOffscreenImagesCreation();
                }
            }
        }
    }

    private static class PhotoImageGenerator
    extends FrameGenerator {
        private AbstractPhotoRenderer renderer;
        private BufferedImage image;

        public PhotoImageGenerator(Home home, int n, int n2, String string, Object3DFactory object3DFactory, AbstractPhotoRenderer.Quality quality) throws IOException {
            this.renderer = AbstractPhotoRenderer.createInstance(string, home, object3DFactory, quality);
            this.image = new BufferedImage(n, n2, 1);
        }

        @Override
        public BufferedImage renderImageAt(Camera camera, boolean bl) throws IOException {
            try {
                this.checkLaunchingThreadIsntInterrupted();
                this.renderer.render(this.image, camera, null);
                this.checkLaunchingThreadIsntInterrupted();
                BufferedImage bufferedImage = this.image;
                return bufferedImage;
            }
            catch (InterruptedIOException interruptedIOException) {
                this.renderer = null;
                throw interruptedIOException;
            }
            finally {
                if (bl) {
                    this.renderer.dispose();
                    this.renderer = null;
                }
            }
        }
    }

    private static abstract class FrameGenerator {
        private Thread launchingThread = Thread.currentThread();

        protected FrameGenerator() {
        }

        public abstract BufferedImage renderImageAt(Camera var1, boolean var2) throws IOException;

        protected void checkLaunchingThreadIsntInterrupted() throws InterruptedIOException {
            if (this.launchingThread.isInterrupted()) {
                throw new InterruptedIOException("Lauching thread interrupted");
            }
        }
    }

    private static class ImageSourceStream
    implements PullBufferStream {
        private final FrameGenerator frameGenerator;
        private final Camera[] framesPath;
        private final BoundedRangeModel progressModel;
        private final VideoFormat format;
        private int imageIndex;
        private boolean stopped;
        private Object mainThreadContext;

        public ImageSourceStream(VideoFormat videoFormat, FrameGenerator frameGenerator, Camera[] cameraArray, BoundedRangeModel boundedRangeModel) {
            this.frameGenerator = frameGenerator;
            this.framesPath = cameraArray;
            this.progressModel = boundedRangeModel;
            this.format = videoFormat;
            try {
                this.mainThreadContext = Class.forName("sun.awt.AppContext").getMethod("getAppContext", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public boolean willReadBlock() {
            return false;
        }

        public void read(Buffer buffer) throws IOException {
            buffer.setOffset(0);
            if (this.endOfStream()) {
                buffer.setEOM(true);
                buffer.setLength(0);
            } else {
                this.checkAppContext();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                BufferedImage bufferedImage = this.frameGenerator.renderImageAt(this.framesPath[this.imageIndex], this.imageIndex == this.framesPath.length - 1);
                ImageIO.write((RenderedImage)bufferedImage, "JPEG", byteArrayOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                buffer.setData((Object)byArray);
                buffer.setLength(byArray.length);
                buffer.setFormat((Format)this.format);
                buffer.setFlags(buffer.getFlags() | 0x10);
                final int n = this.imageIndex++;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImageSourceStream.this.progressModel.setValue(n);
                    }
                });
            }
        }

        private void checkAppContext() {
            if (this.mainThreadContext != null) {
                try {
                    Class<?> clazz = Class.forName("sun.awt.AppContext");
                    if (clazz.getMethod("getAppContext", new Class[0]).invoke(null, new Object[0]) == null) {
                        Field field = clazz.getDeclaredField("threadGroup2appContext");
                        field.setAccessible(true);
                        Map map = (Map)field.get(null);
                        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                        map.put(threadGroup, this.mainThreadContext);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.mainThreadContext = null;
            }
        }

        public Format getFormat() {
            return this.format;
        }

        public ContentDescriptor getContentDescriptor() {
            return new ContentDescriptor("raw");
        }

        public long getContentLength() {
            return 0L;
        }

        public boolean endOfStream() {
            return this.stopped || this.imageIndex == this.framesPath.length;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String string) {
            return null;
        }
    }

    private static class ImageDataSource
    extends PullBufferDataSource {
        private ImageSourceStream stream;

        public ImageDataSource(VideoFormat videoFormat, FrameGenerator frameGenerator, Camera[] cameraArray, BoundedRangeModel boundedRangeModel) {
            this.stream = new ImageSourceStream(videoFormat, frameGenerator, cameraArray, boundedRangeModel);
        }

        public void setLocator(MediaLocator mediaLocator) {
        }

        public MediaLocator getLocator() {
            return null;
        }

        public String getContentType() {
            return "raw";
        }

        public void connect() {
        }

        public void disconnect() {
        }

        public void start() {
        }

        public void stop() {
        }

        public PullBufferStream[] getStreams() {
            return new PullBufferStream[]{this.stream};
        }

        public Time getDuration() {
            return DURATION_UNKNOWN;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String string) {
            return null;
        }
    }

    public static class LanguageChangeListener
    implements PropertyChangeListener {
        private final WeakReference<VideoPanel> videoPanel;

        public LanguageChangeListener(VideoPanel videoPanel) {
            this.videoPanel = new WeakReference<VideoPanel>(videoPanel);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            VideoPanel videoPanel = (VideoPanel)this.videoPanel.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            if (videoPanel == null) {
                userPreferences.removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                videoPanel.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
                videoPanel.setComponentTexts(userPreferences);
                videoPanel.setMnemonics(userPreferences);
            }
        }
    }

    private static enum ActionType {
        START_VIDEO_CREATION,
        STOP_VIDEO_CREATION,
        SAVE_VIDEO,
        CLOSE,
        DELETE_CAMERA_PATH,
        PLAYBACK,
        PAUSE,
        RECORD,
        SEEK_BACKWARD,
        SEEK_FORWARD,
        SKIP_BACKWARD,
        SKIP_FORWARD,
        DELETE_LAST_RECORD;

    }
}

