/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeSet;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutCategoryData;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IndividualSpacings;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.util.ElkReflect;

public final class LayoutMetaDataService {
    private static LayoutMetaDataService instance;
    private final Map<String, LayoutAlgorithmData> layoutAlgorithmMap = Maps.newLinkedHashMap();
    private final Map<String, LayoutOptionData> layoutOptionMap = Maps.newLinkedHashMap();
    private final Map<String, LayoutOptionData> legacyLayoutOptionMap = Maps.newLinkedHashMap();
    private final Map<String, LayoutCategoryData> layoutCategoryMap = Maps.newLinkedHashMap();
    private final Map<String, LayoutAlgorithmData> algorithmSuffixMap = Maps.newHashMap();
    private final Map<String, LayoutOptionData> optionSuffixMap = Maps.newHashMap();

    private LayoutMetaDataService() {
        LayoutMetaDataService.initElkReflect();
    }

    public static synchronized LayoutMetaDataService getInstance() {
        return LayoutMetaDataService.getInstance(null);
    }

    public static synchronized LayoutMetaDataService getInstance(Object loader) {
        if (instance == null) {
            instance = new LayoutMetaDataService();
            instance.registerLayoutMetaDataProviders(new CoreOptions());
            for (ILayoutMetaDataProvider provider : ServiceLoader.load(ILayoutMetaDataProvider.class, (ClassLoader)loader)) {
                instance.registerLayoutMetaDataProviders(provider);
            }
            try {
                Class.forName("org.eclipse.elk.core.service.ElkServicePlugin");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return instance;
    }

    public static synchronized void unload() {
        if (instance != null) {
            for (LayoutAlgorithmData algoData : instance.getAlgorithmData()) {
                algoData.getInstancePool().clear();
            }
            instance = null;
        }
    }

    public static void initElkReflect() {
        ElkReflect.register(KVector.class, () -> new KVector(), v -> ((KVector)v).clone());
        ElkReflect.register(KVectorChain.class, () -> new KVectorChain(), vc -> new KVectorChain((KVectorChain)vc));
        ElkReflect.register(ElkMargin.class, () -> new ElkMargin(), m4 -> new ElkMargin((ElkMargin)m4));
        ElkReflect.register(ElkPadding.class, () -> new ElkPadding(), p -> new ElkPadding((ElkPadding)p));
        ElkReflect.register(IndividualSpacings.class, () -> new IndividualSpacings(), is -> new IndividualSpacings((IndividualSpacings)is));
        ElkReflect.register(ArrayList.class, () -> new ArrayList(), al -> ((ArrayList)al).clone());
        ElkReflect.register(LinkedList.class, () -> new LinkedList(), ll -> Lists.newLinkedList((LinkedList)ll));
        ElkReflect.register(HashSet.class, () -> new HashSet(), hs -> Sets.newHashSet((HashSet)hs));
        ElkReflect.register(LinkedHashSet.class, () -> new LinkedHashSet(), hs -> Sets.newLinkedHashSet((HashSet)hs));
        ElkReflect.register(TreeSet.class, () -> new TreeSet(), ts -> Sets.newTreeSet((TreeSet)ts));
    }

    public void registerLayoutMetaDataProviders(ILayoutMetaDataProvider ... providers) {
        ILayoutMetaDataProvider[] iLayoutMetaDataProviderArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            ILayoutMetaDataProvider provider = iLayoutMetaDataProviderArray[n2];
            Registry registry = new Registry();
            provider.apply(registry);
            registry.applyDependencies();
            ++n2;
        }
        this.optionSuffixMap.clear();
    }

    public LayoutAlgorithmData getAlgorithmData(String id) {
        return this.layoutAlgorithmMap.get(id);
    }

    public Collection<LayoutAlgorithmData> getAlgorithmData() {
        return Collections.unmodifiableCollection(this.layoutAlgorithmMap.values());
    }

    public LayoutAlgorithmData getAlgorithmDataBySuffix(String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return null;
        }
        LayoutAlgorithmData data = this.algorithmSuffixMap.get(suffix);
        if (data == null) {
            for (LayoutAlgorithmData d : this.layoutAlgorithmMap.values()) {
                String id = d.getId();
                if (!id.endsWith(suffix) || suffix.length() != id.length() && id.charAt(id.length() - suffix.length() - 1) != '.') continue;
                if (data != null) {
                    return null;
                }
                data = d;
            }
            if (data != null) {
                this.algorithmSuffixMap.put(suffix, data);
            }
        }
        return data;
    }

    public LayoutAlgorithmData getAlgorithmDataBySuffixOrDefault(String algorithmId, String defaultId) {
        LayoutAlgorithmData defaultIdData;
        LayoutAlgorithmData algorithmIdData;
        if (algorithmId != null && !algorithmId.trim().isEmpty() && (algorithmIdData = this.getAlgorithmDataBySuffix(algorithmId)) != null) {
            return algorithmIdData;
        }
        if (defaultId != null && !defaultId.trim().isEmpty() && (defaultIdData = this.getAlgorithmDataBySuffix(defaultId)) != null) {
            return defaultIdData;
        }
        return null;
    }

    public LayoutOptionData getOptionData(String id) {
        LayoutOptionData data = this.layoutOptionMap.get(id);
        return data != null ? data : this.legacyLayoutOptionMap.get(id);
    }

    public Collection<LayoutOptionData> getOptionData() {
        return Collections.unmodifiableCollection(this.layoutOptionMap.values());
    }

    public LayoutOptionData getOptionDataBySuffix(String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return null;
        }
        LayoutOptionData data = this.optionSuffixMap.get(suffix);
        if (data == null) {
            for (LayoutOptionData d : this.layoutOptionMap.values()) {
                String id = d.getId();
                if (!id.endsWith(suffix) || suffix.length() != id.length() && id.charAt(id.length() - suffix.length() - 1) != '.') continue;
                if (data != null) {
                    return null;
                }
                data = d;
            }
            if (data == null) {
                for (LayoutOptionData d : this.layoutOptionMap.values()) {
                    String[] legacyIds = d.getLegacyIds();
                    if (legacyIds == null) continue;
                    String[] stringArray = legacyIds;
                    int n = legacyIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        if (id.endsWith(suffix) && (suffix.length() == id.length() || id.charAt(id.length() - suffix.length() - 1) == '.')) {
                            if (data != null) {
                                return null;
                            }
                            data = d;
                        }
                        ++n2;
                    }
                }
            }
            if (data != null) {
                this.optionSuffixMap.put(suffix, data);
            }
        }
        return data;
    }

    public List<LayoutOptionData> getOptionData(LayoutAlgorithmData algorithmData, LayoutOptionData.Target targetType) {
        LinkedList<LayoutOptionData> optionDataList = new LinkedList<LayoutOptionData>();
        for (LayoutOptionData optionData : this.layoutOptionMap.values()) {
            if (!algorithmData.knowsOption(optionData) && !CoreOptions.ALGORITHM.equals(optionData) || !optionData.getTargets().contains((Object)targetType)) continue;
            optionDataList.add(optionData);
        }
        return optionDataList;
    }

    public LayoutCategoryData getCategoryData(String id) {
        return this.layoutCategoryMap.get(id);
    }

    public Collection<LayoutCategoryData> getCategoryData() {
        return Collections.unmodifiableCollection(this.layoutCategoryMap.values());
    }

    private class Registry
    implements ILayoutMetaDataProvider.Registry {
        private final List<Triple> optionDependencies = new LinkedList<Triple>();
        private final List<Triple> optionSupport = new LinkedList<Triple>();

        private Registry() {
        }

        @Override
        public void register(LayoutAlgorithmData algorithmData) {
            LayoutMetaDataService.this.layoutAlgorithmMap.put(algorithmData.getId(), algorithmData);
        }

        @Override
        public void register(LayoutOptionData optionData) {
            String id = optionData.getId();
            LayoutMetaDataService.this.layoutOptionMap.put(id, optionData);
            if (optionData.getLegacyIds() != null) {
                String[] stringArray = optionData.getLegacyIds();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String legacyId = stringArray[n2];
                    LayoutMetaDataService.this.legacyLayoutOptionMap.put(legacyId, optionData);
                    ++n2;
                }
            }
        }

        @Override
        public void register(LayoutCategoryData categoryData) {
            LayoutMetaDataService.this.layoutCategoryMap.put(categoryData.getId(), categoryData);
        }

        @Override
        public void addDependency(String sourceOption, String targetOption, Object requiredValue) {
            Triple dep = new Triple();
            dep.firstId = sourceOption;
            dep.secondId = targetOption;
            dep.value = requiredValue;
            this.optionDependencies.add(dep);
        }

        @Override
        public void addOptionSupport(String algorithm, String option, Object defaultValue) {
            Triple sup = new Triple();
            sup.firstId = algorithm;
            sup.secondId = option;
            sup.value = defaultValue;
            this.optionSupport.add(sup);
        }

        private void applyDependencies() {
            for (LayoutAlgorithmData algorithm : LayoutMetaDataService.this.layoutAlgorithmMap.values()) {
                LayoutCategoryData category;
                String categoryId = algorithm.getCategoryId();
                if (categoryId == null) {
                    categoryId = "";
                }
                if ((category = LayoutMetaDataService.this.getCategoryData(categoryId)) == null && categoryId.isEmpty()) {
                    category = this.retrieveBackupCategory();
                }
                if (category == null || category.getLayouters().contains(algorithm)) continue;
                category.getLayouters().add(algorithm);
            }
            for (Triple dep : this.optionDependencies) {
                LayoutOptionData source = LayoutMetaDataService.this.getOptionData(dep.firstId);
                LayoutOptionData target = LayoutMetaDataService.this.getOptionData(dep.secondId);
                if (source == null || target == null) continue;
                source.getDependencies().add(Pair.of(target, dep.value));
            }
            this.optionDependencies.clear();
            for (Triple sup : this.optionSupport) {
                LayoutAlgorithmData algorithm = LayoutMetaDataService.this.getAlgorithmData(sup.firstId);
                LayoutOptionData option = LayoutMetaDataService.this.getOptionData(sup.secondId);
                if (algorithm == null || option == null) continue;
                algorithm.addKnownOption(option, sup.value);
            }
            this.optionSupport.clear();
        }

        private LayoutCategoryData retrieveBackupCategory() {
            LayoutCategoryData otherCategory = LayoutMetaDataService.this.layoutCategoryMap.get("");
            if (otherCategory == null) {
                otherCategory = new LayoutCategoryData.Builder().id("").name("Other").create();
                LayoutMetaDataService.this.layoutCategoryMap.put("", otherCategory);
            }
            return otherCategory;
        }

        private class Triple {
            private String firstId;
            private String secondId;
            private Object value;

            private Triple() {
            }
        }
    }
}

