/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchException;
import org.opensearch.commons.alerting.model.MonitorRunResult;
import org.opensearch.script.ScriptException;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0000\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "userErrorMessage", "", "", "common-utils"})
public final class MonitorRunResultKt {
    private static final Logger logger = LogManager.getLogger(MonitorRunResult.class);

    @NotNull
    public static final String userErrorMessage(@NotNull Throwable $this$userErrorMessage) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$userErrorMessage, (String)"<this>");
        if ($this$userErrorMessage instanceof ScriptException) {
            List list = ((ScriptException)$this$userErrorMessage).getScriptStack();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"this.scriptStack");
            string = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)100, null, null, (int)54, null);
        } else if ($this$userErrorMessage instanceof OpenSearchException) {
            String string2 = ((OpenSearchException)$this$userErrorMessage).getDetailedMessage();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.detailedMessage");
        } else if ($this$userErrorMessage.getMessage() != null) {
            logger.info("Internal error: " + $this$userErrorMessage.getMessage() + ". See the opensearch.log for details", $this$userErrorMessage);
            String string3 = $this$userErrorMessage.getMessage();
            string = string3;
            Intrinsics.checkNotNull((Object)string3);
        } else {
            logger.info("Unknown Internal error. See the OpenSearch log for details.", $this$userErrorMessage);
            string = "Unknown Internal error. See the OpenSearch log for details.";
        }
        return string;
    }
}

