/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DedicatedHostIdListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceIdListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceEventWindowAssociationRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceEventWindowAssociationRequest> {
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceIds").getter(InstanceEventWindowAssociationRequest.getter(InstanceEventWindowAssociationRequest::instanceIds)).setter(InstanceEventWindowAssociationRequest.setter(Builder::instanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("InstanceId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> INSTANCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceTags").getter(InstanceEventWindowAssociationRequest.getter(InstanceEventWindowAssociationRequest::instanceTags)).setter(InstanceEventWindowAssociationRequest.setter(Builder::instanceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTag").unmarshallLocationName("InstanceTag").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DEDICATED_HOST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DedicatedHostIds").getter(InstanceEventWindowAssociationRequest.getter(InstanceEventWindowAssociationRequest::dedicatedHostIds)).setter(InstanceEventWindowAssociationRequest.setter(Builder::dedicatedHostIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedHostId").unmarshallLocationName("DedicatedHostId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_IDS_FIELD, INSTANCE_TAGS_FIELD, DEDICATED_HOST_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> instanceIds;
    private final List<Tag> instanceTags;
    private final List<String> dedicatedHostIds;

    private InstanceEventWindowAssociationRequest(BuilderImpl builder) {
        this.instanceIds = builder.instanceIds;
        this.instanceTags = builder.instanceTags;
        this.dedicatedHostIds = builder.dedicatedHostIds;
    }

    public final boolean hasInstanceIds() {
        return this.instanceIds != null && !(this.instanceIds instanceof SdkAutoConstructList);
    }

    public final List<String> instanceIds() {
        return this.instanceIds;
    }

    public final boolean hasInstanceTags() {
        return this.instanceTags != null && !(this.instanceTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> instanceTags() {
        return this.instanceTags;
    }

    public final boolean hasDedicatedHostIds() {
        return this.dedicatedHostIds != null && !(this.dedicatedHostIds instanceof SdkAutoConstructList);
    }

    public final List<String> dedicatedHostIds() {
        return this.dedicatedHostIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceIds() ? this.instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTags() ? this.instanceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDedicatedHostIds() ? this.dedicatedHostIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceEventWindowAssociationRequest)) {
            return false;
        }
        InstanceEventWindowAssociationRequest other = (InstanceEventWindowAssociationRequest)obj;
        return this.hasInstanceIds() == other.hasInstanceIds() && Objects.equals(this.instanceIds(), other.instanceIds()) && this.hasInstanceTags() == other.hasInstanceTags() && Objects.equals(this.instanceTags(), other.instanceTags()) && this.hasDedicatedHostIds() == other.hasDedicatedHostIds() && Objects.equals(this.dedicatedHostIds(), other.dedicatedHostIds());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceEventWindowAssociationRequest").add("InstanceIds", this.hasInstanceIds() ? this.instanceIds() : null).add("InstanceTags", this.hasInstanceTags() ? this.instanceTags() : null).add("DedicatedHostIds", this.hasDedicatedHostIds() ? this.dedicatedHostIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceIds": {
                return Optional.ofNullable(clazz.cast(this.instanceIds()));
            }
            case "InstanceTags": {
                return Optional.ofNullable(clazz.cast(this.instanceTags()));
            }
            case "DedicatedHostIds": {
                return Optional.ofNullable(clazz.cast(this.dedicatedHostIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceEventWindowAssociationRequest, T> g) {
        return obj -> g.apply((InstanceEventWindowAssociationRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> instanceTags = DefaultSdkAutoConstructList.getInstance();
        private List<String> dedicatedHostIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceEventWindowAssociationRequest model) {
            this.instanceIds(model.instanceIds);
            this.instanceTags(model.instanceTags);
            this.dedicatedHostIds(model.dedicatedHostIds);
        }

        public final Collection<String> getInstanceIds() {
            if (this.instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceIds;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final List<Tag.Builder> getInstanceTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.instanceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceTags(Collection<Tag.BuilderImpl> instanceTags) {
            this.instanceTags = TagListCopier.copyFromBuilder(instanceTags);
        }

        @Override
        public final Builder instanceTags(Collection<Tag> instanceTags) {
            this.instanceTags = TagListCopier.copy(instanceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTags(Tag ... instanceTags) {
            this.instanceTags(Arrays.asList(instanceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTags(Consumer<Tag.Builder> ... instanceTags) {
            this.instanceTags(Stream.of(instanceTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDedicatedHostIds() {
            if (this.dedicatedHostIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dedicatedHostIds;
        }

        public final void setDedicatedHostIds(Collection<String> dedicatedHostIds) {
            this.dedicatedHostIds = DedicatedHostIdListCopier.copy(dedicatedHostIds);
        }

        @Override
        public final Builder dedicatedHostIds(Collection<String> dedicatedHostIds) {
            this.dedicatedHostIds = DedicatedHostIdListCopier.copy(dedicatedHostIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dedicatedHostIds(String ... dedicatedHostIds) {
            this.dedicatedHostIds(Arrays.asList(dedicatedHostIds));
            return this;
        }

        public InstanceEventWindowAssociationRequest build() {
            return new InstanceEventWindowAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceEventWindowAssociationRequest> {
        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder instanceTags(Collection<Tag> var1);

        public Builder instanceTags(Tag ... var1);

        public Builder instanceTags(Consumer<Tag.Builder> ... var1);

        public Builder dedicatedHostIds(Collection<String> var1);

        public Builder dedicatedHostIds(String ... var1);
    }
}

