"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggregateTerm = void 0;

var _explorer = require("../../../../common/constants/explorer");

var _node = require("../node");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class AggregateTerm extends _node.PPLNode {
  constructor(name, children, statsFunction, customLabel) {
    super(name, children);
    this.statsFunction = statsFunction;
    this.customLabel = customLabel;
  }

  getTokens() {
    return {
      function: this.statsFunction.getTokens(),
      [_explorer.CUSTOM_LABEL]: this[_explorer.CUSTOM_LABEL]
    };
  }

  toString() {
    if (this[_explorer.CUSTOM_LABEL]) {
      return `${this.statsFunction.toString()}${this[_explorer.CUSTOM_LABEL] ? ` as ${this[_explorer.CUSTOM_LABEL]}` : ''}`;
    }

    return `${this.statsFunction.toString()}`;
  }

}

exports.AggregateTerm = AggregateTerm;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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