"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.anomalyResultMapper = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const anomalyResultMapper = anomalyResults => {
  let resultData = {
    anomalies: [],
    featureData: {}
  };
  if (anomalyResults.length === 0) return resultData;
  //initialize features list.
  const firstAnomaly = anomalyResults[0];
  Object.values(firstAnomaly.featureData).forEach(feature => {
    resultData.featureData[feature.featureId] = [];
  });
  anomalyResults.forEach(({
    featureData,
    ...rest
  }) => {
    resultData.anomalies.push({
      ...rest,
      anomalyGrade: rest.anomalyGrade != null && rest.anomalyGrade > 0 ? Number.parseFloat(rest.anomalyGrade).toFixed(2) : 0,
      confidence: rest.anomalyGrade != null && rest.anomalyGrade > 0 ? Number.parseFloat(rest.confidence).toFixed(2) : 0,
      plotTime: rest.dataStartTime + Math.floor((rest.dataEndTime - rest.dataStartTime) / 2)
    });
    featureData.forEach(feature => {
      resultData.featureData[feature.featureId].push({
        startTime: rest.dataStartTime,
        endTime: rest.dataEndTime,
        plotTime: rest.dataStartTime + Math.floor((rest.dataEndTime - rest.dataStartTime) / 2),
        data: feature.data
      });
    });
  });
  return resultData;
};
exports.anomalyResultMapper = anomalyResultMapper;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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