import { useCallback, useState } from 'react';
var useToggle = function (initialValue) {
    var _a = useState(initialValue), value = _a[0], setValue = _a[1];
    var toggle = useCallback(function (nextValue) {
        if (typeof nextValue === 'boolean') {
            setValue(nextValue);
        }
        else {
            setValue(function (currentValue) { return !currentValue; });
        }
    }, [setValue]);
    return [value, toggle];
};
export default useToggle;
